package io.fabric8.kubernetes.api.model.discovery.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class EndpointSliceFluentImpl<A extends EndpointSliceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EndpointSliceFluent<A> {

    private String addressType;
    private String apiVersion;
    private List<EndpointBuilder> endpoints =  new ArrayList<EndpointBuilder>();
    private String kind;
    private ObjectMetaBuilder metadata;
    private List<EndpointPortBuilder> ports =  new ArrayList<EndpointPortBuilder>();

    public EndpointSliceFluentImpl() {
    }

    public EndpointSliceFluentImpl(EndpointSlice instance) {
        this.withAddressType(instance.getAddressType()); 
        this.withApiVersion(instance.getApiVersion()); 
        this.withEndpoints(instance.getEndpoints()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withPorts(instance.getPorts()); 
    }

    public String getAddressType() {
        return this.addressType;
    }

    public A withAddressType(String addressType) {
        this.addressType=addressType; return (A) this;
    }

    public Boolean hasAddressType() {
        return this.addressType != null;
    }

    public A withNewAddressType(StringBuilder arg1) {
        return (A)withAddressType(new String(arg1));
    }

    public A withNewAddressType(int[] arg1,int arg2,int arg3) {
        return (A)withAddressType(new String(arg1, arg2, arg3));
    }

    public A withNewAddressType(char[] arg1) {
        return (A)withAddressType(new String(arg1));
    }

    public A withNewAddressType(StringBuffer arg1) {
        return (A)withAddressType(new String(arg1));
    }

    public A withNewAddressType(byte[] arg1,int arg2) {
        return (A)withAddressType(new String(arg1, arg2));
    }

    public A withNewAddressType(byte[] arg1) {
        return (A)withAddressType(new String(arg1));
    }

    public A withNewAddressType(char[] arg1,int arg2,int arg3) {
        return (A)withAddressType(new String(arg1, arg2, arg3));
    }

    public A withNewAddressType(byte[] arg1,int arg2,int arg3) {
        return (A)withAddressType(new String(arg1, arg2, arg3));
    }

    public A withNewAddressType(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withAddressType(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewAddressType(String arg1) {
        return (A)withAddressType(new String(arg1));
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(int[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(char[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(byte[] arg1,int arg2) {
        return (A)withApiVersion(new String(arg1, arg2));
    }

    public A withNewApiVersion(byte[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(char[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withApiVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A addToEndpoints(int index,Endpoint item) {
        if (this.endpoints == null) {this.endpoints = new ArrayList<EndpointBuilder>();}
        EndpointBuilder builder = new EndpointBuilder(item);_visitables.get("endpoints").add(index >= 0 ? index : _visitables.get("endpoints").size(), builder);this.endpoints.add(index >= 0 ? index : endpoints.size(), builder); return (A)this;
    }

    public A setToEndpoints(int index,Endpoint item) {
        if (this.endpoints == null) {this.endpoints = new ArrayList<EndpointBuilder>();}
        EndpointBuilder builder = new EndpointBuilder(item);
        if (index < 0 || index >= _visitables.get("endpoints").size()) { _visitables.get("endpoints").add(builder); } else { _visitables.get("endpoints").set(index, builder);}
        if (index < 0 || index >= endpoints.size()) { endpoints.add(builder); } else { endpoints.set(index, builder);}
         return (A)this;
    }

    public A addToEndpoints(Endpoint... items) {
        if (this.endpoints == null) {this.endpoints = new ArrayList<EndpointBuilder>();}
        for (Endpoint item : items) {EndpointBuilder builder = new EndpointBuilder(item);_visitables.get("endpoints").add(builder);this.endpoints.add(builder);} return (A)this;
    }

    public A addAllToEndpoints(Collection<Endpoint> items) {
        if (this.endpoints == null) {this.endpoints = new ArrayList<EndpointBuilder>();}
        for (Endpoint item : items) {EndpointBuilder builder = new EndpointBuilder(item);_visitables.get("endpoints").add(builder);this.endpoints.add(builder);} return (A)this;
    }

    public A removeFromEndpoints(Endpoint... items) {
        for (Endpoint item : items) {EndpointBuilder builder = new EndpointBuilder(item);_visitables.get("endpoints").remove(builder);if (this.endpoints != null) {this.endpoints.remove(builder);}} return (A)this;
    }

    public A removeAllFromEndpoints(Collection<Endpoint> items) {
        for (Endpoint item : items) {EndpointBuilder builder = new EndpointBuilder(item);_visitables.get("endpoints").remove(builder);if (this.endpoints != null) {this.endpoints.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromEndpoints(Predicate<EndpointBuilder> predicate) {
        if (endpoints == null) return (A) this;
        final Iterator<EndpointBuilder> each = endpoints.iterator();
        final List visitables = _visitables.get("endpoints");
        while (each.hasNext()) {
          EndpointBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildEndpoints instead.
 * @return The buildable object.
 */
@Deprecated public List<Endpoint> getEndpoints() {
        return build(endpoints);
    }

    public List<Endpoint> buildEndpoints() {
        return build(endpoints);
    }

    public Endpoint buildEndpoint(int index) {
        return this.endpoints.get(index).build();
    }

    public Endpoint buildFirstEndpoint() {
        return this.endpoints.get(0).build();
    }

    public Endpoint buildLastEndpoint() {
        return this.endpoints.get(endpoints.size() - 1).build();
    }

    public Endpoint buildMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
        for (EndpointBuilder item: endpoints) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
        for (EndpointBuilder item: endpoints) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withEndpoints(List<Endpoint> endpoints) {
        if (this.endpoints != null) { _visitables.get("endpoints").removeAll(this.endpoints);}
        if (endpoints != null) {this.endpoints = new ArrayList<EndpointBuilder>(); for (Endpoint item : endpoints){this.addToEndpoints(item);}} else { this.endpoints = null;} return (A) this;
    }

    public A withEndpoints(Endpoint... endpoints) {
        if (this.endpoints != null) {this.endpoints.clear();}
        if (endpoints != null) {for (Endpoint item :endpoints){ this.addToEndpoints(item);}} return (A) this;
    }

    public Boolean hasEndpoints() {
        return endpoints != null && !endpoints.isEmpty();
    }

    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.EndpointsNested<A> addNewEndpoint() {
        return new EndpointsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.EndpointsNested<A> addNewEndpointLike(Endpoint item) {
        return new EndpointsNestedImpl(-1, item);
    }

    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.EndpointsNested<A> setNewEndpointLike(int index,Endpoint item) {
        return new EndpointsNestedImpl(index, item);
    }

    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.EndpointsNested<A> editEndpoint(int index) {
        if (endpoints.size() <= index) throw new RuntimeException("Can't edit endpoints. Index exceeds size.");
        return setNewEndpointLike(index, buildEndpoint(index));
    }

    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.EndpointsNested<A> editFirstEndpoint() {
        if (endpoints.size() == 0) throw new RuntimeException("Can't edit first endpoints. The list is empty.");
        return setNewEndpointLike(0, buildEndpoint(0));
    }

    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.EndpointsNested<A> editLastEndpoint() {
        int index = endpoints.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last endpoints. The list is empty.");
        return setNewEndpointLike(index, buildEndpoint(index));
    }

    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.EndpointsNested<A> editMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
        int index = -1;
        for (int i=0;i<endpoints.size();i++) { 
        if (predicate.test(endpoints.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching endpoints. No match found.");
        return setNewEndpointLike(index, buildEndpoint(index));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(int[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(char[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(byte[] arg1,int arg2) {
        return (A)withKind(new String(arg1, arg2));
    }

    public A withNewKind(byte[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(char[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withKind(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public A addToPorts(int index,EndpointPort item) {
        if (this.ports == null) {this.ports = new ArrayList<EndpointPortBuilder>();}
        EndpointPortBuilder builder = new EndpointPortBuilder(item);_visitables.get("ports").add(index >= 0 ? index : _visitables.get("ports").size(), builder);this.ports.add(index >= 0 ? index : ports.size(), builder); return (A)this;
    }

    public A setToPorts(int index,EndpointPort item) {
        if (this.ports == null) {this.ports = new ArrayList<EndpointPortBuilder>();}
        EndpointPortBuilder builder = new EndpointPortBuilder(item);
        if (index < 0 || index >= _visitables.get("ports").size()) { _visitables.get("ports").add(builder); } else { _visitables.get("ports").set(index, builder);}
        if (index < 0 || index >= ports.size()) { ports.add(builder); } else { ports.set(index, builder);}
         return (A)this;
    }

    public A addToPorts(EndpointPort... items) {
        if (this.ports == null) {this.ports = new ArrayList<EndpointPortBuilder>();}
        for (EndpointPort item : items) {EndpointPortBuilder builder = new EndpointPortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
    }

    public A addAllToPorts(Collection<EndpointPort> items) {
        if (this.ports == null) {this.ports = new ArrayList<EndpointPortBuilder>();}
        for (EndpointPort item : items) {EndpointPortBuilder builder = new EndpointPortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
    }

    public A removeFromPorts(EndpointPort... items) {
        for (EndpointPort item : items) {EndpointPortBuilder builder = new EndpointPortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
    }

    public A removeAllFromPorts(Collection<EndpointPort> items) {
        for (EndpointPort item : items) {EndpointPortBuilder builder = new EndpointPortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPorts(Predicate<EndpointPortBuilder> predicate) {
        if (ports == null) return (A) this;
        final Iterator<EndpointPortBuilder> each = ports.iterator();
        final List visitables = _visitables.get("ports");
        while (each.hasNext()) {
          EndpointPortBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildPorts instead.
 * @return The buildable object.
 */
@Deprecated public List<EndpointPort> getPorts() {
        return build(ports);
    }

    public List<EndpointPort> buildPorts() {
        return build(ports);
    }

    public EndpointPort buildPort(int index) {
        return this.ports.get(index).build();
    }

    public EndpointPort buildFirstPort() {
        return this.ports.get(0).build();
    }

    public EndpointPort buildLastPort() {
        return this.ports.get(ports.size() - 1).build();
    }

    public EndpointPort buildMatchingPort(Predicate<EndpointPortBuilder> predicate) {
        for (EndpointPortBuilder item: ports) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingPort(Predicate<EndpointPortBuilder> predicate) {
        for (EndpointPortBuilder item: ports) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withPorts(List<EndpointPort> ports) {
        if (this.ports != null) { _visitables.get("ports").removeAll(this.ports);}
        if (ports != null) {this.ports = new ArrayList<EndpointPortBuilder>(); for (EndpointPort item : ports){this.addToPorts(item);}} else { this.ports = null;} return (A) this;
    }

    public A withPorts(EndpointPort... ports) {
        if (this.ports != null) {this.ports.clear();}
        if (ports != null) {for (EndpointPort item :ports){ this.addToPorts(item);}} return (A) this;
    }

    public Boolean hasPorts() {
        return ports != null && !ports.isEmpty();
    }

    public A addNewPort(String appProtocol,String name,Integer port,String protocol) {
        return (A)addToPorts(new EndpointPort(appProtocol, name, port, protocol));
    }

    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.PortsNested<A> addNewPortLike(EndpointPort item) {
        return new PortsNestedImpl(-1, item);
    }

    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.PortsNested<A> setNewPortLike(int index,EndpointPort item) {
        return new PortsNestedImpl(index, item);
    }

    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.PortsNested<A> editPort(int index) {
        if (ports.size() <= index) throw new RuntimeException("Can't edit ports. Index exceeds size.");
        return setNewPortLike(index, buildPort(index));
    }

    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.PortsNested<A> editFirstPort() {
        if (ports.size() == 0) throw new RuntimeException("Can't edit first ports. The list is empty.");
        return setNewPortLike(0, buildPort(0));
    }

    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.PortsNested<A> editLastPort() {
        int index = ports.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last ports. The list is empty.");
        return setNewPortLike(index, buildPort(index));
    }

    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.PortsNested<A> editMatchingPort(Predicate<EndpointPortBuilder> predicate) {
        int index = -1;
        for (int i=0;i<ports.size();i++) { 
        if (predicate.test(ports.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching ports. No match found.");
        return setNewPortLike(index, buildPort(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EndpointSliceFluentImpl that = (EndpointSliceFluentImpl) o;
        if (addressType != null ? !addressType.equals(that.addressType) :that.addressType != null) return false;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (endpoints != null ? !endpoints.equals(that.endpoints) :that.endpoints != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(addressType,  apiVersion,  endpoints,  kind,  metadata,  ports,  super.hashCode());
    }

    public class EndpointsNestedImpl<N> extends EndpointFluentImpl<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.EndpointsNested<N>> implements io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.EndpointsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EndpointBuilder builder;
        private final int index;

            EndpointsNestedImpl(int index,Endpoint item) {
                this.index = index;
                this.builder = new EndpointBuilder(this, item);
                        
            }

            EndpointsNestedImpl() {
                this.index = -1;
                this.builder = new EndpointBuilder(this);
                        
            }

            public N and() {
                return (N) EndpointSliceFluentImpl.this.setToEndpoints(index,builder.build());
            }

            public N endEndpoint() {
                return and();
            }
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.MetadataNested<N>> implements io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectMetaBuilder builder;

            MetadataNestedImpl(ObjectMeta item) {
                this.builder = new ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) EndpointSliceFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


    public class PortsNestedImpl<N> extends EndpointPortFluentImpl<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.PortsNested<N>> implements io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.PortsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EndpointPortBuilder builder;
        private final int index;

            PortsNestedImpl(int index,EndpointPort item) {
                this.index = index;
                this.builder = new EndpointPortBuilder(this, item);
                        
            }

            PortsNestedImpl() {
                this.index = -1;
                this.builder = new EndpointPortBuilder(this);
                        
            }

            public N and() {
                return (N) EndpointSliceFluentImpl.this.setToPorts(index,builder.build());
            }

            public N endPort() {
                return and();
            }
    }


}
