package io.fabric8.kubernetes.api.model.discovery.v1beta1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface EndpointFluent<A extends EndpointFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToAddresses(int index,String item);
    public A setToAddresses(int index,String item);
    public A addToAddresses(String... items);
    public A addAllToAddresses(Collection<String> items);
    public A removeFromAddresses(String... items);
    public A removeAllFromAddresses(Collection<String> items);
    public List<String> getAddresses();
    public String getAddress(int index);
    public String getFirstAddress();
    public String getLastAddress();
    public String getMatchingAddress(Predicate<String> predicate);
    public Boolean hasMatchingAddress(Predicate<String> predicate);
    public A withAddresses(List<String> addresses);
    public A withAddresses(String... addresses);
    public Boolean hasAddresses();
    public A addNewAddress(StringBuilder arg1);
    public A addNewAddress(int[] arg1,int arg2,int arg3);
    public A addNewAddress(char[] arg1);
    public A addNewAddress(StringBuffer arg1);
    public A addNewAddress(byte[] arg1,int arg2);
    public A addNewAddress(byte[] arg1);
    public A addNewAddress(char[] arg1,int arg2,int arg3);
    public A addNewAddress(byte[] arg1,int arg2,int arg3);
    public A addNewAddress(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewAddress(String arg1);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public EndpointConditions getConditions();
    public EndpointConditions buildConditions();
    public A withConditions(EndpointConditions conditions);
    public Boolean hasConditions();
    public A withNewConditions(Boolean ready,Boolean serving,Boolean terminating);
    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.ConditionsNested<A> withNewConditions();
    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.ConditionsNested<A> withNewConditionsLike(EndpointConditions item);
    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.ConditionsNested<A> editConditions();
    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.ConditionsNested<A> editOrNewConditions();
    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.ConditionsNested<A> editOrNewConditionsLike(EndpointConditions item);
    public String getHostname();
    public A withHostname(String hostname);
    public Boolean hasHostname();
    public A withNewHostname(StringBuilder arg1);
    public A withNewHostname(int[] arg1,int arg2,int arg3);
    public A withNewHostname(char[] arg1);
    public A withNewHostname(StringBuffer arg1);
    public A withNewHostname(byte[] arg1,int arg2);
    public A withNewHostname(byte[] arg1);
    public A withNewHostname(char[] arg1,int arg2,int arg3);
    public A withNewHostname(byte[] arg1,int arg2,int arg3);
    public A withNewHostname(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewHostname(String arg1);
    public String getNodeName();
    public A withNodeName(String nodeName);
    public Boolean hasNodeName();
    public A withNewNodeName(StringBuilder arg1);
    public A withNewNodeName(int[] arg1,int arg2,int arg3);
    public A withNewNodeName(char[] arg1);
    public A withNewNodeName(StringBuffer arg1);
    public A withNewNodeName(byte[] arg1,int arg2);
    public A withNewNodeName(byte[] arg1);
    public A withNewNodeName(char[] arg1,int arg2,int arg3);
    public A withNewNodeName(byte[] arg1,int arg2,int arg3);
    public A withNewNodeName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewNodeName(String arg1);
    
/**
 * This method has been deprecated, please use method buildTargetRef instead.
 * @return The buildable object.
 */
@Deprecated public ObjectReference getTargetRef();
    public ObjectReference buildTargetRef();
    public A withTargetRef(ObjectReference targetRef);
    public Boolean hasTargetRef();
    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.TargetRefNested<A> withNewTargetRef();
    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.TargetRefNested<A> withNewTargetRefLike(ObjectReference item);
    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.TargetRefNested<A> editTargetRef();
    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.TargetRefNested<A> editOrNewTargetRef();
    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.TargetRefNested<A> editOrNewTargetRefLike(ObjectReference item);
    public A addToTopology(String key,String value);
    public A addToTopology(java.util.Map<String,String> map);
    public A removeFromTopology(String key);
    public A removeFromTopology(java.util.Map<String,String> map);
    public java.util.Map<String,String> getTopology();
    public <K extends Object,V extends Object>A withTopology(java.util.Map<String,String> topology);
    public Boolean hasTopology();
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EndpointConditionsFluent<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.ConditionsNested<N>> {

            public N and();
            public N endConditions();    }


    public interface TargetRefNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.TargetRefNested<N>> {

            public N and();
            public N endTargetRef();    }


}
