package io.fabric8.kubernetes.api.model.discovery.v1beta1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class EndpointConditionsFluentImpl<A extends EndpointConditionsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EndpointConditionsFluent<A> {

    private Boolean ready;
    private Boolean serving;
    private Boolean terminating;

    public EndpointConditionsFluentImpl() {
    }

    public EndpointConditionsFluentImpl(EndpointConditions instance) {
        this.withReady(instance.getReady()); 
        this.withServing(instance.getServing()); 
        this.withTerminating(instance.getTerminating()); 
    }

    public Boolean getReady() {
        return this.ready;
    }

    public A withReady(Boolean ready) {
        this.ready=ready; return (A) this;
    }

    public Boolean hasReady() {
        return this.ready != null;
    }

    public A withNewReady(String arg1) {
        return (A)withReady(new Boolean(arg1));
    }

    public A withNewReady(boolean arg1) {
        return (A)withReady(new Boolean(arg1));
    }

    public Boolean getServing() {
        return this.serving;
    }

    public A withServing(Boolean serving) {
        this.serving=serving; return (A) this;
    }

    public Boolean hasServing() {
        return this.serving != null;
    }

    public A withNewServing(String arg1) {
        return (A)withServing(new Boolean(arg1));
    }

    public A withNewServing(boolean arg1) {
        return (A)withServing(new Boolean(arg1));
    }

    public Boolean getTerminating() {
        return this.terminating;
    }

    public A withTerminating(Boolean terminating) {
        this.terminating=terminating; return (A) this;
    }

    public Boolean hasTerminating() {
        return this.terminating != null;
    }

    public A withNewTerminating(String arg1) {
        return (A)withTerminating(new Boolean(arg1));
    }

    public A withNewTerminating(boolean arg1) {
        return (A)withTerminating(new Boolean(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EndpointConditionsFluentImpl that = (EndpointConditionsFluentImpl) o;
        if (ready != null ? !ready.equals(that.ready) :that.ready != null) return false;
        if (serving != null ? !serving.equals(that.serving) :that.serving != null) return false;
        if (terminating != null ? !terminating.equals(that.terminating) :that.terminating != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(ready,  serving,  terminating,  super.hashCode());
    }

}
