package io.fabric8.kubernetes.api.model.discovery.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EndpointConditionsBuilder extends EndpointConditionsFluentImpl<EndpointConditionsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<EndpointConditions,EndpointConditionsBuilder> {

    EndpointConditionsFluent<?> fluent;
    Boolean validationEnabled;

    public EndpointConditionsBuilder() {
        this(true);
    }

    public EndpointConditionsBuilder(Boolean validationEnabled) {
        this(new EndpointConditions(), validationEnabled);
    }

    public EndpointConditionsBuilder(EndpointConditionsFluent<?> fluent) {
        this(fluent, true);
    }

    public EndpointConditionsBuilder(EndpointConditionsFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new EndpointConditions(), validationEnabled);
    }

    public EndpointConditionsBuilder(EndpointConditionsFluent<?> fluent,EndpointConditions instance) {
        this(fluent, instance, true);
    }

    public EndpointConditionsBuilder(EndpointConditionsFluent<?> fluent,EndpointConditions instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withReady(instance.getReady()); 
        fluent.withServing(instance.getServing()); 
        fluent.withTerminating(instance.getTerminating()); 
        this.validationEnabled = validationEnabled; 
    }

    public EndpointConditionsBuilder(EndpointConditions instance) {
        this(instance,true);
    }

    public EndpointConditionsBuilder(EndpointConditions instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withReady(instance.getReady()); 
        this.withServing(instance.getServing()); 
        this.withTerminating(instance.getTerminating()); 
        this.validationEnabled = validationEnabled; 
    }

    public EndpointConditions build() {
        EndpointConditions buildable = new EndpointConditions(fluent.getReady(),fluent.getServing(),fluent.getTerminating());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EndpointConditionsBuilder that = (EndpointConditionsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
