package io.fabric8.kubernetes.api.model.discovery.v1beta1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class EndpointFluentImpl<A extends EndpointFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EndpointFluent<A> {

    private List<String> addresses = new ArrayList<String>();
    private EndpointConditionsBuilder conditions;
    private String hostname;
    private String nodeName;
    private ObjectReferenceBuilder targetRef;
    private Map<String,String> topology;

    public EndpointFluentImpl() {
    }

    public EndpointFluentImpl(Endpoint instance) {
        this.withAddresses(instance.getAddresses()); 
        this.withConditions(instance.getConditions()); 
        this.withHostname(instance.getHostname()); 
        this.withNodeName(instance.getNodeName()); 
        this.withTargetRef(instance.getTargetRef()); 
        this.withTopology(instance.getTopology()); 
    }

    public A addToAddresses(int index,String item) {
        if (this.addresses == null) {this.addresses = new ArrayList<String>();}
        this.addresses.add(index, item);
        return (A)this;
    }

    public A setToAddresses(int index,String item) {
        if (this.addresses == null) {this.addresses = new ArrayList<String>();}
        this.addresses.set(index, item); return (A)this;
    }

    public A addToAddresses(String... items) {
        if (this.addresses == null) {this.addresses = new ArrayList<String>();}
        for (String item : items) {this.addresses.add(item);} return (A)this;
    }

    public A addAllToAddresses(Collection<String> items) {
        if (this.addresses == null) {this.addresses = new ArrayList<String>();}
        for (String item : items) {this.addresses.add(item);} return (A)this;
    }

    public A removeFromAddresses(String... items) {
        for (String item : items) {if (this.addresses!= null){ this.addresses.remove(item);}} return (A)this;
    }

    public A removeAllFromAddresses(Collection<String> items) {
        for (String item : items) {if (this.addresses!= null){ this.addresses.remove(item);}} return (A)this;
    }

    public List<String> getAddresses() {
        return this.addresses;
    }

    public String getAddress(int index) {
        return this.addresses.get(index);
    }

    public String getFirstAddress() {
        return this.addresses.get(0);
    }

    public String getLastAddress() {
        return this.addresses.get(addresses.size() - 1);
    }

    public String getMatchingAddress(Predicate<String> predicate) {
        for (String item: addresses) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingAddress(Predicate<String> predicate) {
        for (String item: addresses) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withAddresses(List<String> addresses) {
        if (this.addresses != null) { _visitables.get("addresses").removeAll(this.addresses);}
        if (addresses != null) {this.addresses = new ArrayList<String>(); for (String item : addresses){this.addToAddresses(item);}} else { this.addresses = null;} return (A) this;
    }

    public A withAddresses(String... addresses) {
        if (this.addresses != null) {this.addresses.clear();}
        if (addresses != null) {for (String item :addresses){ this.addToAddresses(item);}} return (A) this;
    }

    public Boolean hasAddresses() {
        return addresses != null && !addresses.isEmpty();
    }

    public A addNewAddress(String arg1) {
        return (A)addToAddresses(new String(arg1));
    }

    public A addNewAddress(StringBuilder arg1) {
        return (A)addToAddresses(new String(arg1));
    }

    public A addNewAddress(StringBuffer arg1) {
        return (A)addToAddresses(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public EndpointConditions getConditions() {
        return this.conditions!=null?this.conditions.build():null;
    }

    public EndpointConditions buildConditions() {
        return this.conditions!=null?this.conditions.build():null;
    }

    public A withConditions(EndpointConditions conditions) {
        _visitables.get("conditions").remove(this.conditions);
        if (conditions!=null){ this.conditions= new EndpointConditionsBuilder(conditions); _visitables.get("conditions").add(this.conditions);} return (A) this;
    }

    public Boolean hasConditions() {
        return this.conditions != null;
    }

    public A withNewConditions(Boolean ready,Boolean serving,Boolean terminating) {
        return (A)withConditions(new EndpointConditions(ready, serving, terminating));
    }

    public EndpointFluent.ConditionsNested<A> withNewConditions() {
        return new ConditionsNestedImpl();
    }

    public EndpointFluent.ConditionsNested<A> withNewConditionsLike(EndpointConditions item) {
        return new ConditionsNestedImpl(item);
    }

    public EndpointFluent.ConditionsNested<A> editConditions() {
        return withNewConditionsLike(getConditions());
    }

    public EndpointFluent.ConditionsNested<A> editOrNewConditions() {
        return withNewConditionsLike(getConditions() != null ? getConditions(): new EndpointConditionsBuilder().build());
    }

    public EndpointFluent.ConditionsNested<A> editOrNewConditionsLike(EndpointConditions item) {
        return withNewConditionsLike(getConditions() != null ? getConditions(): item);
    }

    public String getHostname() {
        return this.hostname;
    }

    public A withHostname(String hostname) {
        this.hostname=hostname; return (A) this;
    }

    public Boolean hasHostname() {
        return this.hostname != null;
    }

    public A withNewHostname(String arg1) {
        return (A)withHostname(new String(arg1));
    }

    public A withNewHostname(StringBuilder arg1) {
        return (A)withHostname(new String(arg1));
    }

    public A withNewHostname(StringBuffer arg1) {
        return (A)withHostname(new String(arg1));
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public A withNodeName(String nodeName) {
        this.nodeName=nodeName; return (A) this;
    }

    public Boolean hasNodeName() {
        return this.nodeName != null;
    }

    public A withNewNodeName(String arg1) {
        return (A)withNodeName(new String(arg1));
    }

    public A withNewNodeName(StringBuilder arg1) {
        return (A)withNodeName(new String(arg1));
    }

    public A withNewNodeName(StringBuffer arg1) {
        return (A)withNodeName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildTargetRef instead.
 * @return The buildable object.
 */
@Deprecated public ObjectReference getTargetRef() {
        return this.targetRef!=null?this.targetRef.build():null;
    }

    public ObjectReference buildTargetRef() {
        return this.targetRef!=null?this.targetRef.build():null;
    }

    public A withTargetRef(ObjectReference targetRef) {
        _visitables.get("targetRef").remove(this.targetRef);
        if (targetRef!=null){ this.targetRef= new ObjectReferenceBuilder(targetRef); _visitables.get("targetRef").add(this.targetRef);} return (A) this;
    }

    public Boolean hasTargetRef() {
        return this.targetRef != null;
    }

    public EndpointFluent.TargetRefNested<A> withNewTargetRef() {
        return new TargetRefNestedImpl();
    }

    public EndpointFluent.TargetRefNested<A> withNewTargetRefLike(ObjectReference item) {
        return new TargetRefNestedImpl(item);
    }

    public EndpointFluent.TargetRefNested<A> editTargetRef() {
        return withNewTargetRefLike(getTargetRef());
    }

    public EndpointFluent.TargetRefNested<A> editOrNewTargetRef() {
        return withNewTargetRefLike(getTargetRef() != null ? getTargetRef(): new ObjectReferenceBuilder().build());
    }

    public EndpointFluent.TargetRefNested<A> editOrNewTargetRefLike(ObjectReference item) {
        return withNewTargetRefLike(getTargetRef() != null ? getTargetRef(): item);
    }

    public A addToTopology(String key,String value) {
        if(this.topology == null && key != null && value != null) { this.topology = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.topology.put(key, value);} return (A)this;
    }

    public A addToTopology(Map<String,String> map) {
        if(this.topology == null && map != null) { this.topology = new LinkedHashMap<String,String>(); }
        if(map != null) { this.topology.putAll(map);} return (A)this;
    }

    public A removeFromTopology(String key) {
        if(this.topology == null) { return (A) this; }
        if(key != null && this.topology != null) {this.topology.remove(key);} return (A)this;
    }

    public A removeFromTopology(Map<String,String> map) {
        if(this.topology == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.topology != null){this.topology.remove(key);}}} return (A)this;
    }

    public Map<String,String> getTopology() {
        return this.topology;
    }

    public A withTopology(Map<String,String> topology) {
        if (topology == null) { this.topology =  null;} else {this.topology = new LinkedHashMap<String,String>(topology);} return (A) this;
    }

    public Boolean hasTopology() {
        return this.topology != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EndpointFluentImpl that = (EndpointFluentImpl) o;
        if (addresses != null ? !addresses.equals(that.addresses) :that.addresses != null) return false;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (hostname != null ? !hostname.equals(that.hostname) :that.hostname != null) return false;
        if (nodeName != null ? !nodeName.equals(that.nodeName) :that.nodeName != null) return false;
        if (targetRef != null ? !targetRef.equals(that.targetRef) :that.targetRef != null) return false;
        if (topology != null ? !topology.equals(that.topology) :that.topology != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(addresses,  conditions,  hostname,  nodeName,  targetRef,  topology,  super.hashCode());
    }

    public class ConditionsNestedImpl<N> extends EndpointConditionsFluentImpl<EndpointFluent.ConditionsNested<N>> implements EndpointFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EndpointConditionsBuilder builder;

            ConditionsNestedImpl(EndpointConditions item) {
                this.builder = new EndpointConditionsBuilder(this, item);
                        
            }

            ConditionsNestedImpl() {
                this.builder = new EndpointConditionsBuilder(this);
                        
            }

            public N and() {
                return (N) EndpointFluentImpl.this.withConditions(builder.build());
            }

            public N endConditions() {
                return and();
            }
    }


    public class TargetRefNestedImpl<N> extends ObjectReferenceFluentImpl<EndpointFluent.TargetRefNested<N>> implements EndpointFluent.TargetRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectReferenceBuilder builder;

            TargetRefNestedImpl(ObjectReference item) {
                this.builder = new ObjectReferenceBuilder(this, item);
                        
            }

            TargetRefNestedImpl() {
                this.builder = new ObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) EndpointFluentImpl.this.withTargetRef(builder.build());
            }

            public N endTargetRef() {
                return and();
            }
    }


}
