package io.fabric8.kubernetes.api.model.discovery.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class EndpointSliceBuilder extends io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluentImpl<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSlice,io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceBuilder>{
  public EndpointSliceBuilder() {
    this(false);
  }
  public EndpointSliceBuilder(java.lang.Boolean validationEnabled) {
    this(new EndpointSlice(), validationEnabled);
  }
  public EndpointSliceBuilder(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent<?> fluent) {
    this(fluent, false);
  }
  public EndpointSliceBuilder(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new EndpointSlice(), validationEnabled);
  }
  public EndpointSliceBuilder(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent<?> fluent,io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSlice instance) {
    this(fluent, instance, false);
  }
  public EndpointSliceBuilder(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent<?> fluent,io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSlice instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAddressType(instance.getAddressType()); 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withEndpoints(instance.getEndpoints()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withPorts(instance.getPorts()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EndpointSliceBuilder(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSlice instance) {
    this(instance,false);
  }
  public EndpointSliceBuilder(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSlice instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAddressType(instance.getAddressType()); 
    this.withApiVersion(instance.getApiVersion()); 
    this.withEndpoints(instance.getEndpoints()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withPorts(instance.getPorts()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSlice build() {
    EndpointSlice buildable = new EndpointSlice(fluent.getAddressType(),fluent.getApiVersion(),fluent.getEndpoints(),fluent.getKind(),fluent.getMetadata(),fluent.getPorts());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EndpointSliceBuilder that = (EndpointSliceBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}