package io.fabric8.kubernetes.api.model.discovery;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class EndpointConditionsFluentImpl<A extends EndpointConditionsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EndpointConditionsFluent<A> {

    private Boolean ready;

    public EndpointConditionsFluentImpl() {
    }

    public EndpointConditionsFluentImpl(EndpointConditions instance) {
        this.withReady(instance.getReady()); 
    }

    public Boolean isReady() {
        return this.ready;
    }

    public A withReady(Boolean ready) {
        this.ready=ready; return (A) this;
    }

    public Boolean hasReady() {
        return this.ready != null;
    }

    public A withNewReady(String arg1) {
        return (A)withReady(new Boolean(arg1));
    }

    public A withNewReady(boolean arg1) {
        return (A)withReady(new Boolean(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EndpointConditionsFluentImpl that = (EndpointConditionsFluentImpl) o;
        if (ready != null ? !ready.equals(that.ready) :that.ready != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(ready,  super.hashCode());
    }

}
