package io.fabric8.kubernetes.api.model.discovery;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EndpointConditionsBuilder extends EndpointConditionsFluentImpl<EndpointConditionsBuilder> implements VisitableBuilder<EndpointConditions,EndpointConditionsBuilder> {

    EndpointConditionsFluent<?> fluent;
    Boolean validationEnabled;

    public EndpointConditionsBuilder() {
        this(true);
    }

    public EndpointConditionsBuilder(Boolean validationEnabled) {
        this(new EndpointConditions(), validationEnabled);
    }

    public EndpointConditionsBuilder(EndpointConditionsFluent<?> fluent) {
        this(fluent, true);
    }

    public EndpointConditionsBuilder(EndpointConditionsFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new EndpointConditions(), validationEnabled);
    }

    public EndpointConditionsBuilder(EndpointConditionsFluent<?> fluent,EndpointConditions instance) {
        this(fluent, instance, true);
    }

    public EndpointConditionsBuilder(EndpointConditionsFluent<?> fluent,EndpointConditions instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withReady(instance.getReady()); 
        this.validationEnabled = validationEnabled; 
    }

    public EndpointConditionsBuilder(EndpointConditions instance) {
        this(instance,true);
    }

    public EndpointConditionsBuilder(EndpointConditions instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withReady(instance.getReady()); 
        this.validationEnabled = validationEnabled; 
    }

    public EndpointConditions build() {
        EndpointConditions buildable = new EndpointConditions(fluent.isReady());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EndpointConditionsBuilder that = (EndpointConditionsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
