package io.fabric8.kubernetes.api.model.discovery;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface EndpointSliceListFluent<A extends EndpointSliceListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,EndpointSlice item);
    public A setToItems(int index,EndpointSlice item);
    public A addToItems(EndpointSlice... items);
    public A addAllToItems(Collection<EndpointSlice> items);
    public A removeFromItems(EndpointSlice... items);
    public A removeAllFromItems(Collection<EndpointSlice> items);
    public A removeMatchingFromItems(Predicate<EndpointSliceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<EndpointSlice> getItems();
    public List<EndpointSlice> buildItems();
    public EndpointSlice buildItem(int index);
    public EndpointSlice buildFirstItem();
    public EndpointSlice buildLastItem();
    public EndpointSlice buildMatchingItem(Predicate<EndpointSliceBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<EndpointSliceBuilder> predicate);
    public A withItems(List<EndpointSlice> items);
    public A withItems(EndpointSlice... items);
    public Boolean hasItems();
    public EndpointSliceListFluent.ItemsNested<A> addNewItem();
    public EndpointSliceListFluent.ItemsNested<A> addNewItemLike(EndpointSlice item);
    public EndpointSliceListFluent.ItemsNested<A> setNewItemLike(int index,EndpointSlice item);
    public EndpointSliceListFluent.ItemsNested<A> editItem(int index);
    public EndpointSliceListFluent.ItemsNested<A> editFirstItem();
    public EndpointSliceListFluent.ItemsNested<A> editLastItem();
    public EndpointSliceListFluent.ItemsNested<A> editMatchingItem(Predicate<EndpointSliceBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EndpointSliceFluent<EndpointSliceListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
