
package io.fabric8.kubernetes.api.model.discovery;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "addresses",
    "conditions",
    "hostname",
    "targetRef",
    "topology"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(io.fabric8.kubernetes.api.model.ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class Endpoint implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("addresses")
    private List<java.lang.String> addresses = new ArrayList<java.lang.String>();
    /**
     * 
     * 
     */
    @JsonProperty("conditions")
    private EndpointConditions conditions;
    /**
     * 
     * 
     */
    @JsonProperty("hostname")
    private java.lang.String hostname;
    /**
     * 
     * 
     */
    @JsonProperty("targetRef")
    private io.fabric8.kubernetes.api.model.ObjectReference targetRef;
    /**
     * 
     * 
     */
    @JsonProperty("topology")
    private Map<String, String> topology;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public Endpoint() {
    }

    /**
     * 
     * @param targetRef
     * @param addresses
     * @param hostname
     * @param topology
     * @param conditions
     */
    public Endpoint(List<java.lang.String> addresses, EndpointConditions conditions, java.lang.String hostname, io.fabric8.kubernetes.api.model.ObjectReference targetRef, Map<String, String> topology) {
        this.addresses = addresses;
        this.conditions = conditions;
        this.hostname = hostname;
        this.targetRef = targetRef;
        this.topology = topology;
    }

    /**
     * 
     * 
     * @return
     *     The addresses
     */
    @JsonProperty("addresses")
    public List<java.lang.String> getAddresses() {
        return addresses;
    }

    /**
     * 
     * 
     * @param addresses
     *     The addresses
     */
    @JsonProperty("addresses")
    public void setAddresses(List<java.lang.String> addresses) {
        this.addresses = addresses;
    }

    /**
     * 
     * 
     * @return
     *     The conditions
     */
    @JsonProperty("conditions")
    public EndpointConditions getConditions() {
        return conditions;
    }

    /**
     * 
     * 
     * @param conditions
     *     The conditions
     */
    @JsonProperty("conditions")
    public void setConditions(EndpointConditions conditions) {
        this.conditions = conditions;
    }

    /**
     * 
     * 
     * @return
     *     The hostname
     */
    @JsonProperty("hostname")
    public java.lang.String getHostname() {
        return hostname;
    }

    /**
     * 
     * 
     * @param hostname
     *     The hostname
     */
    @JsonProperty("hostname")
    public void setHostname(java.lang.String hostname) {
        this.hostname = hostname;
    }

    /**
     * 
     * 
     * @return
     *     The targetRef
     */
    @JsonProperty("targetRef")
    public io.fabric8.kubernetes.api.model.ObjectReference getTargetRef() {
        return targetRef;
    }

    /**
     * 
     * 
     * @param targetRef
     *     The targetRef
     */
    @JsonProperty("targetRef")
    public void setTargetRef(io.fabric8.kubernetes.api.model.ObjectReference targetRef) {
        this.targetRef = targetRef;
    }

    /**
     * 
     * 
     * @return
     *     The topology
     */
    @JsonProperty("topology")
    public Map<String, String> getTopology() {
        return topology;
    }

    /**
     * 
     * 
     * @param topology
     *     The topology
     */
    @JsonProperty("topology")
    public void setTopology(Map<String, String> topology) {
        this.topology = topology;
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
