package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ValidationSchemaBuilder extends ValidationSchemaFluent<ValidationSchemaBuilder> implements VisitableBuilder<ValidationSchema,ValidationSchemaBuilder>{
  public ValidationSchemaBuilder() {
    this(new ValidationSchema());
  }
  
  public ValidationSchemaBuilder(ValidationSchemaFluent<?> fluent) {
    this(fluent, new ValidationSchema());
  }
  
  public ValidationSchemaBuilder(ValidationSchemaFluent<?> fluent,ValidationSchema instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ValidationSchemaBuilder(ValidationSchema instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ValidationSchemaFluent<?> fluent;
  
  public ValidationSchema build() {
    ValidationSchema buildable = new ValidationSchema(fluent.buildAPIGroup(),fluent.buildAPIGroupList(),fluent.buildAPIResource(),fluent.buildAPIResourceList(),fluent.buildAPIService(),fluent.buildAPIServiceList(),fluent.buildBinding(),fluent.buildComponentStatus(),fluent.buildComponentStatusList(),fluent.buildCondition(),fluent.buildConfig(),fluent.buildConfigMap(),fluent.buildConfigMapList(),fluent.buildContainerStatus(),fluent.buildCreateOptions(),fluent.buildDeleteOptions(),fluent.buildEndpointPort(),fluent.buildEndpoints(),fluent.buildEndpointsList(),fluent.buildEnvVar(),fluent.buildEvent(),fluent.buildEventList(),fluent.buildEventSeries(),fluent.buildEventSource(),fluent.buildGetOptions(),fluent.buildGroupKind(),fluent.buildGroupVersionKind(),fluent.buildGroupVersionResource(),fluent.buildInfo(),fluent.buildKubernetesList(),fluent.buildLimitRangeList(),fluent.buildListOptions(),fluent.buildMicroTime(),fluent.buildNamespace(),fluent.buildNamespaceList(),fluent.buildNode(),fluent.buildNodeList(),fluent.buildObjectMeta(),fluent.buildPatch(),fluent.buildPatchOptions(),fluent.buildPersistentVolume(),fluent.buildPersistentVolumeClaim(),fluent.buildPersistentVolumeClaimList(),fluent.buildPersistentVolumeList(),fluent.buildPodExecOptions(),fluent.buildPodList(),fluent.buildPodTemplateList(),fluent.buildQuantity(),fluent.buildReplicationControllerList(),fluent.buildResourceQuota(),fluent.buildResourceQuotaList(),fluent.buildRootPaths(),fluent.buildSecret(),fluent.buildSecretList(),fluent.buildServiceAccount(),fluent.buildServiceAccountList(),fluent.buildServiceList(),fluent.buildStatus(),fluent.getTime(),fluent.buildToleration(),fluent.buildTopologySelectorTerm(),fluent.buildTypeMeta(),fluent.buildUpdateOptions(),fluent.buildWatchEvent());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}