package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ServerAddressByClientCIDRFluent<A extends ServerAddressByClientCIDRFluent<A>> extends BaseFluent<A>{
  public ServerAddressByClientCIDRFluent() {
  }
  
  public ServerAddressByClientCIDRFluent(ServerAddressByClientCIDR instance) {
    this.copyInstance(instance);
  }
  private String clientCIDR;
  private String serverAddress;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ServerAddressByClientCIDR instance) {
    instance = (instance != null ? instance : new ServerAddressByClientCIDR());
    if (instance != null) {
          this.withClientCIDR(instance.getClientCIDR());
          this.withServerAddress(instance.getServerAddress());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getClientCIDR() {
    return this.clientCIDR;
  }
  
  public A withClientCIDR(String clientCIDR) {
    this.clientCIDR = clientCIDR;
    return (A) this;
  }
  
  public boolean hasClientCIDR() {
    return this.clientCIDR != null;
  }
  
  public String getServerAddress() {
    return this.serverAddress;
  }
  
  public A withServerAddress(String serverAddress) {
    this.serverAddress = serverAddress;
    return (A) this;
  }
  
  public boolean hasServerAddress() {
    return this.serverAddress != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServerAddressByClientCIDRFluent that = (ServerAddressByClientCIDRFluent) o;
    if (!java.util.Objects.equals(clientCIDR, that.clientCIDR)) return false;
    if (!java.util.Objects.equals(serverAddress, that.serverAddress)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clientCIDR,  serverAddress,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clientCIDR != null) { sb.append("clientCIDR:"); sb.append(clientCIDR + ","); }
    if (serverAddress != null) { sb.append("serverAddress:"); sb.append(serverAddress + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}