package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PersistentVolumeClaimSpecFluent<A extends PersistentVolumeClaimSpecFluent<A>> extends BaseFluent<A>{
  public PersistentVolumeClaimSpecFluent() {
  }
  
  public PersistentVolumeClaimSpecFluent(PersistentVolumeClaimSpec instance) {
    this.copyInstance(instance);
  }
  private List<String> accessModes = new ArrayList<String>();
  private TypedLocalObjectReferenceBuilder dataSource;
  private TypedObjectReferenceBuilder dataSourceRef;
  private ResourceRequirementsBuilder resources;
  private LabelSelectorBuilder selector;
  private String storageClassName;
  private String volumeMode;
  private String volumeName;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PersistentVolumeClaimSpec instance) {
    instance = (instance != null ? instance : new PersistentVolumeClaimSpec());
    if (instance != null) {
          this.withAccessModes(instance.getAccessModes());
          this.withDataSource(instance.getDataSource());
          this.withDataSourceRef(instance.getDataSourceRef());
          this.withResources(instance.getResources());
          this.withSelector(instance.getSelector());
          this.withStorageClassName(instance.getStorageClassName());
          this.withVolumeMode(instance.getVolumeMode());
          this.withVolumeName(instance.getVolumeName());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToAccessModes(int index,String item) {
    if (this.accessModes == null) {this.accessModes = new ArrayList<String>();}
    this.accessModes.add(index, item);
    return (A)this;
  }
  
  public A setToAccessModes(int index,String item) {
    if (this.accessModes == null) {this.accessModes = new ArrayList<String>();}
    this.accessModes.set(index, item); return (A)this;
  }
  
  public A addToAccessModes(java.lang.String... items) {
    if (this.accessModes == null) {this.accessModes = new ArrayList<String>();}
    for (String item : items) {this.accessModes.add(item);} return (A)this;
  }
  
  public A addAllToAccessModes(Collection<String> items) {
    if (this.accessModes == null) {this.accessModes = new ArrayList<String>();}
    for (String item : items) {this.accessModes.add(item);} return (A)this;
  }
  
  public A removeFromAccessModes(java.lang.String... items) {
    if (this.accessModes == null) return (A)this;
    for (String item : items) { this.accessModes.remove(item);} return (A)this;
  }
  
  public A removeAllFromAccessModes(Collection<String> items) {
    if (this.accessModes == null) return (A)this;
    for (String item : items) { this.accessModes.remove(item);} return (A)this;
  }
  
  public List<String> getAccessModes() {
    return this.accessModes;
  }
  
  public String getAccessMode(int index) {
    return this.accessModes.get(index);
  }
  
  public String getFirstAccessMode() {
    return this.accessModes.get(0);
  }
  
  public String getLastAccessMode() {
    return this.accessModes.get(accessModes.size() - 1);
  }
  
  public String getMatchingAccessMode(Predicate<String> predicate) {
      for (String item : accessModes) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingAccessMode(Predicate<String> predicate) {
      for (String item : accessModes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAccessModes(List<String> accessModes) {
    if (accessModes != null) {
        this.accessModes = new ArrayList();
        for (String item : accessModes) {
          this.addToAccessModes(item);
        }
    } else {
      this.accessModes = null;
    }
    return (A) this;
  }
  
  public A withAccessModes(java.lang.String... accessModes) {
    if (this.accessModes != null) {
        this.accessModes.clear();
        _visitables.remove("accessModes");
    }
    if (accessModes != null) {
      for (String item : accessModes) {
        this.addToAccessModes(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAccessModes() {
    return this.accessModes != null && !this.accessModes.isEmpty();
  }
  
  public TypedLocalObjectReference buildDataSource() {
    return this.dataSource != null ? this.dataSource.build() : null;
  }
  
  public A withDataSource(TypedLocalObjectReference dataSource) {
    this._visitables.remove("dataSource");
    if (dataSource != null) {
        this.dataSource = new TypedLocalObjectReferenceBuilder(dataSource);
        this._visitables.get("dataSource").add(this.dataSource);
    } else {
        this.dataSource = null;
        this._visitables.get("dataSource").remove(this.dataSource);
    }
    return (A) this;
  }
  
  public boolean hasDataSource() {
    return this.dataSource != null;
  }
  
  public A withNewDataSource(String apiGroup,String kind,String name) {
    return (A)withDataSource(new TypedLocalObjectReference(apiGroup, kind, name));
  }
  
  public DataSourceNested<A> withNewDataSource() {
    return new DataSourceNested(null);
  }
  
  public DataSourceNested<A> withNewDataSourceLike(TypedLocalObjectReference item) {
    return new DataSourceNested(item);
  }
  
  public DataSourceNested<A> editDataSource() {
    return withNewDataSourceLike(java.util.Optional.ofNullable(buildDataSource()).orElse(null));
  }
  
  public DataSourceNested<A> editOrNewDataSource() {
    return withNewDataSourceLike(java.util.Optional.ofNullable(buildDataSource()).orElse(new TypedLocalObjectReferenceBuilder().build()));
  }
  
  public DataSourceNested<A> editOrNewDataSourceLike(TypedLocalObjectReference item) {
    return withNewDataSourceLike(java.util.Optional.ofNullable(buildDataSource()).orElse(item));
  }
  
  public TypedObjectReference buildDataSourceRef() {
    return this.dataSourceRef != null ? this.dataSourceRef.build() : null;
  }
  
  public A withDataSourceRef(TypedObjectReference dataSourceRef) {
    this._visitables.remove("dataSourceRef");
    if (dataSourceRef != null) {
        this.dataSourceRef = new TypedObjectReferenceBuilder(dataSourceRef);
        this._visitables.get("dataSourceRef").add(this.dataSourceRef);
    } else {
        this.dataSourceRef = null;
        this._visitables.get("dataSourceRef").remove(this.dataSourceRef);
    }
    return (A) this;
  }
  
  public boolean hasDataSourceRef() {
    return this.dataSourceRef != null;
  }
  
  public A withNewDataSourceRef(String apiGroup,String kind,String name,String namespace) {
    return (A)withDataSourceRef(new TypedObjectReference(apiGroup, kind, name, namespace));
  }
  
  public DataSourceRefNested<A> withNewDataSourceRef() {
    return new DataSourceRefNested(null);
  }
  
  public DataSourceRefNested<A> withNewDataSourceRefLike(TypedObjectReference item) {
    return new DataSourceRefNested(item);
  }
  
  public DataSourceRefNested<A> editDataSourceRef() {
    return withNewDataSourceRefLike(java.util.Optional.ofNullable(buildDataSourceRef()).orElse(null));
  }
  
  public DataSourceRefNested<A> editOrNewDataSourceRef() {
    return withNewDataSourceRefLike(java.util.Optional.ofNullable(buildDataSourceRef()).orElse(new TypedObjectReferenceBuilder().build()));
  }
  
  public DataSourceRefNested<A> editOrNewDataSourceRefLike(TypedObjectReference item) {
    return withNewDataSourceRefLike(java.util.Optional.ofNullable(buildDataSourceRef()).orElse(item));
  }
  
  public ResourceRequirements buildResources() {
    return this.resources != null ? this.resources.build() : null;
  }
  
  public A withResources(ResourceRequirements resources) {
    this._visitables.remove("resources");
    if (resources != null) {
        this.resources = new ResourceRequirementsBuilder(resources);
        this._visitables.get("resources").add(this.resources);
    } else {
        this.resources = null;
        this._visitables.get("resources").remove(this.resources);
    }
    return (A) this;
  }
  
  public boolean hasResources() {
    return this.resources != null;
  }
  
  public ResourcesNested<A> withNewResources() {
    return new ResourcesNested(null);
  }
  
  public ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
    return new ResourcesNested(item);
  }
  
  public ResourcesNested<A> editResources() {
    return withNewResourcesLike(java.util.Optional.ofNullable(buildResources()).orElse(null));
  }
  
  public ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(java.util.Optional.ofNullable(buildResources()).orElse(new ResourceRequirementsBuilder().build()));
  }
  
  public ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
    return withNewResourcesLike(java.util.Optional.ofNullable(buildResources()).orElse(item));
  }
  
  public LabelSelector buildSelector() {
    return this.selector != null ? this.selector.build() : null;
  }
  
  public A withSelector(LabelSelector selector) {
    this._visitables.remove("selector");
    if (selector != null) {
        this.selector = new LabelSelectorBuilder(selector);
        this._visitables.get("selector").add(this.selector);
    } else {
        this.selector = null;
        this._visitables.get("selector").remove(this.selector);
    }
    return (A) this;
  }
  
  public boolean hasSelector() {
    return this.selector != null;
  }
  
  public SelectorNested<A> withNewSelector() {
    return new SelectorNested(null);
  }
  
  public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
    return new SelectorNested(item);
  }
  
  public SelectorNested<A> editSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(null));
  }
  
  public SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(item));
  }
  
  public String getStorageClassName() {
    return this.storageClassName;
  }
  
  public A withStorageClassName(String storageClassName) {
    this.storageClassName = storageClassName;
    return (A) this;
  }
  
  public boolean hasStorageClassName() {
    return this.storageClassName != null;
  }
  
  public String getVolumeMode() {
    return this.volumeMode;
  }
  
  public A withVolumeMode(String volumeMode) {
    this.volumeMode = volumeMode;
    return (A) this;
  }
  
  public boolean hasVolumeMode() {
    return this.volumeMode != null;
  }
  
  public String getVolumeName() {
    return this.volumeName;
  }
  
  public A withVolumeName(String volumeName) {
    this.volumeName = volumeName;
    return (A) this;
  }
  
  public boolean hasVolumeName() {
    return this.volumeName != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PersistentVolumeClaimSpecFluent that = (PersistentVolumeClaimSpecFluent) o;
    if (!java.util.Objects.equals(accessModes, that.accessModes)) return false;
    if (!java.util.Objects.equals(dataSource, that.dataSource)) return false;
    if (!java.util.Objects.equals(dataSourceRef, that.dataSourceRef)) return false;
    if (!java.util.Objects.equals(resources, that.resources)) return false;
    if (!java.util.Objects.equals(selector, that.selector)) return false;
    if (!java.util.Objects.equals(storageClassName, that.storageClassName)) return false;
    if (!java.util.Objects.equals(volumeMode, that.volumeMode)) return false;
    if (!java.util.Objects.equals(volumeName, that.volumeName)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(accessModes,  dataSource,  dataSourceRef,  resources,  selector,  storageClassName,  volumeMode,  volumeName,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (accessModes != null && !accessModes.isEmpty()) { sb.append("accessModes:"); sb.append(accessModes + ","); }
    if (dataSource != null) { sb.append("dataSource:"); sb.append(dataSource + ","); }
    if (dataSourceRef != null) { sb.append("dataSourceRef:"); sb.append(dataSourceRef + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (storageClassName != null) { sb.append("storageClassName:"); sb.append(storageClassName + ","); }
    if (volumeMode != null) { sb.append("volumeMode:"); sb.append(volumeMode + ","); }
    if (volumeName != null) { sb.append("volumeName:"); sb.append(volumeName + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DataSourceNested<N> extends TypedLocalObjectReferenceFluent<DataSourceNested<N>> implements Nested<N>{
    DataSourceNested(TypedLocalObjectReference item) {
      this.builder = new TypedLocalObjectReferenceBuilder(this, item);
    }
    TypedLocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) PersistentVolumeClaimSpecFluent.this.withDataSource(builder.build());
    }
    
    public N endDataSource() {
      return and();
    }
    
  
  }
  public class DataSourceRefNested<N> extends TypedObjectReferenceFluent<DataSourceRefNested<N>> implements Nested<N>{
    DataSourceRefNested(TypedObjectReference item) {
      this.builder = new TypedObjectReferenceBuilder(this, item);
    }
    TypedObjectReferenceBuilder builder;
    
    public N and() {
      return (N) PersistentVolumeClaimSpecFluent.this.withDataSourceRef(builder.build());
    }
    
    public N endDataSourceRef() {
      return and();
    }
    
  
  }
  public class ResourcesNested<N> extends ResourceRequirementsFluent<ResourcesNested<N>> implements Nested<N>{
    ResourcesNested(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsBuilder builder;
    
    public N and() {
      return (N) PersistentVolumeClaimSpecFluent.this.withResources(builder.build());
    }
    
    public N endResources() {
      return and();
    }
    
  
  }
  public class SelectorNested<N> extends LabelSelectorFluent<SelectorNested<N>> implements Nested<N>{
    SelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) PersistentVolumeClaimSpecFluent.this.withSelector(builder.build());
    }
    
    public N endSelector() {
      return and();
    }
    
  
  }

}