package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NodeConfigStatusBuilder extends NodeConfigStatusFluent<NodeConfigStatusBuilder> implements VisitableBuilder<NodeConfigStatus,NodeConfigStatusBuilder>{
  public NodeConfigStatusBuilder() {
    this(new NodeConfigStatus());
  }
  
  public NodeConfigStatusBuilder(NodeConfigStatusFluent<?> fluent) {
    this(fluent, new NodeConfigStatus());
  }
  
  public NodeConfigStatusBuilder(NodeConfigStatusFluent<?> fluent,NodeConfigStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NodeConfigStatusBuilder(NodeConfigStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NodeConfigStatusFluent<?> fluent;
  
  public NodeConfigStatus build() {
    NodeConfigStatus buildable = new NodeConfigStatus(fluent.buildActive(),fluent.buildAssigned(),fluent.getError(),fluent.buildLastKnownGood());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}