/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ExecAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ExecActionFluent<A extends ExecActionFluent<A>>
extends BaseFluent<A> {
    private List<String> command = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public ExecActionFluent() {
    }

    public ExecActionFluent(ExecAction instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ExecAction instance) {
        ExecAction execAction = instance = instance != null ? instance : new ExecAction();
        if (instance != null) {
            this.withCommand(instance.getCommand());
            this.withCommand(instance.getCommand());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.add(index, item);
        return (A)((Object)this);
    }

    public A setToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.set(index, item);
        return (A)((Object)this);
    }

    public A addToCommand(String ... items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToCommand(Collection<String> items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCommand(String ... items) {
        if (this.command == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.command.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCommand(Collection<String> items) {
        if (this.command == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.command.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getCommand() {
        return this.command;
    }

    public String getCommand(int index) {
        return this.command.get(index);
    }

    public String getFirstCommand() {
        return this.command.get(0);
    }

    public String getLastCommand() {
        return this.command.get(this.command.size() - 1);
    }

    public String getMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCommand(List<String> command) {
        if (command != null) {
            this.command = new ArrayList<String>();
            for (String item : command) {
                this.addToCommand(item);
            }
        } else {
            this.command = null;
        }
        return (A)((Object)this);
    }

    public A withCommand(String ... command) {
        if (this.command != null) {
            this.command.clear();
            this._visitables.remove((Object)"command");
        }
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasCommand() {
        return this.command != null && !this.command.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExecActionFluent that = (ExecActionFluent)((Object)o);
        if (!Objects.equals(this.command, that.command)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.command, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.command != null && !this.command.isEmpty()) {
            sb.append("command:");
            sb.append(this.command + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

