package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TopologySelectorTermFluent<A extends TopologySelectorTermFluent<A>> extends BaseFluent<A>{
  public TopologySelectorTermFluent() {
  }
  
  public TopologySelectorTermFluent(TopologySelectorTerm instance) {
    this.copyInstance(instance);
  }
  private ArrayList<TopologySelectorLabelRequirementBuilder> matchLabelExpressions = new ArrayList<TopologySelectorLabelRequirementBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(TopologySelectorTerm instance) {
    instance = (instance != null ? instance : new TopologySelectorTerm());
    if (instance != null) {
          this.withMatchLabelExpressions(instance.getMatchLabelExpressions());
          this.withMatchLabelExpressions(instance.getMatchLabelExpressions());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToMatchLabelExpressions(int index,TopologySelectorLabelRequirement item) {
    if (this.matchLabelExpressions == null) {this.matchLabelExpressions = new ArrayList<TopologySelectorLabelRequirementBuilder>();}
    TopologySelectorLabelRequirementBuilder builder = new TopologySelectorLabelRequirementBuilder(item);
    if (index < 0 || index >= matchLabelExpressions.size()) { _visitables.get("matchLabelExpressions").add(builder); matchLabelExpressions.add(builder); } else { _visitables.get("matchLabelExpressions").add(index, builder); matchLabelExpressions.add(index, builder);}
    return (A)this;
  }
  
  public A setToMatchLabelExpressions(int index,TopologySelectorLabelRequirement item) {
    if (this.matchLabelExpressions == null) {this.matchLabelExpressions = new ArrayList<TopologySelectorLabelRequirementBuilder>();}
    TopologySelectorLabelRequirementBuilder builder = new TopologySelectorLabelRequirementBuilder(item);
    if (index < 0 || index >= matchLabelExpressions.size()) { _visitables.get("matchLabelExpressions").add(builder); matchLabelExpressions.add(builder); } else { _visitables.get("matchLabelExpressions").set(index, builder); matchLabelExpressions.set(index, builder);}
    return (A)this;
  }
  
  public A addToMatchLabelExpressions(io.fabric8.kubernetes.api.model.TopologySelectorLabelRequirement... items) {
    if (this.matchLabelExpressions == null) {this.matchLabelExpressions = new ArrayList<TopologySelectorLabelRequirementBuilder>();}
    for (TopologySelectorLabelRequirement item : items) {TopologySelectorLabelRequirementBuilder builder = new TopologySelectorLabelRequirementBuilder(item);_visitables.get("matchLabelExpressions").add(builder);this.matchLabelExpressions.add(builder);} return (A)this;
  }
  
  public A addAllToMatchLabelExpressions(Collection<TopologySelectorLabelRequirement> items) {
    if (this.matchLabelExpressions == null) {this.matchLabelExpressions = new ArrayList<TopologySelectorLabelRequirementBuilder>();}
    for (TopologySelectorLabelRequirement item : items) {TopologySelectorLabelRequirementBuilder builder = new TopologySelectorLabelRequirementBuilder(item);_visitables.get("matchLabelExpressions").add(builder);this.matchLabelExpressions.add(builder);} return (A)this;
  }
  
  public A removeFromMatchLabelExpressions(io.fabric8.kubernetes.api.model.TopologySelectorLabelRequirement... items) {
    if (this.matchLabelExpressions == null) return (A)this;
    for (TopologySelectorLabelRequirement item : items) {TopologySelectorLabelRequirementBuilder builder = new TopologySelectorLabelRequirementBuilder(item);_visitables.get("matchLabelExpressions").remove(builder); this.matchLabelExpressions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromMatchLabelExpressions(Collection<TopologySelectorLabelRequirement> items) {
    if (this.matchLabelExpressions == null) return (A)this;
    for (TopologySelectorLabelRequirement item : items) {TopologySelectorLabelRequirementBuilder builder = new TopologySelectorLabelRequirementBuilder(item);_visitables.get("matchLabelExpressions").remove(builder); this.matchLabelExpressions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromMatchLabelExpressions(Predicate<TopologySelectorLabelRequirementBuilder> predicate) {
    if (matchLabelExpressions == null) return (A) this;
    final Iterator<TopologySelectorLabelRequirementBuilder> each = matchLabelExpressions.iterator();
    final List visitables = _visitables.get("matchLabelExpressions");
    while (each.hasNext()) {
      TopologySelectorLabelRequirementBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<TopologySelectorLabelRequirement> buildMatchLabelExpressions() {
    return this.matchLabelExpressions != null ? build(matchLabelExpressions) : null;
  }
  
  public TopologySelectorLabelRequirement buildMatchLabelExpression(int index) {
    return this.matchLabelExpressions.get(index).build();
  }
  
  public TopologySelectorLabelRequirement buildFirstMatchLabelExpression() {
    return this.matchLabelExpressions.get(0).build();
  }
  
  public TopologySelectorLabelRequirement buildLastMatchLabelExpression() {
    return this.matchLabelExpressions.get(matchLabelExpressions.size() - 1).build();
  }
  
  public TopologySelectorLabelRequirement buildMatchingMatchLabelExpression(Predicate<TopologySelectorLabelRequirementBuilder> predicate) {
      for (TopologySelectorLabelRequirementBuilder item : matchLabelExpressions) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingMatchLabelExpression(Predicate<TopologySelectorLabelRequirementBuilder> predicate) {
      for (TopologySelectorLabelRequirementBuilder item : matchLabelExpressions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withMatchLabelExpressions(List<TopologySelectorLabelRequirement> matchLabelExpressions) {
    if (this.matchLabelExpressions != null) {
      this._visitables.get("matchLabelExpressions").clear();
    }
    if (matchLabelExpressions != null) {
        this.matchLabelExpressions = new ArrayList();
        for (TopologySelectorLabelRequirement item : matchLabelExpressions) {
          this.addToMatchLabelExpressions(item);
        }
    } else {
      this.matchLabelExpressions = null;
    }
    return (A) this;
  }
  
  public A withMatchLabelExpressions(io.fabric8.kubernetes.api.model.TopologySelectorLabelRequirement... matchLabelExpressions) {
    if (this.matchLabelExpressions != null) {this.matchLabelExpressions.clear(); _visitables.remove("matchLabelExpressions"); }
    if (matchLabelExpressions != null) {for (TopologySelectorLabelRequirement item :matchLabelExpressions){ this.addToMatchLabelExpressions(item);}} return (A) this;
  }
  
  public boolean hasMatchLabelExpressions() {
    return this.matchLabelExpressions != null && !this.matchLabelExpressions.isEmpty();
  }
  
  public MatchLabelExpressionsNested<A> addNewMatchLabelExpression() {
    return new MatchLabelExpressionsNested(-1, null);
  }
  
  public MatchLabelExpressionsNested<A> addNewMatchLabelExpressionLike(TopologySelectorLabelRequirement item) {
    return new MatchLabelExpressionsNested(-1, item);
  }
  
  public MatchLabelExpressionsNested<A> setNewMatchLabelExpressionLike(int index,TopologySelectorLabelRequirement item) {
    return new MatchLabelExpressionsNested(index, item);
  }
  
  public MatchLabelExpressionsNested<A> editMatchLabelExpression(int index) {
    if (matchLabelExpressions.size() <= index) throw new RuntimeException("Can't edit matchLabelExpressions. Index exceeds size.");
    return setNewMatchLabelExpressionLike(index, buildMatchLabelExpression(index));
  }
  
  public MatchLabelExpressionsNested<A> editFirstMatchLabelExpression() {
    if (matchLabelExpressions.size() == 0) throw new RuntimeException("Can't edit first matchLabelExpressions. The list is empty.");
    return setNewMatchLabelExpressionLike(0, buildMatchLabelExpression(0));
  }
  
  public MatchLabelExpressionsNested<A> editLastMatchLabelExpression() {
    int index = matchLabelExpressions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last matchLabelExpressions. The list is empty.");
    return setNewMatchLabelExpressionLike(index, buildMatchLabelExpression(index));
  }
  
  public MatchLabelExpressionsNested<A> editMatchingMatchLabelExpression(Predicate<TopologySelectorLabelRequirementBuilder> predicate) {
    int index = -1;
    for (int i=0;i<matchLabelExpressions.size();i++) { 
    if (predicate.test(matchLabelExpressions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching matchLabelExpressions. No match found.");
    return setNewMatchLabelExpressionLike(index, buildMatchLabelExpression(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TopologySelectorTermFluent that = (TopologySelectorTermFluent) o;
    if (!java.util.Objects.equals(matchLabelExpressions, that.matchLabelExpressions)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(matchLabelExpressions,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (matchLabelExpressions != null && !matchLabelExpressions.isEmpty()) { sb.append("matchLabelExpressions:"); sb.append(matchLabelExpressions + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class MatchLabelExpressionsNested<N> extends TopologySelectorLabelRequirementFluent<MatchLabelExpressionsNested<N>> implements Nested<N>{
    MatchLabelExpressionsNested(int index,TopologySelectorLabelRequirement item) {
      this.index = index;
      this.builder = new TopologySelectorLabelRequirementBuilder(this, item);
    }
    TopologySelectorLabelRequirementBuilder builder;
    int index;
    
    public N and() {
      return (N) TopologySelectorTermFluent.this.setToMatchLabelExpressions(index,builder.build());
    }
    
    public N endMatchLabelExpression() {
      return and();
    }
    
  
  }

}