package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PersistentVolumeClaimSpecBuilder extends PersistentVolumeClaimSpecFluent<PersistentVolumeClaimSpecBuilder> implements VisitableBuilder<PersistentVolumeClaimSpec,PersistentVolumeClaimSpecBuilder>{
  public PersistentVolumeClaimSpecBuilder() {
    this(new PersistentVolumeClaimSpec());
  }
  
  public PersistentVolumeClaimSpecBuilder(PersistentVolumeClaimSpecFluent<?> fluent) {
    this(fluent, new PersistentVolumeClaimSpec());
  }
  
  public PersistentVolumeClaimSpecBuilder(PersistentVolumeClaimSpecFluent<?> fluent,PersistentVolumeClaimSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PersistentVolumeClaimSpecBuilder(PersistentVolumeClaimSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PersistentVolumeClaimSpecFluent<?> fluent;
  
  public PersistentVolumeClaimSpec build() {
    PersistentVolumeClaimSpec buildable = new PersistentVolumeClaimSpec(fluent.getAccessModes(),fluent.buildDataSource(),fluent.buildDataSourceRef(),fluent.buildResources(),fluent.buildSelector(),fluent.getStorageClassName(),fluent.getVolumeMode(),fluent.getVolumeName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}