package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NamedClusterFluent<A extends NamedClusterFluent<A>> extends BaseFluent<A>{
  public NamedClusterFluent() {
  }
  
  public NamedClusterFluent(NamedCluster instance) {
    this.copyInstance(instance);
  }
  private ClusterBuilder cluster;
  private String name;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NamedCluster instance) {
    instance = (instance != null ? instance : new NamedCluster());
    if (instance != null) {
          this.withCluster(instance.getCluster());
          this.withName(instance.getName());
          this.withCluster(instance.getCluster());
          this.withName(instance.getName());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Cluster buildCluster() {
    return this.cluster != null ? this.cluster.build() : null;
  }
  
  public A withCluster(Cluster cluster) {
    this._visitables.remove(this.cluster);
    if (cluster != null) {
        this.cluster = new ClusterBuilder(cluster);
        this._visitables.get("cluster").add(this.cluster);
    } else {
        this.cluster = null;
        this._visitables.get("cluster").remove(this.cluster);
    }
    return (A) this;
  }
  
  public boolean hasCluster() {
    return this.cluster != null;
  }
  
  public ClusterNested<A> withNewCluster() {
    return new ClusterNested(null);
  }
  
  public ClusterNested<A> withNewClusterLike(Cluster item) {
    return new ClusterNested(item);
  }
  
  public ClusterNested<A> editCluster() {
    return withNewClusterLike(java.util.Optional.ofNullable(buildCluster()).orElse(null));
  }
  
  public ClusterNested<A> editOrNewCluster() {
    return withNewClusterLike(java.util.Optional.ofNullable(buildCluster()).orElse(new ClusterBuilder().build()));
  }
  
  public ClusterNested<A> editOrNewClusterLike(Cluster item) {
    return withNewClusterLike(java.util.Optional.ofNullable(buildCluster()).orElse(item));
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NamedClusterFluent that = (NamedClusterFluent) o;
    if (!java.util.Objects.equals(cluster, that.cluster)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(cluster,  name,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cluster != null) { sb.append("cluster:"); sb.append(cluster + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ClusterNested<N> extends ClusterFluent<ClusterNested<N>> implements Nested<N>{
    ClusterNested(Cluster item) {
      this.builder = new ClusterBuilder(this, item);
    }
    ClusterBuilder builder;
    
    public N and() {
      return (N) NamedClusterFluent.this.withCluster(builder.build());
    }
    
    public N endCluster() {
      return and();
    }
    
  
  }

}