package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CSIPersistentVolumeSourceFluent<A extends CSIPersistentVolumeSourceFluent<A>> extends BaseFluent<A>{
  public CSIPersistentVolumeSourceFluent() {
  }
  
  public CSIPersistentVolumeSourceFluent(CSIPersistentVolumeSource instance) {
    this.copyInstance(instance);
  }
  private SecretReferenceBuilder controllerExpandSecretRef;
  private SecretReferenceBuilder controllerPublishSecretRef;
  private String driver;
  private String fsType;
  private SecretReferenceBuilder nodeExpandSecretRef;
  private SecretReferenceBuilder nodePublishSecretRef;
  private SecretReferenceBuilder nodeStageSecretRef;
  private Boolean readOnly;
  private Map<String,String> volumeAttributes;
  private String volumeHandle;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(CSIPersistentVolumeSource instance) {
    instance = (instance != null ? instance : new CSIPersistentVolumeSource());
    if (instance != null) {
          this.withControllerExpandSecretRef(instance.getControllerExpandSecretRef());
          this.withControllerPublishSecretRef(instance.getControllerPublishSecretRef());
          this.withDriver(instance.getDriver());
          this.withFsType(instance.getFsType());
          this.withNodeExpandSecretRef(instance.getNodeExpandSecretRef());
          this.withNodePublishSecretRef(instance.getNodePublishSecretRef());
          this.withNodeStageSecretRef(instance.getNodeStageSecretRef());
          this.withReadOnly(instance.getReadOnly());
          this.withVolumeAttributes(instance.getVolumeAttributes());
          this.withVolumeHandle(instance.getVolumeHandle());
          this.withControllerExpandSecretRef(instance.getControllerExpandSecretRef());
          this.withControllerPublishSecretRef(instance.getControllerPublishSecretRef());
          this.withDriver(instance.getDriver());
          this.withFsType(instance.getFsType());
          this.withNodeExpandSecretRef(instance.getNodeExpandSecretRef());
          this.withNodePublishSecretRef(instance.getNodePublishSecretRef());
          this.withNodeStageSecretRef(instance.getNodeStageSecretRef());
          this.withReadOnly(instance.getReadOnly());
          this.withVolumeAttributes(instance.getVolumeAttributes());
          this.withVolumeHandle(instance.getVolumeHandle());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public SecretReference buildControllerExpandSecretRef() {
    return this.controllerExpandSecretRef != null ? this.controllerExpandSecretRef.build() : null;
  }
  
  public A withControllerExpandSecretRef(SecretReference controllerExpandSecretRef) {
    this._visitables.remove(this.controllerExpandSecretRef);
    if (controllerExpandSecretRef != null) {
        this.controllerExpandSecretRef = new SecretReferenceBuilder(controllerExpandSecretRef);
        this._visitables.get("controllerExpandSecretRef").add(this.controllerExpandSecretRef);
    } else {
        this.controllerExpandSecretRef = null;
        this._visitables.get("controllerExpandSecretRef").remove(this.controllerExpandSecretRef);
    }
    return (A) this;
  }
  
  public boolean hasControllerExpandSecretRef() {
    return this.controllerExpandSecretRef != null;
  }
  
  public A withNewControllerExpandSecretRef(String name,String namespace) {
    return (A)withControllerExpandSecretRef(new SecretReference(name, namespace));
  }
  
  public ControllerExpandSecretRefNested<A> withNewControllerExpandSecretRef() {
    return new ControllerExpandSecretRefNested(null);
  }
  
  public ControllerExpandSecretRefNested<A> withNewControllerExpandSecretRefLike(SecretReference item) {
    return new ControllerExpandSecretRefNested(item);
  }
  
  public ControllerExpandSecretRefNested<A> editControllerExpandSecretRef() {
    return withNewControllerExpandSecretRefLike(java.util.Optional.ofNullable(buildControllerExpandSecretRef()).orElse(null));
  }
  
  public ControllerExpandSecretRefNested<A> editOrNewControllerExpandSecretRef() {
    return withNewControllerExpandSecretRefLike(java.util.Optional.ofNullable(buildControllerExpandSecretRef()).orElse(new SecretReferenceBuilder().build()));
  }
  
  public ControllerExpandSecretRefNested<A> editOrNewControllerExpandSecretRefLike(SecretReference item) {
    return withNewControllerExpandSecretRefLike(java.util.Optional.ofNullable(buildControllerExpandSecretRef()).orElse(item));
  }
  
  public SecretReference buildControllerPublishSecretRef() {
    return this.controllerPublishSecretRef != null ? this.controllerPublishSecretRef.build() : null;
  }
  
  public A withControllerPublishSecretRef(SecretReference controllerPublishSecretRef) {
    this._visitables.remove(this.controllerPublishSecretRef);
    if (controllerPublishSecretRef != null) {
        this.controllerPublishSecretRef = new SecretReferenceBuilder(controllerPublishSecretRef);
        this._visitables.get("controllerPublishSecretRef").add(this.controllerPublishSecretRef);
    } else {
        this.controllerPublishSecretRef = null;
        this._visitables.get("controllerPublishSecretRef").remove(this.controllerPublishSecretRef);
    }
    return (A) this;
  }
  
  public boolean hasControllerPublishSecretRef() {
    return this.controllerPublishSecretRef != null;
  }
  
  public A withNewControllerPublishSecretRef(String name,String namespace) {
    return (A)withControllerPublishSecretRef(new SecretReference(name, namespace));
  }
  
  public ControllerPublishSecretRefNested<A> withNewControllerPublishSecretRef() {
    return new ControllerPublishSecretRefNested(null);
  }
  
  public ControllerPublishSecretRefNested<A> withNewControllerPublishSecretRefLike(SecretReference item) {
    return new ControllerPublishSecretRefNested(item);
  }
  
  public ControllerPublishSecretRefNested<A> editControllerPublishSecretRef() {
    return withNewControllerPublishSecretRefLike(java.util.Optional.ofNullable(buildControllerPublishSecretRef()).orElse(null));
  }
  
  public ControllerPublishSecretRefNested<A> editOrNewControllerPublishSecretRef() {
    return withNewControllerPublishSecretRefLike(java.util.Optional.ofNullable(buildControllerPublishSecretRef()).orElse(new SecretReferenceBuilder().build()));
  }
  
  public ControllerPublishSecretRefNested<A> editOrNewControllerPublishSecretRefLike(SecretReference item) {
    return withNewControllerPublishSecretRefLike(java.util.Optional.ofNullable(buildControllerPublishSecretRef()).orElse(item));
  }
  
  public String getDriver() {
    return this.driver;
  }
  
  public A withDriver(String driver) {
    this.driver = driver;
    return (A) this;
  }
  
  public boolean hasDriver() {
    return this.driver != null;
  }
  
  public String getFsType() {
    return this.fsType;
  }
  
  public A withFsType(String fsType) {
    this.fsType = fsType;
    return (A) this;
  }
  
  public boolean hasFsType() {
    return this.fsType != null;
  }
  
  public SecretReference buildNodeExpandSecretRef() {
    return this.nodeExpandSecretRef != null ? this.nodeExpandSecretRef.build() : null;
  }
  
  public A withNodeExpandSecretRef(SecretReference nodeExpandSecretRef) {
    this._visitables.remove(this.nodeExpandSecretRef);
    if (nodeExpandSecretRef != null) {
        this.nodeExpandSecretRef = new SecretReferenceBuilder(nodeExpandSecretRef);
        this._visitables.get("nodeExpandSecretRef").add(this.nodeExpandSecretRef);
    } else {
        this.nodeExpandSecretRef = null;
        this._visitables.get("nodeExpandSecretRef").remove(this.nodeExpandSecretRef);
    }
    return (A) this;
  }
  
  public boolean hasNodeExpandSecretRef() {
    return this.nodeExpandSecretRef != null;
  }
  
  public A withNewNodeExpandSecretRef(String name,String namespace) {
    return (A)withNodeExpandSecretRef(new SecretReference(name, namespace));
  }
  
  public NodeExpandSecretRefNested<A> withNewNodeExpandSecretRef() {
    return new NodeExpandSecretRefNested(null);
  }
  
  public NodeExpandSecretRefNested<A> withNewNodeExpandSecretRefLike(SecretReference item) {
    return new NodeExpandSecretRefNested(item);
  }
  
  public NodeExpandSecretRefNested<A> editNodeExpandSecretRef() {
    return withNewNodeExpandSecretRefLike(java.util.Optional.ofNullable(buildNodeExpandSecretRef()).orElse(null));
  }
  
  public NodeExpandSecretRefNested<A> editOrNewNodeExpandSecretRef() {
    return withNewNodeExpandSecretRefLike(java.util.Optional.ofNullable(buildNodeExpandSecretRef()).orElse(new SecretReferenceBuilder().build()));
  }
  
  public NodeExpandSecretRefNested<A> editOrNewNodeExpandSecretRefLike(SecretReference item) {
    return withNewNodeExpandSecretRefLike(java.util.Optional.ofNullable(buildNodeExpandSecretRef()).orElse(item));
  }
  
  public SecretReference buildNodePublishSecretRef() {
    return this.nodePublishSecretRef != null ? this.nodePublishSecretRef.build() : null;
  }
  
  public A withNodePublishSecretRef(SecretReference nodePublishSecretRef) {
    this._visitables.remove(this.nodePublishSecretRef);
    if (nodePublishSecretRef != null) {
        this.nodePublishSecretRef = new SecretReferenceBuilder(nodePublishSecretRef);
        this._visitables.get("nodePublishSecretRef").add(this.nodePublishSecretRef);
    } else {
        this.nodePublishSecretRef = null;
        this._visitables.get("nodePublishSecretRef").remove(this.nodePublishSecretRef);
    }
    return (A) this;
  }
  
  public boolean hasNodePublishSecretRef() {
    return this.nodePublishSecretRef != null;
  }
  
  public A withNewNodePublishSecretRef(String name,String namespace) {
    return (A)withNodePublishSecretRef(new SecretReference(name, namespace));
  }
  
  public NodePublishSecretRefNested<A> withNewNodePublishSecretRef() {
    return new NodePublishSecretRefNested(null);
  }
  
  public NodePublishSecretRefNested<A> withNewNodePublishSecretRefLike(SecretReference item) {
    return new NodePublishSecretRefNested(item);
  }
  
  public NodePublishSecretRefNested<A> editNodePublishSecretRef() {
    return withNewNodePublishSecretRefLike(java.util.Optional.ofNullable(buildNodePublishSecretRef()).orElse(null));
  }
  
  public NodePublishSecretRefNested<A> editOrNewNodePublishSecretRef() {
    return withNewNodePublishSecretRefLike(java.util.Optional.ofNullable(buildNodePublishSecretRef()).orElse(new SecretReferenceBuilder().build()));
  }
  
  public NodePublishSecretRefNested<A> editOrNewNodePublishSecretRefLike(SecretReference item) {
    return withNewNodePublishSecretRefLike(java.util.Optional.ofNullable(buildNodePublishSecretRef()).orElse(item));
  }
  
  public SecretReference buildNodeStageSecretRef() {
    return this.nodeStageSecretRef != null ? this.nodeStageSecretRef.build() : null;
  }
  
  public A withNodeStageSecretRef(SecretReference nodeStageSecretRef) {
    this._visitables.remove(this.nodeStageSecretRef);
    if (nodeStageSecretRef != null) {
        this.nodeStageSecretRef = new SecretReferenceBuilder(nodeStageSecretRef);
        this._visitables.get("nodeStageSecretRef").add(this.nodeStageSecretRef);
    } else {
        this.nodeStageSecretRef = null;
        this._visitables.get("nodeStageSecretRef").remove(this.nodeStageSecretRef);
    }
    return (A) this;
  }
  
  public boolean hasNodeStageSecretRef() {
    return this.nodeStageSecretRef != null;
  }
  
  public A withNewNodeStageSecretRef(String name,String namespace) {
    return (A)withNodeStageSecretRef(new SecretReference(name, namespace));
  }
  
  public NodeStageSecretRefNested<A> withNewNodeStageSecretRef() {
    return new NodeStageSecretRefNested(null);
  }
  
  public NodeStageSecretRefNested<A> withNewNodeStageSecretRefLike(SecretReference item) {
    return new NodeStageSecretRefNested(item);
  }
  
  public NodeStageSecretRefNested<A> editNodeStageSecretRef() {
    return withNewNodeStageSecretRefLike(java.util.Optional.ofNullable(buildNodeStageSecretRef()).orElse(null));
  }
  
  public NodeStageSecretRefNested<A> editOrNewNodeStageSecretRef() {
    return withNewNodeStageSecretRefLike(java.util.Optional.ofNullable(buildNodeStageSecretRef()).orElse(new SecretReferenceBuilder().build()));
  }
  
  public NodeStageSecretRefNested<A> editOrNewNodeStageSecretRefLike(SecretReference item) {
    return withNewNodeStageSecretRefLike(java.util.Optional.ofNullable(buildNodeStageSecretRef()).orElse(item));
  }
  
  public Boolean getReadOnly() {
    return this.readOnly;
  }
  
  public A withReadOnly(Boolean readOnly) {
    this.readOnly = readOnly;
    return (A) this;
  }
  
  public boolean hasReadOnly() {
    return this.readOnly != null;
  }
  
  public A addToVolumeAttributes(String key,String value) {
    if(this.volumeAttributes == null && key != null && value != null) { this.volumeAttributes = new LinkedHashMap(); }
    if(key != null && value != null) {this.volumeAttributes.put(key, value);} return (A)this;
  }
  
  public A addToVolumeAttributes(Map<String,String> map) {
    if(this.volumeAttributes == null && map != null) { this.volumeAttributes = new LinkedHashMap(); }
    if(map != null) { this.volumeAttributes.putAll(map);} return (A)this;
  }
  
  public A removeFromVolumeAttributes(String key) {
    if(this.volumeAttributes == null) { return (A) this; }
    if(key != null && this.volumeAttributes != null) {this.volumeAttributes.remove(key);} return (A)this;
  }
  
  public A removeFromVolumeAttributes(Map<String,String> map) {
    if(this.volumeAttributes == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.volumeAttributes != null){this.volumeAttributes.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getVolumeAttributes() {
    return this.volumeAttributes;
  }
  
  public <K,V>A withVolumeAttributes(Map<String,String> volumeAttributes) {
    if (volumeAttributes == null) {
      this.volumeAttributes = null;
    } else {
      this.volumeAttributes = new LinkedHashMap(volumeAttributes);
    }
    return (A) this;
  }
  
  public boolean hasVolumeAttributes() {
    return this.volumeAttributes != null;
  }
  
  public String getVolumeHandle() {
    return this.volumeHandle;
  }
  
  public A withVolumeHandle(String volumeHandle) {
    this.volumeHandle = volumeHandle;
    return (A) this;
  }
  
  public boolean hasVolumeHandle() {
    return this.volumeHandle != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CSIPersistentVolumeSourceFluent that = (CSIPersistentVolumeSourceFluent) o;
    if (!java.util.Objects.equals(controllerExpandSecretRef, that.controllerExpandSecretRef)) return false;
    if (!java.util.Objects.equals(controllerPublishSecretRef, that.controllerPublishSecretRef)) return false;
    if (!java.util.Objects.equals(driver, that.driver)) return false;
    if (!java.util.Objects.equals(fsType, that.fsType)) return false;
    if (!java.util.Objects.equals(nodeExpandSecretRef, that.nodeExpandSecretRef)) return false;
    if (!java.util.Objects.equals(nodePublishSecretRef, that.nodePublishSecretRef)) return false;
    if (!java.util.Objects.equals(nodeStageSecretRef, that.nodeStageSecretRef)) return false;
    if (!java.util.Objects.equals(readOnly, that.readOnly)) return false;
    if (!java.util.Objects.equals(volumeAttributes, that.volumeAttributes)) return false;
    if (!java.util.Objects.equals(volumeHandle, that.volumeHandle)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(controllerExpandSecretRef,  controllerPublishSecretRef,  driver,  fsType,  nodeExpandSecretRef,  nodePublishSecretRef,  nodeStageSecretRef,  readOnly,  volumeAttributes,  volumeHandle,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (controllerExpandSecretRef != null) { sb.append("controllerExpandSecretRef:"); sb.append(controllerExpandSecretRef + ","); }
    if (controllerPublishSecretRef != null) { sb.append("controllerPublishSecretRef:"); sb.append(controllerPublishSecretRef + ","); }
    if (driver != null) { sb.append("driver:"); sb.append(driver + ","); }
    if (fsType != null) { sb.append("fsType:"); sb.append(fsType + ","); }
    if (nodeExpandSecretRef != null) { sb.append("nodeExpandSecretRef:"); sb.append(nodeExpandSecretRef + ","); }
    if (nodePublishSecretRef != null) { sb.append("nodePublishSecretRef:"); sb.append(nodePublishSecretRef + ","); }
    if (nodeStageSecretRef != null) { sb.append("nodeStageSecretRef:"); sb.append(nodeStageSecretRef + ","); }
    if (readOnly != null) { sb.append("readOnly:"); sb.append(readOnly + ","); }
    if (volumeAttributes != null && !volumeAttributes.isEmpty()) { sb.append("volumeAttributes:"); sb.append(volumeAttributes + ","); }
    if (volumeHandle != null) { sb.append("volumeHandle:"); sb.append(volumeHandle + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withReadOnly() {
    return withReadOnly(true);
  }
  public class ControllerExpandSecretRefNested<N> extends SecretReferenceFluent<ControllerExpandSecretRefNested<N>> implements Nested<N>{
    ControllerExpandSecretRefNested(SecretReference item) {
      this.builder = new SecretReferenceBuilder(this, item);
    }
    SecretReferenceBuilder builder;
    
    public N and() {
      return (N) CSIPersistentVolumeSourceFluent.this.withControllerExpandSecretRef(builder.build());
    }
    
    public N endControllerExpandSecretRef() {
      return and();
    }
    
  
  }
  public class ControllerPublishSecretRefNested<N> extends SecretReferenceFluent<ControllerPublishSecretRefNested<N>> implements Nested<N>{
    ControllerPublishSecretRefNested(SecretReference item) {
      this.builder = new SecretReferenceBuilder(this, item);
    }
    SecretReferenceBuilder builder;
    
    public N and() {
      return (N) CSIPersistentVolumeSourceFluent.this.withControllerPublishSecretRef(builder.build());
    }
    
    public N endControllerPublishSecretRef() {
      return and();
    }
    
  
  }
  public class NodeExpandSecretRefNested<N> extends SecretReferenceFluent<NodeExpandSecretRefNested<N>> implements Nested<N>{
    NodeExpandSecretRefNested(SecretReference item) {
      this.builder = new SecretReferenceBuilder(this, item);
    }
    SecretReferenceBuilder builder;
    
    public N and() {
      return (N) CSIPersistentVolumeSourceFluent.this.withNodeExpandSecretRef(builder.build());
    }
    
    public N endNodeExpandSecretRef() {
      return and();
    }
    
  
  }
  public class NodePublishSecretRefNested<N> extends SecretReferenceFluent<NodePublishSecretRefNested<N>> implements Nested<N>{
    NodePublishSecretRefNested(SecretReference item) {
      this.builder = new SecretReferenceBuilder(this, item);
    }
    SecretReferenceBuilder builder;
    
    public N and() {
      return (N) CSIPersistentVolumeSourceFluent.this.withNodePublishSecretRef(builder.build());
    }
    
    public N endNodePublishSecretRef() {
      return and();
    }
    
  
  }
  public class NodeStageSecretRefNested<N> extends SecretReferenceFluent<NodeStageSecretRefNested<N>> implements Nested<N>{
    NodeStageSecretRefNested(SecretReference item) {
      this.builder = new SecretReferenceBuilder(this, item);
    }
    SecretReferenceBuilder builder;
    
    public N and() {
      return (N) CSIPersistentVolumeSourceFluent.this.withNodeStageSecretRef(builder.build());
    }
    
    public N endNodeStageSecretRef() {
      return and();
    }
    
  
  }

}