package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TopologySpreadConstraintBuilder extends TopologySpreadConstraintFluent<TopologySpreadConstraintBuilder> implements VisitableBuilder<TopologySpreadConstraint,TopologySpreadConstraintBuilder>{
  public TopologySpreadConstraintBuilder() {
    this(false);
  }
  public TopologySpreadConstraintBuilder(Boolean validationEnabled) {
    this(new TopologySpreadConstraint(), validationEnabled);
  }
  public TopologySpreadConstraintBuilder(TopologySpreadConstraintFluent<?> fluent) {
    this(fluent, false);
  }
  public TopologySpreadConstraintBuilder(TopologySpreadConstraintFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TopologySpreadConstraint(), validationEnabled);
  }
  public TopologySpreadConstraintBuilder(TopologySpreadConstraintFluent<?> fluent,TopologySpreadConstraint instance) {
    this(fluent, instance, false);
  }
  public TopologySpreadConstraintBuilder(TopologySpreadConstraintFluent<?> fluent,TopologySpreadConstraint instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TopologySpreadConstraint());

    if (instance != null) {
      fluent.withLabelSelector(instance.getLabelSelector());
      fluent.withMatchLabelKeys(instance.getMatchLabelKeys());
      fluent.withMaxSkew(instance.getMaxSkew());
      fluent.withMinDomains(instance.getMinDomains());
      fluent.withNodeAffinityPolicy(instance.getNodeAffinityPolicy());
      fluent.withNodeTaintsPolicy(instance.getNodeTaintsPolicy());
      fluent.withTopologyKey(instance.getTopologyKey());
      fluent.withWhenUnsatisfiable(instance.getWhenUnsatisfiable());
      fluent.withLabelSelector(instance.getLabelSelector());
      fluent.withMatchLabelKeys(instance.getMatchLabelKeys());
      fluent.withMaxSkew(instance.getMaxSkew());
      fluent.withMinDomains(instance.getMinDomains());
      fluent.withNodeAffinityPolicy(instance.getNodeAffinityPolicy());
      fluent.withNodeTaintsPolicy(instance.getNodeTaintsPolicy());
      fluent.withTopologyKey(instance.getTopologyKey());
      fluent.withWhenUnsatisfiable(instance.getWhenUnsatisfiable());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TopologySpreadConstraintBuilder(TopologySpreadConstraint instance) {
    this(instance,false);
  }
  public TopologySpreadConstraintBuilder(TopologySpreadConstraint instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TopologySpreadConstraint());

    if (instance != null) {
      this.withLabelSelector(instance.getLabelSelector());
      this.withMatchLabelKeys(instance.getMatchLabelKeys());
      this.withMaxSkew(instance.getMaxSkew());
      this.withMinDomains(instance.getMinDomains());
      this.withNodeAffinityPolicy(instance.getNodeAffinityPolicy());
      this.withNodeTaintsPolicy(instance.getNodeTaintsPolicy());
      this.withTopologyKey(instance.getTopologyKey());
      this.withWhenUnsatisfiable(instance.getWhenUnsatisfiable());
      this.withLabelSelector(instance.getLabelSelector());
      this.withMatchLabelKeys(instance.getMatchLabelKeys());
      this.withMaxSkew(instance.getMaxSkew());
      this.withMinDomains(instance.getMinDomains());
      this.withNodeAffinityPolicy(instance.getNodeAffinityPolicy());
      this.withNodeTaintsPolicy(instance.getNodeTaintsPolicy());
      this.withTopologyKey(instance.getTopologyKey());
      this.withWhenUnsatisfiable(instance.getWhenUnsatisfiable());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TopologySpreadConstraintFluent<?> fluent;
  Boolean validationEnabled;
  public TopologySpreadConstraint build() {
    TopologySpreadConstraint buildable = new TopologySpreadConstraint(fluent.buildLabelSelector(),fluent.getMatchLabelKeys(),fluent.getMaxSkew(),fluent.getMinDomains(),fluent.getNodeAffinityPolicy(),fluent.getNodeTaintsPolicy(),fluent.getTopologyKey(),fluent.getWhenUnsatisfiable());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}