package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TaintBuilder extends TaintFluent<TaintBuilder> implements VisitableBuilder<Taint,TaintBuilder>{
  public TaintBuilder() {
    this(false);
  }
  public TaintBuilder(Boolean validationEnabled) {
    this(new Taint(), validationEnabled);
  }
  public TaintBuilder(TaintFluent<?> fluent) {
    this(fluent, false);
  }
  public TaintBuilder(TaintFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Taint(), validationEnabled);
  }
  public TaintBuilder(TaintFluent<?> fluent,Taint instance) {
    this(fluent, instance, false);
  }
  public TaintBuilder(TaintFluent<?> fluent,Taint instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Taint());

    if (instance != null) {
      fluent.withEffect(instance.getEffect());
      fluent.withKey(instance.getKey());
      fluent.withTimeAdded(instance.getTimeAdded());
      fluent.withValue(instance.getValue());
      fluent.withEffect(instance.getEffect());
      fluent.withKey(instance.getKey());
      fluent.withTimeAdded(instance.getTimeAdded());
      fluent.withValue(instance.getValue());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TaintBuilder(Taint instance) {
    this(instance,false);
  }
  public TaintBuilder(Taint instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Taint());

    if (instance != null) {
      this.withEffect(instance.getEffect());
      this.withKey(instance.getKey());
      this.withTimeAdded(instance.getTimeAdded());
      this.withValue(instance.getValue());
      this.withEffect(instance.getEffect());
      this.withKey(instance.getKey());
      this.withTimeAdded(instance.getTimeAdded());
      this.withValue(instance.getValue());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TaintFluent<?> fluent;
  Boolean validationEnabled;
  public Taint build() {
    Taint buildable = new Taint(fluent.getEffect(),fluent.getKey(),fluent.getTimeAdded(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}