package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class StatusFluent<A extends StatusFluent<A>> extends BaseFluent<A>{
  public StatusFluent() {
  }
  public StatusFluent(Status instance) {
    instance = (instance != null ? instance : new Status());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withCode(instance.getCode());
      this.withDetails(instance.getDetails());
      this.withKind(instance.getKind());
      this.withMessage(instance.getMessage());
      this.withMetadata(instance.getMetadata());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withCode(instance.getCode());
      this.withDetails(instance.getDetails());
      this.withKind(instance.getKind());
      this.withMessage(instance.getMessage());
      this.withMetadata(instance.getMetadata());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVersion;
  private Integer code;
  private StatusDetailsBuilder details;
  private String kind;
  private String message;
  private ListMetaBuilder metadata;
  private String reason;
  private String status;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public Integer getCode() {
    return this.code;
  }
  public A withCode(Integer code) {
    this.code=code; return (A) this;
  }
  public boolean hasCode() {
    return this.code != null;
  }
  public StatusDetails buildDetails() {
    return this.details!=null ?this.details.build():null;
  }
  public A withDetails(StatusDetails details) {
    _visitables.get("details").remove(this.details);
    if (details!=null){ this.details= new StatusDetailsBuilder(details); _visitables.get("details").add(this.details);} else { this.details = null; _visitables.get("details").remove(this.details); } return (A) this;
  }
  public boolean hasDetails() {
    return this.details != null;
  }
  public DetailsNested<A> withNewDetails() {
    return new DetailsNested(null);
  }
  public DetailsNested<A> withNewDetailsLike(StatusDetails item) {
    return new DetailsNested(item);
  }
  public DetailsNested<A> editDetails() {
    return withNewDetailsLike(java.util.Optional.ofNullable(buildDetails()).orElse(null));
  }
  public DetailsNested<A> editOrNewDetails() {
    return withNewDetailsLike(java.util.Optional.ofNullable(buildDetails()).orElse(new StatusDetailsBuilder().build()));
  }
  public DetailsNested<A> editOrNewDetailsLike(StatusDetails item) {
    return withNewDetailsLike(java.util.Optional.ofNullable(buildDetails()).orElse(item));
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public boolean hasKind() {
    return this.kind != null;
  }
  public String getMessage() {
    return this.message;
  }
  public A withMessage(String message) {
    this.message=message; return (A) this;
  }
  public boolean hasMessage() {
    return this.message != null;
  }
  public ListMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ListMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink) {
    return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
  }
  public MetadataNested<A> withNewMetadata() {
    return new MetadataNested(null);
  }
  public MetadataNested<A> withNewMetadataLike(ListMeta item) {
    return new MetadataNested(item);
  }
  public MetadataNested<A> editMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(null));
  }
  public MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(new ListMetaBuilder().build()));
  }
  public MetadataNested<A> editOrNewMetadataLike(ListMeta item) {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(item));
  }
  public String getReason() {
    return this.reason;
  }
  public A withReason(String reason) {
    this.reason=reason; return (A) this;
  }
  public boolean hasReason() {
    return this.reason != null;
  }
  public String getStatus() {
    return this.status;
  }
  public A withStatus(String status) {
    this.status=status; return (A) this;
  }
  public boolean hasStatus() {
    return this.status != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    StatusFluent that = (StatusFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(code, that.code)) return false;

    if (!java.util.Objects.equals(details, that.details)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(message, that.message)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(reason, that.reason)) return false;

    if (!java.util.Objects.equals(status, that.status)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  code,  details,  kind,  message,  metadata,  reason,  status,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (code != null) { sb.append("code:"); sb.append(code + ","); }
    if (details != null) { sb.append("details:"); sb.append(details + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (message != null) { sb.append("message:"); sb.append(message + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (reason != null) { sb.append("reason:"); sb.append(reason + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DetailsNested<N> extends StatusDetailsFluent<DetailsNested<N>> implements Nested<N>{
    DetailsNested(StatusDetails item) {
      this.builder = new StatusDetailsBuilder(this, item);
    }
    StatusDetailsBuilder builder;
    public N and() {
      return (N) StatusFluent.this.withDetails(builder.build());
    }
    public N endDetails() {
      return and();
    }
    
  }
  public class MetadataNested<N> extends ListMetaFluent<MetadataNested<N>> implements Nested<N>{
    MetadataNested(ListMeta item) {
      this.builder = new ListMetaBuilder(this, item);
    }
    ListMetaBuilder builder;
    public N and() {
      return (N) StatusFluent.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}