package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ServicePortFluent<A extends ServicePortFluent<A>> extends BaseFluent<A>{
  public ServicePortFluent() {
  }
  public ServicePortFluent(ServicePort instance) {
    instance = (instance != null ? instance : new ServicePort());

    if (instance != null) {
      this.withAppProtocol(instance.getAppProtocol());
      this.withName(instance.getName());
      this.withNodePort(instance.getNodePort());
      this.withPort(instance.getPort());
      this.withProtocol(instance.getProtocol());
      this.withTargetPort(instance.getTargetPort());
      this.withAppProtocol(instance.getAppProtocol());
      this.withName(instance.getName());
      this.withNodePort(instance.getNodePort());
      this.withPort(instance.getPort());
      this.withProtocol(instance.getProtocol());
      this.withTargetPort(instance.getTargetPort());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String appProtocol;
  private String name;
  private Integer nodePort;
  private Integer port;
  private String protocol;
  private IntOrStringBuilder targetPort;
  private Map<String,Object> additionalProperties;
  public String getAppProtocol() {
    return this.appProtocol;
  }
  public A withAppProtocol(String appProtocol) {
    this.appProtocol=appProtocol; return (A) this;
  }
  public boolean hasAppProtocol() {
    return this.appProtocol != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public boolean hasName() {
    return this.name != null;
  }
  public Integer getNodePort() {
    return this.nodePort;
  }
  public A withNodePort(Integer nodePort) {
    this.nodePort=nodePort; return (A) this;
  }
  public boolean hasNodePort() {
    return this.nodePort != null;
  }
  public Integer getPort() {
    return this.port;
  }
  public A withPort(Integer port) {
    this.port=port; return (A) this;
  }
  public boolean hasPort() {
    return this.port != null;
  }
  public String getProtocol() {
    return this.protocol;
  }
  public A withProtocol(String protocol) {
    this.protocol=protocol; return (A) this;
  }
  public boolean hasProtocol() {
    return this.protocol != null;
  }
  public IntOrString buildTargetPort() {
    return this.targetPort!=null ?this.targetPort.build():null;
  }
  public A withTargetPort(IntOrString targetPort) {
    _visitables.get("targetPort").remove(this.targetPort);
    if (targetPort!=null){ this.targetPort= new IntOrStringBuilder(targetPort); _visitables.get("targetPort").add(this.targetPort);} else { this.targetPort = null; _visitables.get("targetPort").remove(this.targetPort); } return (A) this;
  }
  public boolean hasTargetPort() {
    return this.targetPort != null;
  }
  public A withNewTargetPort(Object value) {
    return (A)withTargetPort(new IntOrString(value));
  }
  public TargetPortNested<A> withNewTargetPort() {
    return new TargetPortNested(null);
  }
  public TargetPortNested<A> withNewTargetPortLike(IntOrString item) {
    return new TargetPortNested(item);
  }
  public TargetPortNested<A> editTargetPort() {
    return withNewTargetPortLike(java.util.Optional.ofNullable(buildTargetPort()).orElse(null));
  }
  public TargetPortNested<A> editOrNewTargetPort() {
    return withNewTargetPortLike(java.util.Optional.ofNullable(buildTargetPort()).orElse(new IntOrStringBuilder().build()));
  }
  public TargetPortNested<A> editOrNewTargetPortLike(IntOrString item) {
    return withNewTargetPortLike(java.util.Optional.ofNullable(buildTargetPort()).orElse(item));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServicePortFluent that = (ServicePortFluent) o;
    if (!java.util.Objects.equals(appProtocol, that.appProtocol)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(nodePort, that.nodePort)) return false;

    if (!java.util.Objects.equals(port, that.port)) return false;

    if (!java.util.Objects.equals(protocol, that.protocol)) return false;

    if (!java.util.Objects.equals(targetPort, that.targetPort)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(appProtocol,  name,  nodePort,  port,  protocol,  targetPort,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (appProtocol != null) { sb.append("appProtocol:"); sb.append(appProtocol + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (nodePort != null) { sb.append("nodePort:"); sb.append(nodePort + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (protocol != null) { sb.append("protocol:"); sb.append(protocol + ","); }
    if (targetPort != null) { sb.append("targetPort:"); sb.append(targetPort + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class TargetPortNested<N> extends IntOrStringFluent<TargetPortNested<N>> implements Nested<N>{
    TargetPortNested(IntOrString item) {
      this.builder = new IntOrStringBuilder(this, item);
    }
    IntOrStringBuilder builder;
    public N and() {
      return (N) ServicePortFluent.this.withTargetPort(builder.build());
    }
    public N endTargetPort() {
      return and();
    }
    
  }
  
}