package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretVolumeSourceBuilder extends SecretVolumeSourceFluent<SecretVolumeSourceBuilder> implements VisitableBuilder<SecretVolumeSource,SecretVolumeSourceBuilder>{
  public SecretVolumeSourceBuilder() {
    this(false);
  }
  public SecretVolumeSourceBuilder(Boolean validationEnabled) {
    this(new SecretVolumeSource(), validationEnabled);
  }
  public SecretVolumeSourceBuilder(SecretVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretVolumeSourceBuilder(SecretVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SecretVolumeSource(), validationEnabled);
  }
  public SecretVolumeSourceBuilder(SecretVolumeSourceFluent<?> fluent,SecretVolumeSource instance) {
    this(fluent, instance, false);
  }
  public SecretVolumeSourceBuilder(SecretVolumeSourceFluent<?> fluent,SecretVolumeSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SecretVolumeSource());

    if (instance != null) {
      fluent.withDefaultMode(instance.getDefaultMode());
      fluent.withItems(instance.getItems());
      fluent.withOptional(instance.getOptional());
      fluent.withSecretName(instance.getSecretName());
      fluent.withDefaultMode(instance.getDefaultMode());
      fluent.withItems(instance.getItems());
      fluent.withOptional(instance.getOptional());
      fluent.withSecretName(instance.getSecretName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SecretVolumeSourceBuilder(SecretVolumeSource instance) {
    this(instance,false);
  }
  public SecretVolumeSourceBuilder(SecretVolumeSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SecretVolumeSource());

    if (instance != null) {
      this.withDefaultMode(instance.getDefaultMode());
      this.withItems(instance.getItems());
      this.withOptional(instance.getOptional());
      this.withSecretName(instance.getSecretName());
      this.withDefaultMode(instance.getDefaultMode());
      this.withItems(instance.getItems());
      this.withOptional(instance.getOptional());
      this.withSecretName(instance.getSecretName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SecretVolumeSourceFluent<?> fluent;
  Boolean validationEnabled;
  public SecretVolumeSource build() {
    SecretVolumeSource buildable = new SecretVolumeSource(fluent.getDefaultMode(),fluent.buildItems(),fluent.getOptional(),fluent.getSecretName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}