package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ScopeSelectorBuilder extends ScopeSelectorFluent<ScopeSelectorBuilder> implements VisitableBuilder<ScopeSelector,ScopeSelectorBuilder>{
  public ScopeSelectorBuilder() {
    this(false);
  }
  public ScopeSelectorBuilder(Boolean validationEnabled) {
    this(new ScopeSelector(), validationEnabled);
  }
  public ScopeSelectorBuilder(ScopeSelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public ScopeSelectorBuilder(ScopeSelectorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ScopeSelector(), validationEnabled);
  }
  public ScopeSelectorBuilder(ScopeSelectorFluent<?> fluent,ScopeSelector instance) {
    this(fluent, instance, false);
  }
  public ScopeSelectorBuilder(ScopeSelectorFluent<?> fluent,ScopeSelector instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ScopeSelector());

    if (instance != null) {
      fluent.withMatchExpressions(instance.getMatchExpressions());
      fluent.withMatchExpressions(instance.getMatchExpressions());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ScopeSelectorBuilder(ScopeSelector instance) {
    this(instance,false);
  }
  public ScopeSelectorBuilder(ScopeSelector instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ScopeSelector());

    if (instance != null) {
      this.withMatchExpressions(instance.getMatchExpressions());
      this.withMatchExpressions(instance.getMatchExpressions());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ScopeSelectorFluent<?> fluent;
  Boolean validationEnabled;
  public ScopeSelector build() {
    ScopeSelector buildable = new ScopeSelector(fluent.buildMatchExpressions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}