package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProbeBuilder extends ProbeFluent<ProbeBuilder> implements VisitableBuilder<Probe,ProbeBuilder>{
  public ProbeBuilder() {
    this(false);
  }
  public ProbeBuilder(Boolean validationEnabled) {
    this(new Probe(), validationEnabled);
  }
  public ProbeBuilder(ProbeFluent<?> fluent) {
    this(fluent, false);
  }
  public ProbeBuilder(ProbeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Probe(), validationEnabled);
  }
  public ProbeBuilder(ProbeFluent<?> fluent,Probe instance) {
    this(fluent, instance, false);
  }
  public ProbeBuilder(ProbeFluent<?> fluent,Probe instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Probe());

    if (instance != null) {
      fluent.withExec(instance.getExec());
      fluent.withFailureThreshold(instance.getFailureThreshold());
      fluent.withGrpc(instance.getGrpc());
      fluent.withHttpGet(instance.getHttpGet());
      fluent.withInitialDelaySeconds(instance.getInitialDelaySeconds());
      fluent.withPeriodSeconds(instance.getPeriodSeconds());
      fluent.withSuccessThreshold(instance.getSuccessThreshold());
      fluent.withTcpSocket(instance.getTcpSocket());
      fluent.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
      fluent.withTimeoutSeconds(instance.getTimeoutSeconds());
      fluent.withExec(instance.getExec());
      fluent.withFailureThreshold(instance.getFailureThreshold());
      fluent.withGrpc(instance.getGrpc());
      fluent.withHttpGet(instance.getHttpGet());
      fluent.withInitialDelaySeconds(instance.getInitialDelaySeconds());
      fluent.withPeriodSeconds(instance.getPeriodSeconds());
      fluent.withSuccessThreshold(instance.getSuccessThreshold());
      fluent.withTcpSocket(instance.getTcpSocket());
      fluent.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
      fluent.withTimeoutSeconds(instance.getTimeoutSeconds());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ProbeBuilder(Probe instance) {
    this(instance,false);
  }
  public ProbeBuilder(Probe instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Probe());

    if (instance != null) {
      this.withExec(instance.getExec());
      this.withFailureThreshold(instance.getFailureThreshold());
      this.withGrpc(instance.getGrpc());
      this.withHttpGet(instance.getHttpGet());
      this.withInitialDelaySeconds(instance.getInitialDelaySeconds());
      this.withPeriodSeconds(instance.getPeriodSeconds());
      this.withSuccessThreshold(instance.getSuccessThreshold());
      this.withTcpSocket(instance.getTcpSocket());
      this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
      this.withTimeoutSeconds(instance.getTimeoutSeconds());
      this.withExec(instance.getExec());
      this.withFailureThreshold(instance.getFailureThreshold());
      this.withGrpc(instance.getGrpc());
      this.withHttpGet(instance.getHttpGet());
      this.withInitialDelaySeconds(instance.getInitialDelaySeconds());
      this.withPeriodSeconds(instance.getPeriodSeconds());
      this.withSuccessThreshold(instance.getSuccessThreshold());
      this.withTcpSocket(instance.getTcpSocket());
      this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
      this.withTimeoutSeconds(instance.getTimeoutSeconds());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ProbeFluent<?> fluent;
  Boolean validationEnabled;
  public Probe build() {
    Probe buildable = new Probe(fluent.buildExec(),fluent.getFailureThreshold(),fluent.buildGrpc(),fluent.buildHttpGet(),fluent.getInitialDelaySeconds(),fluent.getPeriodSeconds(),fluent.getSuccessThreshold(),fluent.buildTcpSocket(),fluent.getTerminationGracePeriodSeconds(),fluent.getTimeoutSeconds());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}