package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodTemplateBuilder extends PodTemplateFluent<PodTemplateBuilder> implements VisitableBuilder<PodTemplate,PodTemplateBuilder>{
  public PodTemplateBuilder() {
    this(false);
  }
  public PodTemplateBuilder(Boolean validationEnabled) {
    this(new PodTemplate(), validationEnabled);
  }
  public PodTemplateBuilder(PodTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public PodTemplateBuilder(PodTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodTemplate(), validationEnabled);
  }
  public PodTemplateBuilder(PodTemplateFluent<?> fluent,PodTemplate instance) {
    this(fluent, instance, false);
  }
  public PodTemplateBuilder(PodTemplateFluent<?> fluent,PodTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodTemplate());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withTemplate(instance.getTemplate());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withTemplate(instance.getTemplate());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodTemplateBuilder(PodTemplate instance) {
    this(instance,false);
  }
  public PodTemplateBuilder(PodTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodTemplate());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withTemplate(instance.getTemplate());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withTemplate(instance.getTemplate());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public PodTemplate build() {
    PodTemplate buildable = new PodTemplate(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildTemplate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}