package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodResourceClaimBuilder extends PodResourceClaimFluent<PodResourceClaimBuilder> implements VisitableBuilder<PodResourceClaim,PodResourceClaimBuilder>{
  public PodResourceClaimBuilder() {
    this(false);
  }
  public PodResourceClaimBuilder(Boolean validationEnabled) {
    this(new PodResourceClaim(), validationEnabled);
  }
  public PodResourceClaimBuilder(PodResourceClaimFluent<?> fluent) {
    this(fluent, false);
  }
  public PodResourceClaimBuilder(PodResourceClaimFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodResourceClaim(), validationEnabled);
  }
  public PodResourceClaimBuilder(PodResourceClaimFluent<?> fluent,PodResourceClaim instance) {
    this(fluent, instance, false);
  }
  public PodResourceClaimBuilder(PodResourceClaimFluent<?> fluent,PodResourceClaim instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodResourceClaim());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withSource(instance.getSource());
      fluent.withName(instance.getName());
      fluent.withSource(instance.getSource());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodResourceClaimBuilder(PodResourceClaim instance) {
    this(instance,false);
  }
  public PodResourceClaimBuilder(PodResourceClaim instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodResourceClaim());

    if (instance != null) {
      this.withName(instance.getName());
      this.withSource(instance.getSource());
      this.withName(instance.getName());
      this.withSource(instance.getSource());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodResourceClaimFluent<?> fluent;
  Boolean validationEnabled;
  public PodResourceClaim build() {
    PodResourceClaim buildable = new PodResourceClaim(fluent.getName(),fluent.buildSource());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}