package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodIPBuilder extends PodIPFluent<PodIPBuilder> implements VisitableBuilder<PodIP,PodIPBuilder>{
  public PodIPBuilder() {
    this(false);
  }
  public PodIPBuilder(Boolean validationEnabled) {
    this(new PodIP(), validationEnabled);
  }
  public PodIPBuilder(PodIPFluent<?> fluent) {
    this(fluent, false);
  }
  public PodIPBuilder(PodIPFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodIP(), validationEnabled);
  }
  public PodIPBuilder(PodIPFluent<?> fluent,PodIP instance) {
    this(fluent, instance, false);
  }
  public PodIPBuilder(PodIPFluent<?> fluent,PodIP instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodIP());

    if (instance != null) {
      fluent.withIp(instance.getIp());
      fluent.withIp(instance.getIp());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodIPBuilder(PodIP instance) {
    this(instance,false);
  }
  public PodIPBuilder(PodIP instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodIP());

    if (instance != null) {
      this.withIp(instance.getIp());
      this.withIp(instance.getIp());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodIPFluent<?> fluent;
  Boolean validationEnabled;
  public PodIP build() {
    PodIP buildable = new PodIP(fluent.getIp());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}