package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PatchOptionsBuilder extends PatchOptionsFluent<PatchOptionsBuilder> implements VisitableBuilder<PatchOptions,PatchOptionsBuilder>{
  public PatchOptionsBuilder() {
    this(false);
  }
  public PatchOptionsBuilder(Boolean validationEnabled) {
    this(new PatchOptions(), validationEnabled);
  }
  public PatchOptionsBuilder(PatchOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public PatchOptionsBuilder(PatchOptionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PatchOptions(), validationEnabled);
  }
  public PatchOptionsBuilder(PatchOptionsFluent<?> fluent,PatchOptions instance) {
    this(fluent, instance, false);
  }
  public PatchOptionsBuilder(PatchOptionsFluent<?> fluent,PatchOptions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PatchOptions());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withDryRun(instance.getDryRun());
      fluent.withFieldManager(instance.getFieldManager());
      fluent.withFieldValidation(instance.getFieldValidation());
      fluent.withForce(instance.getForce());
      fluent.withKind(instance.getKind());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withDryRun(instance.getDryRun());
      fluent.withFieldManager(instance.getFieldManager());
      fluent.withFieldValidation(instance.getFieldValidation());
      fluent.withForce(instance.getForce());
      fluent.withKind(instance.getKind());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PatchOptionsBuilder(PatchOptions instance) {
    this(instance,false);
  }
  public PatchOptionsBuilder(PatchOptions instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PatchOptions());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withDryRun(instance.getDryRun());
      this.withFieldManager(instance.getFieldManager());
      this.withFieldValidation(instance.getFieldValidation());
      this.withForce(instance.getForce());
      this.withKind(instance.getKind());
      this.withApiVersion(instance.getApiVersion());
      this.withDryRun(instance.getDryRun());
      this.withFieldManager(instance.getFieldManager());
      this.withFieldValidation(instance.getFieldValidation());
      this.withForce(instance.getForce());
      this.withKind(instance.getKind());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PatchOptionsFluent<?> fluent;
  Boolean validationEnabled;
  public PatchOptions build() {
    PatchOptions buildable = new PatchOptions(fluent.getApiVersion(),fluent.getDryRun(),fluent.getFieldManager(),fluent.getFieldValidation(),fluent.getForce(),fluent.getKind());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}