package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OwnerReferenceBuilder extends OwnerReferenceFluent<OwnerReferenceBuilder> implements VisitableBuilder<OwnerReference,OwnerReferenceBuilder>{
  public OwnerReferenceBuilder() {
    this(false);
  }
  public OwnerReferenceBuilder(Boolean validationEnabled) {
    this(new OwnerReference(), validationEnabled);
  }
  public OwnerReferenceBuilder(OwnerReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public OwnerReferenceBuilder(OwnerReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OwnerReference(), validationEnabled);
  }
  public OwnerReferenceBuilder(OwnerReferenceFluent<?> fluent,OwnerReference instance) {
    this(fluent, instance, false);
  }
  public OwnerReferenceBuilder(OwnerReferenceFluent<?> fluent,OwnerReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OwnerReference());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withBlockOwnerDeletion(instance.getBlockOwnerDeletion());
      fluent.withController(instance.getController());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withUid(instance.getUid());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withBlockOwnerDeletion(instance.getBlockOwnerDeletion());
      fluent.withController(instance.getController());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withUid(instance.getUid());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OwnerReferenceBuilder(OwnerReference instance) {
    this(instance,false);
  }
  public OwnerReferenceBuilder(OwnerReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OwnerReference());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withBlockOwnerDeletion(instance.getBlockOwnerDeletion());
      this.withController(instance.getController());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withUid(instance.getUid());
      this.withApiVersion(instance.getApiVersion());
      this.withBlockOwnerDeletion(instance.getBlockOwnerDeletion());
      this.withController(instance.getController());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withUid(instance.getUid());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OwnerReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public OwnerReference build() {
    OwnerReference buildable = new OwnerReference(fluent.getApiVersion(),fluent.getBlockOwnerDeletion(),fluent.getController(),fluent.getKind(),fluent.getName(),fluent.getUid());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}