package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NodeSpecFluent<A extends NodeSpecFluent<A>> extends BaseFluent<A>{
  public NodeSpecFluent() {
  }
  public NodeSpecFluent(NodeSpec instance) {
    instance = (instance != null ? instance : new NodeSpec());

    if (instance != null) {
      this.withConfigSource(instance.getConfigSource());
      this.withExternalID(instance.getExternalID());
      this.withPodCIDR(instance.getPodCIDR());
      this.withPodCIDRs(instance.getPodCIDRs());
      this.withProviderID(instance.getProviderID());
      this.withTaints(instance.getTaints());
      this.withUnschedulable(instance.getUnschedulable());
      this.withConfigSource(instance.getConfigSource());
      this.withExternalID(instance.getExternalID());
      this.withPodCIDR(instance.getPodCIDR());
      this.withPodCIDRs(instance.getPodCIDRs());
      this.withProviderID(instance.getProviderID());
      this.withTaints(instance.getTaints());
      this.withUnschedulable(instance.getUnschedulable());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private NodeConfigSourceBuilder configSource;
  private String externalID;
  private String podCIDR;
  private List<String> podCIDRs = new ArrayList<String>();
  private String providerID;
  private ArrayList<TaintBuilder> taints = new ArrayList<TaintBuilder>();
  private Boolean unschedulable;
  private Map<String,Object> additionalProperties;
  public NodeConfigSource buildConfigSource() {
    return this.configSource!=null ?this.configSource.build():null;
  }
  public A withConfigSource(NodeConfigSource configSource) {
    _visitables.get("configSource").remove(this.configSource);
    if (configSource!=null){ this.configSource= new NodeConfigSourceBuilder(configSource); _visitables.get("configSource").add(this.configSource);} else { this.configSource = null; _visitables.get("configSource").remove(this.configSource); } return (A) this;
  }
  public boolean hasConfigSource() {
    return this.configSource != null;
  }
  public ConfigSourceNested<A> withNewConfigSource() {
    return new ConfigSourceNested(null);
  }
  public ConfigSourceNested<A> withNewConfigSourceLike(NodeConfigSource item) {
    return new ConfigSourceNested(item);
  }
  public ConfigSourceNested<A> editConfigSource() {
    return withNewConfigSourceLike(java.util.Optional.ofNullable(buildConfigSource()).orElse(null));
  }
  public ConfigSourceNested<A> editOrNewConfigSource() {
    return withNewConfigSourceLike(java.util.Optional.ofNullable(buildConfigSource()).orElse(new NodeConfigSourceBuilder().build()));
  }
  public ConfigSourceNested<A> editOrNewConfigSourceLike(NodeConfigSource item) {
    return withNewConfigSourceLike(java.util.Optional.ofNullable(buildConfigSource()).orElse(item));
  }
  public String getExternalID() {
    return this.externalID;
  }
  public A withExternalID(String externalID) {
    this.externalID=externalID; return (A) this;
  }
  public boolean hasExternalID() {
    return this.externalID != null;
  }
  public String getPodCIDR() {
    return this.podCIDR;
  }
  public A withPodCIDR(String podCIDR) {
    this.podCIDR=podCIDR; return (A) this;
  }
  public boolean hasPodCIDR() {
    return this.podCIDR != null;
  }
  public A addToPodCIDRs(int index,String item) {
    if (this.podCIDRs == null) {this.podCIDRs = new ArrayList<String>();}
    this.podCIDRs.add(index, item);
    return (A)this;
  }
  public A setToPodCIDRs(int index,String item) {
    if (this.podCIDRs == null) {this.podCIDRs = new ArrayList<String>();}
    this.podCIDRs.set(index, item); return (A)this;
  }
  public A addToPodCIDRs(java.lang.String... items) {
    if (this.podCIDRs == null) {this.podCIDRs = new ArrayList<String>();}
    for (String item : items) {this.podCIDRs.add(item);} return (A)this;
  }
  public A addAllToPodCIDRs(Collection<String> items) {
    if (this.podCIDRs == null) {this.podCIDRs = new ArrayList<String>();}
    for (String item : items) {this.podCIDRs.add(item);} return (A)this;
  }
  public A removeFromPodCIDRs(java.lang.String... items) {
    if (this.podCIDRs == null) return (A)this;
    for (String item : items) { this.podCIDRs.remove(item);} return (A)this;
  }
  public A removeAllFromPodCIDRs(Collection<String> items) {
    if (this.podCIDRs == null) return (A)this;
    for (String item : items) { this.podCIDRs.remove(item);} return (A)this;
  }
  public List<String> getPodCIDRs() {
    return this.podCIDRs;
  }
  public String getPodCIDR(int index) {
    return this.podCIDRs.get(index);
  }
  public String getFirstPodCIDR() {
    return this.podCIDRs.get(0);
  }
  public String getLastPodCIDR() {
    return this.podCIDRs.get(podCIDRs.size() - 1);
  }
  public String getMatchingPodCIDR(Predicate<String> predicate) {
    for (String item: podCIDRs) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingPodCIDR(Predicate<String> predicate) {
    for (String item: podCIDRs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPodCIDRs(List<String> podCIDRs) {
    if (podCIDRs != null) {this.podCIDRs = new ArrayList(); for (String item : podCIDRs){this.addToPodCIDRs(item);}} else { this.podCIDRs = null;} return (A) this;
  }
  public A withPodCIDRs(java.lang.String... podCIDRs) {
    if (this.podCIDRs != null) {this.podCIDRs.clear(); _visitables.remove("podCIDRs"); }
    if (podCIDRs != null) {for (String item :podCIDRs){ this.addToPodCIDRs(item);}} return (A) this;
  }
  public boolean hasPodCIDRs() {
    return podCIDRs != null && !podCIDRs.isEmpty();
  }
  public String getProviderID() {
    return this.providerID;
  }
  public A withProviderID(String providerID) {
    this.providerID=providerID; return (A) this;
  }
  public boolean hasProviderID() {
    return this.providerID != null;
  }
  public A addToTaints(int index,Taint item) {
    if (this.taints == null) {this.taints = new ArrayList<TaintBuilder>();}
    TaintBuilder builder = new TaintBuilder(item);
    if (index < 0 || index >= taints.size()) { _visitables.get("taints").add(builder); taints.add(builder); } else { _visitables.get("taints").add(index, builder); taints.add(index, builder);}
    return (A)this;
  }
  public A setToTaints(int index,Taint item) {
    if (this.taints == null) {this.taints = new ArrayList<TaintBuilder>();}
    TaintBuilder builder = new TaintBuilder(item);
    if (index < 0 || index >= taints.size()) { _visitables.get("taints").add(builder); taints.add(builder); } else { _visitables.get("taints").set(index, builder); taints.set(index, builder);}
    return (A)this;
  }
  public A addToTaints(io.fabric8.kubernetes.api.model.Taint... items) {
    if (this.taints == null) {this.taints = new ArrayList<TaintBuilder>();}
    for (Taint item : items) {TaintBuilder builder = new TaintBuilder(item);_visitables.get("taints").add(builder);this.taints.add(builder);} return (A)this;
  }
  public A addAllToTaints(Collection<Taint> items) {
    if (this.taints == null) {this.taints = new ArrayList<TaintBuilder>();}
    for (Taint item : items) {TaintBuilder builder = new TaintBuilder(item);_visitables.get("taints").add(builder);this.taints.add(builder);} return (A)this;
  }
  public A removeFromTaints(io.fabric8.kubernetes.api.model.Taint... items) {
    if (this.taints == null) return (A)this;
    for (Taint item : items) {TaintBuilder builder = new TaintBuilder(item);_visitables.get("taints").remove(builder); this.taints.remove(builder);} return (A)this;
  }
  public A removeAllFromTaints(Collection<Taint> items) {
    if (this.taints == null) return (A)this;
    for (Taint item : items) {TaintBuilder builder = new TaintBuilder(item);_visitables.get("taints").remove(builder); this.taints.remove(builder);} return (A)this;
  }
  public A removeMatchingFromTaints(Predicate<TaintBuilder> predicate) {
    if (taints == null) return (A) this;
    final Iterator<TaintBuilder> each = taints.iterator();
    final List visitables = _visitables.get("taints");
    while (each.hasNext()) {
      TaintBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<Taint> buildTaints() {
    return taints != null ? build(taints) : null;
  }
  public Taint buildTaint(int index) {
    return this.taints.get(index).build();
  }
  public Taint buildFirstTaint() {
    return this.taints.get(0).build();
  }
  public Taint buildLastTaint() {
    return this.taints.get(taints.size() - 1).build();
  }
  public Taint buildMatchingTaint(Predicate<TaintBuilder> predicate) {
    for (TaintBuilder item: taints) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingTaint(Predicate<TaintBuilder> predicate) {
    for (TaintBuilder item: taints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTaints(List<Taint> taints) {
    if (this.taints != null) { _visitables.get("taints").clear();}
    if (taints != null) {this.taints = new ArrayList(); for (Taint item : taints){this.addToTaints(item);}} else { this.taints = null;} return (A) this;
  }
  public A withTaints(io.fabric8.kubernetes.api.model.Taint... taints) {
    if (this.taints != null) {this.taints.clear(); _visitables.remove("taints"); }
    if (taints != null) {for (Taint item :taints){ this.addToTaints(item);}} return (A) this;
  }
  public boolean hasTaints() {
    return taints != null && !taints.isEmpty();
  }
  public A addNewTaint(String effect,String key,String timeAdded,String value) {
    return (A)addToTaints(new Taint(effect, key, timeAdded, value));
  }
  public TaintsNested<A> addNewTaint() {
    return new TaintsNested(-1, null);
  }
  public TaintsNested<A> addNewTaintLike(Taint item) {
    return new TaintsNested(-1, item);
  }
  public TaintsNested<A> setNewTaintLike(int index,Taint item) {
    return new TaintsNested(index, item);
  }
  public TaintsNested<A> editTaint(int index) {
    if (taints.size() <= index) throw new RuntimeException("Can't edit taints. Index exceeds size.");
    return setNewTaintLike(index, buildTaint(index));
  }
  public TaintsNested<A> editFirstTaint() {
    if (taints.size() == 0) throw new RuntimeException("Can't edit first taints. The list is empty.");
    return setNewTaintLike(0, buildTaint(0));
  }
  public TaintsNested<A> editLastTaint() {
    int index = taints.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last taints. The list is empty.");
    return setNewTaintLike(index, buildTaint(index));
  }
  public TaintsNested<A> editMatchingTaint(Predicate<TaintBuilder> predicate) {
    int index = -1;
    for (int i=0;i<taints.size();i++) { 
    if (predicate.test(taints.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching taints. No match found.");
    return setNewTaintLike(index, buildTaint(index));
  }
  public Boolean getUnschedulable() {
    return this.unschedulable;
  }
  public A withUnschedulable(Boolean unschedulable) {
    this.unschedulable=unschedulable; return (A) this;
  }
  public boolean hasUnschedulable() {
    return this.unschedulable != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NodeSpecFluent that = (NodeSpecFluent) o;
    if (!java.util.Objects.equals(configSource, that.configSource)) return false;

    if (!java.util.Objects.equals(externalID, that.externalID)) return false;

    if (!java.util.Objects.equals(podCIDR, that.podCIDR)) return false;

    if (!java.util.Objects.equals(podCIDRs, that.podCIDRs)) return false;

    if (!java.util.Objects.equals(providerID, that.providerID)) return false;

    if (!java.util.Objects.equals(taints, that.taints)) return false;

    if (!java.util.Objects.equals(unschedulable, that.unschedulable)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(configSource,  externalID,  podCIDR,  podCIDRs,  providerID,  taints,  unschedulable,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (configSource != null) { sb.append("configSource:"); sb.append(configSource + ","); }
    if (externalID != null) { sb.append("externalID:"); sb.append(externalID + ","); }
    if (podCIDR != null) { sb.append("podCIDR:"); sb.append(podCIDR + ","); }
    if (podCIDRs != null && !podCIDRs.isEmpty()) { sb.append("podCIDRs:"); sb.append(podCIDRs + ","); }
    if (providerID != null) { sb.append("providerID:"); sb.append(providerID + ","); }
    if (taints != null && !taints.isEmpty()) { sb.append("taints:"); sb.append(taints + ","); }
    if (unschedulable != null) { sb.append("unschedulable:"); sb.append(unschedulable + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withUnschedulable() {
    return withUnschedulable(true);
  }
  public class ConfigSourceNested<N> extends NodeConfigSourceFluent<ConfigSourceNested<N>> implements Nested<N>{
    ConfigSourceNested(NodeConfigSource item) {
      this.builder = new NodeConfigSourceBuilder(this, item);
    }
    NodeConfigSourceBuilder builder;
    public N and() {
      return (N) NodeSpecFluent.this.withConfigSource(builder.build());
    }
    public N endConfigSource() {
      return and();
    }
    
  }
  public class TaintsNested<N> extends TaintFluent<TaintsNested<N>> implements Nested<N>{
    TaintsNested(int index,Taint item) {
      this.index = index;
      this.builder = new TaintBuilder(this, item);
    }
    TaintBuilder builder;
    int index;
    public N and() {
      return (N) NodeSpecFluent.this.setToTaints(index,builder.build());
    }
    public N endTaint() {
      return and();
    }
    
  }
  
}