package io.fabric8.kubernetes.api.model;

import java.lang.String;
import io.fabric8.kubernetes.api.model.version.Info;
import io.fabric8.kubernetes.api.model.version.InfoBuilder;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionBuilder;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.version.InfoFluent;
import java.lang.Boolean;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import java.util.Map;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionFluent;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.runtime.RawExtension;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NamedExtensionFluent<A extends NamedExtensionFluent<A>> extends BaseFluent<A>{
  public NamedExtensionFluent() {
  }
  public NamedExtensionFluent(NamedExtension instance) {
    instance = (instance != null ? instance : new NamedExtension());

    if (instance != null) {
      this.withExtension(instance.getExtension());
      this.withName(instance.getName());
      this.withExtension(instance.getExtension());
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private VisitableBuilder<? extends KubernetesResource,?> extension;
  private String name;
  private Map<String,Object> additionalProperties;
  public KubernetesResource buildExtension() {
    return this.extension!=null?this.extension.build():null;
  }
  public A withExtension(KubernetesResource extension) {
    if (extension==null){ this.extension = null; _visitables.remove("extension"); return (A) this;}
    VisitableBuilder<? extends KubernetesResource,?> builder = builder(extension); _visitables.get("extension").clear();_visitables.get("extension").add(builder);this.extension = builder;
    return (A) this;
  }
  public boolean hasExtension() {
    return this.extension != null;
  }
  public PatchExtensionNested<A> withNewPatchExtension() {
    return new PatchExtensionNested(null);
  }
  public PatchExtensionNested<A> withNewPatchExtensionLike(Patch item) {
    return new PatchExtensionNested(item);
  }
  public LimitRangeExtensionNested<A> withNewLimitRangeExtension() {
    return new LimitRangeExtensionNested(null);
  }
  public LimitRangeExtensionNested<A> withNewLimitRangeExtensionLike(LimitRange item) {
    return new LimitRangeExtensionNested(item);
  }
  public APIGroupListExtensionNested<A> withNewAPIGroupListExtension() {
    return new APIGroupListExtensionNested(null);
  }
  public APIGroupListExtensionNested<A> withNewAPIGroupListExtensionLike(APIGroupList item) {
    return new APIGroupListExtensionNested(item);
  }
  public PortStatusExtensionNested<A> withNewPortStatusExtension() {
    return new PortStatusExtensionNested(null);
  }
  public PortStatusExtensionNested<A> withNewPortStatusExtensionLike(PortStatus item) {
    return new PortStatusExtensionNested(item);
  }
  public A withNewPortStatusExtension(String error,Integer port,String protocol) {
    return (A)withExtension(new PortStatus(error, port, protocol));
  }
  public PodTemplateSpecExtensionNested<A> withNewPodTemplateSpecExtension() {
    return new PodTemplateSpecExtensionNested(null);
  }
  public PodTemplateSpecExtensionNested<A> withNewPodTemplateSpecExtensionLike(PodTemplateSpec item) {
    return new PodTemplateSpecExtensionNested(item);
  }
  public CSIPersistentVolumeSourceExtensionNested<A> withNewCSIPersistentVolumeSourceExtension() {
    return new CSIPersistentVolumeSourceExtensionNested(null);
  }
  public CSIPersistentVolumeSourceExtensionNested<A> withNewCSIPersistentVolumeSourceExtensionLike(CSIPersistentVolumeSource item) {
    return new CSIPersistentVolumeSourceExtensionNested(item);
  }
  public AuthInfoExtensionNested<A> withNewAuthInfoExtension() {
    return new AuthInfoExtensionNested(null);
  }
  public AuthInfoExtensionNested<A> withNewAuthInfoExtensionLike(AuthInfo item) {
    return new AuthInfoExtensionNested(item);
  }
  public APIServiceExtensionNested<A> withNewAPIServiceExtension() {
    return new APIServiceExtensionNested(null);
  }
  public APIServiceExtensionNested<A> withNewAPIServiceExtensionLike(APIService item) {
    return new APIServiceExtensionNested(item);
  }
  public ResourceRequirementsExtensionNested<A> withNewResourceRequirementsExtension() {
    return new ResourceRequirementsExtensionNested(null);
  }
  public ResourceRequirementsExtensionNested<A> withNewResourceRequirementsExtensionLike(ResourceRequirements item) {
    return new ResourceRequirementsExtensionNested(item);
  }
  public ConfigMapKeySelectorExtensionNested<A> withNewConfigMapKeySelectorExtension() {
    return new ConfigMapKeySelectorExtensionNested(null);
  }
  public ConfigMapKeySelectorExtensionNested<A> withNewConfigMapKeySelectorExtensionLike(ConfigMapKeySelector item) {
    return new ConfigMapKeySelectorExtensionNested(item);
  }
  public A withNewConfigMapKeySelectorExtension(String key,String name,Boolean optional) {
    return (A)withExtension(new ConfigMapKeySelector(key, name, optional));
  }
  public HostPathVolumeSourceExtensionNested<A> withNewHostPathVolumeSourceExtension() {
    return new HostPathVolumeSourceExtensionNested(null);
  }
  public HostPathVolumeSourceExtensionNested<A> withNewHostPathVolumeSourceExtensionLike(HostPathVolumeSource item) {
    return new HostPathVolumeSourceExtensionNested(item);
  }
  public A withNewHostPathVolumeSourceExtension(String path,String type) {
    return (A)withExtension(new HostPathVolumeSource(path, type));
  }
  public PersistentVolumeClaimListExtensionNested<A> withNewPersistentVolumeClaimListExtension() {
    return new PersistentVolumeClaimListExtensionNested(null);
  }
  public PersistentVolumeClaimListExtensionNested<A> withNewPersistentVolumeClaimListExtensionLike(PersistentVolumeClaimList item) {
    return new PersistentVolumeClaimListExtensionNested(item);
  }
  public NamedContextExtensionNested<A> withNewNamedContextExtension() {
    return new NamedContextExtensionNested(null);
  }
  public NamedContextExtensionNested<A> withNewNamedContextExtensionLike(NamedContext item) {
    return new NamedContextExtensionNested(item);
  }
  public ConfigExtensionNested<A> withNewConfigExtension() {
    return new ConfigExtensionNested(null);
  }
  public ConfigExtensionNested<A> withNewConfigExtensionLike(Config item) {
    return new ConfigExtensionNested(item);
  }
  public AffinityExtensionNested<A> withNewAffinityExtension() {
    return new AffinityExtensionNested(null);
  }
  public AffinityExtensionNested<A> withNewAffinityExtensionLike(Affinity item) {
    return new AffinityExtensionNested(item);
  }
  public PodResourceClaimExtensionNested<A> withNewPodResourceClaimExtension() {
    return new PodResourceClaimExtensionNested(null);
  }
  public PodResourceClaimExtensionNested<A> withNewPodResourceClaimExtensionLike(PodResourceClaim item) {
    return new PodResourceClaimExtensionNested(item);
  }
  public ReplicationControllerStatusExtensionNested<A> withNewReplicationControllerStatusExtension() {
    return new ReplicationControllerStatusExtensionNested(null);
  }
  public ReplicationControllerStatusExtensionNested<A> withNewReplicationControllerStatusExtensionLike(ReplicationControllerStatus item) {
    return new ReplicationControllerStatusExtensionNested(item);
  }
  public APIServiceStatusExtensionNested<A> withNewAPIServiceStatusExtension() {
    return new APIServiceStatusExtensionNested(null);
  }
  public APIServiceStatusExtensionNested<A> withNewAPIServiceStatusExtensionLike(APIServiceStatus item) {
    return new APIServiceStatusExtensionNested(item);
  }
  public MicroTimeExtensionNested<A> withNewMicroTimeExtension() {
    return new MicroTimeExtensionNested(null);
  }
  public MicroTimeExtensionNested<A> withNewMicroTimeExtensionLike(MicroTime item) {
    return new MicroTimeExtensionNested(item);
  }
  public A withNewMicroTimeExtension(String time) {
    return (A)withExtension(new MicroTime(time));
  }
  public LifecycleExtensionNested<A> withNewLifecycleExtension() {
    return new LifecycleExtensionNested(null);
  }
  public LifecycleExtensionNested<A> withNewLifecycleExtensionLike(Lifecycle item) {
    return new LifecycleExtensionNested(item);
  }
  public PortworxVolumeSourceExtensionNested<A> withNewPortworxVolumeSourceExtension() {
    return new PortworxVolumeSourceExtensionNested(null);
  }
  public PortworxVolumeSourceExtensionNested<A> withNewPortworxVolumeSourceExtensionLike(PortworxVolumeSource item) {
    return new PortworxVolumeSourceExtensionNested(item);
  }
  public A withNewPortworxVolumeSourceExtension(String fsType,Boolean readOnly,String volumeID) {
    return (A)withExtension(new PortworxVolumeSource(fsType, readOnly, volumeID));
  }
  public EventSourceExtensionNested<A> withNewEventSourceExtension() {
    return new EventSourceExtensionNested(null);
  }
  public EventSourceExtensionNested<A> withNewEventSourceExtensionLike(EventSource item) {
    return new EventSourceExtensionNested(item);
  }
  public A withNewEventSourceExtension(String component,String host) {
    return (A)withExtension(new EventSource(component, host));
  }
  public GRPCActionExtensionNested<A> withNewGRPCActionExtension() {
    return new GRPCActionExtensionNested(null);
  }
  public GRPCActionExtensionNested<A> withNewGRPCActionExtensionLike(GRPCAction item) {
    return new GRPCActionExtensionNested(item);
  }
  public A withNewGRPCActionExtension(Integer port,String service) {
    return (A)withExtension(new GRPCAction(port, service));
  }
  public AzureFileVolumeSourceExtensionNested<A> withNewAzureFileVolumeSourceExtension() {
    return new AzureFileVolumeSourceExtensionNested(null);
  }
  public AzureFileVolumeSourceExtensionNested<A> withNewAzureFileVolumeSourceExtensionLike(AzureFileVolumeSource item) {
    return new AzureFileVolumeSourceExtensionNested(item);
  }
  public A withNewAzureFileVolumeSourceExtension(Boolean readOnly,String secretName,String shareName) {
    return (A)withExtension(new AzureFileVolumeSource(readOnly, secretName, shareName));
  }
  public ResourceClaimExtensionNested<A> withNewResourceClaimExtension() {
    return new ResourceClaimExtensionNested(null);
  }
  public ResourceClaimExtensionNested<A> withNewResourceClaimExtensionLike(ResourceClaim item) {
    return new ResourceClaimExtensionNested(item);
  }
  public A withNewResourceClaimExtension(String name) {
    return (A)withExtension(new ResourceClaim(name));
  }
  public ComponentConditionExtensionNested<A> withNewComponentConditionExtension() {
    return new ComponentConditionExtensionNested(null);
  }
  public ComponentConditionExtensionNested<A> withNewComponentConditionExtensionLike(ComponentCondition item) {
    return new ComponentConditionExtensionNested(item);
  }
  public A withNewComponentConditionExtension(String error,String message,String status,String type) {
    return (A)withExtension(new ComponentCondition(error, message, status, type));
  }
  public EnvVarExtensionNested<A> withNewEnvVarExtension() {
    return new EnvVarExtensionNested(null);
  }
  public EnvVarExtensionNested<A> withNewEnvVarExtensionLike(EnvVar item) {
    return new EnvVarExtensionNested(item);
  }
  public ReplicationControllerSpecExtensionNested<A> withNewReplicationControllerSpecExtension() {
    return new ReplicationControllerSpecExtensionNested(null);
  }
  public ReplicationControllerSpecExtensionNested<A> withNewReplicationControllerSpecExtensionLike(ReplicationControllerSpec item) {
    return new ReplicationControllerSpecExtensionNested(item);
  }
  public LoadBalancerIngressExtensionNested<A> withNewLoadBalancerIngressExtension() {
    return new LoadBalancerIngressExtensionNested(null);
  }
  public LoadBalancerIngressExtensionNested<A> withNewLoadBalancerIngressExtensionLike(LoadBalancerIngress item) {
    return new LoadBalancerIngressExtensionNested(item);
  }
  public AttachedVolumeExtensionNested<A> withNewAttachedVolumeExtension() {
    return new AttachedVolumeExtensionNested(null);
  }
  public AttachedVolumeExtensionNested<A> withNewAttachedVolumeExtensionLike(AttachedVolume item) {
    return new AttachedVolumeExtensionNested(item);
  }
  public A withNewAttachedVolumeExtension(String devicePath,String name) {
    return (A)withExtension(new AttachedVolume(devicePath, name));
  }
  public LocalObjectReferenceExtensionNested<A> withNewLocalObjectReferenceExtension() {
    return new LocalObjectReferenceExtensionNested(null);
  }
  public LocalObjectReferenceExtensionNested<A> withNewLocalObjectReferenceExtensionLike(LocalObjectReference item) {
    return new LocalObjectReferenceExtensionNested(item);
  }
  public A withNewLocalObjectReferenceExtension(String name) {
    return (A)withExtension(new LocalObjectReference(name));
  }
  public NamedAuthInfoExtensionNested<A> withNewNamedAuthInfoExtension() {
    return new NamedAuthInfoExtensionNested(null);
  }
  public NamedAuthInfoExtensionNested<A> withNewNamedAuthInfoExtensionLike(NamedAuthInfo item) {
    return new NamedAuthInfoExtensionNested(item);
  }
  public EmptyDirVolumeSourceExtensionNested<A> withNewEmptyDirVolumeSourceExtension() {
    return new EmptyDirVolumeSourceExtensionNested(null);
  }
  public EmptyDirVolumeSourceExtensionNested<A> withNewEmptyDirVolumeSourceExtensionLike(EmptyDirVolumeSource item) {
    return new EmptyDirVolumeSourceExtensionNested(item);
  }
  public PodSpecExtensionNested<A> withNewPodSpecExtension() {
    return new PodSpecExtensionNested(null);
  }
  public PodSpecExtensionNested<A> withNewPodSpecExtensionLike(PodSpec item) {
    return new PodSpecExtensionNested(item);
  }
  public ServerAddressByClientCIDRExtensionNested<A> withNewServerAddressByClientCIDRExtension() {
    return new ServerAddressByClientCIDRExtensionNested(null);
  }
  public ServerAddressByClientCIDRExtensionNested<A> withNewServerAddressByClientCIDRExtensionLike(ServerAddressByClientCIDR item) {
    return new ServerAddressByClientCIDRExtensionNested(item);
  }
  public A withNewServerAddressByClientCIDRExtension(String clientCIDR,String serverAddress) {
    return (A)withExtension(new ServerAddressByClientCIDR(clientCIDR, serverAddress));
  }
  public AzureDiskVolumeSourceExtensionNested<A> withNewAzureDiskVolumeSourceExtension() {
    return new AzureDiskVolumeSourceExtensionNested(null);
  }
  public AzureDiskVolumeSourceExtensionNested<A> withNewAzureDiskVolumeSourceExtensionLike(AzureDiskVolumeSource item) {
    return new AzureDiskVolumeSourceExtensionNested(item);
  }
  public PreconditionsExtensionNested<A> withNewPreconditionsExtension() {
    return new PreconditionsExtensionNested(null);
  }
  public PreconditionsExtensionNested<A> withNewPreconditionsExtensionLike(Preconditions item) {
    return new PreconditionsExtensionNested(item);
  }
  public A withNewPreconditionsExtension(String resourceVersion,String uid) {
    return (A)withExtension(new Preconditions(resourceVersion, uid));
  }
  public InfoExtensionNested<A> withNewInfoExtension() {
    return new InfoExtensionNested(null);
  }
  public InfoExtensionNested<A> withNewInfoExtensionLike(Info item) {
    return new InfoExtensionNested(item);
  }
  public CephFSVolumeSourceExtensionNested<A> withNewCephFSVolumeSourceExtension() {
    return new CephFSVolumeSourceExtensionNested(null);
  }
  public CephFSVolumeSourceExtensionNested<A> withNewCephFSVolumeSourceExtensionLike(CephFSVolumeSource item) {
    return new CephFSVolumeSourceExtensionNested(item);
  }
  public EphemeralContainerExtensionNested<A> withNewEphemeralContainerExtension() {
    return new EphemeralContainerExtensionNested(null);
  }
  public EphemeralContainerExtensionNested<A> withNewEphemeralContainerExtensionLike(EphemeralContainer item) {
    return new EphemeralContainerExtensionNested(item);
  }
  public NodeConditionExtensionNested<A> withNewNodeConditionExtension() {
    return new NodeConditionExtensionNested(null);
  }
  public NodeConditionExtensionNested<A> withNewNodeConditionExtensionLike(NodeCondition item) {
    return new NodeConditionExtensionNested(item);
  }
  public EndpointSubsetExtensionNested<A> withNewEndpointSubsetExtension() {
    return new EndpointSubsetExtensionNested(null);
  }
  public EndpointSubsetExtensionNested<A> withNewEndpointSubsetExtensionLike(EndpointSubset item) {
    return new EndpointSubsetExtensionNested(item);
  }
  public LocalVolumeSourceExtensionNested<A> withNewLocalVolumeSourceExtension() {
    return new LocalVolumeSourceExtensionNested(null);
  }
  public LocalVolumeSourceExtensionNested<A> withNewLocalVolumeSourceExtensionLike(LocalVolumeSource item) {
    return new LocalVolumeSourceExtensionNested(item);
  }
  public A withNewLocalVolumeSourceExtension(String fsType,String path) {
    return (A)withExtension(new LocalVolumeSource(fsType, path));
  }
  public ServiceReferenceExtensionNested<A> withNewServiceReferenceExtension() {
    return new ServiceReferenceExtensionNested(null);
  }
  public ServiceReferenceExtensionNested<A> withNewServiceReferenceExtensionLike(ServiceReference item) {
    return new ServiceReferenceExtensionNested(item);
  }
  public A withNewServiceReferenceExtension(String name,String namespace,Integer port) {
    return (A)withExtension(new ServiceReference(name, namespace, port));
  }
  public ServiceStatusExtensionNested<A> withNewServiceStatusExtension() {
    return new ServiceStatusExtensionNested(null);
  }
  public ServiceStatusExtensionNested<A> withNewServiceStatusExtensionLike(ServiceStatus item) {
    return new ServiceStatusExtensionNested(item);
  }
  public TaintExtensionNested<A> withNewTaintExtension() {
    return new TaintExtensionNested(null);
  }
  public TaintExtensionNested<A> withNewTaintExtensionLike(Taint item) {
    return new TaintExtensionNested(item);
  }
  public A withNewTaintExtension(String effect,String key,String timeAdded,String value) {
    return (A)withExtension(new Taint(effect, key, timeAdded, value));
  }
  public PatchOptionsExtensionNested<A> withNewPatchOptionsExtension() {
    return new PatchOptionsExtensionNested(null);
  }
  public PatchOptionsExtensionNested<A> withNewPatchOptionsExtensionLike(PatchOptions item) {
    return new PatchOptionsExtensionNested(item);
  }
  public ConfigMapNodeConfigSourceExtensionNested<A> withNewConfigMapNodeConfigSourceExtension() {
    return new ConfigMapNodeConfigSourceExtensionNested(null);
  }
  public ConfigMapNodeConfigSourceExtensionNested<A> withNewConfigMapNodeConfigSourceExtensionLike(ConfigMapNodeConfigSource item) {
    return new ConfigMapNodeConfigSourceExtensionNested(item);
  }
  public A withNewConfigMapNodeConfigSourceExtension(String kubeletConfigKey,String name,String namespace,String resourceVersion,String uid) {
    return (A)withExtension(new ConfigMapNodeConfigSource(kubeletConfigKey, name, namespace, resourceVersion, uid));
  }
  public HTTPGetActionExtensionNested<A> withNewHTTPGetActionExtension() {
    return new HTTPGetActionExtensionNested(null);
  }
  public HTTPGetActionExtensionNested<A> withNewHTTPGetActionExtensionLike(HTTPGetAction item) {
    return new HTTPGetActionExtensionNested(item);
  }
  public GlusterfsPersistentVolumeSourceExtensionNested<A> withNewGlusterfsPersistentVolumeSourceExtension() {
    return new GlusterfsPersistentVolumeSourceExtensionNested(null);
  }
  public GlusterfsPersistentVolumeSourceExtensionNested<A> withNewGlusterfsPersistentVolumeSourceExtensionLike(GlusterfsPersistentVolumeSource item) {
    return new GlusterfsPersistentVolumeSourceExtensionNested(item);
  }
  public A withNewGlusterfsPersistentVolumeSourceExtension(String endpoints,String endpointsNamespace,String path,Boolean readOnly) {
    return (A)withExtension(new GlusterfsPersistentVolumeSource(endpoints, endpointsNamespace, path, readOnly));
  }
  public DownwardAPIVolumeSourceExtensionNested<A> withNewDownwardAPIVolumeSourceExtension() {
    return new DownwardAPIVolumeSourceExtensionNested(null);
  }
  public DownwardAPIVolumeSourceExtensionNested<A> withNewDownwardAPIVolumeSourceExtensionLike(DownwardAPIVolumeSource item) {
    return new DownwardAPIVolumeSourceExtensionNested(item);
  }
  public ISCSIPersistentVolumeSourceExtensionNested<A> withNewISCSIPersistentVolumeSourceExtension() {
    return new ISCSIPersistentVolumeSourceExtensionNested(null);
  }
  public ISCSIPersistentVolumeSourceExtensionNested<A> withNewISCSIPersistentVolumeSourceExtensionLike(ISCSIPersistentVolumeSource item) {
    return new ISCSIPersistentVolumeSourceExtensionNested(item);
  }
  public WindowsSecurityContextOptionsExtensionNested<A> withNewWindowsSecurityContextOptionsExtension() {
    return new WindowsSecurityContextOptionsExtensionNested(null);
  }
  public WindowsSecurityContextOptionsExtensionNested<A> withNewWindowsSecurityContextOptionsExtensionLike(WindowsSecurityContextOptions item) {
    return new WindowsSecurityContextOptionsExtensionNested(item);
  }
  public A withNewWindowsSecurityContextOptionsExtension(String gmsaCredentialSpec,String gmsaCredentialSpecName,Boolean hostProcess,String runAsUserName) {
    return (A)withExtension(new WindowsSecurityContextOptions(gmsaCredentialSpec, gmsaCredentialSpecName, hostProcess, runAsUserName));
  }
  public CreateOptionsExtensionNested<A> withNewCreateOptionsExtension() {
    return new CreateOptionsExtensionNested(null);
  }
  public CreateOptionsExtensionNested<A> withNewCreateOptionsExtensionLike(CreateOptions item) {
    return new CreateOptionsExtensionNested(item);
  }
  public EnvFromSourceExtensionNested<A> withNewEnvFromSourceExtension() {
    return new EnvFromSourceExtensionNested(null);
  }
  public EnvFromSourceExtensionNested<A> withNewEnvFromSourceExtensionLike(EnvFromSource item) {
    return new EnvFromSourceExtensionNested(item);
  }
  public NamespaceSpecExtensionNested<A> withNewNamespaceSpecExtension() {
    return new NamespaceSpecExtensionNested(null);
  }
  public NamespaceSpecExtensionNested<A> withNewNamespaceSpecExtensionLike(NamespaceSpec item) {
    return new NamespaceSpecExtensionNested(item);
  }
  public TypeMetaExtensionNested<A> withNewTypeMetaExtension() {
    return new TypeMetaExtensionNested(null);
  }
  public TypeMetaExtensionNested<A> withNewTypeMetaExtensionLike(TypeMeta item) {
    return new TypeMetaExtensionNested(item);
  }
  public A withNewTypeMetaExtension(String apiVersion,String kind) {
    return (A)withExtension(new TypeMeta(apiVersion, kind));
  }
  public RootPathsExtensionNested<A> withNewRootPathsExtension() {
    return new RootPathsExtensionNested(null);
  }
  public RootPathsExtensionNested<A> withNewRootPathsExtensionLike(RootPaths item) {
    return new RootPathsExtensionNested(item);
  }
  public ListMetaExtensionNested<A> withNewListMetaExtension() {
    return new ListMetaExtensionNested(null);
  }
  public ListMetaExtensionNested<A> withNewListMetaExtensionLike(ListMeta item) {
    return new ListMetaExtensionNested(item);
  }
  public A withNewListMetaExtension(String _continue,Long remainingItemCount,String resourceVersion,String selfLink) {
    return (A)withExtension(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
  }
  public SecretReferenceExtensionNested<A> withNewSecretReferenceExtension() {
    return new SecretReferenceExtensionNested(null);
  }
  public SecretReferenceExtensionNested<A> withNewSecretReferenceExtensionLike(SecretReference item) {
    return new SecretReferenceExtensionNested(item);
  }
  public A withNewSecretReferenceExtension(String name,String namespace) {
    return (A)withExtension(new SecretReference(name, namespace));
  }
  public APIGroupExtensionNested<A> withNewAPIGroupExtension() {
    return new APIGroupExtensionNested(null);
  }
  public APIGroupExtensionNested<A> withNewAPIGroupExtensionLike(APIGroup item) {
    return new APIGroupExtensionNested(item);
  }
  public FlexVolumeSourceExtensionNested<A> withNewFlexVolumeSourceExtension() {
    return new FlexVolumeSourceExtensionNested(null);
  }
  public FlexVolumeSourceExtensionNested<A> withNewFlexVolumeSourceExtensionLike(FlexVolumeSource item) {
    return new FlexVolumeSourceExtensionNested(item);
  }
  public PersistentVolumeClaimTemplateExtensionNested<A> withNewPersistentVolumeClaimTemplateExtension() {
    return new PersistentVolumeClaimTemplateExtensionNested(null);
  }
  public PersistentVolumeClaimTemplateExtensionNested<A> withNewPersistentVolumeClaimTemplateExtensionLike(PersistentVolumeClaimTemplate item) {
    return new PersistentVolumeClaimTemplateExtensionNested(item);
  }
  public ISCSIVolumeSourceExtensionNested<A> withNewISCSIVolumeSourceExtension() {
    return new ISCSIVolumeSourceExtensionNested(null);
  }
  public ISCSIVolumeSourceExtensionNested<A> withNewISCSIVolumeSourceExtensionLike(ISCSIVolumeSource item) {
    return new ISCSIVolumeSourceExtensionNested(item);
  }
  public SecretKeySelectorExtensionNested<A> withNewSecretKeySelectorExtension() {
    return new SecretKeySelectorExtensionNested(null);
  }
  public SecretKeySelectorExtensionNested<A> withNewSecretKeySelectorExtensionLike(SecretKeySelector item) {
    return new SecretKeySelectorExtensionNested(item);
  }
  public A withNewSecretKeySelectorExtension(String key,String name,Boolean optional) {
    return (A)withExtension(new SecretKeySelector(key, name, optional));
  }
  public RBDVolumeSourceExtensionNested<A> withNewRBDVolumeSourceExtension() {
    return new RBDVolumeSourceExtensionNested(null);
  }
  public RBDVolumeSourceExtensionNested<A> withNewRBDVolumeSourceExtensionLike(RBDVolumeSource item) {
    return new RBDVolumeSourceExtensionNested(item);
  }
  public NodeConfigStatusExtensionNested<A> withNewNodeConfigStatusExtension() {
    return new NodeConfigStatusExtensionNested(null);
  }
  public NodeConfigStatusExtensionNested<A> withNewNodeConfigStatusExtensionLike(NodeConfigStatus item) {
    return new NodeConfigStatusExtensionNested(item);
  }
  public ResourceQuotaListExtensionNested<A> withNewResourceQuotaListExtension() {
    return new ResourceQuotaListExtensionNested(null);
  }
  public ResourceQuotaListExtensionNested<A> withNewResourceQuotaListExtensionLike(ResourceQuotaList item) {
    return new ResourceQuotaListExtensionNested(item);
  }
  public QuobyteVolumeSourceExtensionNested<A> withNewQuobyteVolumeSourceExtension() {
    return new QuobyteVolumeSourceExtensionNested(null);
  }
  public QuobyteVolumeSourceExtensionNested<A> withNewQuobyteVolumeSourceExtensionLike(QuobyteVolumeSource item) {
    return new QuobyteVolumeSourceExtensionNested(item);
  }
  public APIResourceExtensionNested<A> withNewAPIResourceExtension() {
    return new APIResourceExtensionNested(null);
  }
  public APIResourceExtensionNested<A> withNewAPIResourceExtensionLike(APIResource item) {
    return new APIResourceExtensionNested(item);
  }
  public ResourceQuotaStatusExtensionNested<A> withNewResourceQuotaStatusExtension() {
    return new ResourceQuotaStatusExtensionNested(null);
  }
  public ResourceQuotaStatusExtensionNested<A> withNewResourceQuotaStatusExtensionLike(ResourceQuotaStatus item) {
    return new ResourceQuotaStatusExtensionNested(item);
  }
  public RawExtensionNested<A> withNewRawExtension() {
    return new RawExtensionNested(null);
  }
  public RawExtensionNested<A> withNewRawExtensionLike(RawExtension item) {
    return new RawExtensionNested(item);
  }
  public A withNewRawExtension(Object value) {
    return (A)withExtension(new RawExtension(value));
  }
  public ConfigMapProjectionExtensionNested<A> withNewConfigMapProjectionExtension() {
    return new ConfigMapProjectionExtensionNested(null);
  }
  public ConfigMapProjectionExtensionNested<A> withNewConfigMapProjectionExtensionLike(ConfigMapProjection item) {
    return new ConfigMapProjectionExtensionNested(item);
  }
  public ScopedResourceSelectorRequirementExtensionNested<A> withNewScopedResourceSelectorRequirementExtension() {
    return new ScopedResourceSelectorRequirementExtensionNested(null);
  }
  public ScopedResourceSelectorRequirementExtensionNested<A> withNewScopedResourceSelectorRequirementExtensionLike(ScopedResourceSelectorRequirement item) {
    return new ScopedResourceSelectorRequirementExtensionNested(item);
  }
  public NamespaceExtensionNested<A> withNewNamespaceExtension() {
    return new NamespaceExtensionNested(null);
  }
  public NamespaceExtensionNested<A> withNewNamespaceExtensionLike(Namespace item) {
    return new NamespaceExtensionNested(item);
  }
  public GroupVersionKindExtensionNested<A> withNewGroupVersionKindExtension() {
    return new GroupVersionKindExtensionNested(null);
  }
  public GroupVersionKindExtensionNested<A> withNewGroupVersionKindExtensionLike(GroupVersionKind item) {
    return new GroupVersionKindExtensionNested(item);
  }
  public A withNewGroupVersionKindExtension(String group,String kind,String version) {
    return (A)withExtension(new GroupVersionKind(group, kind, version));
  }
  public ContainerStateTerminatedExtensionNested<A> withNewContainerStateTerminatedExtension() {
    return new ContainerStateTerminatedExtensionNested(null);
  }
  public ContainerStateTerminatedExtensionNested<A> withNewContainerStateTerminatedExtensionLike(ContainerStateTerminated item) {
    return new ContainerStateTerminatedExtensionNested(item);
  }
  public LimitRangeSpecExtensionNested<A> withNewLimitRangeSpecExtension() {
    return new LimitRangeSpecExtensionNested(null);
  }
  public LimitRangeSpecExtensionNested<A> withNewLimitRangeSpecExtensionLike(LimitRangeSpec item) {
    return new LimitRangeSpecExtensionNested(item);
  }
  public ProjectedVolumeSourceExtensionNested<A> withNewProjectedVolumeSourceExtension() {
    return new ProjectedVolumeSourceExtensionNested(null);
  }
  public ProjectedVolumeSourceExtensionNested<A> withNewProjectedVolumeSourceExtensionLike(ProjectedVolumeSource item) {
    return new ProjectedVolumeSourceExtensionNested(item);
  }
  public PodOSExtensionNested<A> withNewPodOSExtension() {
    return new PodOSExtensionNested(null);
  }
  public PodOSExtensionNested<A> withNewPodOSExtensionLike(PodOS item) {
    return new PodOSExtensionNested(item);
  }
  public A withNewPodOSExtension(String name) {
    return (A)withExtension(new PodOS(name));
  }
  public PersistentVolumeClaimStatusExtensionNested<A> withNewPersistentVolumeClaimStatusExtension() {
    return new PersistentVolumeClaimStatusExtensionNested(null);
  }
  public PersistentVolumeClaimStatusExtensionNested<A> withNewPersistentVolumeClaimStatusExtensionLike(PersistentVolumeClaimStatus item) {
    return new PersistentVolumeClaimStatusExtensionNested(item);
  }
  public ContainerStateExtensionNested<A> withNewContainerStateExtension() {
    return new ContainerStateExtensionNested(null);
  }
  public ContainerStateExtensionNested<A> withNewContainerStateExtensionLike(ContainerState item) {
    return new ContainerStateExtensionNested(item);
  }
  public ServiceSpecExtensionNested<A> withNewServiceSpecExtension() {
    return new ServiceSpecExtensionNested(null);
  }
  public ServiceSpecExtensionNested<A> withNewServiceSpecExtensionLike(ServiceSpec item) {
    return new ServiceSpecExtensionNested(item);
  }
  public ServiceAccountTokenProjectionExtensionNested<A> withNewServiceAccountTokenProjectionExtension() {
    return new ServiceAccountTokenProjectionExtensionNested(null);
  }
  public ServiceAccountTokenProjectionExtensionNested<A> withNewServiceAccountTokenProjectionExtensionLike(ServiceAccountTokenProjection item) {
    return new ServiceAccountTokenProjectionExtensionNested(item);
  }
  public A withNewServiceAccountTokenProjectionExtension(String audience,Long expirationSeconds,String path) {
    return (A)withExtension(new ServiceAccountTokenProjection(audience, expirationSeconds, path));
  }
  public PhotonPersistentDiskVolumeSourceExtensionNested<A> withNewPhotonPersistentDiskVolumeSourceExtension() {
    return new PhotonPersistentDiskVolumeSourceExtensionNested(null);
  }
  public PhotonPersistentDiskVolumeSourceExtensionNested<A> withNewPhotonPersistentDiskVolumeSourceExtensionLike(PhotonPersistentDiskVolumeSource item) {
    return new PhotonPersistentDiskVolumeSourceExtensionNested(item);
  }
  public A withNewPhotonPersistentDiskVolumeSourceExtension(String fsType,String pdID) {
    return (A)withExtension(new PhotonPersistentDiskVolumeSource(fsType, pdID));
  }
  public ContainerExtensionNested<A> withNewContainerExtension() {
    return new ContainerExtensionNested(null);
  }
  public ContainerExtensionNested<A> withNewContainerExtensionLike(Container item) {
    return new ContainerExtensionNested(item);
  }
  public NodeSpecExtensionNested<A> withNewNodeSpecExtension() {
    return new NodeSpecExtensionNested(null);
  }
  public NodeSpecExtensionNested<A> withNewNodeSpecExtensionLike(NodeSpec item) {
    return new NodeSpecExtensionNested(item);
  }
  public TypedLocalObjectReferenceExtensionNested<A> withNewTypedLocalObjectReferenceExtension() {
    return new TypedLocalObjectReferenceExtensionNested(null);
  }
  public TypedLocalObjectReferenceExtensionNested<A> withNewTypedLocalObjectReferenceExtensionLike(TypedLocalObjectReference item) {
    return new TypedLocalObjectReferenceExtensionNested(item);
  }
  public A withNewTypedLocalObjectReferenceExtension(String apiGroup,String kind,String name) {
    return (A)withExtension(new TypedLocalObjectReference(apiGroup, kind, name));
  }
  public FieldsV1ExtensionNested<A> withNewFieldsV1Extension() {
    return new FieldsV1ExtensionNested(null);
  }
  public FieldsV1ExtensionNested<A> withNewFieldsV1ExtensionLike(FieldsV1 item) {
    return new FieldsV1ExtensionNested(item);
  }
  public SecretListExtensionNested<A> withNewSecretListExtension() {
    return new SecretListExtensionNested(null);
  }
  public SecretListExtensionNested<A> withNewSecretListExtensionLike(SecretList item) {
    return new SecretListExtensionNested(item);
  }
  public NodeAddressExtensionNested<A> withNewNodeAddressExtension() {
    return new NodeAddressExtensionNested(null);
  }
  public NodeAddressExtensionNested<A> withNewNodeAddressExtensionLike(NodeAddress item) {
    return new NodeAddressExtensionNested(item);
  }
  public A withNewNodeAddressExtension(String address,String type) {
    return (A)withExtension(new NodeAddress(address, type));
  }
  public PodAffinityExtensionNested<A> withNewPodAffinityExtension() {
    return new PodAffinityExtensionNested(null);
  }
  public PodAffinityExtensionNested<A> withNewPodAffinityExtensionLike(PodAffinity item) {
    return new PodAffinityExtensionNested(item);
  }
  public ExecEnvVarExtensionNested<A> withNewExecEnvVarExtension() {
    return new ExecEnvVarExtensionNested(null);
  }
  public ExecEnvVarExtensionNested<A> withNewExecEnvVarExtensionLike(ExecEnvVar item) {
    return new ExecEnvVarExtensionNested(item);
  }
  public A withNewExecEnvVarExtension(String name,String value) {
    return (A)withExtension(new ExecEnvVar(name, value));
  }
  public ServiceExtensionNested<A> withNewServiceExtension() {
    return new ServiceExtensionNested(null);
  }
  public ServiceExtensionNested<A> withNewServiceExtensionLike(Service item) {
    return new ServiceExtensionNested(item);
  }
  public EventSeriesExtensionNested<A> withNewEventSeriesExtension() {
    return new EventSeriesExtensionNested(null);
  }
  public EventSeriesExtensionNested<A> withNewEventSeriesExtensionLike(EventSeries item) {
    return new EventSeriesExtensionNested(item);
  }
  public PodConditionExtensionNested<A> withNewPodConditionExtension() {
    return new PodConditionExtensionNested(null);
  }
  public PodConditionExtensionNested<A> withNewPodConditionExtensionLike(PodCondition item) {
    return new PodConditionExtensionNested(item);
  }
  public TopologySpreadConstraintExtensionNested<A> withNewTopologySpreadConstraintExtension() {
    return new TopologySpreadConstraintExtensionNested(null);
  }
  public TopologySpreadConstraintExtensionNested<A> withNewTopologySpreadConstraintExtensionLike(TopologySpreadConstraint item) {
    return new TopologySpreadConstraintExtensionNested(item);
  }
  public ExecActionExtensionNested<A> withNewExecActionExtension() {
    return new ExecActionExtensionNested(null);
  }
  public ExecActionExtensionNested<A> withNewExecActionExtensionLike(ExecAction item) {
    return new ExecActionExtensionNested(item);
  }
  public ContainerImageExtensionNested<A> withNewContainerImageExtension() {
    return new ContainerImageExtensionNested(null);
  }
  public ContainerImageExtensionNested<A> withNewContainerImageExtensionLike(ContainerImage item) {
    return new ContainerImageExtensionNested(item);
  }
  public GroupKindExtensionNested<A> withNewGroupKindExtension() {
    return new GroupKindExtensionNested(null);
  }
  public GroupKindExtensionNested<A> withNewGroupKindExtensionLike(GroupKind item) {
    return new GroupKindExtensionNested(item);
  }
  public A withNewGroupKindExtension(String group,String kind) {
    return (A)withExtension(new GroupKind(group, kind));
  }
  public ReplicationControllerExtensionNested<A> withNewReplicationControllerExtension() {
    return new ReplicationControllerExtensionNested(null);
  }
  public ReplicationControllerExtensionNested<A> withNewReplicationControllerExtensionLike(ReplicationController item) {
    return new ReplicationControllerExtensionNested(item);
  }
  public NodeStatusExtensionNested<A> withNewNodeStatusExtension() {
    return new NodeStatusExtensionNested(null);
  }
  public NodeStatusExtensionNested<A> withNewNodeStatusExtensionLike(NodeStatus item) {
    return new NodeStatusExtensionNested(item);
  }
  public ConfigMapListExtensionNested<A> withNewConfigMapListExtension() {
    return new ConfigMapListExtensionNested(null);
  }
  public ConfigMapListExtensionNested<A> withNewConfigMapListExtensionLike(ConfigMapList item) {
    return new ConfigMapListExtensionNested(item);
  }
  public NodeSelectorExtensionNested<A> withNewNodeSelectorExtension() {
    return new NodeSelectorExtensionNested(null);
  }
  public NodeSelectorExtensionNested<A> withNewNodeSelectorExtensionLike(NodeSelector item) {
    return new NodeSelectorExtensionNested(item);
  }
  public TolerationExtensionNested<A> withNewTolerationExtension() {
    return new TolerationExtensionNested(null);
  }
  public TolerationExtensionNested<A> withNewTolerationExtensionLike(Toleration item) {
    return new TolerationExtensionNested(item);
  }
  public A withNewTolerationExtension(String effect,String key,String operator,Long tolerationSeconds,String value) {
    return (A)withExtension(new Toleration(effect, key, operator, tolerationSeconds, value));
  }
  public CephFSPersistentVolumeSourceExtensionNested<A> withNewCephFSPersistentVolumeSourceExtension() {
    return new CephFSPersistentVolumeSourceExtensionNested(null);
  }
  public CephFSPersistentVolumeSourceExtensionNested<A> withNewCephFSPersistentVolumeSourceExtensionLike(CephFSPersistentVolumeSource item) {
    return new CephFSPersistentVolumeSourceExtensionNested(item);
  }
  public PersistentVolumeClaimConditionExtensionNested<A> withNewPersistentVolumeClaimConditionExtension() {
    return new PersistentVolumeClaimConditionExtensionNested(null);
  }
  public PersistentVolumeClaimConditionExtensionNested<A> withNewPersistentVolumeClaimConditionExtensionLike(PersistentVolumeClaimCondition item) {
    return new PersistentVolumeClaimConditionExtensionNested(item);
  }
  public PreferredSchedulingTermExtensionNested<A> withNewPreferredSchedulingTermExtension() {
    return new PreferredSchedulingTermExtensionNested(null);
  }
  public PreferredSchedulingTermExtensionNested<A> withNewPreferredSchedulingTermExtensionLike(PreferredSchedulingTerm item) {
    return new PreferredSchedulingTermExtensionNested(item);
  }
  public PersistentVolumeListExtensionNested<A> withNewPersistentVolumeListExtension() {
    return new PersistentVolumeListExtensionNested(null);
  }
  public PersistentVolumeListExtensionNested<A> withNewPersistentVolumeListExtensionLike(PersistentVolumeList item) {
    return new PersistentVolumeListExtensionNested(item);
  }
  public PodSchedulingGateExtensionNested<A> withNewPodSchedulingGateExtension() {
    return new PodSchedulingGateExtensionNested(null);
  }
  public PodSchedulingGateExtensionNested<A> withNewPodSchedulingGateExtensionLike(PodSchedulingGate item) {
    return new PodSchedulingGateExtensionNested(item);
  }
  public A withNewPodSchedulingGateExtension(String name) {
    return (A)withExtension(new PodSchedulingGate(name));
  }
  public PodDNSConfigOptionExtensionNested<A> withNewPodDNSConfigOptionExtension() {
    return new PodDNSConfigOptionExtensionNested(null);
  }
  public PodDNSConfigOptionExtensionNested<A> withNewPodDNSConfigOptionExtensionLike(PodDNSConfigOption item) {
    return new PodDNSConfigOptionExtensionNested(item);
  }
  public A withNewPodDNSConfigOptionExtension(String name,String value) {
    return (A)withExtension(new PodDNSConfigOption(name, value));
  }
  public GCEPersistentDiskVolumeSourceExtensionNested<A> withNewGCEPersistentDiskVolumeSourceExtension() {
    return new GCEPersistentDiskVolumeSourceExtensionNested(null);
  }
  public GCEPersistentDiskVolumeSourceExtensionNested<A> withNewGCEPersistentDiskVolumeSourceExtensionLike(GCEPersistentDiskVolumeSource item) {
    return new GCEPersistentDiskVolumeSourceExtensionNested(item);
  }
  public A withNewGCEPersistentDiskVolumeSourceExtension(String fsType,Integer partition,String pdName,Boolean readOnly) {
    return (A)withExtension(new GCEPersistentDiskVolumeSource(fsType, partition, pdName, readOnly));
  }
  public APIServiceConditionExtensionNested<A> withNewAPIServiceConditionExtension() {
    return new APIServiceConditionExtensionNested(null);
  }
  public APIServiceConditionExtensionNested<A> withNewAPIServiceConditionExtensionLike(APIServiceCondition item) {
    return new APIServiceConditionExtensionNested(item);
  }
  public A withNewAPIServiceConditionExtension(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withExtension(new APIServiceCondition(lastTransitionTime, message, reason, status, type));
  }
  public EventListExtensionNested<A> withNewEventListExtension() {
    return new EventListExtensionNested(null);
  }
  public EventListExtensionNested<A> withNewEventListExtensionLike(EventList item) {
    return new EventListExtensionNested(item);
  }
  public PodReadinessGateExtensionNested<A> withNewPodReadinessGateExtension() {
    return new PodReadinessGateExtensionNested(null);
  }
  public PodReadinessGateExtensionNested<A> withNewPodReadinessGateExtensionLike(PodReadinessGate item) {
    return new PodReadinessGateExtensionNested(item);
  }
  public A withNewPodReadinessGateExtension(String conditionType) {
    return (A)withExtension(new PodReadinessGate(conditionType));
  }
  public ContainerStateWaitingExtensionNested<A> withNewContainerStateWaitingExtension() {
    return new ContainerStateWaitingExtensionNested(null);
  }
  public ContainerStateWaitingExtensionNested<A> withNewContainerStateWaitingExtensionLike(ContainerStateWaiting item) {
    return new ContainerStateWaitingExtensionNested(item);
  }
  public A withNewContainerStateWaitingExtension(String message,String reason) {
    return (A)withExtension(new ContainerStateWaiting(message, reason));
  }
  public VolumeMountExtensionNested<A> withNewVolumeMountExtension() {
    return new VolumeMountExtensionNested(null);
  }
  public VolumeMountExtensionNested<A> withNewVolumeMountExtensionLike(VolumeMount item) {
    return new VolumeMountExtensionNested(item);
  }
  public NamespaceConditionExtensionNested<A> withNewNamespaceConditionExtension() {
    return new NamespaceConditionExtensionNested(null);
  }
  public NamespaceConditionExtensionNested<A> withNewNamespaceConditionExtensionLike(NamespaceCondition item) {
    return new NamespaceConditionExtensionNested(item);
  }
  public A withNewNamespaceConditionExtension(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withExtension(new NamespaceCondition(lastTransitionTime, message, reason, status, type));
  }
  public LabelSelectorExtensionNested<A> withNewLabelSelectorExtension() {
    return new LabelSelectorExtensionNested(null);
  }
  public LabelSelectorExtensionNested<A> withNewLabelSelectorExtensionLike(LabelSelector item) {
    return new LabelSelectorExtensionNested(item);
  }
  public StatusCauseExtensionNested<A> withNewStatusCauseExtension() {
    return new StatusCauseExtensionNested(null);
  }
  public StatusCauseExtensionNested<A> withNewStatusCauseExtensionLike(StatusCause item) {
    return new StatusCauseExtensionNested(item);
  }
  public A withNewStatusCauseExtension(String field,String message,String reason) {
    return (A)withExtension(new StatusCause(field, message, reason));
  }
  public NamedClusterExtensionNested<A> withNewNamedClusterExtension() {
    return new NamedClusterExtensionNested(null);
  }
  public NamedClusterExtensionNested<A> withNewNamedClusterExtensionLike(NamedCluster item) {
    return new NamedClusterExtensionNested(item);
  }
  public StatusDetailsExtensionNested<A> withNewStatusDetailsExtension() {
    return new StatusDetailsExtensionNested(null);
  }
  public StatusDetailsExtensionNested<A> withNewStatusDetailsExtensionLike(StatusDetails item) {
    return new StatusDetailsExtensionNested(item);
  }
  public DownwardAPIVolumeFileExtensionNested<A> withNewDownwardAPIVolumeFileExtension() {
    return new DownwardAPIVolumeFileExtensionNested(null);
  }
  public DownwardAPIVolumeFileExtensionNested<A> withNewDownwardAPIVolumeFileExtensionLike(DownwardAPIVolumeFile item) {
    return new DownwardAPIVolumeFileExtensionNested(item);
  }
  public SeccompProfileExtensionNested<A> withNewSeccompProfileExtension() {
    return new SeccompProfileExtensionNested(null);
  }
  public SeccompProfileExtensionNested<A> withNewSeccompProfileExtensionLike(SeccompProfile item) {
    return new SeccompProfileExtensionNested(item);
  }
  public A withNewSeccompProfileExtension(String localhostProfile,String type) {
    return (A)withExtension(new SeccompProfile(localhostProfile, type));
  }
  public SysctlExtensionNested<A> withNewSysctlExtension() {
    return new SysctlExtensionNested(null);
  }
  public SysctlExtensionNested<A> withNewSysctlExtensionLike(Sysctl item) {
    return new SysctlExtensionNested(item);
  }
  public A withNewSysctlExtension(String name,String value) {
    return (A)withExtension(new Sysctl(name, value));
  }
  public DeleteOptionsExtensionNested<A> withNewDeleteOptionsExtension() {
    return new DeleteOptionsExtensionNested(null);
  }
  public DeleteOptionsExtensionNested<A> withNewDeleteOptionsExtensionLike(DeleteOptions item) {
    return new DeleteOptionsExtensionNested(item);
  }
  public StatusExtensionNested<A> withNewStatusExtension() {
    return new StatusExtensionNested(null);
  }
  public StatusExtensionNested<A> withNewStatusExtensionLike(Status item) {
    return new StatusExtensionNested(item);
  }
  public ContainerStatusExtensionNested<A> withNewContainerStatusExtension() {
    return new ContainerStatusExtensionNested(null);
  }
  public ContainerStatusExtensionNested<A> withNewContainerStatusExtensionLike(ContainerStatus item) {
    return new ContainerStatusExtensionNested(item);
  }
  public PodTemplateExtensionNested<A> withNewPodTemplateExtension() {
    return new PodTemplateExtensionNested(null);
  }
  public PodTemplateExtensionNested<A> withNewPodTemplateExtensionLike(PodTemplate item) {
    return new PodTemplateExtensionNested(item);
  }
  public ConfigMapEnvSourceExtensionNested<A> withNewConfigMapEnvSourceExtension() {
    return new ConfigMapEnvSourceExtensionNested(null);
  }
  public ConfigMapEnvSourceExtensionNested<A> withNewConfigMapEnvSourceExtensionLike(ConfigMapEnvSource item) {
    return new ConfigMapEnvSourceExtensionNested(item);
  }
  public A withNewConfigMapEnvSourceExtension(String name,Boolean optional) {
    return (A)withExtension(new ConfigMapEnvSource(name, optional));
  }
  public NodeSelectorRequirementExtensionNested<A> withNewNodeSelectorRequirementExtension() {
    return new NodeSelectorRequirementExtensionNested(null);
  }
  public NodeSelectorRequirementExtensionNested<A> withNewNodeSelectorRequirementExtensionLike(NodeSelectorRequirement item) {
    return new NodeSelectorRequirementExtensionNested(item);
  }
  public TCPSocketActionExtensionNested<A> withNewTCPSocketActionExtension() {
    return new TCPSocketActionExtensionNested(null);
  }
  public TCPSocketActionExtensionNested<A> withNewTCPSocketActionExtensionLike(TCPSocketAction item) {
    return new TCPSocketActionExtensionNested(item);
  }
  public EventExtensionNested<A> withNewEventExtension() {
    return new EventExtensionNested(null);
  }
  public EventExtensionNested<A> withNewEventExtensionLike(Event item) {
    return new EventExtensionNested(item);
  }
  public PreferencesExtensionNested<A> withNewPreferencesExtension() {
    return new PreferencesExtensionNested(null);
  }
  public PreferencesExtensionNested<A> withNewPreferencesExtensionLike(Preferences item) {
    return new PreferencesExtensionNested(item);
  }
  public ObjectFieldSelectorExtensionNested<A> withNewObjectFieldSelectorExtension() {
    return new ObjectFieldSelectorExtensionNested(null);
  }
  public ObjectFieldSelectorExtensionNested<A> withNewObjectFieldSelectorExtensionLike(ObjectFieldSelector item) {
    return new ObjectFieldSelectorExtensionNested(item);
  }
  public A withNewObjectFieldSelectorExtension(String apiVersion,String fieldPath) {
    return (A)withExtension(new ObjectFieldSelector(apiVersion, fieldPath));
  }
  public PodTemplateListExtensionNested<A> withNewPodTemplateListExtension() {
    return new PodTemplateListExtensionNested(null);
  }
  public PodTemplateListExtensionNested<A> withNewPodTemplateListExtensionLike(PodTemplateList item) {
    return new PodTemplateListExtensionNested(item);
  }
  public PersistentVolumeExtensionNested<A> withNewPersistentVolumeExtension() {
    return new PersistentVolumeExtensionNested(null);
  }
  public PersistentVolumeExtensionNested<A> withNewPersistentVolumeExtensionLike(PersistentVolume item) {
    return new PersistentVolumeExtensionNested(item);
  }
  public CinderVolumeSourceExtensionNested<A> withNewCinderVolumeSourceExtension() {
    return new CinderVolumeSourceExtensionNested(null);
  }
  public CinderVolumeSourceExtensionNested<A> withNewCinderVolumeSourceExtensionLike(CinderVolumeSource item) {
    return new CinderVolumeSourceExtensionNested(item);
  }
  public EndpointAddressExtensionNested<A> withNewEndpointAddressExtension() {
    return new EndpointAddressExtensionNested(null);
  }
  public EndpointAddressExtensionNested<A> withNewEndpointAddressExtensionLike(EndpointAddress item) {
    return new EndpointAddressExtensionNested(item);
  }
  public NodeConfigSourceExtensionNested<A> withNewNodeConfigSourceExtension() {
    return new NodeConfigSourceExtensionNested(null);
  }
  public NodeConfigSourceExtensionNested<A> withNewNodeConfigSourceExtensionLike(NodeConfigSource item) {
    return new NodeConfigSourceExtensionNested(item);
  }
  public VsphereVirtualDiskVolumeSourceExtensionNested<A> withNewVsphereVirtualDiskVolumeSourceExtension() {
    return new VsphereVirtualDiskVolumeSourceExtensionNested(null);
  }
  public VsphereVirtualDiskVolumeSourceExtensionNested<A> withNewVsphereVirtualDiskVolumeSourceExtensionLike(VsphereVirtualDiskVolumeSource item) {
    return new VsphereVirtualDiskVolumeSourceExtensionNested(item);
  }
  public A withNewVsphereVirtualDiskVolumeSourceExtension(String fsType,String storagePolicyID,String storagePolicyName,String volumePath) {
    return (A)withExtension(new VsphereVirtualDiskVolumeSource(fsType, storagePolicyID, storagePolicyName, volumePath));
  }
  public ObjectMetaExtensionNested<A> withNewObjectMetaExtension() {
    return new ObjectMetaExtensionNested(null);
  }
  public ObjectMetaExtensionNested<A> withNewObjectMetaExtensionLike(ObjectMeta item) {
    return new ObjectMetaExtensionNested(item);
  }
  public PersistentVolumeClaimExtensionNested<A> withNewPersistentVolumeClaimExtension() {
    return new PersistentVolumeClaimExtensionNested(null);
  }
  public PersistentVolumeClaimExtensionNested<A> withNewPersistentVolumeClaimExtensionLike(PersistentVolumeClaim item) {
    return new PersistentVolumeClaimExtensionNested(item);
  }
  public LabelSelectorRequirementExtensionNested<A> withNewLabelSelectorRequirementExtension() {
    return new LabelSelectorRequirementExtensionNested(null);
  }
  public LabelSelectorRequirementExtensionNested<A> withNewLabelSelectorRequirementExtensionLike(LabelSelectorRequirement item) {
    return new LabelSelectorRequirementExtensionNested(item);
  }
  public GitRepoVolumeSourceExtensionNested<A> withNewGitRepoVolumeSourceExtension() {
    return new GitRepoVolumeSourceExtensionNested(null);
  }
  public GitRepoVolumeSourceExtensionNested<A> withNewGitRepoVolumeSourceExtensionLike(GitRepoVolumeSource item) {
    return new GitRepoVolumeSourceExtensionNested(item);
  }
  public A withNewGitRepoVolumeSourceExtension(String directory,String repository,String revision) {
    return (A)withExtension(new GitRepoVolumeSource(directory, repository, revision));
  }
  public GenericKubernetesResourceExtensionNested<A> withNewGenericKubernetesResourceExtension() {
    return new GenericKubernetesResourceExtensionNested(null);
  }
  public GenericKubernetesResourceExtensionNested<A> withNewGenericKubernetesResourceExtensionLike(GenericKubernetesResource item) {
    return new GenericKubernetesResourceExtensionNested(item);
  }
  public EndpointsListExtensionNested<A> withNewEndpointsListExtension() {
    return new EndpointsListExtensionNested(null);
  }
  public EndpointsListExtensionNested<A> withNewEndpointsListExtensionLike(EndpointsList item) {
    return new EndpointsListExtensionNested(item);
  }
  public GroupVersionResourceExtensionNested<A> withNewGroupVersionResourceExtension() {
    return new GroupVersionResourceExtensionNested(null);
  }
  public GroupVersionResourceExtensionNested<A> withNewGroupVersionResourceExtensionLike(GroupVersionResource item) {
    return new GroupVersionResourceExtensionNested(item);
  }
  public A withNewGroupVersionResourceExtension(String group,String resource,String version) {
    return (A)withExtension(new GroupVersionResource(group, resource, version));
  }
  public CinderPersistentVolumeSourceExtensionNested<A> withNewCinderPersistentVolumeSourceExtension() {
    return new CinderPersistentVolumeSourceExtensionNested(null);
  }
  public CinderPersistentVolumeSourceExtensionNested<A> withNewCinderPersistentVolumeSourceExtensionLike(CinderPersistentVolumeSource item) {
    return new CinderPersistentVolumeSourceExtensionNested(item);
  }
  public TopologySelectorTermExtensionNested<A> withNewTopologySelectorTermExtension() {
    return new TopologySelectorTermExtensionNested(null);
  }
  public TopologySelectorTermExtensionNested<A> withNewTopologySelectorTermExtensionLike(TopologySelectorTerm item) {
    return new TopologySelectorTermExtensionNested(item);
  }
  public OwnerReferenceExtensionNested<A> withNewOwnerReferenceExtension() {
    return new OwnerReferenceExtensionNested(null);
  }
  public OwnerReferenceExtensionNested<A> withNewOwnerReferenceExtensionLike(OwnerReference item) {
    return new OwnerReferenceExtensionNested(item);
  }
  public StorageOSPersistentVolumeSourceExtensionNested<A> withNewStorageOSPersistentVolumeSourceExtension() {
    return new StorageOSPersistentVolumeSourceExtensionNested(null);
  }
  public StorageOSPersistentVolumeSourceExtensionNested<A> withNewStorageOSPersistentVolumeSourceExtensionLike(StorageOSPersistentVolumeSource item) {
    return new StorageOSPersistentVolumeSourceExtensionNested(item);
  }
  public EphemeralVolumeSourceExtensionNested<A> withNewEphemeralVolumeSourceExtension() {
    return new EphemeralVolumeSourceExtensionNested(null);
  }
  public EphemeralVolumeSourceExtensionNested<A> withNewEphemeralVolumeSourceExtensionLike(EphemeralVolumeSource item) {
    return new EphemeralVolumeSourceExtensionNested(item);
  }
  public ReplicationControllerConditionExtensionNested<A> withNewReplicationControllerConditionExtension() {
    return new ReplicationControllerConditionExtensionNested(null);
  }
  public ReplicationControllerConditionExtensionNested<A> withNewReplicationControllerConditionExtensionLike(ReplicationControllerCondition item) {
    return new ReplicationControllerConditionExtensionNested(item);
  }
  public A withNewReplicationControllerConditionExtension(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withExtension(new ReplicationControllerCondition(lastTransitionTime, message, reason, status, type));
  }
  public PodAntiAffinityExtensionNested<A> withNewPodAntiAffinityExtension() {
    return new PodAntiAffinityExtensionNested(null);
  }
  public PodAntiAffinityExtensionNested<A> withNewPodAntiAffinityExtensionLike(PodAntiAffinity item) {
    return new PodAntiAffinityExtensionNested(item);
  }
  public SecurityContextExtensionNested<A> withNewSecurityContextExtension() {
    return new SecurityContextExtensionNested(null);
  }
  public SecurityContextExtensionNested<A> withNewSecurityContextExtensionLike(SecurityContext item) {
    return new SecurityContextExtensionNested(item);
  }
  public ReplicationControllerListExtensionNested<A> withNewReplicationControllerListExtension() {
    return new ReplicationControllerListExtensionNested(null);
  }
  public ReplicationControllerListExtensionNested<A> withNewReplicationControllerListExtensionLike(ReplicationControllerList item) {
    return new ReplicationControllerListExtensionNested(item);
  }
  public ConfigMapVolumeSourceExtensionNested<A> withNewConfigMapVolumeSourceExtension() {
    return new ConfigMapVolumeSourceExtensionNested(null);
  }
  public ConfigMapVolumeSourceExtensionNested<A> withNewConfigMapVolumeSourceExtensionLike(ConfigMapVolumeSource item) {
    return new ConfigMapVolumeSourceExtensionNested(item);
  }
  public ContainerStateRunningExtensionNested<A> withNewContainerStateRunningExtension() {
    return new ContainerStateRunningExtensionNested(null);
  }
  public ContainerStateRunningExtensionNested<A> withNewContainerStateRunningExtensionLike(ContainerStateRunning item) {
    return new ContainerStateRunningExtensionNested(item);
  }
  public A withNewContainerStateRunningExtension(String startedAt) {
    return (A)withExtension(new ContainerStateRunning(startedAt));
  }
  public ComponentStatusListExtensionNested<A> withNewComponentStatusListExtension() {
    return new ComponentStatusListExtensionNested(null);
  }
  public ComponentStatusListExtensionNested<A> withNewComponentStatusListExtensionLike(ComponentStatusList item) {
    return new ComponentStatusListExtensionNested(item);
  }
  public FlockerVolumeSourceExtensionNested<A> withNewFlockerVolumeSourceExtension() {
    return new FlockerVolumeSourceExtensionNested(null);
  }
  public FlockerVolumeSourceExtensionNested<A> withNewFlockerVolumeSourceExtensionLike(FlockerVolumeSource item) {
    return new FlockerVolumeSourceExtensionNested(item);
  }
  public A withNewFlockerVolumeSourceExtension(String datasetName,String datasetUUID) {
    return (A)withExtension(new FlockerVolumeSource(datasetName, datasetUUID));
  }
  public ScaleIOVolumeSourceExtensionNested<A> withNewScaleIOVolumeSourceExtension() {
    return new ScaleIOVolumeSourceExtensionNested(null);
  }
  public ScaleIOVolumeSourceExtensionNested<A> withNewScaleIOVolumeSourceExtensionLike(ScaleIOVolumeSource item) {
    return new ScaleIOVolumeSourceExtensionNested(item);
  }
  public LimitRangeListExtensionNested<A> withNewLimitRangeListExtension() {
    return new LimitRangeListExtensionNested(null);
  }
  public LimitRangeListExtensionNested<A> withNewLimitRangeListExtensionLike(LimitRangeList item) {
    return new LimitRangeListExtensionNested(item);
  }
  public PodExecOptionsExtensionNested<A> withNewPodExecOptionsExtension() {
    return new PodExecOptionsExtensionNested(null);
  }
  public PodExecOptionsExtensionNested<A> withNewPodExecOptionsExtensionLike(PodExecOptions item) {
    return new PodExecOptionsExtensionNested(item);
  }
  public ProbeExtensionNested<A> withNewProbeExtension() {
    return new ProbeExtensionNested(null);
  }
  public ProbeExtensionNested<A> withNewProbeExtensionLike(Probe item) {
    return new ProbeExtensionNested(item);
  }
  public UpdateOptionsExtensionNested<A> withNewUpdateOptionsExtension() {
    return new UpdateOptionsExtensionNested(null);
  }
  public UpdateOptionsExtensionNested<A> withNewUpdateOptionsExtensionLike(UpdateOptions item) {
    return new UpdateOptionsExtensionNested(item);
  }
  public EndpointsExtensionNested<A> withNewEndpointsExtension() {
    return new EndpointsExtensionNested(null);
  }
  public EndpointsExtensionNested<A> withNewEndpointsExtensionLike(Endpoints item) {
    return new EndpointsExtensionNested(item);
  }
  public NamedExtensionNested<A> withNewNamedExtension() {
    return new NamedExtensionNested(null);
  }
  public NamedExtensionNested<A> withNewNamedExtensionLike(NamedExtension item) {
    return new NamedExtensionNested(item);
  }
  public AzureFilePersistentVolumeSourceExtensionNested<A> withNewAzureFilePersistentVolumeSourceExtension() {
    return new AzureFilePersistentVolumeSourceExtensionNested(null);
  }
  public AzureFilePersistentVolumeSourceExtensionNested<A> withNewAzureFilePersistentVolumeSourceExtensionLike(AzureFilePersistentVolumeSource item) {
    return new AzureFilePersistentVolumeSourceExtensionNested(item);
  }
  public A withNewAzureFilePersistentVolumeSourceExtension(Boolean readOnly,String secretName,String secretNamespace,String shareName) {
    return (A)withExtension(new AzureFilePersistentVolumeSource(readOnly, secretName, secretNamespace, shareName));
  }
  public APIResourceListExtensionNested<A> withNewAPIResourceListExtension() {
    return new APIResourceListExtensionNested(null);
  }
  public APIResourceListExtensionNested<A> withNewAPIResourceListExtensionLike(APIResourceList item) {
    return new APIResourceListExtensionNested(item);
  }
  public APIServiceListExtensionNested<A> withNewAPIServiceListExtension() {
    return new APIServiceListExtensionNested(null);
  }
  public APIServiceListExtensionNested<A> withNewAPIServiceListExtensionLike(APIServiceList item) {
    return new APIServiceListExtensionNested(item);
  }
  public SecretVolumeSourceExtensionNested<A> withNewSecretVolumeSourceExtension() {
    return new SecretVolumeSourceExtensionNested(null);
  }
  public SecretVolumeSourceExtensionNested<A> withNewSecretVolumeSourceExtensionLike(SecretVolumeSource item) {
    return new SecretVolumeSourceExtensionNested(item);
  }
  public PodExtensionNested<A> withNewPodExtension() {
    return new PodExtensionNested(null);
  }
  public PodExtensionNested<A> withNewPodExtensionLike(Pod item) {
    return new PodExtensionNested(item);
  }
  public ClientIPConfigExtensionNested<A> withNewClientIPConfigExtension() {
    return new ClientIPConfigExtensionNested(null);
  }
  public ClientIPConfigExtensionNested<A> withNewClientIPConfigExtensionLike(ClientIPConfig item) {
    return new ClientIPConfigExtensionNested(item);
  }
  public A withNewClientIPConfigExtension(Integer timeoutSeconds) {
    return (A)withExtension(new ClientIPConfig(timeoutSeconds));
  }
  public ContextExtensionNested<A> withNewContextExtension() {
    return new ContextExtensionNested(null);
  }
  public ContextExtensionNested<A> withNewContextExtensionLike(Context item) {
    return new ContextExtensionNested(item);
  }
  public NodeAffinityExtensionNested<A> withNewNodeAffinityExtension() {
    return new NodeAffinityExtensionNested(null);
  }
  public NodeAffinityExtensionNested<A> withNewNodeAffinityExtensionLike(NodeAffinity item) {
    return new NodeAffinityExtensionNested(item);
  }
  public ConfigMapExtensionNested<A> withNewConfigMapExtension() {
    return new ConfigMapExtensionNested(null);
  }
  public ConfigMapExtensionNested<A> withNewConfigMapExtensionLike(ConfigMap item) {
    return new ConfigMapExtensionNested(item);
  }
  public ContainerPortExtensionNested<A> withNewContainerPortExtension() {
    return new ContainerPortExtensionNested(null);
  }
  public ContainerPortExtensionNested<A> withNewContainerPortExtensionLike(ContainerPort item) {
    return new ContainerPortExtensionNested(item);
  }
  public A withNewContainerPortExtension(Integer containerPort,String hostIP,Integer hostPort,String name,String protocol) {
    return (A)withExtension(new ContainerPort(containerPort, hostIP, hostPort, name, protocol));
  }
  public ConditionExtensionNested<A> withNewConditionExtension() {
    return new ConditionExtensionNested(null);
  }
  public ConditionExtensionNested<A> withNewConditionExtensionLike(Condition item) {
    return new ConditionExtensionNested(item);
  }
  public PodListExtensionNested<A> withNewPodListExtension() {
    return new PodListExtensionNested(null);
  }
  public PodListExtensionNested<A> withNewPodListExtensionLike(PodList item) {
    return new PodListExtensionNested(item);
  }
  public FCVolumeSourceExtensionNested<A> withNewFCVolumeSourceExtension() {
    return new FCVolumeSourceExtensionNested(null);
  }
  public FCVolumeSourceExtensionNested<A> withNewFCVolumeSourceExtensionLike(FCVolumeSource item) {
    return new FCVolumeSourceExtensionNested(item);
  }
  public ResourceFieldSelectorExtensionNested<A> withNewResourceFieldSelectorExtension() {
    return new ResourceFieldSelectorExtensionNested(null);
  }
  public ResourceFieldSelectorExtensionNested<A> withNewResourceFieldSelectorExtensionLike(ResourceFieldSelector item) {
    return new ResourceFieldSelectorExtensionNested(item);
  }
  public PersistentVolumeClaimSpecExtensionNested<A> withNewPersistentVolumeClaimSpecExtension() {
    return new PersistentVolumeClaimSpecExtensionNested(null);
  }
  public PersistentVolumeClaimSpecExtensionNested<A> withNewPersistentVolumeClaimSpecExtensionLike(PersistentVolumeClaimSpec item) {
    return new PersistentVolumeClaimSpecExtensionNested(item);
  }
  public LoadBalancerStatusExtensionNested<A> withNewLoadBalancerStatusExtension() {
    return new LoadBalancerStatusExtensionNested(null);
  }
  public LoadBalancerStatusExtensionNested<A> withNewLoadBalancerStatusExtensionLike(LoadBalancerStatus item) {
    return new LoadBalancerStatusExtensionNested(item);
  }
  public PodSecurityContextExtensionNested<A> withNewPodSecurityContextExtension() {
    return new PodSecurityContextExtensionNested(null);
  }
  public PodSecurityContextExtensionNested<A> withNewPodSecurityContextExtensionLike(PodSecurityContext item) {
    return new PodSecurityContextExtensionNested(item);
  }
  public ScopeSelectorExtensionNested<A> withNewScopeSelectorExtension() {
    return new ScopeSelectorExtensionNested(null);
  }
  public ScopeSelectorExtensionNested<A> withNewScopeSelectorExtensionLike(ScopeSelector item) {
    return new ScopeSelectorExtensionNested(item);
  }
  public DownwardAPIProjectionExtensionNested<A> withNewDownwardAPIProjectionExtension() {
    return new DownwardAPIProjectionExtensionNested(null);
  }
  public DownwardAPIProjectionExtensionNested<A> withNewDownwardAPIProjectionExtensionLike(DownwardAPIProjection item) {
    return new DownwardAPIProjectionExtensionNested(item);
  }
  public PodAffinityTermExtensionNested<A> withNewPodAffinityTermExtension() {
    return new PodAffinityTermExtensionNested(null);
  }
  public PodAffinityTermExtensionNested<A> withNewPodAffinityTermExtensionLike(PodAffinityTerm item) {
    return new PodAffinityTermExtensionNested(item);
  }
  public APIServiceSpecExtensionNested<A> withNewAPIServiceSpecExtension() {
    return new APIServiceSpecExtensionNested(null);
  }
  public APIServiceSpecExtensionNested<A> withNewAPIServiceSpecExtensionLike(APIServiceSpec item) {
    return new APIServiceSpecExtensionNested(item);
  }
  public ServicePortExtensionNested<A> withNewServicePortExtension() {
    return new ServicePortExtensionNested(null);
  }
  public ServicePortExtensionNested<A> withNewServicePortExtensionLike(ServicePort item) {
    return new ServicePortExtensionNested(item);
  }
  public GroupVersionForDiscoveryExtensionNested<A> withNewGroupVersionForDiscoveryExtension() {
    return new GroupVersionForDiscoveryExtensionNested(null);
  }
  public GroupVersionForDiscoveryExtensionNested<A> withNewGroupVersionForDiscoveryExtensionLike(GroupVersionForDiscovery item) {
    return new GroupVersionForDiscoveryExtensionNested(item);
  }
  public A withNewGroupVersionForDiscoveryExtension(String groupVersion,String version) {
    return (A)withExtension(new GroupVersionForDiscovery(groupVersion, version));
  }
  public ClaimSourceExtensionNested<A> withNewClaimSourceExtension() {
    return new ClaimSourceExtensionNested(null);
  }
  public ClaimSourceExtensionNested<A> withNewClaimSourceExtensionLike(ClaimSource item) {
    return new ClaimSourceExtensionNested(item);
  }
  public A withNewClaimSourceExtension(String resourceClaimName,String resourceClaimTemplateName) {
    return (A)withExtension(new ClaimSource(resourceClaimName, resourceClaimTemplateName));
  }
  public PersistentVolumeClaimSourceExtensionNested<A> withNewPersistentVolumeClaimSourceExtension() {
    return new PersistentVolumeClaimSourceExtensionNested(null);
  }
  public PersistentVolumeClaimSourceExtensionNested<A> withNewPersistentVolumeClaimSourceExtensionLike(PersistentVolumeClaimVolumeSource item) {
    return new PersistentVolumeClaimSourceExtensionNested(item);
  }
  public A withNewPersistentVolumeClaimSourceExtension(String claimName,Boolean readOnly) {
    return (A)withExtension(new PersistentVolumeClaimVolumeSource(claimName, readOnly));
  }
  public SessionAffinityConfigExtensionNested<A> withNewSessionAffinityConfigExtension() {
    return new SessionAffinityConfigExtensionNested(null);
  }
  public SessionAffinityConfigExtensionNested<A> withNewSessionAffinityConfigExtensionLike(SessionAffinityConfig item) {
    return new SessionAffinityConfigExtensionNested(item);
  }
  public ServiceAccountListExtensionNested<A> withNewServiceAccountListExtension() {
    return new ServiceAccountListExtensionNested(null);
  }
  public ServiceAccountListExtensionNested<A> withNewServiceAccountListExtensionLike(ServiceAccountList item) {
    return new ServiceAccountListExtensionNested(item);
  }
  public ComponentStatusExtensionNested<A> withNewComponentStatusExtension() {
    return new ComponentStatusExtensionNested(null);
  }
  public ComponentStatusExtensionNested<A> withNewComponentStatusExtensionLike(ComponentStatus item) {
    return new ComponentStatusExtensionNested(item);
  }
  public DaemonEndpointExtensionNested<A> withNewDaemonEndpointExtension() {
    return new DaemonEndpointExtensionNested(null);
  }
  public DaemonEndpointExtensionNested<A> withNewDaemonEndpointExtensionLike(DaemonEndpoint item) {
    return new DaemonEndpointExtensionNested(item);
  }
  public A withNewDaemonEndpointExtension(Integer port) {
    return (A)withExtension(new DaemonEndpoint(port));
  }
  public KeyToPathExtensionNested<A> withNewKeyToPathExtension() {
    return new KeyToPathExtensionNested(null);
  }
  public KeyToPathExtensionNested<A> withNewKeyToPathExtensionLike(KeyToPath item) {
    return new KeyToPathExtensionNested(item);
  }
  public A withNewKeyToPathExtension(String key,Integer mode,String path) {
    return (A)withExtension(new KeyToPath(key, mode, path));
  }
  public FlexPersistentVolumeSourceExtensionNested<A> withNewFlexPersistentVolumeSourceExtension() {
    return new FlexPersistentVolumeSourceExtensionNested(null);
  }
  public FlexPersistentVolumeSourceExtensionNested<A> withNewFlexPersistentVolumeSourceExtensionLike(FlexPersistentVolumeSource item) {
    return new FlexPersistentVolumeSourceExtensionNested(item);
  }
  public NamespaceListExtensionNested<A> withNewNamespaceListExtension() {
    return new NamespaceListExtensionNested(null);
  }
  public NamespaceListExtensionNested<A> withNewNamespaceListExtensionLike(NamespaceList item) {
    return new NamespaceListExtensionNested(item);
  }
  public PodDNSConfigExtensionNested<A> withNewPodDNSConfigExtension() {
    return new PodDNSConfigExtensionNested(null);
  }
  public PodDNSConfigExtensionNested<A> withNewPodDNSConfigExtensionLike(PodDNSConfig item) {
    return new PodDNSConfigExtensionNested(item);
  }
  public NodeListExtensionNested<A> withNewNodeListExtension() {
    return new NodeListExtensionNested(null);
  }
  public NodeListExtensionNested<A> withNewNodeListExtensionLike(NodeList item) {
    return new NodeListExtensionNested(item);
  }
  public BindingExtensionNested<A> withNewBindingExtension() {
    return new BindingExtensionNested(null);
  }
  public BindingExtensionNested<A> withNewBindingExtensionLike(Binding item) {
    return new BindingExtensionNested(item);
  }
  public EnvVarSourceExtensionNested<A> withNewEnvVarSourceExtension() {
    return new EnvVarSourceExtensionNested(null);
  }
  public EnvVarSourceExtensionNested<A> withNewEnvVarSourceExtensionLike(EnvVarSource item) {
    return new EnvVarSourceExtensionNested(item);
  }
  public VolumeProjectionExtensionNested<A> withNewVolumeProjectionExtension() {
    return new VolumeProjectionExtensionNested(null);
  }
  public VolumeProjectionExtensionNested<A> withNewVolumeProjectionExtensionLike(VolumeProjection item) {
    return new VolumeProjectionExtensionNested(item);
  }
  public ResourceQuotaExtensionNested<A> withNewResourceQuotaExtension() {
    return new ResourceQuotaExtensionNested(null);
  }
  public ResourceQuotaExtensionNested<A> withNewResourceQuotaExtensionLike(ResourceQuota item) {
    return new ResourceQuotaExtensionNested(item);
  }
  public SecretExtensionNested<A> withNewSecretExtension() {
    return new SecretExtensionNested(null);
  }
  public SecretExtensionNested<A> withNewSecretExtensionLike(Secret item) {
    return new SecretExtensionNested(item);
  }
  public ServiceListExtensionNested<A> withNewServiceListExtension() {
    return new ServiceListExtensionNested(null);
  }
  public ServiceListExtensionNested<A> withNewServiceListExtensionLike(ServiceList item) {
    return new ServiceListExtensionNested(item);
  }
  public VolumeNodeAffinityExtensionNested<A> withNewVolumeNodeAffinityExtension() {
    return new VolumeNodeAffinityExtensionNested(null);
  }
  public VolumeNodeAffinityExtensionNested<A> withNewVolumeNodeAffinityExtensionLike(VolumeNodeAffinity item) {
    return new VolumeNodeAffinityExtensionNested(item);
  }
  public ResourceQuotaSpecExtensionNested<A> withNewResourceQuotaSpecExtension() {
    return new ResourceQuotaSpecExtensionNested(null);
  }
  public ResourceQuotaSpecExtensionNested<A> withNewResourceQuotaSpecExtensionLike(ResourceQuotaSpec item) {
    return new ResourceQuotaSpecExtensionNested(item);
  }
  public NodeSelectorTermExtensionNested<A> withNewNodeSelectorTermExtension() {
    return new NodeSelectorTermExtensionNested(null);
  }
  public NodeSelectorTermExtensionNested<A> withNewNodeSelectorTermExtensionLike(NodeSelectorTerm item) {
    return new NodeSelectorTermExtensionNested(item);
  }
  public ScaleIOPersistentVolumeSourceExtensionNested<A> withNewScaleIOPersistentVolumeSourceExtension() {
    return new ScaleIOPersistentVolumeSourceExtensionNested(null);
  }
  public ScaleIOPersistentVolumeSourceExtensionNested<A> withNewScaleIOPersistentVolumeSourceExtensionLike(ScaleIOPersistentVolumeSource item) {
    return new ScaleIOPersistentVolumeSourceExtensionNested(item);
  }
  public ListOptionsExtensionNested<A> withNewListOptionsExtension() {
    return new ListOptionsExtensionNested(null);
  }
  public ListOptionsExtensionNested<A> withNewListOptionsExtensionLike(ListOptions item) {
    return new ListOptionsExtensionNested(item);
  }
  public WeightedPodAffinityTermExtensionNested<A> withNewWeightedPodAffinityTermExtension() {
    return new WeightedPodAffinityTermExtensionNested(null);
  }
  public WeightedPodAffinityTermExtensionNested<A> withNewWeightedPodAffinityTermExtensionLike(WeightedPodAffinityTerm item) {
    return new WeightedPodAffinityTermExtensionNested(item);
  }
  public TypedObjectReferenceExtensionNested<A> withNewTypedObjectReferenceExtension() {
    return new TypedObjectReferenceExtensionNested(null);
  }
  public TypedObjectReferenceExtensionNested<A> withNewTypedObjectReferenceExtensionLike(TypedObjectReference item) {
    return new TypedObjectReferenceExtensionNested(item);
  }
  public A withNewTypedObjectReferenceExtension(String apiGroup,String kind,String name,String namespace) {
    return (A)withExtension(new TypedObjectReference(apiGroup, kind, name, namespace));
  }
  public ContainerResizePolicyExtensionNested<A> withNewContainerResizePolicyExtension() {
    return new ContainerResizePolicyExtensionNested(null);
  }
  public ContainerResizePolicyExtensionNested<A> withNewContainerResizePolicyExtensionLike(ContainerResizePolicy item) {
    return new ContainerResizePolicyExtensionNested(item);
  }
  public A withNewContainerResizePolicyExtension(String resourceName,String restartPolicy) {
    return (A)withExtension(new ContainerResizePolicy(resourceName, restartPolicy));
  }
  public NodeSystemInfoExtensionNested<A> withNewNodeSystemInfoExtension() {
    return new NodeSystemInfoExtensionNested(null);
  }
  public NodeSystemInfoExtensionNested<A> withNewNodeSystemInfoExtensionLike(NodeSystemInfo item) {
    return new NodeSystemInfoExtensionNested(item);
  }
  public TopologySelectorLabelRequirementExtensionNested<A> withNewTopologySelectorLabelRequirementExtension() {
    return new TopologySelectorLabelRequirementExtensionNested(null);
  }
  public TopologySelectorLabelRequirementExtensionNested<A> withNewTopologySelectorLabelRequirementExtensionLike(TopologySelectorLabelRequirement item) {
    return new TopologySelectorLabelRequirementExtensionNested(item);
  }
  public RBDPersistentVolumeSourceExtensionNested<A> withNewRBDPersistentVolumeSourceExtension() {
    return new RBDPersistentVolumeSourceExtensionNested(null);
  }
  public RBDPersistentVolumeSourceExtensionNested<A> withNewRBDPersistentVolumeSourceExtensionLike(RBDPersistentVolumeSource item) {
    return new RBDPersistentVolumeSourceExtensionNested(item);
  }
  public AuthProviderConfigExtensionNested<A> withNewAuthProviderConfigExtension() {
    return new AuthProviderConfigExtensionNested(null);
  }
  public AuthProviderConfigExtensionNested<A> withNewAuthProviderConfigExtensionLike(AuthProviderConfig item) {
    return new AuthProviderConfigExtensionNested(item);
  }
  public SELinuxOptionsExtensionNested<A> withNewSELinuxOptionsExtension() {
    return new SELinuxOptionsExtensionNested(null);
  }
  public SELinuxOptionsExtensionNested<A> withNewSELinuxOptionsExtensionLike(SELinuxOptions item) {
    return new SELinuxOptionsExtensionNested(item);
  }
  public A withNewSELinuxOptionsExtension(String level,String role,String type,String user) {
    return (A)withExtension(new SELinuxOptions(level, role, type, user));
  }
  public HostAliasExtensionNested<A> withNewHostAliasExtension() {
    return new HostAliasExtensionNested(null);
  }
  public HostAliasExtensionNested<A> withNewHostAliasExtensionLike(HostAlias item) {
    return new HostAliasExtensionNested(item);
  }
  public NodeDaemonEndpointsExtensionNested<A> withNewNodeDaemonEndpointsExtension() {
    return new NodeDaemonEndpointsExtensionNested(null);
  }
  public NodeDaemonEndpointsExtensionNested<A> withNewNodeDaemonEndpointsExtensionLike(NodeDaemonEndpoints item) {
    return new NodeDaemonEndpointsExtensionNested(item);
  }
  public VolumeDeviceExtensionNested<A> withNewVolumeDeviceExtension() {
    return new VolumeDeviceExtensionNested(null);
  }
  public VolumeDeviceExtensionNested<A> withNewVolumeDeviceExtensionLike(VolumeDevice item) {
    return new VolumeDeviceExtensionNested(item);
  }
  public A withNewVolumeDeviceExtension(String devicePath,String name) {
    return (A)withExtension(new VolumeDevice(devicePath, name));
  }
  public CSIVolumeSourceExtensionNested<A> withNewCSIVolumeSourceExtension() {
    return new CSIVolumeSourceExtensionNested(null);
  }
  public CSIVolumeSourceExtensionNested<A> withNewCSIVolumeSourceExtensionLike(CSIVolumeSource item) {
    return new CSIVolumeSourceExtensionNested(item);
  }
  public PersistentVolumeSpecExtensionNested<A> withNewPersistentVolumeSpecExtension() {
    return new PersistentVolumeSpecExtensionNested(null);
  }
  public PersistentVolumeSpecExtensionNested<A> withNewPersistentVolumeSpecExtensionLike(PersistentVolumeSpec item) {
    return new PersistentVolumeSpecExtensionNested(item);
  }
  public NodeExtensionNested<A> withNewNodeExtension() {
    return new NodeExtensionNested(null);
  }
  public NodeExtensionNested<A> withNewNodeExtensionLike(Node item) {
    return new NodeExtensionNested(item);
  }
  public LifecycleHandlerExtensionNested<A> withNewLifecycleHandlerExtension() {
    return new LifecycleHandlerExtensionNested(null);
  }
  public LifecycleHandlerExtensionNested<A> withNewLifecycleHandlerExtensionLike(LifecycleHandler item) {
    return new LifecycleHandlerExtensionNested(item);
  }
  public VolumeExtensionNested<A> withNewVolumeExtension() {
    return new VolumeExtensionNested(null);
  }
  public VolumeExtensionNested<A> withNewVolumeExtensionLike(Volume item) {
    return new VolumeExtensionNested(item);
  }
  public ClusterExtensionNested<A> withNewClusterExtension() {
    return new ClusterExtensionNested(null);
  }
  public ClusterExtensionNested<A> withNewClusterExtensionLike(Cluster item) {
    return new ClusterExtensionNested(item);
  }
  public NFSVolumeSourceExtensionNested<A> withNewNFSVolumeSourceExtension() {
    return new NFSVolumeSourceExtensionNested(null);
  }
  public NFSVolumeSourceExtensionNested<A> withNewNFSVolumeSourceExtensionLike(NFSVolumeSource item) {
    return new NFSVolumeSourceExtensionNested(item);
  }
  public A withNewNFSVolumeSourceExtension(String path,Boolean readOnly,String server) {
    return (A)withExtension(new NFSVolumeSource(path, readOnly, server));
  }
  public StorageOSVolumeSourceExtensionNested<A> withNewStorageOSVolumeSourceExtension() {
    return new StorageOSVolumeSourceExtensionNested(null);
  }
  public StorageOSVolumeSourceExtensionNested<A> withNewStorageOSVolumeSourceExtensionLike(StorageOSVolumeSource item) {
    return new StorageOSVolumeSourceExtensionNested(item);
  }
  public PodStatusExtensionNested<A> withNewPodStatusExtension() {
    return new PodStatusExtensionNested(null);
  }
  public PodStatusExtensionNested<A> withNewPodStatusExtensionLike(PodStatus item) {
    return new PodStatusExtensionNested(item);
  }
  public KubernetesListExtensionNested<A> withNewKubernetesListExtension() {
    return new KubernetesListExtensionNested(null);
  }
  public KubernetesListExtensionNested<A> withNewKubernetesListExtensionLike(KubernetesList item) {
    return new KubernetesListExtensionNested(item);
  }
  public ExecConfigExtensionNested<A> withNewExecConfigExtension() {
    return new ExecConfigExtensionNested(null);
  }
  public ExecConfigExtensionNested<A> withNewExecConfigExtensionLike(ExecConfig item) {
    return new ExecConfigExtensionNested(item);
  }
  public PersistentVolumeStatusExtensionNested<A> withNewPersistentVolumeStatusExtension() {
    return new PersistentVolumeStatusExtensionNested(null);
  }
  public PersistentVolumeStatusExtensionNested<A> withNewPersistentVolumeStatusExtensionLike(PersistentVolumeStatus item) {
    return new PersistentVolumeStatusExtensionNested(item);
  }
  public A withNewPersistentVolumeStatusExtension(String message,String phase,String reason) {
    return (A)withExtension(new PersistentVolumeStatus(message, phase, reason));
  }
  public EndpointPortExtensionNested<A> withNewEndpointPortExtension() {
    return new EndpointPortExtensionNested(null);
  }
  public EndpointPortExtensionNested<A> withNewEndpointPortExtensionLike(EndpointPort item) {
    return new EndpointPortExtensionNested(item);
  }
  public A withNewEndpointPortExtension(String appProtocol,String name,Integer port,String protocol) {
    return (A)withExtension(new EndpointPort(appProtocol, name, port, protocol));
  }
  public HTTPHeaderExtensionNested<A> withNewHTTPHeaderExtension() {
    return new HTTPHeaderExtensionNested(null);
  }
  public HTTPHeaderExtensionNested<A> withNewHTTPHeaderExtensionLike(HTTPHeader item) {
    return new HTTPHeaderExtensionNested(item);
  }
  public A withNewHTTPHeaderExtension(String name,String value) {
    return (A)withExtension(new HTTPHeader(name, value));
  }
  public CapabilitiesExtensionNested<A> withNewCapabilitiesExtension() {
    return new CapabilitiesExtensionNested(null);
  }
  public CapabilitiesExtensionNested<A> withNewCapabilitiesExtensionLike(Capabilities item) {
    return new CapabilitiesExtensionNested(item);
  }
  public ObjectReferenceExtensionNested<A> withNewObjectReferenceExtension() {
    return new ObjectReferenceExtensionNested(null);
  }
  public ObjectReferenceExtensionNested<A> withNewObjectReferenceExtensionLike(ObjectReference item) {
    return new ObjectReferenceExtensionNested(item);
  }
  public WatchEventExtensionNested<A> withNewWatchEventExtension() {
    return new WatchEventExtensionNested(null);
  }
  public WatchEventExtensionNested<A> withNewWatchEventExtensionLike(WatchEvent item) {
    return new WatchEventExtensionNested(item);
  }
  public LimitRangeItemExtensionNested<A> withNewLimitRangeItemExtension() {
    return new LimitRangeItemExtensionNested(null);
  }
  public LimitRangeItemExtensionNested<A> withNewLimitRangeItemExtensionLike(LimitRangeItem item) {
    return new LimitRangeItemExtensionNested(item);
  }
  public SecretProjectionExtensionNested<A> withNewSecretProjectionExtension() {
    return new SecretProjectionExtensionNested(null);
  }
  public SecretProjectionExtensionNested<A> withNewSecretProjectionExtensionLike(SecretProjection item) {
    return new SecretProjectionExtensionNested(item);
  }
  public GetOptionsExtensionNested<A> withNewGetOptionsExtension() {
    return new GetOptionsExtensionNested(null);
  }
  public GetOptionsExtensionNested<A> withNewGetOptionsExtensionLike(GetOptions item) {
    return new GetOptionsExtensionNested(item);
  }
  public A withNewGetOptionsExtension(String apiVersion,String kind,String resourceVersion) {
    return (A)withExtension(new GetOptions(apiVersion, kind, resourceVersion));
  }
  public GlusterfsVolumeSourceExtensionNested<A> withNewGlusterfsVolumeSourceExtension() {
    return new GlusterfsVolumeSourceExtensionNested(null);
  }
  public GlusterfsVolumeSourceExtensionNested<A> withNewGlusterfsVolumeSourceExtensionLike(GlusterfsVolumeSource item) {
    return new GlusterfsVolumeSourceExtensionNested(item);
  }
  public A withNewGlusterfsVolumeSourceExtension(String endpoints,String path,Boolean readOnly) {
    return (A)withExtension(new GlusterfsVolumeSource(endpoints, path, readOnly));
  }
  public ManagedFieldsEntryExtensionNested<A> withNewManagedFieldsEntryExtension() {
    return new ManagedFieldsEntryExtensionNested(null);
  }
  public ManagedFieldsEntryExtensionNested<A> withNewManagedFieldsEntryExtensionLike(ManagedFieldsEntry item) {
    return new ManagedFieldsEntryExtensionNested(item);
  }
  public NamespaceStatusExtensionNested<A> withNewNamespaceStatusExtension() {
    return new NamespaceStatusExtensionNested(null);
  }
  public NamespaceStatusExtensionNested<A> withNewNamespaceStatusExtensionLike(NamespaceStatus item) {
    return new NamespaceStatusExtensionNested(item);
  }
  public SecretEnvSourceExtensionNested<A> withNewSecretEnvSourceExtension() {
    return new SecretEnvSourceExtensionNested(null);
  }
  public SecretEnvSourceExtensionNested<A> withNewSecretEnvSourceExtensionLike(SecretEnvSource item) {
    return new SecretEnvSourceExtensionNested(item);
  }
  public A withNewSecretEnvSourceExtension(String name,Boolean optional) {
    return (A)withExtension(new SecretEnvSource(name, optional));
  }
  public ServiceAccountExtensionNested<A> withNewServiceAccountExtension() {
    return new ServiceAccountExtensionNested(null);
  }
  public ServiceAccountExtensionNested<A> withNewServiceAccountExtensionLike(ServiceAccount item) {
    return new ServiceAccountExtensionNested(item);
  }
  public AWSElasticBlockStoreVolumeSourceExtensionNested<A> withNewAWSElasticBlockStoreVolumeSourceExtension() {
    return new AWSElasticBlockStoreVolumeSourceExtensionNested(null);
  }
  public AWSElasticBlockStoreVolumeSourceExtensionNested<A> withNewAWSElasticBlockStoreVolumeSourceExtensionLike(AWSElasticBlockStoreVolumeSource item) {
    return new AWSElasticBlockStoreVolumeSourceExtensionNested(item);
  }
  public A withNewAWSElasticBlockStoreVolumeSourceExtension(String fsType,Integer partition,Boolean readOnly,String volumeID) {
    return (A)withExtension(new AWSElasticBlockStoreVolumeSource(fsType, partition, readOnly, volumeID));
  }
  public PodIPExtensionNested<A> withNewPodIPExtension() {
    return new PodIPExtensionNested(null);
  }
  public PodIPExtensionNested<A> withNewPodIPExtensionLike(PodIP item) {
    return new PodIPExtensionNested(item);
  }
  public A withNewPodIPExtension(String ip) {
    return (A)withExtension(new PodIP(ip));
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public boolean hasName() {
    return this.name != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NamedExtensionFluent that = (NamedExtensionFluent) o;
    if (!java.util.Objects.equals(extension, that.extension)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(extension,  name,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (extension != null) { sb.append("extension:"); sb.append(extension + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.fabric8.kubernetes.api.model."+"Patch": return (VisitableBuilder<T, ?>)new PatchBuilder((Patch) item);
    case "io.fabric8.kubernetes.api.model."+"LimitRange": return (VisitableBuilder<T, ?>)new LimitRangeBuilder((LimitRange) item);
    case "io.fabric8.kubernetes.api.model."+"APIGroupList": return (VisitableBuilder<T, ?>)new APIGroupListBuilder((APIGroupList) item);
    case "io.fabric8.kubernetes.api.model."+"PortStatus": return (VisitableBuilder<T, ?>)new PortStatusBuilder((PortStatus) item);
    case "io.fabric8.kubernetes.api.model."+"PodTemplateSpec": return (VisitableBuilder<T, ?>)new PodTemplateSpecBuilder((PodTemplateSpec) item);
    case "io.fabric8.kubernetes.api.model."+"CSIPersistentVolumeSource": return (VisitableBuilder<T, ?>)new CSIPersistentVolumeSourceBuilder((CSIPersistentVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"AuthInfo": return (VisitableBuilder<T, ?>)new AuthInfoBuilder((AuthInfo) item);
    case "io.fabric8.kubernetes.api.model."+"APIService": return (VisitableBuilder<T, ?>)new APIServiceBuilder((APIService) item);
    case "io.fabric8.kubernetes.api.model."+"ResourceRequirements": return (VisitableBuilder<T, ?>)new ResourceRequirementsBuilder((ResourceRequirements) item);
    case "io.fabric8.kubernetes.api.model."+"ConfigMapKeySelector": return (VisitableBuilder<T, ?>)new ConfigMapKeySelectorBuilder((ConfigMapKeySelector) item);
    case "io.fabric8.kubernetes.api.model."+"HostPathVolumeSource": return (VisitableBuilder<T, ?>)new HostPathVolumeSourceBuilder((HostPathVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolumeClaimList": return (VisitableBuilder<T, ?>)new PersistentVolumeClaimListBuilder((PersistentVolumeClaimList) item);
    case "io.fabric8.kubernetes.api.model."+"NamedContext": return (VisitableBuilder<T, ?>)new NamedContextBuilder((NamedContext) item);
    case "io.fabric8.kubernetes.api.model."+"Config": return (VisitableBuilder<T, ?>)new ConfigBuilder((Config) item);
    case "io.fabric8.kubernetes.api.model."+"Affinity": return (VisitableBuilder<T, ?>)new AffinityBuilder((Affinity) item);
    case "io.fabric8.kubernetes.api.model."+"PodResourceClaim": return (VisitableBuilder<T, ?>)new PodResourceClaimBuilder((PodResourceClaim) item);
    case "io.fabric8.kubernetes.api.model."+"ReplicationControllerStatus": return (VisitableBuilder<T, ?>)new ReplicationControllerStatusBuilder((ReplicationControllerStatus) item);
    case "io.fabric8.kubernetes.api.model."+"APIServiceStatus": return (VisitableBuilder<T, ?>)new APIServiceStatusBuilder((APIServiceStatus) item);
    case "io.fabric8.kubernetes.api.model."+"MicroTime": return (VisitableBuilder<T, ?>)new MicroTimeBuilder((MicroTime) item);
    case "io.fabric8.kubernetes.api.model."+"Lifecycle": return (VisitableBuilder<T, ?>)new LifecycleBuilder((Lifecycle) item);
    case "io.fabric8.kubernetes.api.model."+"PortworxVolumeSource": return (VisitableBuilder<T, ?>)new PortworxVolumeSourceBuilder((PortworxVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"EventSource": return (VisitableBuilder<T, ?>)new EventSourceBuilder((EventSource) item);
    case "io.fabric8.kubernetes.api.model."+"GRPCAction": return (VisitableBuilder<T, ?>)new GRPCActionBuilder((GRPCAction) item);
    case "io.fabric8.kubernetes.api.model."+"AzureFileVolumeSource": return (VisitableBuilder<T, ?>)new AzureFileVolumeSourceBuilder((AzureFileVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"ResourceClaim": return (VisitableBuilder<T, ?>)new ResourceClaimBuilder((ResourceClaim) item);
    case "io.fabric8.kubernetes.api.model."+"ComponentCondition": return (VisitableBuilder<T, ?>)new ComponentConditionBuilder((ComponentCondition) item);
    case "io.fabric8.kubernetes.api.model."+"EnvVar": return (VisitableBuilder<T, ?>)new EnvVarBuilder((EnvVar) item);
    case "io.fabric8.kubernetes.api.model."+"ReplicationControllerSpec": return (VisitableBuilder<T, ?>)new ReplicationControllerSpecBuilder((ReplicationControllerSpec) item);
    case "io.fabric8.kubernetes.api.model."+"LoadBalancerIngress": return (VisitableBuilder<T, ?>)new LoadBalancerIngressBuilder((LoadBalancerIngress) item);
    case "io.fabric8.kubernetes.api.model."+"AttachedVolume": return (VisitableBuilder<T, ?>)new AttachedVolumeBuilder((AttachedVolume) item);
    case "io.fabric8.kubernetes.api.model."+"LocalObjectReference": return (VisitableBuilder<T, ?>)new LocalObjectReferenceBuilder((LocalObjectReference) item);
    case "io.fabric8.kubernetes.api.model."+"NamedAuthInfo": return (VisitableBuilder<T, ?>)new NamedAuthInfoBuilder((NamedAuthInfo) item);
    case "io.fabric8.kubernetes.api.model."+"EmptyDirVolumeSource": return (VisitableBuilder<T, ?>)new EmptyDirVolumeSourceBuilder((EmptyDirVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"PodSpec": return (VisitableBuilder<T, ?>)new PodSpecBuilder((PodSpec) item);
    case "io.fabric8.kubernetes.api.model."+"ServerAddressByClientCIDR": return (VisitableBuilder<T, ?>)new ServerAddressByClientCIDRBuilder((ServerAddressByClientCIDR) item);
    case "io.fabric8.kubernetes.api.model."+"AzureDiskVolumeSource": return (VisitableBuilder<T, ?>)new AzureDiskVolumeSourceBuilder((AzureDiskVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"Preconditions": return (VisitableBuilder<T, ?>)new PreconditionsBuilder((Preconditions) item);
    case "io.fabric8.kubernetes.api.model.version."+"Info": return (VisitableBuilder<T, ?>)new InfoBuilder((Info) item);
    case "io.fabric8.kubernetes.api.model."+"CephFSVolumeSource": return (VisitableBuilder<T, ?>)new CephFSVolumeSourceBuilder((CephFSVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"EphemeralContainer": return (VisitableBuilder<T, ?>)new EphemeralContainerBuilder((EphemeralContainer) item);
    case "io.fabric8.kubernetes.api.model."+"NodeCondition": return (VisitableBuilder<T, ?>)new NodeConditionBuilder((NodeCondition) item);
    case "io.fabric8.kubernetes.api.model."+"EndpointSubset": return (VisitableBuilder<T, ?>)new EndpointSubsetBuilder((EndpointSubset) item);
    case "io.fabric8.kubernetes.api.model."+"LocalVolumeSource": return (VisitableBuilder<T, ?>)new LocalVolumeSourceBuilder((LocalVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"ServiceReference": return (VisitableBuilder<T, ?>)new ServiceReferenceBuilder((ServiceReference) item);
    case "io.fabric8.kubernetes.api.model."+"ServiceStatus": return (VisitableBuilder<T, ?>)new ServiceStatusBuilder((ServiceStatus) item);
    case "io.fabric8.kubernetes.api.model."+"Taint": return (VisitableBuilder<T, ?>)new TaintBuilder((Taint) item);
    case "io.fabric8.kubernetes.api.model."+"PatchOptions": return (VisitableBuilder<T, ?>)new PatchOptionsBuilder((PatchOptions) item);
    case "io.fabric8.kubernetes.api.model."+"ConfigMapNodeConfigSource": return (VisitableBuilder<T, ?>)new ConfigMapNodeConfigSourceBuilder((ConfigMapNodeConfigSource) item);
    case "io.fabric8.kubernetes.api.model."+"HTTPGetAction": return (VisitableBuilder<T, ?>)new HTTPGetActionBuilder((HTTPGetAction) item);
    case "io.fabric8.kubernetes.api.model."+"GlusterfsPersistentVolumeSource": return (VisitableBuilder<T, ?>)new GlusterfsPersistentVolumeSourceBuilder((GlusterfsPersistentVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"DownwardAPIVolumeSource": return (VisitableBuilder<T, ?>)new DownwardAPIVolumeSourceBuilder((DownwardAPIVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"ISCSIPersistentVolumeSource": return (VisitableBuilder<T, ?>)new ISCSIPersistentVolumeSourceBuilder((ISCSIPersistentVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"WindowsSecurityContextOptions": return (VisitableBuilder<T, ?>)new WindowsSecurityContextOptionsBuilder((WindowsSecurityContextOptions) item);
    case "io.fabric8.kubernetes.api.model."+"CreateOptions": return (VisitableBuilder<T, ?>)new CreateOptionsBuilder((CreateOptions) item);
    case "io.fabric8.kubernetes.api.model."+"EnvFromSource": return (VisitableBuilder<T, ?>)new EnvFromSourceBuilder((EnvFromSource) item);
    case "io.fabric8.kubernetes.api.model."+"NamespaceSpec": return (VisitableBuilder<T, ?>)new NamespaceSpecBuilder((NamespaceSpec) item);
    case "io.fabric8.kubernetes.api.model."+"TypeMeta": return (VisitableBuilder<T, ?>)new TypeMetaBuilder((TypeMeta) item);
    case "io.fabric8.kubernetes.api.model."+"RootPaths": return (VisitableBuilder<T, ?>)new RootPathsBuilder((RootPaths) item);
    case "io.fabric8.kubernetes.api.model."+"ListMeta": return (VisitableBuilder<T, ?>)new ListMetaBuilder((ListMeta) item);
    case "io.fabric8.kubernetes.api.model."+"SecretReference": return (VisitableBuilder<T, ?>)new SecretReferenceBuilder((SecretReference) item);
    case "io.fabric8.kubernetes.api.model."+"APIGroup": return (VisitableBuilder<T, ?>)new APIGroupBuilder((APIGroup) item);
    case "io.fabric8.kubernetes.api.model."+"FlexVolumeSource": return (VisitableBuilder<T, ?>)new FlexVolumeSourceBuilder((FlexVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolumeClaimTemplate": return (VisitableBuilder<T, ?>)new PersistentVolumeClaimTemplateBuilder((PersistentVolumeClaimTemplate) item);
    case "io.fabric8.kubernetes.api.model."+"ISCSIVolumeSource": return (VisitableBuilder<T, ?>)new ISCSIVolumeSourceBuilder((ISCSIVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"SecretKeySelector": return (VisitableBuilder<T, ?>)new SecretKeySelectorBuilder((SecretKeySelector) item);
    case "io.fabric8.kubernetes.api.model."+"RBDVolumeSource": return (VisitableBuilder<T, ?>)new RBDVolumeSourceBuilder((RBDVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"NodeConfigStatus": return (VisitableBuilder<T, ?>)new NodeConfigStatusBuilder((NodeConfigStatus) item);
    case "io.fabric8.kubernetes.api.model."+"ResourceQuotaList": return (VisitableBuilder<T, ?>)new ResourceQuotaListBuilder((ResourceQuotaList) item);
    case "io.fabric8.kubernetes.api.model."+"QuobyteVolumeSource": return (VisitableBuilder<T, ?>)new QuobyteVolumeSourceBuilder((QuobyteVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"APIResource": return (VisitableBuilder<T, ?>)new APIResourceBuilder((APIResource) item);
    case "io.fabric8.kubernetes.api.model."+"ResourceQuotaStatus": return (VisitableBuilder<T, ?>)new ResourceQuotaStatusBuilder((ResourceQuotaStatus) item);
    case "io.fabric8.kubernetes.api.model.runtime."+"RawExtension": return (VisitableBuilder<T, ?>)new RawExtensionBuilder((RawExtension) item);
    case "io.fabric8.kubernetes.api.model."+"ConfigMapProjection": return (VisitableBuilder<T, ?>)new ConfigMapProjectionBuilder((ConfigMapProjection) item);
    case "io.fabric8.kubernetes.api.model."+"ScopedResourceSelectorRequirement": return (VisitableBuilder<T, ?>)new ScopedResourceSelectorRequirementBuilder((ScopedResourceSelectorRequirement) item);
    case "io.fabric8.kubernetes.api.model."+"Namespace": return (VisitableBuilder<T, ?>)new NamespaceBuilder((Namespace) item);
    case "io.fabric8.kubernetes.api.model."+"GroupVersionKind": return (VisitableBuilder<T, ?>)new GroupVersionKindBuilder((GroupVersionKind) item);
    case "io.fabric8.kubernetes.api.model."+"ContainerStateTerminated": return (VisitableBuilder<T, ?>)new ContainerStateTerminatedBuilder((ContainerStateTerminated) item);
    case "io.fabric8.kubernetes.api.model."+"LimitRangeSpec": return (VisitableBuilder<T, ?>)new LimitRangeSpecBuilder((LimitRangeSpec) item);
    case "io.fabric8.kubernetes.api.model."+"ProjectedVolumeSource": return (VisitableBuilder<T, ?>)new ProjectedVolumeSourceBuilder((ProjectedVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"PodOS": return (VisitableBuilder<T, ?>)new PodOSBuilder((PodOS) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolumeClaimStatus": return (VisitableBuilder<T, ?>)new PersistentVolumeClaimStatusBuilder((PersistentVolumeClaimStatus) item);
    case "io.fabric8.kubernetes.api.model."+"ContainerState": return (VisitableBuilder<T, ?>)new ContainerStateBuilder((ContainerState) item);
    case "io.fabric8.kubernetes.api.model."+"ServiceSpec": return (VisitableBuilder<T, ?>)new ServiceSpecBuilder((ServiceSpec) item);
    case "io.fabric8.kubernetes.api.model."+"ServiceAccountTokenProjection": return (VisitableBuilder<T, ?>)new ServiceAccountTokenProjectionBuilder((ServiceAccountTokenProjection) item);
    case "io.fabric8.kubernetes.api.model."+"PhotonPersistentDiskVolumeSource": return (VisitableBuilder<T, ?>)new PhotonPersistentDiskVolumeSourceBuilder((PhotonPersistentDiskVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"Container": return (VisitableBuilder<T, ?>)new ContainerBuilder((Container) item);
    case "io.fabric8.kubernetes.api.model."+"NodeSpec": return (VisitableBuilder<T, ?>)new NodeSpecBuilder((NodeSpec) item);
    case "io.fabric8.kubernetes.api.model."+"TypedLocalObjectReference": return (VisitableBuilder<T, ?>)new TypedLocalObjectReferenceBuilder((TypedLocalObjectReference) item);
    case "io.fabric8.kubernetes.api.model."+"FieldsV1": return (VisitableBuilder<T, ?>)new FieldsV1Builder((FieldsV1) item);
    case "io.fabric8.kubernetes.api.model."+"SecretList": return (VisitableBuilder<T, ?>)new SecretListBuilder((SecretList) item);
    case "io.fabric8.kubernetes.api.model."+"NodeAddress": return (VisitableBuilder<T, ?>)new NodeAddressBuilder((NodeAddress) item);
    case "io.fabric8.kubernetes.api.model."+"PodAffinity": return (VisitableBuilder<T, ?>)new PodAffinityBuilder((PodAffinity) item);
    case "io.fabric8.kubernetes.api.model."+"ExecEnvVar": return (VisitableBuilder<T, ?>)new ExecEnvVarBuilder((ExecEnvVar) item);
    case "io.fabric8.kubernetes.api.model."+"Service": return (VisitableBuilder<T, ?>)new ServiceBuilder((Service) item);
    case "io.fabric8.kubernetes.api.model."+"EventSeries": return (VisitableBuilder<T, ?>)new EventSeriesBuilder((EventSeries) item);
    case "io.fabric8.kubernetes.api.model."+"PodCondition": return (VisitableBuilder<T, ?>)new PodConditionBuilder((PodCondition) item);
    case "io.fabric8.kubernetes.api.model."+"TopologySpreadConstraint": return (VisitableBuilder<T, ?>)new TopologySpreadConstraintBuilder((TopologySpreadConstraint) item);
    case "io.fabric8.kubernetes.api.model."+"ExecAction": return (VisitableBuilder<T, ?>)new ExecActionBuilder((ExecAction) item);
    case "io.fabric8.kubernetes.api.model."+"ContainerImage": return (VisitableBuilder<T, ?>)new ContainerImageBuilder((ContainerImage) item);
    case "io.fabric8.kubernetes.api.model."+"GroupKind": return (VisitableBuilder<T, ?>)new GroupKindBuilder((GroupKind) item);
    case "io.fabric8.kubernetes.api.model."+"ReplicationController": return (VisitableBuilder<T, ?>)new ReplicationControllerBuilder((ReplicationController) item);
    case "io.fabric8.kubernetes.api.model."+"NodeStatus": return (VisitableBuilder<T, ?>)new NodeStatusBuilder((NodeStatus) item);
    case "io.fabric8.kubernetes.api.model."+"ConfigMapList": return (VisitableBuilder<T, ?>)new ConfigMapListBuilder((ConfigMapList) item);
    case "io.fabric8.kubernetes.api.model."+"NodeSelector": return (VisitableBuilder<T, ?>)new NodeSelectorBuilder((NodeSelector) item);
    case "io.fabric8.kubernetes.api.model."+"Toleration": return (VisitableBuilder<T, ?>)new TolerationBuilder((Toleration) item);
    case "io.fabric8.kubernetes.api.model."+"CephFSPersistentVolumeSource": return (VisitableBuilder<T, ?>)new CephFSPersistentVolumeSourceBuilder((CephFSPersistentVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolumeClaimCondition": return (VisitableBuilder<T, ?>)new PersistentVolumeClaimConditionBuilder((PersistentVolumeClaimCondition) item);
    case "io.fabric8.kubernetes.api.model."+"PreferredSchedulingTerm": return (VisitableBuilder<T, ?>)new PreferredSchedulingTermBuilder((PreferredSchedulingTerm) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolumeList": return (VisitableBuilder<T, ?>)new PersistentVolumeListBuilder((PersistentVolumeList) item);
    case "io.fabric8.kubernetes.api.model."+"PodSchedulingGate": return (VisitableBuilder<T, ?>)new PodSchedulingGateBuilder((PodSchedulingGate) item);
    case "io.fabric8.kubernetes.api.model."+"PodDNSConfigOption": return (VisitableBuilder<T, ?>)new PodDNSConfigOptionBuilder((PodDNSConfigOption) item);
    case "io.fabric8.kubernetes.api.model."+"GCEPersistentDiskVolumeSource": return (VisitableBuilder<T, ?>)new GCEPersistentDiskVolumeSourceBuilder((GCEPersistentDiskVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"APIServiceCondition": return (VisitableBuilder<T, ?>)new APIServiceConditionBuilder((APIServiceCondition) item);
    case "io.fabric8.kubernetes.api.model."+"EventList": return (VisitableBuilder<T, ?>)new EventListBuilder((EventList) item);
    case "io.fabric8.kubernetes.api.model."+"PodReadinessGate": return (VisitableBuilder<T, ?>)new PodReadinessGateBuilder((PodReadinessGate) item);
    case "io.fabric8.kubernetes.api.model."+"ContainerStateWaiting": return (VisitableBuilder<T, ?>)new ContainerStateWaitingBuilder((ContainerStateWaiting) item);
    case "io.fabric8.kubernetes.api.model."+"VolumeMount": return (VisitableBuilder<T, ?>)new VolumeMountBuilder((VolumeMount) item);
    case "io.fabric8.kubernetes.api.model."+"NamespaceCondition": return (VisitableBuilder<T, ?>)new NamespaceConditionBuilder((NamespaceCondition) item);
    case "io.fabric8.kubernetes.api.model."+"LabelSelector": return (VisitableBuilder<T, ?>)new LabelSelectorBuilder((LabelSelector) item);
    case "io.fabric8.kubernetes.api.model."+"StatusCause": return (VisitableBuilder<T, ?>)new StatusCauseBuilder((StatusCause) item);
    case "io.fabric8.kubernetes.api.model."+"NamedCluster": return (VisitableBuilder<T, ?>)new NamedClusterBuilder((NamedCluster) item);
    case "io.fabric8.kubernetes.api.model."+"StatusDetails": return (VisitableBuilder<T, ?>)new StatusDetailsBuilder((StatusDetails) item);
    case "io.fabric8.kubernetes.api.model."+"DownwardAPIVolumeFile": return (VisitableBuilder<T, ?>)new DownwardAPIVolumeFileBuilder((DownwardAPIVolumeFile) item);
    case "io.fabric8.kubernetes.api.model."+"SeccompProfile": return (VisitableBuilder<T, ?>)new SeccompProfileBuilder((SeccompProfile) item);
    case "io.fabric8.kubernetes.api.model."+"Sysctl": return (VisitableBuilder<T, ?>)new SysctlBuilder((Sysctl) item);
    case "io.fabric8.kubernetes.api.model."+"DeleteOptions": return (VisitableBuilder<T, ?>)new DeleteOptionsBuilder((DeleteOptions) item);
    case "io.fabric8.kubernetes.api.model."+"Status": return (VisitableBuilder<T, ?>)new StatusBuilder((Status) item);
    case "io.fabric8.kubernetes.api.model."+"ContainerStatus": return (VisitableBuilder<T, ?>)new ContainerStatusBuilder((ContainerStatus) item);
    case "io.fabric8.kubernetes.api.model."+"PodTemplate": return (VisitableBuilder<T, ?>)new PodTemplateBuilder((PodTemplate) item);
    case "io.fabric8.kubernetes.api.model."+"ConfigMapEnvSource": return (VisitableBuilder<T, ?>)new ConfigMapEnvSourceBuilder((ConfigMapEnvSource) item);
    case "io.fabric8.kubernetes.api.model."+"NodeSelectorRequirement": return (VisitableBuilder<T, ?>)new NodeSelectorRequirementBuilder((NodeSelectorRequirement) item);
    case "io.fabric8.kubernetes.api.model."+"TCPSocketAction": return (VisitableBuilder<T, ?>)new TCPSocketActionBuilder((TCPSocketAction) item);
    case "io.fabric8.kubernetes.api.model."+"Event": return (VisitableBuilder<T, ?>)new EventBuilder((Event) item);
    case "io.fabric8.kubernetes.api.model."+"Preferences": return (VisitableBuilder<T, ?>)new PreferencesBuilder((Preferences) item);
    case "io.fabric8.kubernetes.api.model."+"ObjectFieldSelector": return (VisitableBuilder<T, ?>)new ObjectFieldSelectorBuilder((ObjectFieldSelector) item);
    case "io.fabric8.kubernetes.api.model."+"PodTemplateList": return (VisitableBuilder<T, ?>)new PodTemplateListBuilder((PodTemplateList) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolume": return (VisitableBuilder<T, ?>)new PersistentVolumeBuilder((PersistentVolume) item);
    case "io.fabric8.kubernetes.api.model."+"CinderVolumeSource": return (VisitableBuilder<T, ?>)new CinderVolumeSourceBuilder((CinderVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"EndpointAddress": return (VisitableBuilder<T, ?>)new EndpointAddressBuilder((EndpointAddress) item);
    case "io.fabric8.kubernetes.api.model."+"NodeConfigSource": return (VisitableBuilder<T, ?>)new NodeConfigSourceBuilder((NodeConfigSource) item);
    case "io.fabric8.kubernetes.api.model."+"VsphereVirtualDiskVolumeSource": return (VisitableBuilder<T, ?>)new VsphereVirtualDiskVolumeSourceBuilder((VsphereVirtualDiskVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"ObjectMeta": return (VisitableBuilder<T, ?>)new ObjectMetaBuilder((ObjectMeta) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolumeClaim": return (VisitableBuilder<T, ?>)new PersistentVolumeClaimBuilder((PersistentVolumeClaim) item);
    case "io.fabric8.kubernetes.api.model."+"LabelSelectorRequirement": return (VisitableBuilder<T, ?>)new LabelSelectorRequirementBuilder((LabelSelectorRequirement) item);
    case "io.fabric8.kubernetes.api.model."+"GitRepoVolumeSource": return (VisitableBuilder<T, ?>)new GitRepoVolumeSourceBuilder((GitRepoVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"GenericKubernetesResource": return (VisitableBuilder<T, ?>)new GenericKubernetesResourceBuilder((GenericKubernetesResource) item);
    case "io.fabric8.kubernetes.api.model."+"EndpointsList": return (VisitableBuilder<T, ?>)new EndpointsListBuilder((EndpointsList) item);
    case "io.fabric8.kubernetes.api.model."+"GroupVersionResource": return (VisitableBuilder<T, ?>)new GroupVersionResourceBuilder((GroupVersionResource) item);
    case "io.fabric8.kubernetes.api.model."+"CinderPersistentVolumeSource": return (VisitableBuilder<T, ?>)new CinderPersistentVolumeSourceBuilder((CinderPersistentVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"TopologySelectorTerm": return (VisitableBuilder<T, ?>)new TopologySelectorTermBuilder((TopologySelectorTerm) item);
    case "io.fabric8.kubernetes.api.model."+"OwnerReference": return (VisitableBuilder<T, ?>)new OwnerReferenceBuilder((OwnerReference) item);
    case "io.fabric8.kubernetes.api.model."+"StorageOSPersistentVolumeSource": return (VisitableBuilder<T, ?>)new StorageOSPersistentVolumeSourceBuilder((StorageOSPersistentVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"EphemeralVolumeSource": return (VisitableBuilder<T, ?>)new EphemeralVolumeSourceBuilder((EphemeralVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"ReplicationControllerCondition": return (VisitableBuilder<T, ?>)new ReplicationControllerConditionBuilder((ReplicationControllerCondition) item);
    case "io.fabric8.kubernetes.api.model."+"PodAntiAffinity": return (VisitableBuilder<T, ?>)new PodAntiAffinityBuilder((PodAntiAffinity) item);
    case "io.fabric8.kubernetes.api.model."+"SecurityContext": return (VisitableBuilder<T, ?>)new SecurityContextBuilder((SecurityContext) item);
    case "io.fabric8.kubernetes.api.model."+"ReplicationControllerList": return (VisitableBuilder<T, ?>)new ReplicationControllerListBuilder((ReplicationControllerList) item);
    case "io.fabric8.kubernetes.api.model."+"ConfigMapVolumeSource": return (VisitableBuilder<T, ?>)new ConfigMapVolumeSourceBuilder((ConfigMapVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"ContainerStateRunning": return (VisitableBuilder<T, ?>)new ContainerStateRunningBuilder((ContainerStateRunning) item);
    case "io.fabric8.kubernetes.api.model."+"ComponentStatusList": return (VisitableBuilder<T, ?>)new ComponentStatusListBuilder((ComponentStatusList) item);
    case "io.fabric8.kubernetes.api.model."+"FlockerVolumeSource": return (VisitableBuilder<T, ?>)new FlockerVolumeSourceBuilder((FlockerVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"ScaleIOVolumeSource": return (VisitableBuilder<T, ?>)new ScaleIOVolumeSourceBuilder((ScaleIOVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"LimitRangeList": return (VisitableBuilder<T, ?>)new LimitRangeListBuilder((LimitRangeList) item);
    case "io.fabric8.kubernetes.api.model."+"PodExecOptions": return (VisitableBuilder<T, ?>)new PodExecOptionsBuilder((PodExecOptions) item);
    case "io.fabric8.kubernetes.api.model."+"Probe": return (VisitableBuilder<T, ?>)new ProbeBuilder((Probe) item);
    case "io.fabric8.kubernetes.api.model."+"UpdateOptions": return (VisitableBuilder<T, ?>)new UpdateOptionsBuilder((UpdateOptions) item);
    case "io.fabric8.kubernetes.api.model."+"Endpoints": return (VisitableBuilder<T, ?>)new EndpointsBuilder((Endpoints) item);
    case "io.fabric8.kubernetes.api.model."+"NamedExtension": return (VisitableBuilder<T, ?>)new NamedExtensionBuilder((NamedExtension) item);
    case "io.fabric8.kubernetes.api.model."+"AzureFilePersistentVolumeSource": return (VisitableBuilder<T, ?>)new AzureFilePersistentVolumeSourceBuilder((AzureFilePersistentVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"APIResourceList": return (VisitableBuilder<T, ?>)new APIResourceListBuilder((APIResourceList) item);
    case "io.fabric8.kubernetes.api.model."+"APIServiceList": return (VisitableBuilder<T, ?>)new APIServiceListBuilder((APIServiceList) item);
    case "io.fabric8.kubernetes.api.model."+"SecretVolumeSource": return (VisitableBuilder<T, ?>)new SecretVolumeSourceBuilder((SecretVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"Pod": return (VisitableBuilder<T, ?>)new PodBuilder((Pod) item);
    case "io.fabric8.kubernetes.api.model."+"ClientIPConfig": return (VisitableBuilder<T, ?>)new ClientIPConfigBuilder((ClientIPConfig) item);
    case "io.fabric8.kubernetes.api.model."+"Context": return (VisitableBuilder<T, ?>)new ContextBuilder((Context) item);
    case "io.fabric8.kubernetes.api.model."+"NodeAffinity": return (VisitableBuilder<T, ?>)new NodeAffinityBuilder((NodeAffinity) item);
    case "io.fabric8.kubernetes.api.model."+"ConfigMap": return (VisitableBuilder<T, ?>)new ConfigMapBuilder((ConfigMap) item);
    case "io.fabric8.kubernetes.api.model."+"ContainerPort": return (VisitableBuilder<T, ?>)new ContainerPortBuilder((ContainerPort) item);
    case "io.fabric8.kubernetes.api.model."+"Condition": return (VisitableBuilder<T, ?>)new ConditionBuilder((Condition) item);
    case "io.fabric8.kubernetes.api.model."+"PodList": return (VisitableBuilder<T, ?>)new PodListBuilder((PodList) item);
    case "io.fabric8.kubernetes.api.model."+"FCVolumeSource": return (VisitableBuilder<T, ?>)new FCVolumeSourceBuilder((FCVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"ResourceFieldSelector": return (VisitableBuilder<T, ?>)new ResourceFieldSelectorBuilder((ResourceFieldSelector) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolumeClaimSpec": return (VisitableBuilder<T, ?>)new PersistentVolumeClaimSpecBuilder((PersistentVolumeClaimSpec) item);
    case "io.fabric8.kubernetes.api.model."+"LoadBalancerStatus": return (VisitableBuilder<T, ?>)new LoadBalancerStatusBuilder((LoadBalancerStatus) item);
    case "io.fabric8.kubernetes.api.model."+"PodSecurityContext": return (VisitableBuilder<T, ?>)new PodSecurityContextBuilder((PodSecurityContext) item);
    case "io.fabric8.kubernetes.api.model."+"ScopeSelector": return (VisitableBuilder<T, ?>)new ScopeSelectorBuilder((ScopeSelector) item);
    case "io.fabric8.kubernetes.api.model."+"DownwardAPIProjection": return (VisitableBuilder<T, ?>)new DownwardAPIProjectionBuilder((DownwardAPIProjection) item);
    case "io.fabric8.kubernetes.api.model."+"PodAffinityTerm": return (VisitableBuilder<T, ?>)new PodAffinityTermBuilder((PodAffinityTerm) item);
    case "io.fabric8.kubernetes.api.model."+"APIServiceSpec": return (VisitableBuilder<T, ?>)new APIServiceSpecBuilder((APIServiceSpec) item);
    case "io.fabric8.kubernetes.api.model."+"ServicePort": return (VisitableBuilder<T, ?>)new ServicePortBuilder((ServicePort) item);
    case "io.fabric8.kubernetes.api.model."+"GroupVersionForDiscovery": return (VisitableBuilder<T, ?>)new GroupVersionForDiscoveryBuilder((GroupVersionForDiscovery) item);
    case "io.fabric8.kubernetes.api.model."+"ClaimSource": return (VisitableBuilder<T, ?>)new ClaimSourceBuilder((ClaimSource) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolumeClaimVolumeSource": return (VisitableBuilder<T, ?>)new PersistentVolumeClaimVolumeSourceBuilder((PersistentVolumeClaimVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"SessionAffinityConfig": return (VisitableBuilder<T, ?>)new SessionAffinityConfigBuilder((SessionAffinityConfig) item);
    case "io.fabric8.kubernetes.api.model."+"ServiceAccountList": return (VisitableBuilder<T, ?>)new ServiceAccountListBuilder((ServiceAccountList) item);
    case "io.fabric8.kubernetes.api.model."+"ComponentStatus": return (VisitableBuilder<T, ?>)new ComponentStatusBuilder((ComponentStatus) item);
    case "io.fabric8.kubernetes.api.model."+"DaemonEndpoint": return (VisitableBuilder<T, ?>)new DaemonEndpointBuilder((DaemonEndpoint) item);
    case "io.fabric8.kubernetes.api.model."+"KeyToPath": return (VisitableBuilder<T, ?>)new KeyToPathBuilder((KeyToPath) item);
    case "io.fabric8.kubernetes.api.model."+"FlexPersistentVolumeSource": return (VisitableBuilder<T, ?>)new FlexPersistentVolumeSourceBuilder((FlexPersistentVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"NamespaceList": return (VisitableBuilder<T, ?>)new NamespaceListBuilder((NamespaceList) item);
    case "io.fabric8.kubernetes.api.model."+"PodDNSConfig": return (VisitableBuilder<T, ?>)new PodDNSConfigBuilder((PodDNSConfig) item);
    case "io.fabric8.kubernetes.api.model."+"NodeList": return (VisitableBuilder<T, ?>)new NodeListBuilder((NodeList) item);
    case "io.fabric8.kubernetes.api.model."+"Binding": return (VisitableBuilder<T, ?>)new BindingBuilder((Binding) item);
    case "io.fabric8.kubernetes.api.model."+"EnvVarSource": return (VisitableBuilder<T, ?>)new EnvVarSourceBuilder((EnvVarSource) item);
    case "io.fabric8.kubernetes.api.model."+"VolumeProjection": return (VisitableBuilder<T, ?>)new VolumeProjectionBuilder((VolumeProjection) item);
    case "io.fabric8.kubernetes.api.model."+"ResourceQuota": return (VisitableBuilder<T, ?>)new ResourceQuotaBuilder((ResourceQuota) item);
    case "io.fabric8.kubernetes.api.model."+"Secret": return (VisitableBuilder<T, ?>)new SecretBuilder((Secret) item);
    case "io.fabric8.kubernetes.api.model."+"ServiceList": return (VisitableBuilder<T, ?>)new ServiceListBuilder((ServiceList) item);
    case "io.fabric8.kubernetes.api.model."+"VolumeNodeAffinity": return (VisitableBuilder<T, ?>)new VolumeNodeAffinityBuilder((VolumeNodeAffinity) item);
    case "io.fabric8.kubernetes.api.model."+"ResourceQuotaSpec": return (VisitableBuilder<T, ?>)new ResourceQuotaSpecBuilder((ResourceQuotaSpec) item);
    case "io.fabric8.kubernetes.api.model."+"NodeSelectorTerm": return (VisitableBuilder<T, ?>)new NodeSelectorTermBuilder((NodeSelectorTerm) item);
    case "io.fabric8.kubernetes.api.model."+"ScaleIOPersistentVolumeSource": return (VisitableBuilder<T, ?>)new ScaleIOPersistentVolumeSourceBuilder((ScaleIOPersistentVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"ListOptions": return (VisitableBuilder<T, ?>)new ListOptionsBuilder((ListOptions) item);
    case "io.fabric8.kubernetes.api.model."+"WeightedPodAffinityTerm": return (VisitableBuilder<T, ?>)new WeightedPodAffinityTermBuilder((WeightedPodAffinityTerm) item);
    case "io.fabric8.kubernetes.api.model."+"TypedObjectReference": return (VisitableBuilder<T, ?>)new TypedObjectReferenceBuilder((TypedObjectReference) item);
    case "io.fabric8.kubernetes.api.model."+"ContainerResizePolicy": return (VisitableBuilder<T, ?>)new ContainerResizePolicyBuilder((ContainerResizePolicy) item);
    case "io.fabric8.kubernetes.api.model."+"NodeSystemInfo": return (VisitableBuilder<T, ?>)new NodeSystemInfoBuilder((NodeSystemInfo) item);
    case "io.fabric8.kubernetes.api.model."+"TopologySelectorLabelRequirement": return (VisitableBuilder<T, ?>)new TopologySelectorLabelRequirementBuilder((TopologySelectorLabelRequirement) item);
    case "io.fabric8.kubernetes.api.model."+"RBDPersistentVolumeSource": return (VisitableBuilder<T, ?>)new RBDPersistentVolumeSourceBuilder((RBDPersistentVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"AuthProviderConfig": return (VisitableBuilder<T, ?>)new AuthProviderConfigBuilder((AuthProviderConfig) item);
    case "io.fabric8.kubernetes.api.model."+"SELinuxOptions": return (VisitableBuilder<T, ?>)new SELinuxOptionsBuilder((SELinuxOptions) item);
    case "io.fabric8.kubernetes.api.model."+"HostAlias": return (VisitableBuilder<T, ?>)new HostAliasBuilder((HostAlias) item);
    case "io.fabric8.kubernetes.api.model."+"NodeDaemonEndpoints": return (VisitableBuilder<T, ?>)new NodeDaemonEndpointsBuilder((NodeDaemonEndpoints) item);
    case "io.fabric8.kubernetes.api.model."+"VolumeDevice": return (VisitableBuilder<T, ?>)new VolumeDeviceBuilder((VolumeDevice) item);
    case "io.fabric8.kubernetes.api.model."+"CSIVolumeSource": return (VisitableBuilder<T, ?>)new CSIVolumeSourceBuilder((CSIVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolumeSpec": return (VisitableBuilder<T, ?>)new PersistentVolumeSpecBuilder((PersistentVolumeSpec) item);
    case "io.fabric8.kubernetes.api.model."+"Node": return (VisitableBuilder<T, ?>)new NodeBuilder((Node) item);
    case "io.fabric8.kubernetes.api.model."+"LifecycleHandler": return (VisitableBuilder<T, ?>)new LifecycleHandlerBuilder((LifecycleHandler) item);
    case "io.fabric8.kubernetes.api.model."+"Volume": return (VisitableBuilder<T, ?>)new VolumeBuilder((Volume) item);
    case "io.fabric8.kubernetes.api.model."+"Cluster": return (VisitableBuilder<T, ?>)new ClusterBuilder((Cluster) item);
    case "io.fabric8.kubernetes.api.model."+"NFSVolumeSource": return (VisitableBuilder<T, ?>)new NFSVolumeSourceBuilder((NFSVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"StorageOSVolumeSource": return (VisitableBuilder<T, ?>)new StorageOSVolumeSourceBuilder((StorageOSVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"PodStatus": return (VisitableBuilder<T, ?>)new PodStatusBuilder((PodStatus) item);
    case "io.fabric8.kubernetes.api.model."+"KubernetesList": return (VisitableBuilder<T, ?>)new KubernetesListBuilder((KubernetesList) item);
    case "io.fabric8.kubernetes.api.model."+"ExecConfig": return (VisitableBuilder<T, ?>)new ExecConfigBuilder((ExecConfig) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolumeStatus": return (VisitableBuilder<T, ?>)new PersistentVolumeStatusBuilder((PersistentVolumeStatus) item);
    case "io.fabric8.kubernetes.api.model."+"EndpointPort": return (VisitableBuilder<T, ?>)new EndpointPortBuilder((EndpointPort) item);
    case "io.fabric8.kubernetes.api.model."+"HTTPHeader": return (VisitableBuilder<T, ?>)new HTTPHeaderBuilder((HTTPHeader) item);
    case "io.fabric8.kubernetes.api.model."+"Capabilities": return (VisitableBuilder<T, ?>)new CapabilitiesBuilder((Capabilities) item);
    case "io.fabric8.kubernetes.api.model."+"ObjectReference": return (VisitableBuilder<T, ?>)new ObjectReferenceBuilder((ObjectReference) item);
    case "io.fabric8.kubernetes.api.model."+"WatchEvent": return (VisitableBuilder<T, ?>)new WatchEventBuilder((WatchEvent) item);
    case "io.fabric8.kubernetes.api.model."+"LimitRangeItem": return (VisitableBuilder<T, ?>)new LimitRangeItemBuilder((LimitRangeItem) item);
    case "io.fabric8.kubernetes.api.model."+"SecretProjection": return (VisitableBuilder<T, ?>)new SecretProjectionBuilder((SecretProjection) item);
    case "io.fabric8.kubernetes.api.model."+"GetOptions": return (VisitableBuilder<T, ?>)new GetOptionsBuilder((GetOptions) item);
    case "io.fabric8.kubernetes.api.model."+"GlusterfsVolumeSource": return (VisitableBuilder<T, ?>)new GlusterfsVolumeSourceBuilder((GlusterfsVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"ManagedFieldsEntry": return (VisitableBuilder<T, ?>)new ManagedFieldsEntryBuilder((ManagedFieldsEntry) item);
    case "io.fabric8.kubernetes.api.model."+"NamespaceStatus": return (VisitableBuilder<T, ?>)new NamespaceStatusBuilder((NamespaceStatus) item);
    case "io.fabric8.kubernetes.api.model."+"SecretEnvSource": return (VisitableBuilder<T, ?>)new SecretEnvSourceBuilder((SecretEnvSource) item);
    case "io.fabric8.kubernetes.api.model."+"ServiceAccount": return (VisitableBuilder<T, ?>)new ServiceAccountBuilder((ServiceAccount) item);
    case "io.fabric8.kubernetes.api.model."+"AWSElasticBlockStoreVolumeSource": return (VisitableBuilder<T, ?>)new AWSElasticBlockStoreVolumeSourceBuilder((AWSElasticBlockStoreVolumeSource) item);
    case "io.fabric8.kubernetes.api.model."+"PodIP": return (VisitableBuilder<T, ?>)new PodIPBuilder((PodIP) item);
    }
 return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class PatchExtensionNested<N> extends PatchFluent<PatchExtensionNested<N>> implements Nested<N>{
    PatchExtensionNested(Patch item) {
      this.builder = new PatchBuilder(this, item);
    }
    PatchBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPatchExtension() {
      return and();
    }
    
  }
  public class LimitRangeExtensionNested<N> extends LimitRangeFluent<LimitRangeExtensionNested<N>> implements Nested<N>{
    LimitRangeExtensionNested(LimitRange item) {
      this.builder = new LimitRangeBuilder(this, item);
    }
    LimitRangeBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endLimitRangeExtension() {
      return and();
    }
    
  }
  public class APIGroupListExtensionNested<N> extends APIGroupListFluent<APIGroupListExtensionNested<N>> implements Nested<N>{
    APIGroupListExtensionNested(APIGroupList item) {
      this.builder = new APIGroupListBuilder(this, item);
    }
    APIGroupListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endAPIGroupListExtension() {
      return and();
    }
    
  }
  public class PortStatusExtensionNested<N> extends PortStatusFluent<PortStatusExtensionNested<N>> implements Nested<N>{
    PortStatusExtensionNested(PortStatus item) {
      this.builder = new PortStatusBuilder(this, item);
    }
    PortStatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPortStatusExtension() {
      return and();
    }
    
  }
  public class PodTemplateSpecExtensionNested<N> extends PodTemplateSpecFluent<PodTemplateSpecExtensionNested<N>> implements Nested<N>{
    PodTemplateSpecExtensionNested(PodTemplateSpec item) {
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    PodTemplateSpecBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPodTemplateSpecExtension() {
      return and();
    }
    
  }
  public class CSIPersistentVolumeSourceExtensionNested<N> extends CSIPersistentVolumeSourceFluent<CSIPersistentVolumeSourceExtensionNested<N>> implements Nested<N>{
    CSIPersistentVolumeSourceExtensionNested(CSIPersistentVolumeSource item) {
      this.builder = new CSIPersistentVolumeSourceBuilder(this, item);
    }
    CSIPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endCSIPersistentVolumeSourceExtension() {
      return and();
    }
    
  }
  public class AuthInfoExtensionNested<N> extends AuthInfoFluent<AuthInfoExtensionNested<N>> implements Nested<N>{
    AuthInfoExtensionNested(AuthInfo item) {
      this.builder = new AuthInfoBuilder(this, item);
    }
    AuthInfoBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endAuthInfoExtension() {
      return and();
    }
    
  }
  public class APIServiceExtensionNested<N> extends APIServiceFluent<APIServiceExtensionNested<N>> implements Nested<N>{
    APIServiceExtensionNested(APIService item) {
      this.builder = new APIServiceBuilder(this, item);
    }
    APIServiceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endAPIServiceExtension() {
      return and();
    }
    
  }
  public class ResourceRequirementsExtensionNested<N> extends ResourceRequirementsFluent<ResourceRequirementsExtensionNested<N>> implements Nested<N>{
    ResourceRequirementsExtensionNested(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endResourceRequirementsExtension() {
      return and();
    }
    
  }
  public class ConfigMapKeySelectorExtensionNested<N> extends ConfigMapKeySelectorFluent<ConfigMapKeySelectorExtensionNested<N>> implements Nested<N>{
    ConfigMapKeySelectorExtensionNested(ConfigMapKeySelector item) {
      this.builder = new ConfigMapKeySelectorBuilder(this, item);
    }
    ConfigMapKeySelectorBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endConfigMapKeySelectorExtension() {
      return and();
    }
    
  }
  public class HostPathVolumeSourceExtensionNested<N> extends HostPathVolumeSourceFluent<HostPathVolumeSourceExtensionNested<N>> implements Nested<N>{
    HostPathVolumeSourceExtensionNested(HostPathVolumeSource item) {
      this.builder = new HostPathVolumeSourceBuilder(this, item);
    }
    HostPathVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endHostPathVolumeSourceExtension() {
      return and();
    }
    
  }
  public class PersistentVolumeClaimListExtensionNested<N> extends PersistentVolumeClaimListFluent<PersistentVolumeClaimListExtensionNested<N>> implements Nested<N>{
    PersistentVolumeClaimListExtensionNested(PersistentVolumeClaimList item) {
      this.builder = new PersistentVolumeClaimListBuilder(this, item);
    }
    PersistentVolumeClaimListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPersistentVolumeClaimListExtension() {
      return and();
    }
    
  }
  public class NamedContextExtensionNested<N> extends NamedContextFluent<NamedContextExtensionNested<N>> implements Nested<N>{
    NamedContextExtensionNested(NamedContext item) {
      this.builder = new NamedContextBuilder(this, item);
    }
    NamedContextBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endNamedContextExtension() {
      return and();
    }
    
  }
  public class ConfigExtensionNested<N> extends ConfigFluent<ConfigExtensionNested<N>> implements Nested<N>{
    ConfigExtensionNested(Config item) {
      this.builder = new ConfigBuilder(this, item);
    }
    ConfigBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endConfigExtension() {
      return and();
    }
    
  }
  public class AffinityExtensionNested<N> extends AffinityFluent<AffinityExtensionNested<N>> implements Nested<N>{
    AffinityExtensionNested(Affinity item) {
      this.builder = new AffinityBuilder(this, item);
    }
    AffinityBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endAffinityExtension() {
      return and();
    }
    
  }
  public class PodResourceClaimExtensionNested<N> extends PodResourceClaimFluent<PodResourceClaimExtensionNested<N>> implements Nested<N>{
    PodResourceClaimExtensionNested(PodResourceClaim item) {
      this.builder = new PodResourceClaimBuilder(this, item);
    }
    PodResourceClaimBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPodResourceClaimExtension() {
      return and();
    }
    
  }
  public class ReplicationControllerStatusExtensionNested<N> extends ReplicationControllerStatusFluent<ReplicationControllerStatusExtensionNested<N>> implements Nested<N>{
    ReplicationControllerStatusExtensionNested(ReplicationControllerStatus item) {
      this.builder = new ReplicationControllerStatusBuilder(this, item);
    }
    ReplicationControllerStatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endReplicationControllerStatusExtension() {
      return and();
    }
    
  }
  public class APIServiceStatusExtensionNested<N> extends APIServiceStatusFluent<APIServiceStatusExtensionNested<N>> implements Nested<N>{
    APIServiceStatusExtensionNested(APIServiceStatus item) {
      this.builder = new APIServiceStatusBuilder(this, item);
    }
    APIServiceStatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endAPIServiceStatusExtension() {
      return and();
    }
    
  }
  public class MicroTimeExtensionNested<N> extends MicroTimeFluent<MicroTimeExtensionNested<N>> implements Nested<N>{
    MicroTimeExtensionNested(MicroTime item) {
      this.builder = new MicroTimeBuilder(this, item);
    }
    MicroTimeBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endMicroTimeExtension() {
      return and();
    }
    
  }
  public class LifecycleExtensionNested<N> extends LifecycleFluent<LifecycleExtensionNested<N>> implements Nested<N>{
    LifecycleExtensionNested(Lifecycle item) {
      this.builder = new LifecycleBuilder(this, item);
    }
    LifecycleBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endLifecycleExtension() {
      return and();
    }
    
  }
  public class PortworxVolumeSourceExtensionNested<N> extends PortworxVolumeSourceFluent<PortworxVolumeSourceExtensionNested<N>> implements Nested<N>{
    PortworxVolumeSourceExtensionNested(PortworxVolumeSource item) {
      this.builder = new PortworxVolumeSourceBuilder(this, item);
    }
    PortworxVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPortworxVolumeSourceExtension() {
      return and();
    }
    
  }
  public class EventSourceExtensionNested<N> extends EventSourceFluent<EventSourceExtensionNested<N>> implements Nested<N>{
    EventSourceExtensionNested(EventSource item) {
      this.builder = new EventSourceBuilder(this, item);
    }
    EventSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endEventSourceExtension() {
      return and();
    }
    
  }
  public class GRPCActionExtensionNested<N> extends GRPCActionFluent<GRPCActionExtensionNested<N>> implements Nested<N>{
    GRPCActionExtensionNested(GRPCAction item) {
      this.builder = new GRPCActionBuilder(this, item);
    }
    GRPCActionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endGRPCActionExtension() {
      return and();
    }
    
  }
  public class AzureFileVolumeSourceExtensionNested<N> extends AzureFileVolumeSourceFluent<AzureFileVolumeSourceExtensionNested<N>> implements Nested<N>{
    AzureFileVolumeSourceExtensionNested(AzureFileVolumeSource item) {
      this.builder = new AzureFileVolumeSourceBuilder(this, item);
    }
    AzureFileVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endAzureFileVolumeSourceExtension() {
      return and();
    }
    
  }
  public class ResourceClaimExtensionNested<N> extends ResourceClaimFluent<ResourceClaimExtensionNested<N>> implements Nested<N>{
    ResourceClaimExtensionNested(ResourceClaim item) {
      this.builder = new ResourceClaimBuilder(this, item);
    }
    ResourceClaimBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endResourceClaimExtension() {
      return and();
    }
    
  }
  public class ComponentConditionExtensionNested<N> extends ComponentConditionFluent<ComponentConditionExtensionNested<N>> implements Nested<N>{
    ComponentConditionExtensionNested(ComponentCondition item) {
      this.builder = new ComponentConditionBuilder(this, item);
    }
    ComponentConditionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endComponentConditionExtension() {
      return and();
    }
    
  }
  public class EnvVarExtensionNested<N> extends EnvVarFluent<EnvVarExtensionNested<N>> implements Nested<N>{
    EnvVarExtensionNested(EnvVar item) {
      this.builder = new EnvVarBuilder(this, item);
    }
    EnvVarBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endEnvVarExtension() {
      return and();
    }
    
  }
  public class ReplicationControllerSpecExtensionNested<N> extends ReplicationControllerSpecFluent<ReplicationControllerSpecExtensionNested<N>> implements Nested<N>{
    ReplicationControllerSpecExtensionNested(ReplicationControllerSpec item) {
      this.builder = new ReplicationControllerSpecBuilder(this, item);
    }
    ReplicationControllerSpecBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endReplicationControllerSpecExtension() {
      return and();
    }
    
  }
  public class LoadBalancerIngressExtensionNested<N> extends LoadBalancerIngressFluent<LoadBalancerIngressExtensionNested<N>> implements Nested<N>{
    LoadBalancerIngressExtensionNested(LoadBalancerIngress item) {
      this.builder = new LoadBalancerIngressBuilder(this, item);
    }
    LoadBalancerIngressBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endLoadBalancerIngressExtension() {
      return and();
    }
    
  }
  public class AttachedVolumeExtensionNested<N> extends AttachedVolumeFluent<AttachedVolumeExtensionNested<N>> implements Nested<N>{
    AttachedVolumeExtensionNested(AttachedVolume item) {
      this.builder = new AttachedVolumeBuilder(this, item);
    }
    AttachedVolumeBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endAttachedVolumeExtension() {
      return and();
    }
    
  }
  public class LocalObjectReferenceExtensionNested<N> extends LocalObjectReferenceFluent<LocalObjectReferenceExtensionNested<N>> implements Nested<N>{
    LocalObjectReferenceExtensionNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endLocalObjectReferenceExtension() {
      return and();
    }
    
  }
  public class NamedAuthInfoExtensionNested<N> extends NamedAuthInfoFluent<NamedAuthInfoExtensionNested<N>> implements Nested<N>{
    NamedAuthInfoExtensionNested(NamedAuthInfo item) {
      this.builder = new NamedAuthInfoBuilder(this, item);
    }
    NamedAuthInfoBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endNamedAuthInfoExtension() {
      return and();
    }
    
  }
  public class EmptyDirVolumeSourceExtensionNested<N> extends EmptyDirVolumeSourceFluent<EmptyDirVolumeSourceExtensionNested<N>> implements Nested<N>{
    EmptyDirVolumeSourceExtensionNested(EmptyDirVolumeSource item) {
      this.builder = new EmptyDirVolumeSourceBuilder(this, item);
    }
    EmptyDirVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endEmptyDirVolumeSourceExtension() {
      return and();
    }
    
  }
  public class PodSpecExtensionNested<N> extends PodSpecFluent<PodSpecExtensionNested<N>> implements Nested<N>{
    PodSpecExtensionNested(PodSpec item) {
      this.builder = new PodSpecBuilder(this, item);
    }
    PodSpecBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPodSpecExtension() {
      return and();
    }
    
  }
  public class ServerAddressByClientCIDRExtensionNested<N> extends ServerAddressByClientCIDRFluent<ServerAddressByClientCIDRExtensionNested<N>> implements Nested<N>{
    ServerAddressByClientCIDRExtensionNested(ServerAddressByClientCIDR item) {
      this.builder = new ServerAddressByClientCIDRBuilder(this, item);
    }
    ServerAddressByClientCIDRBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endServerAddressByClientCIDRExtension() {
      return and();
    }
    
  }
  public class AzureDiskVolumeSourceExtensionNested<N> extends AzureDiskVolumeSourceFluent<AzureDiskVolumeSourceExtensionNested<N>> implements Nested<N>{
    AzureDiskVolumeSourceExtensionNested(AzureDiskVolumeSource item) {
      this.builder = new AzureDiskVolumeSourceBuilder(this, item);
    }
    AzureDiskVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endAzureDiskVolumeSourceExtension() {
      return and();
    }
    
  }
  public class PreconditionsExtensionNested<N> extends PreconditionsFluent<PreconditionsExtensionNested<N>> implements Nested<N>{
    PreconditionsExtensionNested(Preconditions item) {
      this.builder = new PreconditionsBuilder(this, item);
    }
    PreconditionsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPreconditionsExtension() {
      return and();
    }
    
  }
  public class InfoExtensionNested<N> extends InfoFluent<InfoExtensionNested<N>> implements Nested<N>{
    InfoExtensionNested(Info item) {
      this.builder = new InfoBuilder(this, item);
    }
    InfoBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endInfoExtension() {
      return and();
    }
    
  }
  public class CephFSVolumeSourceExtensionNested<N> extends CephFSVolumeSourceFluent<CephFSVolumeSourceExtensionNested<N>> implements Nested<N>{
    CephFSVolumeSourceExtensionNested(CephFSVolumeSource item) {
      this.builder = new CephFSVolumeSourceBuilder(this, item);
    }
    CephFSVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endCephFSVolumeSourceExtension() {
      return and();
    }
    
  }
  public class EphemeralContainerExtensionNested<N> extends EphemeralContainerFluent<EphemeralContainerExtensionNested<N>> implements Nested<N>{
    EphemeralContainerExtensionNested(EphemeralContainer item) {
      this.builder = new EphemeralContainerBuilder(this, item);
    }
    EphemeralContainerBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endEphemeralContainerExtension() {
      return and();
    }
    
  }
  public class NodeConditionExtensionNested<N> extends NodeConditionFluent<NodeConditionExtensionNested<N>> implements Nested<N>{
    NodeConditionExtensionNested(NodeCondition item) {
      this.builder = new NodeConditionBuilder(this, item);
    }
    NodeConditionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endNodeConditionExtension() {
      return and();
    }
    
  }
  public class EndpointSubsetExtensionNested<N> extends EndpointSubsetFluent<EndpointSubsetExtensionNested<N>> implements Nested<N>{
    EndpointSubsetExtensionNested(EndpointSubset item) {
      this.builder = new EndpointSubsetBuilder(this, item);
    }
    EndpointSubsetBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endEndpointSubsetExtension() {
      return and();
    }
    
  }
  public class LocalVolumeSourceExtensionNested<N> extends LocalVolumeSourceFluent<LocalVolumeSourceExtensionNested<N>> implements Nested<N>{
    LocalVolumeSourceExtensionNested(LocalVolumeSource item) {
      this.builder = new LocalVolumeSourceBuilder(this, item);
    }
    LocalVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endLocalVolumeSourceExtension() {
      return and();
    }
    
  }
  public class ServiceReferenceExtensionNested<N> extends ServiceReferenceFluent<ServiceReferenceExtensionNested<N>> implements Nested<N>{
    ServiceReferenceExtensionNested(ServiceReference item) {
      this.builder = new ServiceReferenceBuilder(this, item);
    }
    ServiceReferenceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endServiceReferenceExtension() {
      return and();
    }
    
  }
  public class ServiceStatusExtensionNested<N> extends ServiceStatusFluent<ServiceStatusExtensionNested<N>> implements Nested<N>{
    ServiceStatusExtensionNested(ServiceStatus item) {
      this.builder = new ServiceStatusBuilder(this, item);
    }
    ServiceStatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endServiceStatusExtension() {
      return and();
    }
    
  }
  public class TaintExtensionNested<N> extends TaintFluent<TaintExtensionNested<N>> implements Nested<N>{
    TaintExtensionNested(Taint item) {
      this.builder = new TaintBuilder(this, item);
    }
    TaintBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endTaintExtension() {
      return and();
    }
    
  }
  public class PatchOptionsExtensionNested<N> extends PatchOptionsFluent<PatchOptionsExtensionNested<N>> implements Nested<N>{
    PatchOptionsExtensionNested(PatchOptions item) {
      this.builder = new PatchOptionsBuilder(this, item);
    }
    PatchOptionsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPatchOptionsExtension() {
      return and();
    }
    
  }
  public class ConfigMapNodeConfigSourceExtensionNested<N> extends ConfigMapNodeConfigSourceFluent<ConfigMapNodeConfigSourceExtensionNested<N>> implements Nested<N>{
    ConfigMapNodeConfigSourceExtensionNested(ConfigMapNodeConfigSource item) {
      this.builder = new ConfigMapNodeConfigSourceBuilder(this, item);
    }
    ConfigMapNodeConfigSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endConfigMapNodeConfigSourceExtension() {
      return and();
    }
    
  }
  public class HTTPGetActionExtensionNested<N> extends HTTPGetActionFluent<HTTPGetActionExtensionNested<N>> implements Nested<N>{
    HTTPGetActionExtensionNested(HTTPGetAction item) {
      this.builder = new HTTPGetActionBuilder(this, item);
    }
    HTTPGetActionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endHTTPGetActionExtension() {
      return and();
    }
    
  }
  public class GlusterfsPersistentVolumeSourceExtensionNested<N> extends GlusterfsPersistentVolumeSourceFluent<GlusterfsPersistentVolumeSourceExtensionNested<N>> implements Nested<N>{
    GlusterfsPersistentVolumeSourceExtensionNested(GlusterfsPersistentVolumeSource item) {
      this.builder = new GlusterfsPersistentVolumeSourceBuilder(this, item);
    }
    GlusterfsPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endGlusterfsPersistentVolumeSourceExtension() {
      return and();
    }
    
  }
  public class DownwardAPIVolumeSourceExtensionNested<N> extends DownwardAPIVolumeSourceFluent<DownwardAPIVolumeSourceExtensionNested<N>> implements Nested<N>{
    DownwardAPIVolumeSourceExtensionNested(DownwardAPIVolumeSource item) {
      this.builder = new DownwardAPIVolumeSourceBuilder(this, item);
    }
    DownwardAPIVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endDownwardAPIVolumeSourceExtension() {
      return and();
    }
    
  }
  public class ISCSIPersistentVolumeSourceExtensionNested<N> extends ISCSIPersistentVolumeSourceFluent<ISCSIPersistentVolumeSourceExtensionNested<N>> implements Nested<N>{
    ISCSIPersistentVolumeSourceExtensionNested(ISCSIPersistentVolumeSource item) {
      this.builder = new ISCSIPersistentVolumeSourceBuilder(this, item);
    }
    ISCSIPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endISCSIPersistentVolumeSourceExtension() {
      return and();
    }
    
  }
  public class WindowsSecurityContextOptionsExtensionNested<N> extends WindowsSecurityContextOptionsFluent<WindowsSecurityContextOptionsExtensionNested<N>> implements Nested<N>{
    WindowsSecurityContextOptionsExtensionNested(WindowsSecurityContextOptions item) {
      this.builder = new WindowsSecurityContextOptionsBuilder(this, item);
    }
    WindowsSecurityContextOptionsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endWindowsSecurityContextOptionsExtension() {
      return and();
    }
    
  }
  public class CreateOptionsExtensionNested<N> extends CreateOptionsFluent<CreateOptionsExtensionNested<N>> implements Nested<N>{
    CreateOptionsExtensionNested(CreateOptions item) {
      this.builder = new CreateOptionsBuilder(this, item);
    }
    CreateOptionsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endCreateOptionsExtension() {
      return and();
    }
    
  }
  public class EnvFromSourceExtensionNested<N> extends EnvFromSourceFluent<EnvFromSourceExtensionNested<N>> implements Nested<N>{
    EnvFromSourceExtensionNested(EnvFromSource item) {
      this.builder = new EnvFromSourceBuilder(this, item);
    }
    EnvFromSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endEnvFromSourceExtension() {
      return and();
    }
    
  }
  public class NamespaceSpecExtensionNested<N> extends NamespaceSpecFluent<NamespaceSpecExtensionNested<N>> implements Nested<N>{
    NamespaceSpecExtensionNested(NamespaceSpec item) {
      this.builder = new NamespaceSpecBuilder(this, item);
    }
    NamespaceSpecBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endNamespaceSpecExtension() {
      return and();
    }
    
  }
  public class TypeMetaExtensionNested<N> extends TypeMetaFluent<TypeMetaExtensionNested<N>> implements Nested<N>{
    TypeMetaExtensionNested(TypeMeta item) {
      this.builder = new TypeMetaBuilder(this, item);
    }
    TypeMetaBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endTypeMetaExtension() {
      return and();
    }
    
  }
  public class RootPathsExtensionNested<N> extends RootPathsFluent<RootPathsExtensionNested<N>> implements Nested<N>{
    RootPathsExtensionNested(RootPaths item) {
      this.builder = new RootPathsBuilder(this, item);
    }
    RootPathsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endRootPathsExtension() {
      return and();
    }
    
  }
  public class ListMetaExtensionNested<N> extends ListMetaFluent<ListMetaExtensionNested<N>> implements Nested<N>{
    ListMetaExtensionNested(ListMeta item) {
      this.builder = new ListMetaBuilder(this, item);
    }
    ListMetaBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endListMetaExtension() {
      return and();
    }
    
  }
  public class SecretReferenceExtensionNested<N> extends SecretReferenceFluent<SecretReferenceExtensionNested<N>> implements Nested<N>{
    SecretReferenceExtensionNested(SecretReference item) {
      this.builder = new SecretReferenceBuilder(this, item);
    }
    SecretReferenceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endSecretReferenceExtension() {
      return and();
    }
    
  }
  public class APIGroupExtensionNested<N> extends APIGroupFluent<APIGroupExtensionNested<N>> implements Nested<N>{
    APIGroupExtensionNested(APIGroup item) {
      this.builder = new APIGroupBuilder(this, item);
    }
    APIGroupBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endAPIGroupExtension() {
      return and();
    }
    
  }
  public class FlexVolumeSourceExtensionNested<N> extends FlexVolumeSourceFluent<FlexVolumeSourceExtensionNested<N>> implements Nested<N>{
    FlexVolumeSourceExtensionNested(FlexVolumeSource item) {
      this.builder = new FlexVolumeSourceBuilder(this, item);
    }
    FlexVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endFlexVolumeSourceExtension() {
      return and();
    }
    
  }
  public class PersistentVolumeClaimTemplateExtensionNested<N> extends PersistentVolumeClaimTemplateFluent<PersistentVolumeClaimTemplateExtensionNested<N>> implements Nested<N>{
    PersistentVolumeClaimTemplateExtensionNested(PersistentVolumeClaimTemplate item) {
      this.builder = new PersistentVolumeClaimTemplateBuilder(this, item);
    }
    PersistentVolumeClaimTemplateBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPersistentVolumeClaimTemplateExtension() {
      return and();
    }
    
  }
  public class ISCSIVolumeSourceExtensionNested<N> extends ISCSIVolumeSourceFluent<ISCSIVolumeSourceExtensionNested<N>> implements Nested<N>{
    ISCSIVolumeSourceExtensionNested(ISCSIVolumeSource item) {
      this.builder = new ISCSIVolumeSourceBuilder(this, item);
    }
    ISCSIVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endISCSIVolumeSourceExtension() {
      return and();
    }
    
  }
  public class SecretKeySelectorExtensionNested<N> extends SecretKeySelectorFluent<SecretKeySelectorExtensionNested<N>> implements Nested<N>{
    SecretKeySelectorExtensionNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endSecretKeySelectorExtension() {
      return and();
    }
    
  }
  public class RBDVolumeSourceExtensionNested<N> extends RBDVolumeSourceFluent<RBDVolumeSourceExtensionNested<N>> implements Nested<N>{
    RBDVolumeSourceExtensionNested(RBDVolumeSource item) {
      this.builder = new RBDVolumeSourceBuilder(this, item);
    }
    RBDVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endRBDVolumeSourceExtension() {
      return and();
    }
    
  }
  public class NodeConfigStatusExtensionNested<N> extends NodeConfigStatusFluent<NodeConfigStatusExtensionNested<N>> implements Nested<N>{
    NodeConfigStatusExtensionNested(NodeConfigStatus item) {
      this.builder = new NodeConfigStatusBuilder(this, item);
    }
    NodeConfigStatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endNodeConfigStatusExtension() {
      return and();
    }
    
  }
  public class ResourceQuotaListExtensionNested<N> extends ResourceQuotaListFluent<ResourceQuotaListExtensionNested<N>> implements Nested<N>{
    ResourceQuotaListExtensionNested(ResourceQuotaList item) {
      this.builder = new ResourceQuotaListBuilder(this, item);
    }
    ResourceQuotaListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endResourceQuotaListExtension() {
      return and();
    }
    
  }
  public class QuobyteVolumeSourceExtensionNested<N> extends QuobyteVolumeSourceFluent<QuobyteVolumeSourceExtensionNested<N>> implements Nested<N>{
    QuobyteVolumeSourceExtensionNested(QuobyteVolumeSource item) {
      this.builder = new QuobyteVolumeSourceBuilder(this, item);
    }
    QuobyteVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endQuobyteVolumeSourceExtension() {
      return and();
    }
    
  }
  public class APIResourceExtensionNested<N> extends APIResourceFluent<APIResourceExtensionNested<N>> implements Nested<N>{
    APIResourceExtensionNested(APIResource item) {
      this.builder = new APIResourceBuilder(this, item);
    }
    APIResourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endAPIResourceExtension() {
      return and();
    }
    
  }
  public class ResourceQuotaStatusExtensionNested<N> extends ResourceQuotaStatusFluent<ResourceQuotaStatusExtensionNested<N>> implements Nested<N>{
    ResourceQuotaStatusExtensionNested(ResourceQuotaStatus item) {
      this.builder = new ResourceQuotaStatusBuilder(this, item);
    }
    ResourceQuotaStatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endResourceQuotaStatusExtension() {
      return and();
    }
    
  }
  public class RawExtensionNested<N> extends RawExtensionFluent<RawExtensionNested<N>> implements Nested<N>{
    RawExtensionNested(RawExtension item) {
      this.builder = new RawExtensionBuilder(this, item);
    }
    RawExtensionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endRawExtension() {
      return and();
    }
    
  }
  public class ConfigMapProjectionExtensionNested<N> extends ConfigMapProjectionFluent<ConfigMapProjectionExtensionNested<N>> implements Nested<N>{
    ConfigMapProjectionExtensionNested(ConfigMapProjection item) {
      this.builder = new ConfigMapProjectionBuilder(this, item);
    }
    ConfigMapProjectionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endConfigMapProjectionExtension() {
      return and();
    }
    
  }
  public class ScopedResourceSelectorRequirementExtensionNested<N> extends ScopedResourceSelectorRequirementFluent<ScopedResourceSelectorRequirementExtensionNested<N>> implements Nested<N>{
    ScopedResourceSelectorRequirementExtensionNested(ScopedResourceSelectorRequirement item) {
      this.builder = new ScopedResourceSelectorRequirementBuilder(this, item);
    }
    ScopedResourceSelectorRequirementBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endScopedResourceSelectorRequirementExtension() {
      return and();
    }
    
  }
  public class NamespaceExtensionNested<N> extends NamespaceFluent<NamespaceExtensionNested<N>> implements Nested<N>{
    NamespaceExtensionNested(Namespace item) {
      this.builder = new NamespaceBuilder(this, item);
    }
    NamespaceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endNamespaceExtension() {
      return and();
    }
    
  }
  public class GroupVersionKindExtensionNested<N> extends GroupVersionKindFluent<GroupVersionKindExtensionNested<N>> implements Nested<N>{
    GroupVersionKindExtensionNested(GroupVersionKind item) {
      this.builder = new GroupVersionKindBuilder(this, item);
    }
    GroupVersionKindBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endGroupVersionKindExtension() {
      return and();
    }
    
  }
  public class ContainerStateTerminatedExtensionNested<N> extends ContainerStateTerminatedFluent<ContainerStateTerminatedExtensionNested<N>> implements Nested<N>{
    ContainerStateTerminatedExtensionNested(ContainerStateTerminated item) {
      this.builder = new ContainerStateTerminatedBuilder(this, item);
    }
    ContainerStateTerminatedBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endContainerStateTerminatedExtension() {
      return and();
    }
    
  }
  public class LimitRangeSpecExtensionNested<N> extends LimitRangeSpecFluent<LimitRangeSpecExtensionNested<N>> implements Nested<N>{
    LimitRangeSpecExtensionNested(LimitRangeSpec item) {
      this.builder = new LimitRangeSpecBuilder(this, item);
    }
    LimitRangeSpecBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endLimitRangeSpecExtension() {
      return and();
    }
    
  }
  public class ProjectedVolumeSourceExtensionNested<N> extends ProjectedVolumeSourceFluent<ProjectedVolumeSourceExtensionNested<N>> implements Nested<N>{
    ProjectedVolumeSourceExtensionNested(ProjectedVolumeSource item) {
      this.builder = new ProjectedVolumeSourceBuilder(this, item);
    }
    ProjectedVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endProjectedVolumeSourceExtension() {
      return and();
    }
    
  }
  public class PodOSExtensionNested<N> extends PodOSFluent<PodOSExtensionNested<N>> implements Nested<N>{
    PodOSExtensionNested(PodOS item) {
      this.builder = new PodOSBuilder(this, item);
    }
    PodOSBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPodOSExtension() {
      return and();
    }
    
  }
  public class PersistentVolumeClaimStatusExtensionNested<N> extends PersistentVolumeClaimStatusFluent<PersistentVolumeClaimStatusExtensionNested<N>> implements Nested<N>{
    PersistentVolumeClaimStatusExtensionNested(PersistentVolumeClaimStatus item) {
      this.builder = new PersistentVolumeClaimStatusBuilder(this, item);
    }
    PersistentVolumeClaimStatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPersistentVolumeClaimStatusExtension() {
      return and();
    }
    
  }
  public class ContainerStateExtensionNested<N> extends ContainerStateFluent<ContainerStateExtensionNested<N>> implements Nested<N>{
    ContainerStateExtensionNested(ContainerState item) {
      this.builder = new ContainerStateBuilder(this, item);
    }
    ContainerStateBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endContainerStateExtension() {
      return and();
    }
    
  }
  public class ServiceSpecExtensionNested<N> extends ServiceSpecFluent<ServiceSpecExtensionNested<N>> implements Nested<N>{
    ServiceSpecExtensionNested(ServiceSpec item) {
      this.builder = new ServiceSpecBuilder(this, item);
    }
    ServiceSpecBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endServiceSpecExtension() {
      return and();
    }
    
  }
  public class ServiceAccountTokenProjectionExtensionNested<N> extends ServiceAccountTokenProjectionFluent<ServiceAccountTokenProjectionExtensionNested<N>> implements Nested<N>{
    ServiceAccountTokenProjectionExtensionNested(ServiceAccountTokenProjection item) {
      this.builder = new ServiceAccountTokenProjectionBuilder(this, item);
    }
    ServiceAccountTokenProjectionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endServiceAccountTokenProjectionExtension() {
      return and();
    }
    
  }
  public class PhotonPersistentDiskVolumeSourceExtensionNested<N> extends PhotonPersistentDiskVolumeSourceFluent<PhotonPersistentDiskVolumeSourceExtensionNested<N>> implements Nested<N>{
    PhotonPersistentDiskVolumeSourceExtensionNested(PhotonPersistentDiskVolumeSource item) {
      this.builder = new PhotonPersistentDiskVolumeSourceBuilder(this, item);
    }
    PhotonPersistentDiskVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPhotonPersistentDiskVolumeSourceExtension() {
      return and();
    }
    
  }
  public class ContainerExtensionNested<N> extends ContainerFluent<ContainerExtensionNested<N>> implements Nested<N>{
    ContainerExtensionNested(Container item) {
      this.builder = new ContainerBuilder(this, item);
    }
    ContainerBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endContainerExtension() {
      return and();
    }
    
  }
  public class NodeSpecExtensionNested<N> extends NodeSpecFluent<NodeSpecExtensionNested<N>> implements Nested<N>{
    NodeSpecExtensionNested(NodeSpec item) {
      this.builder = new NodeSpecBuilder(this, item);
    }
    NodeSpecBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endNodeSpecExtension() {
      return and();
    }
    
  }
  public class TypedLocalObjectReferenceExtensionNested<N> extends TypedLocalObjectReferenceFluent<TypedLocalObjectReferenceExtensionNested<N>> implements Nested<N>{
    TypedLocalObjectReferenceExtensionNested(TypedLocalObjectReference item) {
      this.builder = new TypedLocalObjectReferenceBuilder(this, item);
    }
    TypedLocalObjectReferenceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endTypedLocalObjectReferenceExtension() {
      return and();
    }
    
  }
  public class FieldsV1ExtensionNested<N> extends FieldsV1Fluent<FieldsV1ExtensionNested<N>> implements Nested<N>{
    FieldsV1ExtensionNested(FieldsV1 item) {
      this.builder = new FieldsV1Builder(this, item);
    }
    FieldsV1Builder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endFieldsV1Extension() {
      return and();
    }
    
  }
  public class SecretListExtensionNested<N> extends SecretListFluent<SecretListExtensionNested<N>> implements Nested<N>{
    SecretListExtensionNested(SecretList item) {
      this.builder = new SecretListBuilder(this, item);
    }
    SecretListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endSecretListExtension() {
      return and();
    }
    
  }
  public class NodeAddressExtensionNested<N> extends NodeAddressFluent<NodeAddressExtensionNested<N>> implements Nested<N>{
    NodeAddressExtensionNested(NodeAddress item) {
      this.builder = new NodeAddressBuilder(this, item);
    }
    NodeAddressBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endNodeAddressExtension() {
      return and();
    }
    
  }
  public class PodAffinityExtensionNested<N> extends PodAffinityFluent<PodAffinityExtensionNested<N>> implements Nested<N>{
    PodAffinityExtensionNested(PodAffinity item) {
      this.builder = new PodAffinityBuilder(this, item);
    }
    PodAffinityBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPodAffinityExtension() {
      return and();
    }
    
  }
  public class ExecEnvVarExtensionNested<N> extends ExecEnvVarFluent<ExecEnvVarExtensionNested<N>> implements Nested<N>{
    ExecEnvVarExtensionNested(ExecEnvVar item) {
      this.builder = new ExecEnvVarBuilder(this, item);
    }
    ExecEnvVarBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endExecEnvVarExtension() {
      return and();
    }
    
  }
  public class ServiceExtensionNested<N> extends ServiceFluent<ServiceExtensionNested<N>> implements Nested<N>{
    ServiceExtensionNested(Service item) {
      this.builder = new ServiceBuilder(this, item);
    }
    ServiceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endServiceExtension() {
      return and();
    }
    
  }
  public class EventSeriesExtensionNested<N> extends EventSeriesFluent<EventSeriesExtensionNested<N>> implements Nested<N>{
    EventSeriesExtensionNested(EventSeries item) {
      this.builder = new EventSeriesBuilder(this, item);
    }
    EventSeriesBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endEventSeriesExtension() {
      return and();
    }
    
  }
  public class PodConditionExtensionNested<N> extends PodConditionFluent<PodConditionExtensionNested<N>> implements Nested<N>{
    PodConditionExtensionNested(PodCondition item) {
      this.builder = new PodConditionBuilder(this, item);
    }
    PodConditionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPodConditionExtension() {
      return and();
    }
    
  }
  public class TopologySpreadConstraintExtensionNested<N> extends TopologySpreadConstraintFluent<TopologySpreadConstraintExtensionNested<N>> implements Nested<N>{
    TopologySpreadConstraintExtensionNested(TopologySpreadConstraint item) {
      this.builder = new TopologySpreadConstraintBuilder(this, item);
    }
    TopologySpreadConstraintBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endTopologySpreadConstraintExtension() {
      return and();
    }
    
  }
  public class ExecActionExtensionNested<N> extends ExecActionFluent<ExecActionExtensionNested<N>> implements Nested<N>{
    ExecActionExtensionNested(ExecAction item) {
      this.builder = new ExecActionBuilder(this, item);
    }
    ExecActionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endExecActionExtension() {
      return and();
    }
    
  }
  public class ContainerImageExtensionNested<N> extends ContainerImageFluent<ContainerImageExtensionNested<N>> implements Nested<N>{
    ContainerImageExtensionNested(ContainerImage item) {
      this.builder = new ContainerImageBuilder(this, item);
    }
    ContainerImageBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endContainerImageExtension() {
      return and();
    }
    
  }
  public class GroupKindExtensionNested<N> extends GroupKindFluent<GroupKindExtensionNested<N>> implements Nested<N>{
    GroupKindExtensionNested(GroupKind item) {
      this.builder = new GroupKindBuilder(this, item);
    }
    GroupKindBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endGroupKindExtension() {
      return and();
    }
    
  }
  public class ReplicationControllerExtensionNested<N> extends ReplicationControllerFluent<ReplicationControllerExtensionNested<N>> implements Nested<N>{
    ReplicationControllerExtensionNested(ReplicationController item) {
      this.builder = new ReplicationControllerBuilder(this, item);
    }
    ReplicationControllerBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endReplicationControllerExtension() {
      return and();
    }
    
  }
  public class NodeStatusExtensionNested<N> extends NodeStatusFluent<NodeStatusExtensionNested<N>> implements Nested<N>{
    NodeStatusExtensionNested(NodeStatus item) {
      this.builder = new NodeStatusBuilder(this, item);
    }
    NodeStatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endNodeStatusExtension() {
      return and();
    }
    
  }
  public class ConfigMapListExtensionNested<N> extends ConfigMapListFluent<ConfigMapListExtensionNested<N>> implements Nested<N>{
    ConfigMapListExtensionNested(ConfigMapList item) {
      this.builder = new ConfigMapListBuilder(this, item);
    }
    ConfigMapListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endConfigMapListExtension() {
      return and();
    }
    
  }
  public class NodeSelectorExtensionNested<N> extends NodeSelectorFluent<NodeSelectorExtensionNested<N>> implements Nested<N>{
    NodeSelectorExtensionNested(NodeSelector item) {
      this.builder = new NodeSelectorBuilder(this, item);
    }
    NodeSelectorBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endNodeSelectorExtension() {
      return and();
    }
    
  }
  public class TolerationExtensionNested<N> extends TolerationFluent<TolerationExtensionNested<N>> implements Nested<N>{
    TolerationExtensionNested(Toleration item) {
      this.builder = new TolerationBuilder(this, item);
    }
    TolerationBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endTolerationExtension() {
      return and();
    }
    
  }
  public class CephFSPersistentVolumeSourceExtensionNested<N> extends CephFSPersistentVolumeSourceFluent<CephFSPersistentVolumeSourceExtensionNested<N>> implements Nested<N>{
    CephFSPersistentVolumeSourceExtensionNested(CephFSPersistentVolumeSource item) {
      this.builder = new CephFSPersistentVolumeSourceBuilder(this, item);
    }
    CephFSPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endCephFSPersistentVolumeSourceExtension() {
      return and();
    }
    
  }
  public class PersistentVolumeClaimConditionExtensionNested<N> extends PersistentVolumeClaimConditionFluent<PersistentVolumeClaimConditionExtensionNested<N>> implements Nested<N>{
    PersistentVolumeClaimConditionExtensionNested(PersistentVolumeClaimCondition item) {
      this.builder = new PersistentVolumeClaimConditionBuilder(this, item);
    }
    PersistentVolumeClaimConditionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPersistentVolumeClaimConditionExtension() {
      return and();
    }
    
  }
  public class PreferredSchedulingTermExtensionNested<N> extends PreferredSchedulingTermFluent<PreferredSchedulingTermExtensionNested<N>> implements Nested<N>{
    PreferredSchedulingTermExtensionNested(PreferredSchedulingTerm item) {
      this.builder = new PreferredSchedulingTermBuilder(this, item);
    }
    PreferredSchedulingTermBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPreferredSchedulingTermExtension() {
      return and();
    }
    
  }
  public class PersistentVolumeListExtensionNested<N> extends PersistentVolumeListFluent<PersistentVolumeListExtensionNested<N>> implements Nested<N>{
    PersistentVolumeListExtensionNested(PersistentVolumeList item) {
      this.builder = new PersistentVolumeListBuilder(this, item);
    }
    PersistentVolumeListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPersistentVolumeListExtension() {
      return and();
    }
    
  }
  public class PodSchedulingGateExtensionNested<N> extends PodSchedulingGateFluent<PodSchedulingGateExtensionNested<N>> implements Nested<N>{
    PodSchedulingGateExtensionNested(PodSchedulingGate item) {
      this.builder = new PodSchedulingGateBuilder(this, item);
    }
    PodSchedulingGateBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPodSchedulingGateExtension() {
      return and();
    }
    
  }
  public class PodDNSConfigOptionExtensionNested<N> extends PodDNSConfigOptionFluent<PodDNSConfigOptionExtensionNested<N>> implements Nested<N>{
    PodDNSConfigOptionExtensionNested(PodDNSConfigOption item) {
      this.builder = new PodDNSConfigOptionBuilder(this, item);
    }
    PodDNSConfigOptionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPodDNSConfigOptionExtension() {
      return and();
    }
    
  }
  public class GCEPersistentDiskVolumeSourceExtensionNested<N> extends GCEPersistentDiskVolumeSourceFluent<GCEPersistentDiskVolumeSourceExtensionNested<N>> implements Nested<N>{
    GCEPersistentDiskVolumeSourceExtensionNested(GCEPersistentDiskVolumeSource item) {
      this.builder = new GCEPersistentDiskVolumeSourceBuilder(this, item);
    }
    GCEPersistentDiskVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endGCEPersistentDiskVolumeSourceExtension() {
      return and();
    }
    
  }
  public class APIServiceConditionExtensionNested<N> extends APIServiceConditionFluent<APIServiceConditionExtensionNested<N>> implements Nested<N>{
    APIServiceConditionExtensionNested(APIServiceCondition item) {
      this.builder = new APIServiceConditionBuilder(this, item);
    }
    APIServiceConditionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endAPIServiceConditionExtension() {
      return and();
    }
    
  }
  public class EventListExtensionNested<N> extends EventListFluent<EventListExtensionNested<N>> implements Nested<N>{
    EventListExtensionNested(EventList item) {
      this.builder = new EventListBuilder(this, item);
    }
    EventListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endEventListExtension() {
      return and();
    }
    
  }
  public class PodReadinessGateExtensionNested<N> extends PodReadinessGateFluent<PodReadinessGateExtensionNested<N>> implements Nested<N>{
    PodReadinessGateExtensionNested(PodReadinessGate item) {
      this.builder = new PodReadinessGateBuilder(this, item);
    }
    PodReadinessGateBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPodReadinessGateExtension() {
      return and();
    }
    
  }
  public class ContainerStateWaitingExtensionNested<N> extends ContainerStateWaitingFluent<ContainerStateWaitingExtensionNested<N>> implements Nested<N>{
    ContainerStateWaitingExtensionNested(ContainerStateWaiting item) {
      this.builder = new ContainerStateWaitingBuilder(this, item);
    }
    ContainerStateWaitingBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endContainerStateWaitingExtension() {
      return and();
    }
    
  }
  public class VolumeMountExtensionNested<N> extends VolumeMountFluent<VolumeMountExtensionNested<N>> implements Nested<N>{
    VolumeMountExtensionNested(VolumeMount item) {
      this.builder = new VolumeMountBuilder(this, item);
    }
    VolumeMountBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endVolumeMountExtension() {
      return and();
    }
    
  }
  public class NamespaceConditionExtensionNested<N> extends NamespaceConditionFluent<NamespaceConditionExtensionNested<N>> implements Nested<N>{
    NamespaceConditionExtensionNested(NamespaceCondition item) {
      this.builder = new NamespaceConditionBuilder(this, item);
    }
    NamespaceConditionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endNamespaceConditionExtension() {
      return and();
    }
    
  }
  public class LabelSelectorExtensionNested<N> extends LabelSelectorFluent<LabelSelectorExtensionNested<N>> implements Nested<N>{
    LabelSelectorExtensionNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endLabelSelectorExtension() {
      return and();
    }
    
  }
  public class StatusCauseExtensionNested<N> extends StatusCauseFluent<StatusCauseExtensionNested<N>> implements Nested<N>{
    StatusCauseExtensionNested(StatusCause item) {
      this.builder = new StatusCauseBuilder(this, item);
    }
    StatusCauseBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endStatusCauseExtension() {
      return and();
    }
    
  }
  public class NamedClusterExtensionNested<N> extends NamedClusterFluent<NamedClusterExtensionNested<N>> implements Nested<N>{
    NamedClusterExtensionNested(NamedCluster item) {
      this.builder = new NamedClusterBuilder(this, item);
    }
    NamedClusterBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endNamedClusterExtension() {
      return and();
    }
    
  }
  public class StatusDetailsExtensionNested<N> extends StatusDetailsFluent<StatusDetailsExtensionNested<N>> implements Nested<N>{
    StatusDetailsExtensionNested(StatusDetails item) {
      this.builder = new StatusDetailsBuilder(this, item);
    }
    StatusDetailsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endStatusDetailsExtension() {
      return and();
    }
    
  }
  public class DownwardAPIVolumeFileExtensionNested<N> extends DownwardAPIVolumeFileFluent<DownwardAPIVolumeFileExtensionNested<N>> implements Nested<N>{
    DownwardAPIVolumeFileExtensionNested(DownwardAPIVolumeFile item) {
      this.builder = new DownwardAPIVolumeFileBuilder(this, item);
    }
    DownwardAPIVolumeFileBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endDownwardAPIVolumeFileExtension() {
      return and();
    }
    
  }
  public class SeccompProfileExtensionNested<N> extends SeccompProfileFluent<SeccompProfileExtensionNested<N>> implements Nested<N>{
    SeccompProfileExtensionNested(SeccompProfile item) {
      this.builder = new SeccompProfileBuilder(this, item);
    }
    SeccompProfileBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endSeccompProfileExtension() {
      return and();
    }
    
  }
  public class SysctlExtensionNested<N> extends SysctlFluent<SysctlExtensionNested<N>> implements Nested<N>{
    SysctlExtensionNested(Sysctl item) {
      this.builder = new SysctlBuilder(this, item);
    }
    SysctlBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endSysctlExtension() {
      return and();
    }
    
  }
  public class DeleteOptionsExtensionNested<N> extends DeleteOptionsFluent<DeleteOptionsExtensionNested<N>> implements Nested<N>{
    DeleteOptionsExtensionNested(DeleteOptions item) {
      this.builder = new DeleteOptionsBuilder(this, item);
    }
    DeleteOptionsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endDeleteOptionsExtension() {
      return and();
    }
    
  }
  public class StatusExtensionNested<N> extends StatusFluent<StatusExtensionNested<N>> implements Nested<N>{
    StatusExtensionNested(Status item) {
      this.builder = new StatusBuilder(this, item);
    }
    StatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endStatusExtension() {
      return and();
    }
    
  }
  public class ContainerStatusExtensionNested<N> extends ContainerStatusFluent<ContainerStatusExtensionNested<N>> implements Nested<N>{
    ContainerStatusExtensionNested(ContainerStatus item) {
      this.builder = new ContainerStatusBuilder(this, item);
    }
    ContainerStatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endContainerStatusExtension() {
      return and();
    }
    
  }
  public class PodTemplateExtensionNested<N> extends PodTemplateFluent<PodTemplateExtensionNested<N>> implements Nested<N>{
    PodTemplateExtensionNested(PodTemplate item) {
      this.builder = new PodTemplateBuilder(this, item);
    }
    PodTemplateBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPodTemplateExtension() {
      return and();
    }
    
  }
  public class ConfigMapEnvSourceExtensionNested<N> extends ConfigMapEnvSourceFluent<ConfigMapEnvSourceExtensionNested<N>> implements Nested<N>{
    ConfigMapEnvSourceExtensionNested(ConfigMapEnvSource item) {
      this.builder = new ConfigMapEnvSourceBuilder(this, item);
    }
    ConfigMapEnvSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endConfigMapEnvSourceExtension() {
      return and();
    }
    
  }
  public class NodeSelectorRequirementExtensionNested<N> extends NodeSelectorRequirementFluent<NodeSelectorRequirementExtensionNested<N>> implements Nested<N>{
    NodeSelectorRequirementExtensionNested(NodeSelectorRequirement item) {
      this.builder = new NodeSelectorRequirementBuilder(this, item);
    }
    NodeSelectorRequirementBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endNodeSelectorRequirementExtension() {
      return and();
    }
    
  }
  public class TCPSocketActionExtensionNested<N> extends TCPSocketActionFluent<TCPSocketActionExtensionNested<N>> implements Nested<N>{
    TCPSocketActionExtensionNested(TCPSocketAction item) {
      this.builder = new TCPSocketActionBuilder(this, item);
    }
    TCPSocketActionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endTCPSocketActionExtension() {
      return and();
    }
    
  }
  public class EventExtensionNested<N> extends EventFluent<EventExtensionNested<N>> implements Nested<N>{
    EventExtensionNested(Event item) {
      this.builder = new EventBuilder(this, item);
    }
    EventBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endEventExtension() {
      return and();
    }
    
  }
  public class PreferencesExtensionNested<N> extends PreferencesFluent<PreferencesExtensionNested<N>> implements Nested<N>{
    PreferencesExtensionNested(Preferences item) {
      this.builder = new PreferencesBuilder(this, item);
    }
    PreferencesBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPreferencesExtension() {
      return and();
    }
    
  }
  public class ObjectFieldSelectorExtensionNested<N> extends ObjectFieldSelectorFluent<ObjectFieldSelectorExtensionNested<N>> implements Nested<N>{
    ObjectFieldSelectorExtensionNested(ObjectFieldSelector item) {
      this.builder = new ObjectFieldSelectorBuilder(this, item);
    }
    ObjectFieldSelectorBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endObjectFieldSelectorExtension() {
      return and();
    }
    
  }
  public class PodTemplateListExtensionNested<N> extends PodTemplateListFluent<PodTemplateListExtensionNested<N>> implements Nested<N>{
    PodTemplateListExtensionNested(PodTemplateList item) {
      this.builder = new PodTemplateListBuilder(this, item);
    }
    PodTemplateListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPodTemplateListExtension() {
      return and();
    }
    
  }
  public class PersistentVolumeExtensionNested<N> extends PersistentVolumeFluent<PersistentVolumeExtensionNested<N>> implements Nested<N>{
    PersistentVolumeExtensionNested(PersistentVolume item) {
      this.builder = new PersistentVolumeBuilder(this, item);
    }
    PersistentVolumeBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPersistentVolumeExtension() {
      return and();
    }
    
  }
  public class CinderVolumeSourceExtensionNested<N> extends CinderVolumeSourceFluent<CinderVolumeSourceExtensionNested<N>> implements Nested<N>{
    CinderVolumeSourceExtensionNested(CinderVolumeSource item) {
      this.builder = new CinderVolumeSourceBuilder(this, item);
    }
    CinderVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endCinderVolumeSourceExtension() {
      return and();
    }
    
  }
  public class EndpointAddressExtensionNested<N> extends EndpointAddressFluent<EndpointAddressExtensionNested<N>> implements Nested<N>{
    EndpointAddressExtensionNested(EndpointAddress item) {
      this.builder = new EndpointAddressBuilder(this, item);
    }
    EndpointAddressBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endEndpointAddressExtension() {
      return and();
    }
    
  }
  public class NodeConfigSourceExtensionNested<N> extends NodeConfigSourceFluent<NodeConfigSourceExtensionNested<N>> implements Nested<N>{
    NodeConfigSourceExtensionNested(NodeConfigSource item) {
      this.builder = new NodeConfigSourceBuilder(this, item);
    }
    NodeConfigSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endNodeConfigSourceExtension() {
      return and();
    }
    
  }
  public class VsphereVirtualDiskVolumeSourceExtensionNested<N> extends VsphereVirtualDiskVolumeSourceFluent<VsphereVirtualDiskVolumeSourceExtensionNested<N>> implements Nested<N>{
    VsphereVirtualDiskVolumeSourceExtensionNested(VsphereVirtualDiskVolumeSource item) {
      this.builder = new VsphereVirtualDiskVolumeSourceBuilder(this, item);
    }
    VsphereVirtualDiskVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endVsphereVirtualDiskVolumeSourceExtension() {
      return and();
    }
    
  }
  public class ObjectMetaExtensionNested<N> extends ObjectMetaFluent<ObjectMetaExtensionNested<N>> implements Nested<N>{
    ObjectMetaExtensionNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endObjectMetaExtension() {
      return and();
    }
    
  }
  public class PersistentVolumeClaimExtensionNested<N> extends PersistentVolumeClaimFluent<PersistentVolumeClaimExtensionNested<N>> implements Nested<N>{
    PersistentVolumeClaimExtensionNested(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPersistentVolumeClaimExtension() {
      return and();
    }
    
  }
  public class LabelSelectorRequirementExtensionNested<N> extends LabelSelectorRequirementFluent<LabelSelectorRequirementExtensionNested<N>> implements Nested<N>{
    LabelSelectorRequirementExtensionNested(LabelSelectorRequirement item) {
      this.builder = new LabelSelectorRequirementBuilder(this, item);
    }
    LabelSelectorRequirementBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endLabelSelectorRequirementExtension() {
      return and();
    }
    
  }
  public class GitRepoVolumeSourceExtensionNested<N> extends GitRepoVolumeSourceFluent<GitRepoVolumeSourceExtensionNested<N>> implements Nested<N>{
    GitRepoVolumeSourceExtensionNested(GitRepoVolumeSource item) {
      this.builder = new GitRepoVolumeSourceBuilder(this, item);
    }
    GitRepoVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endGitRepoVolumeSourceExtension() {
      return and();
    }
    
  }
  public class GenericKubernetesResourceExtensionNested<N> extends GenericKubernetesResourceFluent<GenericKubernetesResourceExtensionNested<N>> implements Nested<N>{
    GenericKubernetesResourceExtensionNested(GenericKubernetesResource item) {
      this.builder = new GenericKubernetesResourceBuilder(this, item);
    }
    GenericKubernetesResourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endGenericKubernetesResourceExtension() {
      return and();
    }
    
  }
  public class EndpointsListExtensionNested<N> extends EndpointsListFluent<EndpointsListExtensionNested<N>> implements Nested<N>{
    EndpointsListExtensionNested(EndpointsList item) {
      this.builder = new EndpointsListBuilder(this, item);
    }
    EndpointsListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endEndpointsListExtension() {
      return and();
    }
    
  }
  public class GroupVersionResourceExtensionNested<N> extends GroupVersionResourceFluent<GroupVersionResourceExtensionNested<N>> implements Nested<N>{
    GroupVersionResourceExtensionNested(GroupVersionResource item) {
      this.builder = new GroupVersionResourceBuilder(this, item);
    }
    GroupVersionResourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endGroupVersionResourceExtension() {
      return and();
    }
    
  }
  public class CinderPersistentVolumeSourceExtensionNested<N> extends CinderPersistentVolumeSourceFluent<CinderPersistentVolumeSourceExtensionNested<N>> implements Nested<N>{
    CinderPersistentVolumeSourceExtensionNested(CinderPersistentVolumeSource item) {
      this.builder = new CinderPersistentVolumeSourceBuilder(this, item);
    }
    CinderPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endCinderPersistentVolumeSourceExtension() {
      return and();
    }
    
  }
  public class TopologySelectorTermExtensionNested<N> extends TopologySelectorTermFluent<TopologySelectorTermExtensionNested<N>> implements Nested<N>{
    TopologySelectorTermExtensionNested(TopologySelectorTerm item) {
      this.builder = new TopologySelectorTermBuilder(this, item);
    }
    TopologySelectorTermBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endTopologySelectorTermExtension() {
      return and();
    }
    
  }
  public class OwnerReferenceExtensionNested<N> extends OwnerReferenceFluent<OwnerReferenceExtensionNested<N>> implements Nested<N>{
    OwnerReferenceExtensionNested(OwnerReference item) {
      this.builder = new OwnerReferenceBuilder(this, item);
    }
    OwnerReferenceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endOwnerReferenceExtension() {
      return and();
    }
    
  }
  public class StorageOSPersistentVolumeSourceExtensionNested<N> extends StorageOSPersistentVolumeSourceFluent<StorageOSPersistentVolumeSourceExtensionNested<N>> implements Nested<N>{
    StorageOSPersistentVolumeSourceExtensionNested(StorageOSPersistentVolumeSource item) {
      this.builder = new StorageOSPersistentVolumeSourceBuilder(this, item);
    }
    StorageOSPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endStorageOSPersistentVolumeSourceExtension() {
      return and();
    }
    
  }
  public class EphemeralVolumeSourceExtensionNested<N> extends EphemeralVolumeSourceFluent<EphemeralVolumeSourceExtensionNested<N>> implements Nested<N>{
    EphemeralVolumeSourceExtensionNested(EphemeralVolumeSource item) {
      this.builder = new EphemeralVolumeSourceBuilder(this, item);
    }
    EphemeralVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endEphemeralVolumeSourceExtension() {
      return and();
    }
    
  }
  public class ReplicationControllerConditionExtensionNested<N> extends ReplicationControllerConditionFluent<ReplicationControllerConditionExtensionNested<N>> implements Nested<N>{
    ReplicationControllerConditionExtensionNested(ReplicationControllerCondition item) {
      this.builder = new ReplicationControllerConditionBuilder(this, item);
    }
    ReplicationControllerConditionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endReplicationControllerConditionExtension() {
      return and();
    }
    
  }
  public class PodAntiAffinityExtensionNested<N> extends PodAntiAffinityFluent<PodAntiAffinityExtensionNested<N>> implements Nested<N>{
    PodAntiAffinityExtensionNested(PodAntiAffinity item) {
      this.builder = new PodAntiAffinityBuilder(this, item);
    }
    PodAntiAffinityBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPodAntiAffinityExtension() {
      return and();
    }
    
  }
  public class SecurityContextExtensionNested<N> extends SecurityContextFluent<SecurityContextExtensionNested<N>> implements Nested<N>{
    SecurityContextExtensionNested(SecurityContext item) {
      this.builder = new SecurityContextBuilder(this, item);
    }
    SecurityContextBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endSecurityContextExtension() {
      return and();
    }
    
  }
  public class ReplicationControllerListExtensionNested<N> extends ReplicationControllerListFluent<ReplicationControllerListExtensionNested<N>> implements Nested<N>{
    ReplicationControllerListExtensionNested(ReplicationControllerList item) {
      this.builder = new ReplicationControllerListBuilder(this, item);
    }
    ReplicationControllerListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endReplicationControllerListExtension() {
      return and();
    }
    
  }
  public class ConfigMapVolumeSourceExtensionNested<N> extends ConfigMapVolumeSourceFluent<ConfigMapVolumeSourceExtensionNested<N>> implements Nested<N>{
    ConfigMapVolumeSourceExtensionNested(ConfigMapVolumeSource item) {
      this.builder = new ConfigMapVolumeSourceBuilder(this, item);
    }
    ConfigMapVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endConfigMapVolumeSourceExtension() {
      return and();
    }
    
  }
  public class ContainerStateRunningExtensionNested<N> extends ContainerStateRunningFluent<ContainerStateRunningExtensionNested<N>> implements Nested<N>{
    ContainerStateRunningExtensionNested(ContainerStateRunning item) {
      this.builder = new ContainerStateRunningBuilder(this, item);
    }
    ContainerStateRunningBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endContainerStateRunningExtension() {
      return and();
    }
    
  }
  public class ComponentStatusListExtensionNested<N> extends ComponentStatusListFluent<ComponentStatusListExtensionNested<N>> implements Nested<N>{
    ComponentStatusListExtensionNested(ComponentStatusList item) {
      this.builder = new ComponentStatusListBuilder(this, item);
    }
    ComponentStatusListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endComponentStatusListExtension() {
      return and();
    }
    
  }
  public class FlockerVolumeSourceExtensionNested<N> extends FlockerVolumeSourceFluent<FlockerVolumeSourceExtensionNested<N>> implements Nested<N>{
    FlockerVolumeSourceExtensionNested(FlockerVolumeSource item) {
      this.builder = new FlockerVolumeSourceBuilder(this, item);
    }
    FlockerVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endFlockerVolumeSourceExtension() {
      return and();
    }
    
  }
  public class ScaleIOVolumeSourceExtensionNested<N> extends ScaleIOVolumeSourceFluent<ScaleIOVolumeSourceExtensionNested<N>> implements Nested<N>{
    ScaleIOVolumeSourceExtensionNested(ScaleIOVolumeSource item) {
      this.builder = new ScaleIOVolumeSourceBuilder(this, item);
    }
    ScaleIOVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endScaleIOVolumeSourceExtension() {
      return and();
    }
    
  }
  public class LimitRangeListExtensionNested<N> extends LimitRangeListFluent<LimitRangeListExtensionNested<N>> implements Nested<N>{
    LimitRangeListExtensionNested(LimitRangeList item) {
      this.builder = new LimitRangeListBuilder(this, item);
    }
    LimitRangeListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endLimitRangeListExtension() {
      return and();
    }
    
  }
  public class PodExecOptionsExtensionNested<N> extends PodExecOptionsFluent<PodExecOptionsExtensionNested<N>> implements Nested<N>{
    PodExecOptionsExtensionNested(PodExecOptions item) {
      this.builder = new PodExecOptionsBuilder(this, item);
    }
    PodExecOptionsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPodExecOptionsExtension() {
      return and();
    }
    
  }
  public class ProbeExtensionNested<N> extends ProbeFluent<ProbeExtensionNested<N>> implements Nested<N>{
    ProbeExtensionNested(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endProbeExtension() {
      return and();
    }
    
  }
  public class UpdateOptionsExtensionNested<N> extends UpdateOptionsFluent<UpdateOptionsExtensionNested<N>> implements Nested<N>{
    UpdateOptionsExtensionNested(UpdateOptions item) {
      this.builder = new UpdateOptionsBuilder(this, item);
    }
    UpdateOptionsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endUpdateOptionsExtension() {
      return and();
    }
    
  }
  public class EndpointsExtensionNested<N> extends EndpointsFluent<EndpointsExtensionNested<N>> implements Nested<N>{
    EndpointsExtensionNested(Endpoints item) {
      this.builder = new EndpointsBuilder(this, item);
    }
    EndpointsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endEndpointsExtension() {
      return and();
    }
    
  }
  public class NamedExtensionNested<N> extends NamedExtensionFluent<NamedExtensionNested<N>> implements Nested<N>{
    NamedExtensionNested(NamedExtension item) {
      this.builder = new NamedExtensionBuilder(this, item);
    }
    NamedExtensionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endNamedExtension() {
      return and();
    }
    
  }
  public class AzureFilePersistentVolumeSourceExtensionNested<N> extends AzureFilePersistentVolumeSourceFluent<AzureFilePersistentVolumeSourceExtensionNested<N>> implements Nested<N>{
    AzureFilePersistentVolumeSourceExtensionNested(AzureFilePersistentVolumeSource item) {
      this.builder = new AzureFilePersistentVolumeSourceBuilder(this, item);
    }
    AzureFilePersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endAzureFilePersistentVolumeSourceExtension() {
      return and();
    }
    
  }
  public class APIResourceListExtensionNested<N> extends APIResourceListFluent<APIResourceListExtensionNested<N>> implements Nested<N>{
    APIResourceListExtensionNested(APIResourceList item) {
      this.builder = new APIResourceListBuilder(this, item);
    }
    APIResourceListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endAPIResourceListExtension() {
      return and();
    }
    
  }
  public class APIServiceListExtensionNested<N> extends APIServiceListFluent<APIServiceListExtensionNested<N>> implements Nested<N>{
    APIServiceListExtensionNested(APIServiceList item) {
      this.builder = new APIServiceListBuilder(this, item);
    }
    APIServiceListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endAPIServiceListExtension() {
      return and();
    }
    
  }
  public class SecretVolumeSourceExtensionNested<N> extends SecretVolumeSourceFluent<SecretVolumeSourceExtensionNested<N>> implements Nested<N>{
    SecretVolumeSourceExtensionNested(SecretVolumeSource item) {
      this.builder = new SecretVolumeSourceBuilder(this, item);
    }
    SecretVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endSecretVolumeSourceExtension() {
      return and();
    }
    
  }
  public class PodExtensionNested<N> extends PodFluent<PodExtensionNested<N>> implements Nested<N>{
    PodExtensionNested(Pod item) {
      this.builder = new PodBuilder(this, item);
    }
    PodBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPodExtension() {
      return and();
    }
    
  }
  public class ClientIPConfigExtensionNested<N> extends ClientIPConfigFluent<ClientIPConfigExtensionNested<N>> implements Nested<N>{
    ClientIPConfigExtensionNested(ClientIPConfig item) {
      this.builder = new ClientIPConfigBuilder(this, item);
    }
    ClientIPConfigBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endClientIPConfigExtension() {
      return and();
    }
    
  }
  public class ContextExtensionNested<N> extends ContextFluent<ContextExtensionNested<N>> implements Nested<N>{
    ContextExtensionNested(Context item) {
      this.builder = new ContextBuilder(this, item);
    }
    ContextBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endContextExtension() {
      return and();
    }
    
  }
  public class NodeAffinityExtensionNested<N> extends NodeAffinityFluent<NodeAffinityExtensionNested<N>> implements Nested<N>{
    NodeAffinityExtensionNested(NodeAffinity item) {
      this.builder = new NodeAffinityBuilder(this, item);
    }
    NodeAffinityBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endNodeAffinityExtension() {
      return and();
    }
    
  }
  public class ConfigMapExtensionNested<N> extends ConfigMapFluent<ConfigMapExtensionNested<N>> implements Nested<N>{
    ConfigMapExtensionNested(ConfigMap item) {
      this.builder = new ConfigMapBuilder(this, item);
    }
    ConfigMapBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endConfigMapExtension() {
      return and();
    }
    
  }
  public class ContainerPortExtensionNested<N> extends ContainerPortFluent<ContainerPortExtensionNested<N>> implements Nested<N>{
    ContainerPortExtensionNested(ContainerPort item) {
      this.builder = new ContainerPortBuilder(this, item);
    }
    ContainerPortBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endContainerPortExtension() {
      return and();
    }
    
  }
  public class ConditionExtensionNested<N> extends ConditionFluent<ConditionExtensionNested<N>> implements Nested<N>{
    ConditionExtensionNested(Condition item) {
      this.builder = new ConditionBuilder(this, item);
    }
    ConditionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endConditionExtension() {
      return and();
    }
    
  }
  public class PodListExtensionNested<N> extends PodListFluent<PodListExtensionNested<N>> implements Nested<N>{
    PodListExtensionNested(PodList item) {
      this.builder = new PodListBuilder(this, item);
    }
    PodListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPodListExtension() {
      return and();
    }
    
  }
  public class FCVolumeSourceExtensionNested<N> extends FCVolumeSourceFluent<FCVolumeSourceExtensionNested<N>> implements Nested<N>{
    FCVolumeSourceExtensionNested(FCVolumeSource item) {
      this.builder = new FCVolumeSourceBuilder(this, item);
    }
    FCVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endFCVolumeSourceExtension() {
      return and();
    }
    
  }
  public class ResourceFieldSelectorExtensionNested<N> extends ResourceFieldSelectorFluent<ResourceFieldSelectorExtensionNested<N>> implements Nested<N>{
    ResourceFieldSelectorExtensionNested(ResourceFieldSelector item) {
      this.builder = new ResourceFieldSelectorBuilder(this, item);
    }
    ResourceFieldSelectorBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endResourceFieldSelectorExtension() {
      return and();
    }
    
  }
  public class PersistentVolumeClaimSpecExtensionNested<N> extends PersistentVolumeClaimSpecFluent<PersistentVolumeClaimSpecExtensionNested<N>> implements Nested<N>{
    PersistentVolumeClaimSpecExtensionNested(PersistentVolumeClaimSpec item) {
      this.builder = new PersistentVolumeClaimSpecBuilder(this, item);
    }
    PersistentVolumeClaimSpecBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPersistentVolumeClaimSpecExtension() {
      return and();
    }
    
  }
  public class LoadBalancerStatusExtensionNested<N> extends LoadBalancerStatusFluent<LoadBalancerStatusExtensionNested<N>> implements Nested<N>{
    LoadBalancerStatusExtensionNested(LoadBalancerStatus item) {
      this.builder = new LoadBalancerStatusBuilder(this, item);
    }
    LoadBalancerStatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endLoadBalancerStatusExtension() {
      return and();
    }
    
  }
  public class PodSecurityContextExtensionNested<N> extends PodSecurityContextFluent<PodSecurityContextExtensionNested<N>> implements Nested<N>{
    PodSecurityContextExtensionNested(PodSecurityContext item) {
      this.builder = new PodSecurityContextBuilder(this, item);
    }
    PodSecurityContextBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPodSecurityContextExtension() {
      return and();
    }
    
  }
  public class ScopeSelectorExtensionNested<N> extends ScopeSelectorFluent<ScopeSelectorExtensionNested<N>> implements Nested<N>{
    ScopeSelectorExtensionNested(ScopeSelector item) {
      this.builder = new ScopeSelectorBuilder(this, item);
    }
    ScopeSelectorBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endScopeSelectorExtension() {
      return and();
    }
    
  }
  public class DownwardAPIProjectionExtensionNested<N> extends DownwardAPIProjectionFluent<DownwardAPIProjectionExtensionNested<N>> implements Nested<N>{
    DownwardAPIProjectionExtensionNested(DownwardAPIProjection item) {
      this.builder = new DownwardAPIProjectionBuilder(this, item);
    }
    DownwardAPIProjectionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endDownwardAPIProjectionExtension() {
      return and();
    }
    
  }
  public class PodAffinityTermExtensionNested<N> extends PodAffinityTermFluent<PodAffinityTermExtensionNested<N>> implements Nested<N>{
    PodAffinityTermExtensionNested(PodAffinityTerm item) {
      this.builder = new PodAffinityTermBuilder(this, item);
    }
    PodAffinityTermBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPodAffinityTermExtension() {
      return and();
    }
    
  }
  public class APIServiceSpecExtensionNested<N> extends APIServiceSpecFluent<APIServiceSpecExtensionNested<N>> implements Nested<N>{
    APIServiceSpecExtensionNested(APIServiceSpec item) {
      this.builder = new APIServiceSpecBuilder(this, item);
    }
    APIServiceSpecBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endAPIServiceSpecExtension() {
      return and();
    }
    
  }
  public class ServicePortExtensionNested<N> extends ServicePortFluent<ServicePortExtensionNested<N>> implements Nested<N>{
    ServicePortExtensionNested(ServicePort item) {
      this.builder = new ServicePortBuilder(this, item);
    }
    ServicePortBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endServicePortExtension() {
      return and();
    }
    
  }
  public class GroupVersionForDiscoveryExtensionNested<N> extends GroupVersionForDiscoveryFluent<GroupVersionForDiscoveryExtensionNested<N>> implements Nested<N>{
    GroupVersionForDiscoveryExtensionNested(GroupVersionForDiscovery item) {
      this.builder = new GroupVersionForDiscoveryBuilder(this, item);
    }
    GroupVersionForDiscoveryBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endGroupVersionForDiscoveryExtension() {
      return and();
    }
    
  }
  public class ClaimSourceExtensionNested<N> extends ClaimSourceFluent<ClaimSourceExtensionNested<N>> implements Nested<N>{
    ClaimSourceExtensionNested(ClaimSource item) {
      this.builder = new ClaimSourceBuilder(this, item);
    }
    ClaimSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endClaimSourceExtension() {
      return and();
    }
    
  }
  public class PersistentVolumeClaimSourceExtensionNested<N> extends PersistentVolumeClaimVolumeSourceFluent<PersistentVolumeClaimSourceExtensionNested<N>> implements Nested<N>{
    PersistentVolumeClaimSourceExtensionNested(PersistentVolumeClaimVolumeSource item) {
      this.builder = new PersistentVolumeClaimVolumeSourceBuilder(this, item);
    }
    PersistentVolumeClaimVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPersistentVolumeClaimSourceExtension() {
      return and();
    }
    
  }
  public class SessionAffinityConfigExtensionNested<N> extends SessionAffinityConfigFluent<SessionAffinityConfigExtensionNested<N>> implements Nested<N>{
    SessionAffinityConfigExtensionNested(SessionAffinityConfig item) {
      this.builder = new SessionAffinityConfigBuilder(this, item);
    }
    SessionAffinityConfigBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endSessionAffinityConfigExtension() {
      return and();
    }
    
  }
  public class ServiceAccountListExtensionNested<N> extends ServiceAccountListFluent<ServiceAccountListExtensionNested<N>> implements Nested<N>{
    ServiceAccountListExtensionNested(ServiceAccountList item) {
      this.builder = new ServiceAccountListBuilder(this, item);
    }
    ServiceAccountListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endServiceAccountListExtension() {
      return and();
    }
    
  }
  public class ComponentStatusExtensionNested<N> extends ComponentStatusFluent<ComponentStatusExtensionNested<N>> implements Nested<N>{
    ComponentStatusExtensionNested(ComponentStatus item) {
      this.builder = new ComponentStatusBuilder(this, item);
    }
    ComponentStatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endComponentStatusExtension() {
      return and();
    }
    
  }
  public class DaemonEndpointExtensionNested<N> extends DaemonEndpointFluent<DaemonEndpointExtensionNested<N>> implements Nested<N>{
    DaemonEndpointExtensionNested(DaemonEndpoint item) {
      this.builder = new DaemonEndpointBuilder(this, item);
    }
    DaemonEndpointBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endDaemonEndpointExtension() {
      return and();
    }
    
  }
  public class KeyToPathExtensionNested<N> extends KeyToPathFluent<KeyToPathExtensionNested<N>> implements Nested<N>{
    KeyToPathExtensionNested(KeyToPath item) {
      this.builder = new KeyToPathBuilder(this, item);
    }
    KeyToPathBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endKeyToPathExtension() {
      return and();
    }
    
  }
  public class FlexPersistentVolumeSourceExtensionNested<N> extends FlexPersistentVolumeSourceFluent<FlexPersistentVolumeSourceExtensionNested<N>> implements Nested<N>{
    FlexPersistentVolumeSourceExtensionNested(FlexPersistentVolumeSource item) {
      this.builder = new FlexPersistentVolumeSourceBuilder(this, item);
    }
    FlexPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endFlexPersistentVolumeSourceExtension() {
      return and();
    }
    
  }
  public class NamespaceListExtensionNested<N> extends NamespaceListFluent<NamespaceListExtensionNested<N>> implements Nested<N>{
    NamespaceListExtensionNested(NamespaceList item) {
      this.builder = new NamespaceListBuilder(this, item);
    }
    NamespaceListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endNamespaceListExtension() {
      return and();
    }
    
  }
  public class PodDNSConfigExtensionNested<N> extends PodDNSConfigFluent<PodDNSConfigExtensionNested<N>> implements Nested<N>{
    PodDNSConfigExtensionNested(PodDNSConfig item) {
      this.builder = new PodDNSConfigBuilder(this, item);
    }
    PodDNSConfigBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPodDNSConfigExtension() {
      return and();
    }
    
  }
  public class NodeListExtensionNested<N> extends NodeListFluent<NodeListExtensionNested<N>> implements Nested<N>{
    NodeListExtensionNested(NodeList item) {
      this.builder = new NodeListBuilder(this, item);
    }
    NodeListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endNodeListExtension() {
      return and();
    }
    
  }
  public class BindingExtensionNested<N> extends BindingFluent<BindingExtensionNested<N>> implements Nested<N>{
    BindingExtensionNested(Binding item) {
      this.builder = new BindingBuilder(this, item);
    }
    BindingBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endBindingExtension() {
      return and();
    }
    
  }
  public class EnvVarSourceExtensionNested<N> extends EnvVarSourceFluent<EnvVarSourceExtensionNested<N>> implements Nested<N>{
    EnvVarSourceExtensionNested(EnvVarSource item) {
      this.builder = new EnvVarSourceBuilder(this, item);
    }
    EnvVarSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endEnvVarSourceExtension() {
      return and();
    }
    
  }
  public class VolumeProjectionExtensionNested<N> extends VolumeProjectionFluent<VolumeProjectionExtensionNested<N>> implements Nested<N>{
    VolumeProjectionExtensionNested(VolumeProjection item) {
      this.builder = new VolumeProjectionBuilder(this, item);
    }
    VolumeProjectionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endVolumeProjectionExtension() {
      return and();
    }
    
  }
  public class ResourceQuotaExtensionNested<N> extends ResourceQuotaFluent<ResourceQuotaExtensionNested<N>> implements Nested<N>{
    ResourceQuotaExtensionNested(ResourceQuota item) {
      this.builder = new ResourceQuotaBuilder(this, item);
    }
    ResourceQuotaBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endResourceQuotaExtension() {
      return and();
    }
    
  }
  public class SecretExtensionNested<N> extends SecretFluent<SecretExtensionNested<N>> implements Nested<N>{
    SecretExtensionNested(Secret item) {
      this.builder = new SecretBuilder(this, item);
    }
    SecretBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endSecretExtension() {
      return and();
    }
    
  }
  public class ServiceListExtensionNested<N> extends ServiceListFluent<ServiceListExtensionNested<N>> implements Nested<N>{
    ServiceListExtensionNested(ServiceList item) {
      this.builder = new ServiceListBuilder(this, item);
    }
    ServiceListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endServiceListExtension() {
      return and();
    }
    
  }
  public class VolumeNodeAffinityExtensionNested<N> extends VolumeNodeAffinityFluent<VolumeNodeAffinityExtensionNested<N>> implements Nested<N>{
    VolumeNodeAffinityExtensionNested(VolumeNodeAffinity item) {
      this.builder = new VolumeNodeAffinityBuilder(this, item);
    }
    VolumeNodeAffinityBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endVolumeNodeAffinityExtension() {
      return and();
    }
    
  }
  public class ResourceQuotaSpecExtensionNested<N> extends ResourceQuotaSpecFluent<ResourceQuotaSpecExtensionNested<N>> implements Nested<N>{
    ResourceQuotaSpecExtensionNested(ResourceQuotaSpec item) {
      this.builder = new ResourceQuotaSpecBuilder(this, item);
    }
    ResourceQuotaSpecBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endResourceQuotaSpecExtension() {
      return and();
    }
    
  }
  public class NodeSelectorTermExtensionNested<N> extends NodeSelectorTermFluent<NodeSelectorTermExtensionNested<N>> implements Nested<N>{
    NodeSelectorTermExtensionNested(NodeSelectorTerm item) {
      this.builder = new NodeSelectorTermBuilder(this, item);
    }
    NodeSelectorTermBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endNodeSelectorTermExtension() {
      return and();
    }
    
  }
  public class ScaleIOPersistentVolumeSourceExtensionNested<N> extends ScaleIOPersistentVolumeSourceFluent<ScaleIOPersistentVolumeSourceExtensionNested<N>> implements Nested<N>{
    ScaleIOPersistentVolumeSourceExtensionNested(ScaleIOPersistentVolumeSource item) {
      this.builder = new ScaleIOPersistentVolumeSourceBuilder(this, item);
    }
    ScaleIOPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endScaleIOPersistentVolumeSourceExtension() {
      return and();
    }
    
  }
  public class ListOptionsExtensionNested<N> extends ListOptionsFluent<ListOptionsExtensionNested<N>> implements Nested<N>{
    ListOptionsExtensionNested(ListOptions item) {
      this.builder = new ListOptionsBuilder(this, item);
    }
    ListOptionsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endListOptionsExtension() {
      return and();
    }
    
  }
  public class WeightedPodAffinityTermExtensionNested<N> extends WeightedPodAffinityTermFluent<WeightedPodAffinityTermExtensionNested<N>> implements Nested<N>{
    WeightedPodAffinityTermExtensionNested(WeightedPodAffinityTerm item) {
      this.builder = new WeightedPodAffinityTermBuilder(this, item);
    }
    WeightedPodAffinityTermBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endWeightedPodAffinityTermExtension() {
      return and();
    }
    
  }
  public class TypedObjectReferenceExtensionNested<N> extends TypedObjectReferenceFluent<TypedObjectReferenceExtensionNested<N>> implements Nested<N>{
    TypedObjectReferenceExtensionNested(TypedObjectReference item) {
      this.builder = new TypedObjectReferenceBuilder(this, item);
    }
    TypedObjectReferenceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endTypedObjectReferenceExtension() {
      return and();
    }
    
  }
  public class ContainerResizePolicyExtensionNested<N> extends ContainerResizePolicyFluent<ContainerResizePolicyExtensionNested<N>> implements Nested<N>{
    ContainerResizePolicyExtensionNested(ContainerResizePolicy item) {
      this.builder = new ContainerResizePolicyBuilder(this, item);
    }
    ContainerResizePolicyBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endContainerResizePolicyExtension() {
      return and();
    }
    
  }
  public class NodeSystemInfoExtensionNested<N> extends NodeSystemInfoFluent<NodeSystemInfoExtensionNested<N>> implements Nested<N>{
    NodeSystemInfoExtensionNested(NodeSystemInfo item) {
      this.builder = new NodeSystemInfoBuilder(this, item);
    }
    NodeSystemInfoBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endNodeSystemInfoExtension() {
      return and();
    }
    
  }
  public class TopologySelectorLabelRequirementExtensionNested<N> extends TopologySelectorLabelRequirementFluent<TopologySelectorLabelRequirementExtensionNested<N>> implements Nested<N>{
    TopologySelectorLabelRequirementExtensionNested(TopologySelectorLabelRequirement item) {
      this.builder = new TopologySelectorLabelRequirementBuilder(this, item);
    }
    TopologySelectorLabelRequirementBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endTopologySelectorLabelRequirementExtension() {
      return and();
    }
    
  }
  public class RBDPersistentVolumeSourceExtensionNested<N> extends RBDPersistentVolumeSourceFluent<RBDPersistentVolumeSourceExtensionNested<N>> implements Nested<N>{
    RBDPersistentVolumeSourceExtensionNested(RBDPersistentVolumeSource item) {
      this.builder = new RBDPersistentVolumeSourceBuilder(this, item);
    }
    RBDPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endRBDPersistentVolumeSourceExtension() {
      return and();
    }
    
  }
  public class AuthProviderConfigExtensionNested<N> extends AuthProviderConfigFluent<AuthProviderConfigExtensionNested<N>> implements Nested<N>{
    AuthProviderConfigExtensionNested(AuthProviderConfig item) {
      this.builder = new AuthProviderConfigBuilder(this, item);
    }
    AuthProviderConfigBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endAuthProviderConfigExtension() {
      return and();
    }
    
  }
  public class SELinuxOptionsExtensionNested<N> extends SELinuxOptionsFluent<SELinuxOptionsExtensionNested<N>> implements Nested<N>{
    SELinuxOptionsExtensionNested(SELinuxOptions item) {
      this.builder = new SELinuxOptionsBuilder(this, item);
    }
    SELinuxOptionsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endSELinuxOptionsExtension() {
      return and();
    }
    
  }
  public class HostAliasExtensionNested<N> extends HostAliasFluent<HostAliasExtensionNested<N>> implements Nested<N>{
    HostAliasExtensionNested(HostAlias item) {
      this.builder = new HostAliasBuilder(this, item);
    }
    HostAliasBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endHostAliasExtension() {
      return and();
    }
    
  }
  public class NodeDaemonEndpointsExtensionNested<N> extends NodeDaemonEndpointsFluent<NodeDaemonEndpointsExtensionNested<N>> implements Nested<N>{
    NodeDaemonEndpointsExtensionNested(NodeDaemonEndpoints item) {
      this.builder = new NodeDaemonEndpointsBuilder(this, item);
    }
    NodeDaemonEndpointsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endNodeDaemonEndpointsExtension() {
      return and();
    }
    
  }
  public class VolumeDeviceExtensionNested<N> extends VolumeDeviceFluent<VolumeDeviceExtensionNested<N>> implements Nested<N>{
    VolumeDeviceExtensionNested(VolumeDevice item) {
      this.builder = new VolumeDeviceBuilder(this, item);
    }
    VolumeDeviceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endVolumeDeviceExtension() {
      return and();
    }
    
  }
  public class CSIVolumeSourceExtensionNested<N> extends CSIVolumeSourceFluent<CSIVolumeSourceExtensionNested<N>> implements Nested<N>{
    CSIVolumeSourceExtensionNested(CSIVolumeSource item) {
      this.builder = new CSIVolumeSourceBuilder(this, item);
    }
    CSIVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endCSIVolumeSourceExtension() {
      return and();
    }
    
  }
  public class PersistentVolumeSpecExtensionNested<N> extends PersistentVolumeSpecFluent<PersistentVolumeSpecExtensionNested<N>> implements Nested<N>{
    PersistentVolumeSpecExtensionNested(PersistentVolumeSpec item) {
      this.builder = new PersistentVolumeSpecBuilder(this, item);
    }
    PersistentVolumeSpecBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPersistentVolumeSpecExtension() {
      return and();
    }
    
  }
  public class NodeExtensionNested<N> extends NodeFluent<NodeExtensionNested<N>> implements Nested<N>{
    NodeExtensionNested(Node item) {
      this.builder = new NodeBuilder(this, item);
    }
    NodeBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endNodeExtension() {
      return and();
    }
    
  }
  public class LifecycleHandlerExtensionNested<N> extends LifecycleHandlerFluent<LifecycleHandlerExtensionNested<N>> implements Nested<N>{
    LifecycleHandlerExtensionNested(LifecycleHandler item) {
      this.builder = new LifecycleHandlerBuilder(this, item);
    }
    LifecycleHandlerBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endLifecycleHandlerExtension() {
      return and();
    }
    
  }
  public class VolumeExtensionNested<N> extends VolumeFluent<VolumeExtensionNested<N>> implements Nested<N>{
    VolumeExtensionNested(Volume item) {
      this.builder = new VolumeBuilder(this, item);
    }
    VolumeBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endVolumeExtension() {
      return and();
    }
    
  }
  public class ClusterExtensionNested<N> extends ClusterFluent<ClusterExtensionNested<N>> implements Nested<N>{
    ClusterExtensionNested(Cluster item) {
      this.builder = new ClusterBuilder(this, item);
    }
    ClusterBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endClusterExtension() {
      return and();
    }
    
  }
  public class NFSVolumeSourceExtensionNested<N> extends NFSVolumeSourceFluent<NFSVolumeSourceExtensionNested<N>> implements Nested<N>{
    NFSVolumeSourceExtensionNested(NFSVolumeSource item) {
      this.builder = new NFSVolumeSourceBuilder(this, item);
    }
    NFSVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endNFSVolumeSourceExtension() {
      return and();
    }
    
  }
  public class StorageOSVolumeSourceExtensionNested<N> extends StorageOSVolumeSourceFluent<StorageOSVolumeSourceExtensionNested<N>> implements Nested<N>{
    StorageOSVolumeSourceExtensionNested(StorageOSVolumeSource item) {
      this.builder = new StorageOSVolumeSourceBuilder(this, item);
    }
    StorageOSVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endStorageOSVolumeSourceExtension() {
      return and();
    }
    
  }
  public class PodStatusExtensionNested<N> extends PodStatusFluent<PodStatusExtensionNested<N>> implements Nested<N>{
    PodStatusExtensionNested(PodStatus item) {
      this.builder = new PodStatusBuilder(this, item);
    }
    PodStatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPodStatusExtension() {
      return and();
    }
    
  }
  public class KubernetesListExtensionNested<N> extends KubernetesListFluent<KubernetesListExtensionNested<N>> implements Nested<N>{
    KubernetesListExtensionNested(KubernetesList item) {
      this.builder = new KubernetesListBuilder(this, item);
    }
    KubernetesListBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endKubernetesListExtension() {
      return and();
    }
    
  }
  public class ExecConfigExtensionNested<N> extends ExecConfigFluent<ExecConfigExtensionNested<N>> implements Nested<N>{
    ExecConfigExtensionNested(ExecConfig item) {
      this.builder = new ExecConfigBuilder(this, item);
    }
    ExecConfigBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endExecConfigExtension() {
      return and();
    }
    
  }
  public class PersistentVolumeStatusExtensionNested<N> extends PersistentVolumeStatusFluent<PersistentVolumeStatusExtensionNested<N>> implements Nested<N>{
    PersistentVolumeStatusExtensionNested(PersistentVolumeStatus item) {
      this.builder = new PersistentVolumeStatusBuilder(this, item);
    }
    PersistentVolumeStatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPersistentVolumeStatusExtension() {
      return and();
    }
    
  }
  public class EndpointPortExtensionNested<N> extends EndpointPortFluent<EndpointPortExtensionNested<N>> implements Nested<N>{
    EndpointPortExtensionNested(EndpointPort item) {
      this.builder = new EndpointPortBuilder(this, item);
    }
    EndpointPortBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endEndpointPortExtension() {
      return and();
    }
    
  }
  public class HTTPHeaderExtensionNested<N> extends HTTPHeaderFluent<HTTPHeaderExtensionNested<N>> implements Nested<N>{
    HTTPHeaderExtensionNested(HTTPHeader item) {
      this.builder = new HTTPHeaderBuilder(this, item);
    }
    HTTPHeaderBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endHTTPHeaderExtension() {
      return and();
    }
    
  }
  public class CapabilitiesExtensionNested<N> extends CapabilitiesFluent<CapabilitiesExtensionNested<N>> implements Nested<N>{
    CapabilitiesExtensionNested(Capabilities item) {
      this.builder = new CapabilitiesBuilder(this, item);
    }
    CapabilitiesBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endCapabilitiesExtension() {
      return and();
    }
    
  }
  public class ObjectReferenceExtensionNested<N> extends ObjectReferenceFluent<ObjectReferenceExtensionNested<N>> implements Nested<N>{
    ObjectReferenceExtensionNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endObjectReferenceExtension() {
      return and();
    }
    
  }
  public class WatchEventExtensionNested<N> extends WatchEventFluent<WatchEventExtensionNested<N>> implements Nested<N>{
    WatchEventExtensionNested(WatchEvent item) {
      this.builder = new WatchEventBuilder(this, item);
    }
    WatchEventBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endWatchEventExtension() {
      return and();
    }
    
  }
  public class LimitRangeItemExtensionNested<N> extends LimitRangeItemFluent<LimitRangeItemExtensionNested<N>> implements Nested<N>{
    LimitRangeItemExtensionNested(LimitRangeItem item) {
      this.builder = new LimitRangeItemBuilder(this, item);
    }
    LimitRangeItemBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endLimitRangeItemExtension() {
      return and();
    }
    
  }
  public class SecretProjectionExtensionNested<N> extends SecretProjectionFluent<SecretProjectionExtensionNested<N>> implements Nested<N>{
    SecretProjectionExtensionNested(SecretProjection item) {
      this.builder = new SecretProjectionBuilder(this, item);
    }
    SecretProjectionBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endSecretProjectionExtension() {
      return and();
    }
    
  }
  public class GetOptionsExtensionNested<N> extends GetOptionsFluent<GetOptionsExtensionNested<N>> implements Nested<N>{
    GetOptionsExtensionNested(GetOptions item) {
      this.builder = new GetOptionsBuilder(this, item);
    }
    GetOptionsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endGetOptionsExtension() {
      return and();
    }
    
  }
  public class GlusterfsVolumeSourceExtensionNested<N> extends GlusterfsVolumeSourceFluent<GlusterfsVolumeSourceExtensionNested<N>> implements Nested<N>{
    GlusterfsVolumeSourceExtensionNested(GlusterfsVolumeSource item) {
      this.builder = new GlusterfsVolumeSourceBuilder(this, item);
    }
    GlusterfsVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endGlusterfsVolumeSourceExtension() {
      return and();
    }
    
  }
  public class ManagedFieldsEntryExtensionNested<N> extends ManagedFieldsEntryFluent<ManagedFieldsEntryExtensionNested<N>> implements Nested<N>{
    ManagedFieldsEntryExtensionNested(ManagedFieldsEntry item) {
      this.builder = new ManagedFieldsEntryBuilder(this, item);
    }
    ManagedFieldsEntryBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endManagedFieldsEntryExtension() {
      return and();
    }
    
  }
  public class NamespaceStatusExtensionNested<N> extends NamespaceStatusFluent<NamespaceStatusExtensionNested<N>> implements Nested<N>{
    NamespaceStatusExtensionNested(NamespaceStatus item) {
      this.builder = new NamespaceStatusBuilder(this, item);
    }
    NamespaceStatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endNamespaceStatusExtension() {
      return and();
    }
    
  }
  public class SecretEnvSourceExtensionNested<N> extends SecretEnvSourceFluent<SecretEnvSourceExtensionNested<N>> implements Nested<N>{
    SecretEnvSourceExtensionNested(SecretEnvSource item) {
      this.builder = new SecretEnvSourceBuilder(this, item);
    }
    SecretEnvSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endSecretEnvSourceExtension() {
      return and();
    }
    
  }
  public class ServiceAccountExtensionNested<N> extends ServiceAccountFluent<ServiceAccountExtensionNested<N>> implements Nested<N>{
    ServiceAccountExtensionNested(ServiceAccount item) {
      this.builder = new ServiceAccountBuilder(this, item);
    }
    ServiceAccountBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endServiceAccountExtension() {
      return and();
    }
    
  }
  public class AWSElasticBlockStoreVolumeSourceExtensionNested<N> extends AWSElasticBlockStoreVolumeSourceFluent<AWSElasticBlockStoreVolumeSourceExtensionNested<N>> implements Nested<N>{
    AWSElasticBlockStoreVolumeSourceExtensionNested(AWSElasticBlockStoreVolumeSource item) {
      this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this, item);
    }
    AWSElasticBlockStoreVolumeSourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endAWSElasticBlockStoreVolumeSourceExtension() {
      return and();
    }
    
  }
  public class PodIPExtensionNested<N> extends PodIPFluent<PodIPExtensionNested<N>> implements Nested<N>{
    PodIPExtensionNested(PodIP item) {
      this.builder = new PodIPBuilder(this, item);
    }
    PodIPBuilder builder;
    public N and() {
      return (N) NamedExtensionFluent.this.withExtension(builder.build());
    }
    public N endPodIPExtension() {
      return and();
    }
    
  }
  
}