package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NamedContextBuilder extends NamedContextFluent<NamedContextBuilder> implements VisitableBuilder<NamedContext,NamedContextBuilder>{
  public NamedContextBuilder() {
    this(false);
  }
  public NamedContextBuilder(Boolean validationEnabled) {
    this(new NamedContext(), validationEnabled);
  }
  public NamedContextBuilder(NamedContextFluent<?> fluent) {
    this(fluent, false);
  }
  public NamedContextBuilder(NamedContextFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NamedContext(), validationEnabled);
  }
  public NamedContextBuilder(NamedContextFluent<?> fluent,NamedContext instance) {
    this(fluent, instance, false);
  }
  public NamedContextBuilder(NamedContextFluent<?> fluent,NamedContext instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NamedContext());

    if (instance != null) {
      fluent.withContext(instance.getContext());
      fluent.withName(instance.getName());
      fluent.withContext(instance.getContext());
      fluent.withName(instance.getName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NamedContextBuilder(NamedContext instance) {
    this(instance,false);
  }
  public NamedContextBuilder(NamedContext instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NamedContext());

    if (instance != null) {
      this.withContext(instance.getContext());
      this.withName(instance.getName());
      this.withContext(instance.getContext());
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NamedContextFluent<?> fluent;
  Boolean validationEnabled;
  public NamedContext build() {
    NamedContext buildable = new NamedContext(fluent.buildContext(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}