package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LoadBalancerIngressBuilder extends LoadBalancerIngressFluent<LoadBalancerIngressBuilder> implements VisitableBuilder<LoadBalancerIngress,LoadBalancerIngressBuilder>{
  public LoadBalancerIngressBuilder() {
    this(false);
  }
  public LoadBalancerIngressBuilder(Boolean validationEnabled) {
    this(new LoadBalancerIngress(), validationEnabled);
  }
  public LoadBalancerIngressBuilder(LoadBalancerIngressFluent<?> fluent) {
    this(fluent, false);
  }
  public LoadBalancerIngressBuilder(LoadBalancerIngressFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LoadBalancerIngress(), validationEnabled);
  }
  public LoadBalancerIngressBuilder(LoadBalancerIngressFluent<?> fluent,LoadBalancerIngress instance) {
    this(fluent, instance, false);
  }
  public LoadBalancerIngressBuilder(LoadBalancerIngressFluent<?> fluent,LoadBalancerIngress instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new LoadBalancerIngress());

    if (instance != null) {
      fluent.withHostname(instance.getHostname());
      fluent.withIp(instance.getIp());
      fluent.withPorts(instance.getPorts());
      fluent.withHostname(instance.getHostname());
      fluent.withIp(instance.getIp());
      fluent.withPorts(instance.getPorts());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public LoadBalancerIngressBuilder(LoadBalancerIngress instance) {
    this(instance,false);
  }
  public LoadBalancerIngressBuilder(LoadBalancerIngress instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new LoadBalancerIngress());

    if (instance != null) {
      this.withHostname(instance.getHostname());
      this.withIp(instance.getIp());
      this.withPorts(instance.getPorts());
      this.withHostname(instance.getHostname());
      this.withIp(instance.getIp());
      this.withPorts(instance.getPorts());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  LoadBalancerIngressFluent<?> fluent;
  Boolean validationEnabled;
  public LoadBalancerIngress build() {
    LoadBalancerIngress buildable = new LoadBalancerIngress(fluent.getHostname(),fluent.getIp(),fluent.buildPorts());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}