package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LabelSelectorRequirementBuilder extends LabelSelectorRequirementFluent<LabelSelectorRequirementBuilder> implements VisitableBuilder<LabelSelectorRequirement,LabelSelectorRequirementBuilder>{
  public LabelSelectorRequirementBuilder() {
    this(false);
  }
  public LabelSelectorRequirementBuilder(Boolean validationEnabled) {
    this(new LabelSelectorRequirement(), validationEnabled);
  }
  public LabelSelectorRequirementBuilder(LabelSelectorRequirementFluent<?> fluent) {
    this(fluent, false);
  }
  public LabelSelectorRequirementBuilder(LabelSelectorRequirementFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LabelSelectorRequirement(), validationEnabled);
  }
  public LabelSelectorRequirementBuilder(LabelSelectorRequirementFluent<?> fluent,LabelSelectorRequirement instance) {
    this(fluent, instance, false);
  }
  public LabelSelectorRequirementBuilder(LabelSelectorRequirementFluent<?> fluent,LabelSelectorRequirement instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new LabelSelectorRequirement());

    if (instance != null) {
      fluent.withKey(instance.getKey());
      fluent.withOperator(instance.getOperator());
      fluent.withValues(instance.getValues());
      fluent.withKey(instance.getKey());
      fluent.withOperator(instance.getOperator());
      fluent.withValues(instance.getValues());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public LabelSelectorRequirementBuilder(LabelSelectorRequirement instance) {
    this(instance,false);
  }
  public LabelSelectorRequirementBuilder(LabelSelectorRequirement instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new LabelSelectorRequirement());

    if (instance != null) {
      this.withKey(instance.getKey());
      this.withOperator(instance.getOperator());
      this.withValues(instance.getValues());
      this.withKey(instance.getKey());
      this.withOperator(instance.getOperator());
      this.withValues(instance.getValues());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  LabelSelectorRequirementFluent<?> fluent;
  Boolean validationEnabled;
  public LabelSelectorRequirement build() {
    LabelSelectorRequirement buildable = new LabelSelectorRequirement(fluent.getKey(),fluent.getOperator(),fluent.getValues());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}