package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FlexPersistentVolumeSourceBuilder extends FlexPersistentVolumeSourceFluent<FlexPersistentVolumeSourceBuilder> implements VisitableBuilder<FlexPersistentVolumeSource,FlexPersistentVolumeSourceBuilder>{
  public FlexPersistentVolumeSourceBuilder() {
    this(false);
  }
  public FlexPersistentVolumeSourceBuilder(Boolean validationEnabled) {
    this(new FlexPersistentVolumeSource(), validationEnabled);
  }
  public FlexPersistentVolumeSourceBuilder(FlexPersistentVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public FlexPersistentVolumeSourceBuilder(FlexPersistentVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new FlexPersistentVolumeSource(), validationEnabled);
  }
  public FlexPersistentVolumeSourceBuilder(FlexPersistentVolumeSourceFluent<?> fluent,FlexPersistentVolumeSource instance) {
    this(fluent, instance, false);
  }
  public FlexPersistentVolumeSourceBuilder(FlexPersistentVolumeSourceFluent<?> fluent,FlexPersistentVolumeSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new FlexPersistentVolumeSource());

    if (instance != null) {
      fluent.withDriver(instance.getDriver());
      fluent.withFsType(instance.getFsType());
      fluent.withOptions(instance.getOptions());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withSecretRef(instance.getSecretRef());
      fluent.withDriver(instance.getDriver());
      fluent.withFsType(instance.getFsType());
      fluent.withOptions(instance.getOptions());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withSecretRef(instance.getSecretRef());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public FlexPersistentVolumeSourceBuilder(FlexPersistentVolumeSource instance) {
    this(instance,false);
  }
  public FlexPersistentVolumeSourceBuilder(FlexPersistentVolumeSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new FlexPersistentVolumeSource());

    if (instance != null) {
      this.withDriver(instance.getDriver());
      this.withFsType(instance.getFsType());
      this.withOptions(instance.getOptions());
      this.withReadOnly(instance.getReadOnly());
      this.withSecretRef(instance.getSecretRef());
      this.withDriver(instance.getDriver());
      this.withFsType(instance.getFsType());
      this.withOptions(instance.getOptions());
      this.withReadOnly(instance.getReadOnly());
      this.withSecretRef(instance.getSecretRef());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  FlexPersistentVolumeSourceFluent<?> fluent;
  Boolean validationEnabled;
  public FlexPersistentVolumeSource build() {
    FlexPersistentVolumeSource buildable = new FlexPersistentVolumeSource(fluent.getDriver(),fluent.getFsType(),fluent.getOptions(),fluent.getReadOnly(),fluent.buildSecretRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}