package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EnvVarSourceFluent<A extends EnvVarSourceFluent<A>> extends BaseFluent<A>{
  public EnvVarSourceFluent() {
  }
  public EnvVarSourceFluent(EnvVarSource instance) {
    instance = (instance != null ? instance : new EnvVarSource());

    if (instance != null) {
      this.withConfigMapKeyRef(instance.getConfigMapKeyRef());
      this.withFieldRef(instance.getFieldRef());
      this.withResourceFieldRef(instance.getResourceFieldRef());
      this.withSecretKeyRef(instance.getSecretKeyRef());
      this.withConfigMapKeyRef(instance.getConfigMapKeyRef());
      this.withFieldRef(instance.getFieldRef());
      this.withResourceFieldRef(instance.getResourceFieldRef());
      this.withSecretKeyRef(instance.getSecretKeyRef());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ConfigMapKeySelectorBuilder configMapKeyRef;
  private ObjectFieldSelectorBuilder fieldRef;
  private ResourceFieldSelectorBuilder resourceFieldRef;
  private SecretKeySelectorBuilder secretKeyRef;
  private Map<String,Object> additionalProperties;
  public ConfigMapKeySelector buildConfigMapKeyRef() {
    return this.configMapKeyRef!=null ?this.configMapKeyRef.build():null;
  }
  public A withConfigMapKeyRef(ConfigMapKeySelector configMapKeyRef) {
    _visitables.get("configMapKeyRef").remove(this.configMapKeyRef);
    if (configMapKeyRef!=null){ this.configMapKeyRef= new ConfigMapKeySelectorBuilder(configMapKeyRef); _visitables.get("configMapKeyRef").add(this.configMapKeyRef);} else { this.configMapKeyRef = null; _visitables.get("configMapKeyRef").remove(this.configMapKeyRef); } return (A) this;
  }
  public boolean hasConfigMapKeyRef() {
    return this.configMapKeyRef != null;
  }
  public A withNewConfigMapKeyRef(String key,String name,Boolean optional) {
    return (A)withConfigMapKeyRef(new ConfigMapKeySelector(key, name, optional));
  }
  public ConfigMapKeyRefNested<A> withNewConfigMapKeyRef() {
    return new ConfigMapKeyRefNested(null);
  }
  public ConfigMapKeyRefNested<A> withNewConfigMapKeyRefLike(ConfigMapKeySelector item) {
    return new ConfigMapKeyRefNested(item);
  }
  public ConfigMapKeyRefNested<A> editConfigMapKeyRef() {
    return withNewConfigMapKeyRefLike(java.util.Optional.ofNullable(buildConfigMapKeyRef()).orElse(null));
  }
  public ConfigMapKeyRefNested<A> editOrNewConfigMapKeyRef() {
    return withNewConfigMapKeyRefLike(java.util.Optional.ofNullable(buildConfigMapKeyRef()).orElse(new ConfigMapKeySelectorBuilder().build()));
  }
  public ConfigMapKeyRefNested<A> editOrNewConfigMapKeyRefLike(ConfigMapKeySelector item) {
    return withNewConfigMapKeyRefLike(java.util.Optional.ofNullable(buildConfigMapKeyRef()).orElse(item));
  }
  public ObjectFieldSelector buildFieldRef() {
    return this.fieldRef!=null ?this.fieldRef.build():null;
  }
  public A withFieldRef(ObjectFieldSelector fieldRef) {
    _visitables.get("fieldRef").remove(this.fieldRef);
    if (fieldRef!=null){ this.fieldRef= new ObjectFieldSelectorBuilder(fieldRef); _visitables.get("fieldRef").add(this.fieldRef);} else { this.fieldRef = null; _visitables.get("fieldRef").remove(this.fieldRef); } return (A) this;
  }
  public boolean hasFieldRef() {
    return this.fieldRef != null;
  }
  public A withNewFieldRef(String apiVersion,String fieldPath) {
    return (A)withFieldRef(new ObjectFieldSelector(apiVersion, fieldPath));
  }
  public FieldRefNested<A> withNewFieldRef() {
    return new FieldRefNested(null);
  }
  public FieldRefNested<A> withNewFieldRefLike(ObjectFieldSelector item) {
    return new FieldRefNested(item);
  }
  public FieldRefNested<A> editFieldRef() {
    return withNewFieldRefLike(java.util.Optional.ofNullable(buildFieldRef()).orElse(null));
  }
  public FieldRefNested<A> editOrNewFieldRef() {
    return withNewFieldRefLike(java.util.Optional.ofNullable(buildFieldRef()).orElse(new ObjectFieldSelectorBuilder().build()));
  }
  public FieldRefNested<A> editOrNewFieldRefLike(ObjectFieldSelector item) {
    return withNewFieldRefLike(java.util.Optional.ofNullable(buildFieldRef()).orElse(item));
  }
  public ResourceFieldSelector buildResourceFieldRef() {
    return this.resourceFieldRef!=null ?this.resourceFieldRef.build():null;
  }
  public A withResourceFieldRef(ResourceFieldSelector resourceFieldRef) {
    _visitables.get("resourceFieldRef").remove(this.resourceFieldRef);
    if (resourceFieldRef!=null){ this.resourceFieldRef= new ResourceFieldSelectorBuilder(resourceFieldRef); _visitables.get("resourceFieldRef").add(this.resourceFieldRef);} else { this.resourceFieldRef = null; _visitables.get("resourceFieldRef").remove(this.resourceFieldRef); } return (A) this;
  }
  public boolean hasResourceFieldRef() {
    return this.resourceFieldRef != null;
  }
  public ResourceFieldRefNested<A> withNewResourceFieldRef() {
    return new ResourceFieldRefNested(null);
  }
  public ResourceFieldRefNested<A> withNewResourceFieldRefLike(ResourceFieldSelector item) {
    return new ResourceFieldRefNested(item);
  }
  public ResourceFieldRefNested<A> editResourceFieldRef() {
    return withNewResourceFieldRefLike(java.util.Optional.ofNullable(buildResourceFieldRef()).orElse(null));
  }
  public ResourceFieldRefNested<A> editOrNewResourceFieldRef() {
    return withNewResourceFieldRefLike(java.util.Optional.ofNullable(buildResourceFieldRef()).orElse(new ResourceFieldSelectorBuilder().build()));
  }
  public ResourceFieldRefNested<A> editOrNewResourceFieldRefLike(ResourceFieldSelector item) {
    return withNewResourceFieldRefLike(java.util.Optional.ofNullable(buildResourceFieldRef()).orElse(item));
  }
  public SecretKeySelector buildSecretKeyRef() {
    return this.secretKeyRef!=null ?this.secretKeyRef.build():null;
  }
  public A withSecretKeyRef(SecretKeySelector secretKeyRef) {
    _visitables.get("secretKeyRef").remove(this.secretKeyRef);
    if (secretKeyRef!=null){ this.secretKeyRef= new SecretKeySelectorBuilder(secretKeyRef); _visitables.get("secretKeyRef").add(this.secretKeyRef);} else { this.secretKeyRef = null; _visitables.get("secretKeyRef").remove(this.secretKeyRef); } return (A) this;
  }
  public boolean hasSecretKeyRef() {
    return this.secretKeyRef != null;
  }
  public A withNewSecretKeyRef(String key,String name,Boolean optional) {
    return (A)withSecretKeyRef(new SecretKeySelector(key, name, optional));
  }
  public SecretKeyRefNested<A> withNewSecretKeyRef() {
    return new SecretKeyRefNested(null);
  }
  public SecretKeyRefNested<A> withNewSecretKeyRefLike(SecretKeySelector item) {
    return new SecretKeyRefNested(item);
  }
  public SecretKeyRefNested<A> editSecretKeyRef() {
    return withNewSecretKeyRefLike(java.util.Optional.ofNullable(buildSecretKeyRef()).orElse(null));
  }
  public SecretKeyRefNested<A> editOrNewSecretKeyRef() {
    return withNewSecretKeyRefLike(java.util.Optional.ofNullable(buildSecretKeyRef()).orElse(new SecretKeySelectorBuilder().build()));
  }
  public SecretKeyRefNested<A> editOrNewSecretKeyRefLike(SecretKeySelector item) {
    return withNewSecretKeyRefLike(java.util.Optional.ofNullable(buildSecretKeyRef()).orElse(item));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EnvVarSourceFluent that = (EnvVarSourceFluent) o;
    if (!java.util.Objects.equals(configMapKeyRef, that.configMapKeyRef)) return false;

    if (!java.util.Objects.equals(fieldRef, that.fieldRef)) return false;

    if (!java.util.Objects.equals(resourceFieldRef, that.resourceFieldRef)) return false;

    if (!java.util.Objects.equals(secretKeyRef, that.secretKeyRef)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(configMapKeyRef,  fieldRef,  resourceFieldRef,  secretKeyRef,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (configMapKeyRef != null) { sb.append("configMapKeyRef:"); sb.append(configMapKeyRef + ","); }
    if (fieldRef != null) { sb.append("fieldRef:"); sb.append(fieldRef + ","); }
    if (resourceFieldRef != null) { sb.append("resourceFieldRef:"); sb.append(resourceFieldRef + ","); }
    if (secretKeyRef != null) { sb.append("secretKeyRef:"); sb.append(secretKeyRef + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ConfigMapKeyRefNested<N> extends ConfigMapKeySelectorFluent<ConfigMapKeyRefNested<N>> implements Nested<N>{
    ConfigMapKeyRefNested(ConfigMapKeySelector item) {
      this.builder = new ConfigMapKeySelectorBuilder(this, item);
    }
    ConfigMapKeySelectorBuilder builder;
    public N and() {
      return (N) EnvVarSourceFluent.this.withConfigMapKeyRef(builder.build());
    }
    public N endConfigMapKeyRef() {
      return and();
    }
    
  }
  public class FieldRefNested<N> extends ObjectFieldSelectorFluent<FieldRefNested<N>> implements Nested<N>{
    FieldRefNested(ObjectFieldSelector item) {
      this.builder = new ObjectFieldSelectorBuilder(this, item);
    }
    ObjectFieldSelectorBuilder builder;
    public N and() {
      return (N) EnvVarSourceFluent.this.withFieldRef(builder.build());
    }
    public N endFieldRef() {
      return and();
    }
    
  }
  public class ResourceFieldRefNested<N> extends ResourceFieldSelectorFluent<ResourceFieldRefNested<N>> implements Nested<N>{
    ResourceFieldRefNested(ResourceFieldSelector item) {
      this.builder = new ResourceFieldSelectorBuilder(this, item);
    }
    ResourceFieldSelectorBuilder builder;
    public N and() {
      return (N) EnvVarSourceFluent.this.withResourceFieldRef(builder.build());
    }
    public N endResourceFieldRef() {
      return and();
    }
    
  }
  public class SecretKeyRefNested<N> extends SecretKeySelectorFluent<SecretKeyRefNested<N>> implements Nested<N>{
    SecretKeyRefNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    public N and() {
      return (N) EnvVarSourceFluent.this.withSecretKeyRef(builder.build());
    }
    public N endSecretKeyRef() {
      return and();
    }
    
  }
  
}