package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EnvFromSourceBuilder extends EnvFromSourceFluent<EnvFromSourceBuilder> implements VisitableBuilder<EnvFromSource,EnvFromSourceBuilder>{
  public EnvFromSourceBuilder() {
    this(false);
  }
  public EnvFromSourceBuilder(Boolean validationEnabled) {
    this(new EnvFromSource(), validationEnabled);
  }
  public EnvFromSourceBuilder(EnvFromSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public EnvFromSourceBuilder(EnvFromSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EnvFromSource(), validationEnabled);
  }
  public EnvFromSourceBuilder(EnvFromSourceFluent<?> fluent,EnvFromSource instance) {
    this(fluent, instance, false);
  }
  public EnvFromSourceBuilder(EnvFromSourceFluent<?> fluent,EnvFromSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new EnvFromSource());

    if (instance != null) {
      fluent.withConfigMapRef(instance.getConfigMapRef());
      fluent.withPrefix(instance.getPrefix());
      fluent.withSecretRef(instance.getSecretRef());
      fluent.withConfigMapRef(instance.getConfigMapRef());
      fluent.withPrefix(instance.getPrefix());
      fluent.withSecretRef(instance.getSecretRef());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EnvFromSourceBuilder(EnvFromSource instance) {
    this(instance,false);
  }
  public EnvFromSourceBuilder(EnvFromSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new EnvFromSource());

    if (instance != null) {
      this.withConfigMapRef(instance.getConfigMapRef());
      this.withPrefix(instance.getPrefix());
      this.withSecretRef(instance.getSecretRef());
      this.withConfigMapRef(instance.getConfigMapRef());
      this.withPrefix(instance.getPrefix());
      this.withSecretRef(instance.getSecretRef());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EnvFromSourceFluent<?> fluent;
  Boolean validationEnabled;
  public EnvFromSource build() {
    EnvFromSource buildable = new EnvFromSource(fluent.buildConfigMapRef(),fluent.getPrefix(),fluent.buildSecretRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}