package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerStatusBuilder extends ContainerStatusFluent<ContainerStatusBuilder> implements VisitableBuilder<ContainerStatus,ContainerStatusBuilder>{
  public ContainerStatusBuilder() {
    this(false);
  }
  public ContainerStatusBuilder(Boolean validationEnabled) {
    this(new ContainerStatus(), validationEnabled);
  }
  public ContainerStatusBuilder(ContainerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerStatusBuilder(ContainerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ContainerStatus(), validationEnabled);
  }
  public ContainerStatusBuilder(ContainerStatusFluent<?> fluent,ContainerStatus instance) {
    this(fluent, instance, false);
  }
  public ContainerStatusBuilder(ContainerStatusFluent<?> fluent,ContainerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ContainerStatus());

    if (instance != null) {
      fluent.withAllocatedResources(instance.getAllocatedResources());
      fluent.withContainerID(instance.getContainerID());
      fluent.withImage(instance.getImage());
      fluent.withImageID(instance.getImageID());
      fluent.withLastState(instance.getLastState());
      fluent.withName(instance.getName());
      fluent.withReady(instance.getReady());
      fluent.withResources(instance.getResources());
      fluent.withRestartCount(instance.getRestartCount());
      fluent.withStarted(instance.getStarted());
      fluent.withState(instance.getState());
      fluent.withAllocatedResources(instance.getAllocatedResources());
      fluent.withContainerID(instance.getContainerID());
      fluent.withImage(instance.getImage());
      fluent.withImageID(instance.getImageID());
      fluent.withLastState(instance.getLastState());
      fluent.withName(instance.getName());
      fluent.withReady(instance.getReady());
      fluent.withResources(instance.getResources());
      fluent.withRestartCount(instance.getRestartCount());
      fluent.withStarted(instance.getStarted());
      fluent.withState(instance.getState());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ContainerStatusBuilder(ContainerStatus instance) {
    this(instance,false);
  }
  public ContainerStatusBuilder(ContainerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ContainerStatus());

    if (instance != null) {
      this.withAllocatedResources(instance.getAllocatedResources());
      this.withContainerID(instance.getContainerID());
      this.withImage(instance.getImage());
      this.withImageID(instance.getImageID());
      this.withLastState(instance.getLastState());
      this.withName(instance.getName());
      this.withReady(instance.getReady());
      this.withResources(instance.getResources());
      this.withRestartCount(instance.getRestartCount());
      this.withStarted(instance.getStarted());
      this.withState(instance.getState());
      this.withAllocatedResources(instance.getAllocatedResources());
      this.withContainerID(instance.getContainerID());
      this.withImage(instance.getImage());
      this.withImageID(instance.getImageID());
      this.withLastState(instance.getLastState());
      this.withName(instance.getName());
      this.withReady(instance.getReady());
      this.withResources(instance.getResources());
      this.withRestartCount(instance.getRestartCount());
      this.withStarted(instance.getStarted());
      this.withState(instance.getState());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ContainerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ContainerStatus build() {
    ContainerStatus buildable = new ContainerStatus(fluent.getAllocatedResources(),fluent.getContainerID(),fluent.getImage(),fluent.getImageID(),fluent.buildLastState(),fluent.getName(),fluent.getReady(),fluent.buildResources(),fluent.getRestartCount(),fluent.getStarted(),fluent.buildState());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}