package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigBuilder extends ConfigFluent<ConfigBuilder> implements VisitableBuilder<Config,ConfigBuilder>{
  public ConfigBuilder() {
    this(false);
  }
  public ConfigBuilder(Boolean validationEnabled) {
    this(new Config(), validationEnabled);
  }
  public ConfigBuilder(ConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigBuilder(ConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Config(), validationEnabled);
  }
  public ConfigBuilder(ConfigFluent<?> fluent,Config instance) {
    this(fluent, instance, false);
  }
  public ConfigBuilder(ConfigFluent<?> fluent,Config instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Config());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withClusters(instance.getClusters());
      fluent.withContexts(instance.getContexts());
      fluent.withCurrentContext(instance.getCurrentContext());
      fluent.withExtensions(instance.getExtensions());
      fluent.withKind(instance.getKind());
      fluent.withPreferences(instance.getPreferences());
      fluent.withUsers(instance.getUsers());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withClusters(instance.getClusters());
      fluent.withContexts(instance.getContexts());
      fluent.withCurrentContext(instance.getCurrentContext());
      fluent.withExtensions(instance.getExtensions());
      fluent.withKind(instance.getKind());
      fluent.withPreferences(instance.getPreferences());
      fluent.withUsers(instance.getUsers());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConfigBuilder(Config instance) {
    this(instance,false);
  }
  public ConfigBuilder(Config instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Config());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withClusters(instance.getClusters());
      this.withContexts(instance.getContexts());
      this.withCurrentContext(instance.getCurrentContext());
      this.withExtensions(instance.getExtensions());
      this.withKind(instance.getKind());
      this.withPreferences(instance.getPreferences());
      this.withUsers(instance.getUsers());
      this.withApiVersion(instance.getApiVersion());
      this.withClusters(instance.getClusters());
      this.withContexts(instance.getContexts());
      this.withCurrentContext(instance.getCurrentContext());
      this.withExtensions(instance.getExtensions());
      this.withKind(instance.getKind());
      this.withPreferences(instance.getPreferences());
      this.withUsers(instance.getUsers());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConfigFluent<?> fluent;
  Boolean validationEnabled;
  public Config build() {
    Config buildable = new Config(fluent.getApiVersion(),fluent.buildClusters(),fluent.buildContexts(),fluent.getCurrentContext(),fluent.buildExtensions(),fluent.getKind(),fluent.buildPreferences(),fluent.buildUsers());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}