package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterBuilder extends ClusterFluent<ClusterBuilder> implements VisitableBuilder<Cluster,ClusterBuilder>{
  public ClusterBuilder() {
    this(false);
  }
  public ClusterBuilder(Boolean validationEnabled) {
    this(new Cluster(), validationEnabled);
  }
  public ClusterBuilder(ClusterFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterBuilder(ClusterFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Cluster(), validationEnabled);
  }
  public ClusterBuilder(ClusterFluent<?> fluent,Cluster instance) {
    this(fluent, instance, false);
  }
  public ClusterBuilder(ClusterFluent<?> fluent,Cluster instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Cluster());

    if (instance != null) {
      fluent.withCertificateAuthority(instance.getCertificateAuthority());
      fluent.withCertificateAuthorityData(instance.getCertificateAuthorityData());
      fluent.withDisableCompression(instance.getDisableCompression());
      fluent.withExtensions(instance.getExtensions());
      fluent.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify());
      fluent.withProxyUrl(instance.getProxyUrl());
      fluent.withServer(instance.getServer());
      fluent.withTlsServerName(instance.getTlsServerName());
      fluent.withCertificateAuthority(instance.getCertificateAuthority());
      fluent.withCertificateAuthorityData(instance.getCertificateAuthorityData());
      fluent.withDisableCompression(instance.getDisableCompression());
      fluent.withExtensions(instance.getExtensions());
      fluent.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify());
      fluent.withProxyUrl(instance.getProxyUrl());
      fluent.withServer(instance.getServer());
      fluent.withTlsServerName(instance.getTlsServerName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterBuilder(Cluster instance) {
    this(instance,false);
  }
  public ClusterBuilder(Cluster instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Cluster());

    if (instance != null) {
      this.withCertificateAuthority(instance.getCertificateAuthority());
      this.withCertificateAuthorityData(instance.getCertificateAuthorityData());
      this.withDisableCompression(instance.getDisableCompression());
      this.withExtensions(instance.getExtensions());
      this.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify());
      this.withProxyUrl(instance.getProxyUrl());
      this.withServer(instance.getServer());
      this.withTlsServerName(instance.getTlsServerName());
      this.withCertificateAuthority(instance.getCertificateAuthority());
      this.withCertificateAuthorityData(instance.getCertificateAuthorityData());
      this.withDisableCompression(instance.getDisableCompression());
      this.withExtensions(instance.getExtensions());
      this.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify());
      this.withProxyUrl(instance.getProxyUrl());
      this.withServer(instance.getServer());
      this.withTlsServerName(instance.getTlsServerName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterFluent<?> fluent;
  Boolean validationEnabled;
  public Cluster build() {
    Cluster buildable = new Cluster(fluent.getCertificateAuthority(),fluent.getCertificateAuthorityData(),fluent.getDisableCompression(),fluent.buildExtensions(),fluent.getInsecureSkipTlsVerify(),fluent.getProxyUrl(),fluent.getServer(),fluent.getTlsServerName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}