package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CinderPersistentVolumeSourceBuilder extends CinderPersistentVolumeSourceFluent<CinderPersistentVolumeSourceBuilder> implements VisitableBuilder<CinderPersistentVolumeSource,CinderPersistentVolumeSourceBuilder>{
  public CinderPersistentVolumeSourceBuilder() {
    this(false);
  }
  public CinderPersistentVolumeSourceBuilder(Boolean validationEnabled) {
    this(new CinderPersistentVolumeSource(), validationEnabled);
  }
  public CinderPersistentVolumeSourceBuilder(CinderPersistentVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public CinderPersistentVolumeSourceBuilder(CinderPersistentVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CinderPersistentVolumeSource(), validationEnabled);
  }
  public CinderPersistentVolumeSourceBuilder(CinderPersistentVolumeSourceFluent<?> fluent,CinderPersistentVolumeSource instance) {
    this(fluent, instance, false);
  }
  public CinderPersistentVolumeSourceBuilder(CinderPersistentVolumeSourceFluent<?> fluent,CinderPersistentVolumeSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CinderPersistentVolumeSource());

    if (instance != null) {
      fluent.withFsType(instance.getFsType());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withSecretRef(instance.getSecretRef());
      fluent.withVolumeID(instance.getVolumeID());
      fluent.withFsType(instance.getFsType());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withSecretRef(instance.getSecretRef());
      fluent.withVolumeID(instance.getVolumeID());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CinderPersistentVolumeSourceBuilder(CinderPersistentVolumeSource instance) {
    this(instance,false);
  }
  public CinderPersistentVolumeSourceBuilder(CinderPersistentVolumeSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CinderPersistentVolumeSource());

    if (instance != null) {
      this.withFsType(instance.getFsType());
      this.withReadOnly(instance.getReadOnly());
      this.withSecretRef(instance.getSecretRef());
      this.withVolumeID(instance.getVolumeID());
      this.withFsType(instance.getFsType());
      this.withReadOnly(instance.getReadOnly());
      this.withSecretRef(instance.getSecretRef());
      this.withVolumeID(instance.getVolumeID());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CinderPersistentVolumeSourceFluent<?> fluent;
  Boolean validationEnabled;
  public CinderPersistentVolumeSource build() {
    CinderPersistentVolumeSource buildable = new CinderPersistentVolumeSource(fluent.getFsType(),fluent.getReadOnly(),fluent.buildSecretRef(),fluent.getVolumeID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}