package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIServiceListBuilder extends APIServiceListFluent<APIServiceListBuilder> implements VisitableBuilder<APIServiceList,APIServiceListBuilder>{
  public APIServiceListBuilder() {
    this(false);
  }
  public APIServiceListBuilder(Boolean validationEnabled) {
    this(new APIServiceList(), validationEnabled);
  }
  public APIServiceListBuilder(APIServiceListFluent<?> fluent) {
    this(fluent, false);
  }
  public APIServiceListBuilder(APIServiceListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new APIServiceList(), validationEnabled);
  }
  public APIServiceListBuilder(APIServiceListFluent<?> fluent,APIServiceList instance) {
    this(fluent, instance, false);
  }
  public APIServiceListBuilder(APIServiceListFluent<?> fluent,APIServiceList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new APIServiceList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public APIServiceListBuilder(APIServiceList instance) {
    this(instance,false);
  }
  public APIServiceListBuilder(APIServiceList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new APIServiceList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  APIServiceListFluent<?> fluent;
  Boolean validationEnabled;
  public APIServiceList build() {
    APIServiceList buildable = new APIServiceList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.buildMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}