package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class APIResourceListFluent<A extends APIResourceListFluent<A>> extends BaseFluent<A>{
  public APIResourceListFluent() {
  }
  public APIResourceListFluent(APIResourceList instance) {
    instance = (instance != null ? instance : new APIResourceList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withGroupVersion(instance.getGroupVersion());
      this.withKind(instance.getKind());
      this.withResources(instance.getResources());
      this.withApiVersion(instance.getApiVersion());
      this.withGroupVersion(instance.getGroupVersion());
      this.withKind(instance.getKind());
      this.withResources(instance.getResources());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVersion;
  private String groupVersion;
  private String kind;
  private ArrayList<APIResourceBuilder> resources = new ArrayList<APIResourceBuilder>();
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getGroupVersion() {
    return this.groupVersion;
  }
  public A withGroupVersion(String groupVersion) {
    this.groupVersion=groupVersion; return (A) this;
  }
  public boolean hasGroupVersion() {
    return this.groupVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public boolean hasKind() {
    return this.kind != null;
  }
  public A addToResources(int index,APIResource item) {
    if (this.resources == null) {this.resources = new ArrayList<APIResourceBuilder>();}
    APIResourceBuilder builder = new APIResourceBuilder(item);
    if (index < 0 || index >= resources.size()) { _visitables.get("resources").add(builder); resources.add(builder); } else { _visitables.get("resources").add(index, builder); resources.add(index, builder);}
    return (A)this;
  }
  public A setToResources(int index,APIResource item) {
    if (this.resources == null) {this.resources = new ArrayList<APIResourceBuilder>();}
    APIResourceBuilder builder = new APIResourceBuilder(item);
    if (index < 0 || index >= resources.size()) { _visitables.get("resources").add(builder); resources.add(builder); } else { _visitables.get("resources").set(index, builder); resources.set(index, builder);}
    return (A)this;
  }
  public A addToResources(io.fabric8.kubernetes.api.model.APIResource... items) {
    if (this.resources == null) {this.resources = new ArrayList<APIResourceBuilder>();}
    for (APIResource item : items) {APIResourceBuilder builder = new APIResourceBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
  }
  public A addAllToResources(Collection<APIResource> items) {
    if (this.resources == null) {this.resources = new ArrayList<APIResourceBuilder>();}
    for (APIResource item : items) {APIResourceBuilder builder = new APIResourceBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
  }
  public A removeFromResources(io.fabric8.kubernetes.api.model.APIResource... items) {
    if (this.resources == null) return (A)this;
    for (APIResource item : items) {APIResourceBuilder builder = new APIResourceBuilder(item);_visitables.get("resources").remove(builder); this.resources.remove(builder);} return (A)this;
  }
  public A removeAllFromResources(Collection<APIResource> items) {
    if (this.resources == null) return (A)this;
    for (APIResource item : items) {APIResourceBuilder builder = new APIResourceBuilder(item);_visitables.get("resources").remove(builder); this.resources.remove(builder);} return (A)this;
  }
  public A removeMatchingFromResources(Predicate<APIResourceBuilder> predicate) {
    if (resources == null) return (A) this;
    final Iterator<APIResourceBuilder> each = resources.iterator();
    final List visitables = _visitables.get("resources");
    while (each.hasNext()) {
      APIResourceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<APIResource> buildResources() {
    return resources != null ? build(resources) : null;
  }
  public APIResource buildResource(int index) {
    return this.resources.get(index).build();
  }
  public APIResource buildFirstResource() {
    return this.resources.get(0).build();
  }
  public APIResource buildLastResource() {
    return this.resources.get(resources.size() - 1).build();
  }
  public APIResource buildMatchingResource(Predicate<APIResourceBuilder> predicate) {
    for (APIResourceBuilder item: resources) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingResource(Predicate<APIResourceBuilder> predicate) {
    for (APIResourceBuilder item: resources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResources(List<APIResource> resources) {
    if (this.resources != null) { _visitables.get("resources").clear();}
    if (resources != null) {this.resources = new ArrayList(); for (APIResource item : resources){this.addToResources(item);}} else { this.resources = null;} return (A) this;
  }
  public A withResources(io.fabric8.kubernetes.api.model.APIResource... resources) {
    if (this.resources != null) {this.resources.clear(); _visitables.remove("resources"); }
    if (resources != null) {for (APIResource item :resources){ this.addToResources(item);}} return (A) this;
  }
  public boolean hasResources() {
    return resources != null && !resources.isEmpty();
  }
  public ResourcesNested<A> addNewResource() {
    return new ResourcesNested(-1, null);
  }
  public ResourcesNested<A> addNewResourceLike(APIResource item) {
    return new ResourcesNested(-1, item);
  }
  public ResourcesNested<A> setNewResourceLike(int index,APIResource item) {
    return new ResourcesNested(index, item);
  }
  public ResourcesNested<A> editResource(int index) {
    if (resources.size() <= index) throw new RuntimeException("Can't edit resources. Index exceeds size.");
    return setNewResourceLike(index, buildResource(index));
  }
  public ResourcesNested<A> editFirstResource() {
    if (resources.size() == 0) throw new RuntimeException("Can't edit first resources. The list is empty.");
    return setNewResourceLike(0, buildResource(0));
  }
  public ResourcesNested<A> editLastResource() {
    int index = resources.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last resources. The list is empty.");
    return setNewResourceLike(index, buildResource(index));
  }
  public ResourcesNested<A> editMatchingResource(Predicate<APIResourceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<resources.size();i++) { 
    if (predicate.test(resources.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching resources. No match found.");
    return setNewResourceLike(index, buildResource(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    APIResourceListFluent that = (APIResourceListFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(groupVersion, that.groupVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(resources, that.resources)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  groupVersion,  kind,  resources,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (groupVersion != null) { sb.append("groupVersion:"); sb.append(groupVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (resources != null && !resources.isEmpty()) { sb.append("resources:"); sb.append(resources + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ResourcesNested<N> extends APIResourceFluent<ResourcesNested<N>> implements Nested<N>{
    ResourcesNested(int index,APIResource item) {
      this.index = index;
      this.builder = new APIResourceBuilder(this, item);
    }
    APIResourceBuilder builder;
    int index;
    public N and() {
      return (N) APIResourceListFluent.this.setToResources(index,builder.build());
    }
    public N endResource() {
      return and();
    }
    
  }
  
}