package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIResourceBuilder extends APIResourceFluent<APIResourceBuilder> implements VisitableBuilder<APIResource,APIResourceBuilder>{
  public APIResourceBuilder() {
    this(false);
  }
  public APIResourceBuilder(Boolean validationEnabled) {
    this(new APIResource(), validationEnabled);
  }
  public APIResourceBuilder(APIResourceFluent<?> fluent) {
    this(fluent, false);
  }
  public APIResourceBuilder(APIResourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new APIResource(), validationEnabled);
  }
  public APIResourceBuilder(APIResourceFluent<?> fluent,APIResource instance) {
    this(fluent, instance, false);
  }
  public APIResourceBuilder(APIResourceFluent<?> fluent,APIResource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new APIResource());

    if (instance != null) {
      fluent.withCategories(instance.getCategories());
      fluent.withGroup(instance.getGroup());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withNamespaced(instance.getNamespaced());
      fluent.withShortNames(instance.getShortNames());
      fluent.withSingularName(instance.getSingularName());
      fluent.withStorageVersionHash(instance.getStorageVersionHash());
      fluent.withVerbs(instance.getVerbs());
      fluent.withVersion(instance.getVersion());
      fluent.withCategories(instance.getCategories());
      fluent.withGroup(instance.getGroup());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withNamespaced(instance.getNamespaced());
      fluent.withShortNames(instance.getShortNames());
      fluent.withSingularName(instance.getSingularName());
      fluent.withStorageVersionHash(instance.getStorageVersionHash());
      fluent.withVerbs(instance.getVerbs());
      fluent.withVersion(instance.getVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public APIResourceBuilder(APIResource instance) {
    this(instance,false);
  }
  public APIResourceBuilder(APIResource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new APIResource());

    if (instance != null) {
      this.withCategories(instance.getCategories());
      this.withGroup(instance.getGroup());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withNamespaced(instance.getNamespaced());
      this.withShortNames(instance.getShortNames());
      this.withSingularName(instance.getSingularName());
      this.withStorageVersionHash(instance.getStorageVersionHash());
      this.withVerbs(instance.getVerbs());
      this.withVersion(instance.getVersion());
      this.withCategories(instance.getCategories());
      this.withGroup(instance.getGroup());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withNamespaced(instance.getNamespaced());
      this.withShortNames(instance.getShortNames());
      this.withSingularName(instance.getSingularName());
      this.withStorageVersionHash(instance.getStorageVersionHash());
      this.withVerbs(instance.getVerbs());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  APIResourceFluent<?> fluent;
  Boolean validationEnabled;
  public APIResource build() {
    APIResource buildable = new APIResource(fluent.getCategories(),fluent.getGroup(),fluent.getKind(),fluent.getName(),fluent.getNamespaced(),fluent.getShortNames(),fluent.getSingularName(),fluent.getStorageVersionHash(),fluent.getVerbs(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}