package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface SecretListFluent<A extends SecretListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(int index,Secret item);
  public A setToItems(int index,Secret item);
  public A addToItems(io.fabric8.kubernetes.api.model.Secret... items);
  public A addAllToItems(Collection<Secret> items);
  public A removeFromItems(io.fabric8.kubernetes.api.model.Secret... items);
  public A removeAllFromItems(Collection<Secret> items);
  public A removeMatchingFromItems(Predicate<SecretBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Secret> getItems();
  public List<Secret> buildItems();
  public Secret buildItem(int index);
  public Secret buildFirstItem();
  public Secret buildLastItem();
  public Secret buildMatchingItem(Predicate<SecretBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<SecretBuilder> predicate);
  public A withItems(List<Secret> items);
  public A withItems(io.fabric8.kubernetes.api.model.Secret... items);
  public Boolean hasItems();
  public SecretListFluent.ItemsNested<A> addNewItem();
  public SecretListFluent.ItemsNested<A> addNewItemLike(Secret item);
  public SecretListFluent.ItemsNested<A> setNewItemLike(int index,Secret item);
  public SecretListFluent.ItemsNested<A> editItem(int index);
  public SecretListFluent.ItemsNested<A> editFirstItem();
  public SecretListFluent.ItemsNested<A> editLastItem();
  public SecretListFluent.ItemsNested<A> editMatchingItem(Predicate<SecretBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ListMeta getMetadata();
  public ListMeta buildMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public SecretListFluent.MetadataNested<A> withNewMetadata();
  public SecretListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
  public SecretListFluent.MetadataNested<A> editMetadata();
  public SecretListFluent.MetadataNested<A> editOrNewMetadata();
  public SecretListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ItemsNested<N> extends Nested<N>,SecretFluent<SecretListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<SecretListFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  
}