package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SeccompProfileBuilder extends SeccompProfileFluentImpl<SeccompProfileBuilder> implements VisitableBuilder<SeccompProfile,SeccompProfileBuilder>{
  public SeccompProfileBuilder() {
    this(false);
  }
  public SeccompProfileBuilder(Boolean validationEnabled) {
    this(new SeccompProfile(), validationEnabled);
  }
  public SeccompProfileBuilder(SeccompProfileFluent<?> fluent) {
    this(fluent, false);
  }
  public SeccompProfileBuilder(SeccompProfileFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SeccompProfile(), validationEnabled);
  }
  public SeccompProfileBuilder(SeccompProfileFluent<?> fluent,SeccompProfile instance) {
    this(fluent, instance, false);
  }
  public SeccompProfileBuilder(SeccompProfileFluent<?> fluent,SeccompProfile instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLocalhostProfile(instance.getLocalhostProfile());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SeccompProfileBuilder(SeccompProfile instance) {
    this(instance,false);
  }
  public SeccompProfileBuilder(SeccompProfile instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLocalhostProfile(instance.getLocalhostProfile());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SeccompProfileFluent<?> fluent;
  Boolean validationEnabled;
  public SeccompProfile build() {
    SeccompProfile buildable = new SeccompProfile(fluent.getLocalhostProfile(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}