package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface PodStatusFluent<A extends PodStatusFluent<A>> extends Fluent<A>{
  public A addToConditions(int index,PodCondition item);
  public A setToConditions(int index,PodCondition item);
  public A addToConditions(io.fabric8.kubernetes.api.model.PodCondition... items);
  public A addAllToConditions(Collection<PodCondition> items);
  public A removeFromConditions(io.fabric8.kubernetes.api.model.PodCondition... items);
  public A removeAllFromConditions(Collection<PodCondition> items);
  public A removeMatchingFromConditions(Predicate<PodConditionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<PodCondition> getConditions();
  public List<PodCondition> buildConditions();
  public PodCondition buildCondition(int index);
  public PodCondition buildFirstCondition();
  public PodCondition buildLastCondition();
  public PodCondition buildMatchingCondition(Predicate<PodConditionBuilder> predicate);
  public Boolean hasMatchingCondition(Predicate<PodConditionBuilder> predicate);
  public A withConditions(List<PodCondition> conditions);
  public A withConditions(io.fabric8.kubernetes.api.model.PodCondition... conditions);
  public Boolean hasConditions();
  public PodStatusFluent.ConditionsNested<A> addNewCondition();
  public PodStatusFluent.ConditionsNested<A> addNewConditionLike(PodCondition item);
  public PodStatusFluent.ConditionsNested<A> setNewConditionLike(int index,PodCondition item);
  public PodStatusFluent.ConditionsNested<A> editCondition(int index);
  public PodStatusFluent.ConditionsNested<A> editFirstCondition();
  public PodStatusFluent.ConditionsNested<A> editLastCondition();
  public PodStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<PodConditionBuilder> predicate);
  public A addToContainerStatuses(int index,ContainerStatus item);
  public A setToContainerStatuses(int index,ContainerStatus item);
  public A addToContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... items);
  public A addAllToContainerStatuses(Collection<ContainerStatus> items);
  public A removeFromContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... items);
  public A removeAllFromContainerStatuses(Collection<ContainerStatus> items);
  public A removeMatchingFromContainerStatuses(Predicate<ContainerStatusBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildContainerStatuses instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ContainerStatus> getContainerStatuses();
  public List<ContainerStatus> buildContainerStatuses();
  public ContainerStatus buildContainerStatus(int index);
  public ContainerStatus buildFirstContainerStatus();
  public ContainerStatus buildLastContainerStatus();
  public ContainerStatus buildMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate);
  public Boolean hasMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate);
  public A withContainerStatuses(List<ContainerStatus> containerStatuses);
  public A withContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... containerStatuses);
  public Boolean hasContainerStatuses();
  public PodStatusFluent.ContainerStatusesNested<A> addNewContainerStatus();
  public PodStatusFluent.ContainerStatusesNested<A> addNewContainerStatusLike(ContainerStatus item);
  public PodStatusFluent.ContainerStatusesNested<A> setNewContainerStatusLike(int index,ContainerStatus item);
  public PodStatusFluent.ContainerStatusesNested<A> editContainerStatus(int index);
  public PodStatusFluent.ContainerStatusesNested<A> editFirstContainerStatus();
  public PodStatusFluent.ContainerStatusesNested<A> editLastContainerStatus();
  public PodStatusFluent.ContainerStatusesNested<A> editMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate);
  public A addToEphemeralContainerStatuses(int index,ContainerStatus item);
  public A setToEphemeralContainerStatuses(int index,ContainerStatus item);
  public A addToEphemeralContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... items);
  public A addAllToEphemeralContainerStatuses(Collection<ContainerStatus> items);
  public A removeFromEphemeralContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... items);
  public A removeAllFromEphemeralContainerStatuses(Collection<ContainerStatus> items);
  public A removeMatchingFromEphemeralContainerStatuses(Predicate<ContainerStatusBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildEphemeralContainerStatuses instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ContainerStatus> getEphemeralContainerStatuses();
  public List<ContainerStatus> buildEphemeralContainerStatuses();
  public ContainerStatus buildEphemeralContainerStatus(int index);
  public ContainerStatus buildFirstEphemeralContainerStatus();
  public ContainerStatus buildLastEphemeralContainerStatus();
  public ContainerStatus buildMatchingEphemeralContainerStatus(Predicate<ContainerStatusBuilder> predicate);
  public Boolean hasMatchingEphemeralContainerStatus(Predicate<ContainerStatusBuilder> predicate);
  public A withEphemeralContainerStatuses(List<ContainerStatus> ephemeralContainerStatuses);
  public A withEphemeralContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... ephemeralContainerStatuses);
  public Boolean hasEphemeralContainerStatuses();
  public PodStatusFluent.EphemeralContainerStatusesNested<A> addNewEphemeralContainerStatus();
  public PodStatusFluent.EphemeralContainerStatusesNested<A> addNewEphemeralContainerStatusLike(ContainerStatus item);
  public PodStatusFluent.EphemeralContainerStatusesNested<A> setNewEphemeralContainerStatusLike(int index,ContainerStatus item);
  public PodStatusFluent.EphemeralContainerStatusesNested<A> editEphemeralContainerStatus(int index);
  public PodStatusFluent.EphemeralContainerStatusesNested<A> editFirstEphemeralContainerStatus();
  public PodStatusFluent.EphemeralContainerStatusesNested<A> editLastEphemeralContainerStatus();
  public PodStatusFluent.EphemeralContainerStatusesNested<A> editMatchingEphemeralContainerStatus(Predicate<ContainerStatusBuilder> predicate);
  public String getHostIP();
  public A withHostIP(String hostIP);
  public Boolean hasHostIP();
  public A addToInitContainerStatuses(int index,ContainerStatus item);
  public A setToInitContainerStatuses(int index,ContainerStatus item);
  public A addToInitContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... items);
  public A addAllToInitContainerStatuses(Collection<ContainerStatus> items);
  public A removeFromInitContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... items);
  public A removeAllFromInitContainerStatuses(Collection<ContainerStatus> items);
  public A removeMatchingFromInitContainerStatuses(Predicate<ContainerStatusBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildInitContainerStatuses instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ContainerStatus> getInitContainerStatuses();
  public List<ContainerStatus> buildInitContainerStatuses();
  public ContainerStatus buildInitContainerStatus(int index);
  public ContainerStatus buildFirstInitContainerStatus();
  public ContainerStatus buildLastInitContainerStatus();
  public ContainerStatus buildMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate);
  public Boolean hasMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate);
  public A withInitContainerStatuses(List<ContainerStatus> initContainerStatuses);
  public A withInitContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... initContainerStatuses);
  public Boolean hasInitContainerStatuses();
  public PodStatusFluent.InitContainerStatusesNested<A> addNewInitContainerStatus();
  public PodStatusFluent.InitContainerStatusesNested<A> addNewInitContainerStatusLike(ContainerStatus item);
  public PodStatusFluent.InitContainerStatusesNested<A> setNewInitContainerStatusLike(int index,ContainerStatus item);
  public PodStatusFluent.InitContainerStatusesNested<A> editInitContainerStatus(int index);
  public PodStatusFluent.InitContainerStatusesNested<A> editFirstInitContainerStatus();
  public PodStatusFluent.InitContainerStatusesNested<A> editLastInitContainerStatus();
  public PodStatusFluent.InitContainerStatusesNested<A> editMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate);
  public String getMessage();
  public A withMessage(String message);
  public Boolean hasMessage();
  public String getNominatedNodeName();
  public A withNominatedNodeName(String nominatedNodeName);
  public Boolean hasNominatedNodeName();
  public String getPhase();
  public A withPhase(String phase);
  public Boolean hasPhase();
  public String getPodIP();
  public A withPodIP(String podIP);
  public Boolean hasPodIP();
  public A addToPodIPs(int index,PodIP item);
  public A setToPodIPs(int index,PodIP item);
  public A addToPodIPs(io.fabric8.kubernetes.api.model.PodIP... items);
  public A addAllToPodIPs(Collection<PodIP> items);
  public A removeFromPodIPs(io.fabric8.kubernetes.api.model.PodIP... items);
  public A removeAllFromPodIPs(Collection<PodIP> items);
  public A removeMatchingFromPodIPs(Predicate<PodIPBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildPodIPs instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<PodIP> getPodIPs();
  public List<PodIP> buildPodIPs();
  public PodIP buildPodIP(int index);
  public PodIP buildFirstPodIP();
  public PodIP buildLastPodIP();
  public PodIP buildMatchingPodIP(Predicate<PodIPBuilder> predicate);
  public Boolean hasMatchingPodIP(Predicate<PodIPBuilder> predicate);
  public A withPodIPs(List<PodIP> podIPs);
  public A withPodIPs(io.fabric8.kubernetes.api.model.PodIP... podIPs);
  public Boolean hasPodIPs();
  public A addNewPodIP(String ip);
  public PodStatusFluent.PodIPsNested<A> addNewPodIP();
  public PodStatusFluent.PodIPsNested<A> addNewPodIPLike(PodIP item);
  public PodStatusFluent.PodIPsNested<A> setNewPodIPLike(int index,PodIP item);
  public PodStatusFluent.PodIPsNested<A> editPodIP(int index);
  public PodStatusFluent.PodIPsNested<A> editFirstPodIP();
  public PodStatusFluent.PodIPsNested<A> editLastPodIP();
  public PodStatusFluent.PodIPsNested<A> editMatchingPodIP(Predicate<PodIPBuilder> predicate);
  public String getQosClass();
  public A withQosClass(String qosClass);
  public Boolean hasQosClass();
  public String getReason();
  public A withReason(String reason);
  public Boolean hasReason();
  public String getStartTime();
  public A withStartTime(String startTime);
  public Boolean hasStartTime();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ConditionsNested<N> extends Nested<N>,PodConditionFluent<PodStatusFluent.ConditionsNested<N>>{
    public N and();
    public N endCondition();
    
  }
  public interface ContainerStatusesNested<N> extends Nested<N>,ContainerStatusFluent<PodStatusFluent.ContainerStatusesNested<N>>{
    public N and();
    public N endContainerStatus();
    
  }
  public interface EphemeralContainerStatusesNested<N> extends Nested<N>,ContainerStatusFluent<PodStatusFluent.EphemeralContainerStatusesNested<N>>{
    public N and();
    public N endEphemeralContainerStatus();
    
  }
  public interface InitContainerStatusesNested<N> extends Nested<N>,ContainerStatusFluent<PodStatusFluent.InitContainerStatusesNested<N>>{
    public N and();
    public N endInitContainerStatus();
    
  }
  public interface PodIPsNested<N> extends Nested<N>,PodIPFluent<PodStatusFluent.PodIPsNested<N>>{
    public N and();
    public N endPodIP();
    
  }
  
}