package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodDNSConfigOptionBuilder extends PodDNSConfigOptionFluentImpl<PodDNSConfigOptionBuilder> implements VisitableBuilder<PodDNSConfigOption,PodDNSConfigOptionBuilder>{
  public PodDNSConfigOptionBuilder() {
    this(false);
  }
  public PodDNSConfigOptionBuilder(Boolean validationEnabled) {
    this(new PodDNSConfigOption(), validationEnabled);
  }
  public PodDNSConfigOptionBuilder(PodDNSConfigOptionFluent<?> fluent) {
    this(fluent, false);
  }
  public PodDNSConfigOptionBuilder(PodDNSConfigOptionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodDNSConfigOption(), validationEnabled);
  }
  public PodDNSConfigOptionBuilder(PodDNSConfigOptionFluent<?> fluent,PodDNSConfigOption instance) {
    this(fluent, instance, false);
  }
  public PodDNSConfigOptionBuilder(PodDNSConfigOptionFluent<?> fluent,PodDNSConfigOption instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withValue(instance.getValue());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodDNSConfigOptionBuilder(PodDNSConfigOption instance) {
    this(instance,false);
  }
  public PodDNSConfigOptionBuilder(PodDNSConfigOption instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withName(instance.getName());
      this.withValue(instance.getValue());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodDNSConfigOptionFluent<?> fluent;
  Boolean validationEnabled;
  public PodDNSConfigOption build() {
    PodDNSConfigOption buildable = new PodDNSConfigOption(fluent.getName(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}